// Copyright 2020-2022 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.
#include "xmath_fft_lut.h"

const complex_s32_t xmath_dit_fft_lut[1020] = 
	{
	{ 1073741824,           0}, {  759250125,  -759250125}, {          0, -1073741824}, { -759250125,  -759250125}, 
	{          0, -1073741824}, { -410903207,  -992008094}, { -759250125,  -759250125}, { -992008094,  -410903207}, 
	{ 1073741824,           0}, {  992008094,  -410903207}, {  759250125,  -759250125}, {  410903207,  -992008094}, 
	{ -759250125,  -759250125}, { -892783698,  -596538995}, { -992008094,  -410903207}, {-1053110176,  -209476638}, 
	{          0, -1073741824}, { -209476638, -1053110176}, { -410903207,  -992008094}, { -596538995,  -892783698}, 
	{  759250125,  -759250125}, {  596538995,  -892783698}, {  410903207,  -992008094}, {  209476638, -1053110176}, 
	{ 1073741824,           0}, { 1053110176,  -209476638}, {  992008094,  -410903207}, {  892783698,  -596538995}, 
	{ -992008094,  -410903207}, {-1027506862,  -311690799}, {-1053110176,  -209476638}, {-1068571464,  -105245103}, 
	{ -759250125,  -759250125}, { -830013654,  -681174602}, { -892783698,  -596538995}, { -946955747,  -506158392}, 
	{ -410903207,  -992008094}, { -506158392,  -946955747}, { -596538995,  -892783698}, { -681174602,  -830013654}, 
	{          0, -1073741824}, { -105245103, -1068571464}, { -209476638, -1053110176}, { -311690799, -1027506862}, 
	{  410903207,  -992008094}, {  311690799, -1027506862}, {  209476638, -1053110176}, {  105245103, -1068571464}, 
	{  759250125,  -759250125}, {  681174602,  -830013654}, {  596538995,  -892783698}, {  506158392,  -946955747}, 
	{  992008094,  -410903207}, {  946955747,  -506158392}, {  892783698,  -596538995}, {  830013654,  -681174602}, 
	{ 1073741824,           0}, { 1068571464,  -105245103}, { 1053110176,  -209476638}, { 1027506862,  -311690799}, 
	{-1053110176,  -209476638}, {-1062120190,  -157550647}, {-1068571464,  -105245103}, {-1072448455,   -52686014}, 
	{ -992008094,  -410903207}, {-1010975242,  -361732726}, {-1027506862,  -311690799}, {-1041563127,  -260897982}, 
	{ -892783698,  -596538995}, { -920979082,  -552013618}, { -946955747,  -506158392}, { -970651112,  -459083786}, 
	{ -759250125,  -759250125}, { -795590213,  -721080937}, { -830013654,  -681174602}, { -862437520,  -639627258}, 
	{ -596538995,  -892783698}, { -639627258,  -862437520}, { -681174602,  -830013654}, { -721080937,  -795590213}, 
	{ -410903207,  -992008094}, { -459083786,  -970651112}, { -506158392,  -946955747}, { -552013618,  -920979082}, 
	{ -209476638, -1053110176}, { -260897982, -1041563127}, { -311690799, -1027506862}, { -361732726, -1010975242}, 
	{          0, -1073741824}, {  -52686014, -1072448455}, { -105245103, -1068571464}, { -157550647, -1062120190}, 
	{  209476638, -1053110176}, {  157550647, -1062120190}, {  105245103, -1068571464}, {   52686014, -1072448455}, 
	{  410903207,  -992008094}, {  361732726, -1010975242}, {  311690799, -1027506862}, {  260897982, -1041563127}, 
	{  596538995,  -892783698}, {  552013618,  -920979082}, {  506158392,  -946955747}, {  459083786,  -970651112}, 
	{  759250125,  -759250125}, {  721080937,  -795590213}, {  681174602,  -830013654}, {  639627258,  -862437520}, 
	{  892783698,  -596538995}, {  862437520,  -639627258}, {  830013654,  -681174602}, {  795590213,  -721080937}, 
	{  992008094,  -410903207}, {  970651112,  -459083786}, {  946955747,  -506158392}, {  920979082,  -552013618}, 
	{ 1053110176,  -209476638}, { 1041563127,  -260897982}, { 1027506862,  -311690799}, { 1010975242,  -361732726}, 
	{ 1073741824,           0}, { 1072448455,   -52686014}, { 1068571464,  -105245103}, { 1062120190,  -157550647}, 
	{-1068571464,  -105245103}, {-1070832474,   -78989349}, {-1072448455,   -52686014}, {-1073418433,   -26350943}, 
	{-1053110176,  -209476638}, {-1057933813,  -183568930}, {-1062120190,  -157550647}, {-1065666786,  -131437462}, 
	{-1027506862,  -311690799}, {-1034846671,  -286380643}, {-1041563127,  -260897982}, {-1047652185,  -235258165}, 
	{ -992008094,  -410903207}, {-1001793390,  -386434353}, {-1010975242,  -361732726}, {-1019548121,  -336813204}, 
	{ -946955747,  -506158392}, { -959092290,  -482766489}, { -970651112,  -459083786}, { -981625251,  -435124548}, 
	{ -892783698,  -596538995}, { -907154608,  -574449320}, { -920979082,  -552013618}, { -934248793,  -529245404}, 
	{ -830013654,  -681174602}, { -846480531,  -660599890}, { -862437520,  -639627258}, { -877875009,  -618269338}, 
	{ -759250125,  -759250125}, { -777654384,  -740388522}, { -795590213,  -721080937}, { -813046808,  -701339000}, 
	{ -681174602,  -830013654}, { -701339000,  -813046808}, { -721080937,  -795590213}, { -740388522,  -777654384}, 
	{ -596538995,  -892783698}, { -618269338,  -877875009}, { -639627258,  -862437520}, { -660599890,  -846480531}, 
	{ -506158392,  -946955747}, { -529245404,  -934248793}, { -552013618,  -920979082}, { -574449320,  -907154608}, 
	{ -410903207,  -992008094}, { -435124548,  -981625251}, { -459083786,  -970651112}, { -482766489,  -959092290}, 
	{ -311690799, -1027506862}, { -336813204, -1019548121}, { -361732726, -1010975242}, { -386434353, -1001793390}, 
	{ -209476638, -1053110176}, { -235258165, -1047652185}, { -260897982, -1041563127}, { -286380643, -1034846671}, 
	{ -105245103, -1068571464}, { -131437462, -1065666786}, { -157550647, -1062120190}, { -183568930, -1057933813}, 
	{          0, -1073741824}, {  -26350943, -1073418433}, {  -52686014, -1072448455}, {  -78989349, -1070832474}, 
	{  105245103, -1068571464}, {   78989349, -1070832474}, {   52686014, -1072448455}, {   26350943, -1073418433}, 
	{  209476638, -1053110176}, {  183568930, -1057933813}, {  157550647, -1062120190}, {  131437462, -1065666786}, 
	{  311690799, -1027506862}, {  286380643, -1034846671}, {  260897982, -1041563127}, {  235258165, -1047652185}, 
	{  410903207,  -992008094}, {  386434353, -1001793390}, {  361732726, -1010975242}, {  336813204, -1019548121}, 
	{  506158392,  -946955747}, {  482766489,  -959092290}, {  459083786,  -970651112}, {  435124548,  -981625251}, 
	{  596538995,  -892783698}, {  574449320,  -907154608}, {  552013618,  -920979082}, {  529245404,  -934248793}, 
	{  681174602,  -830013654}, {  660599890,  -846480531}, {  639627258,  -862437520}, {  618269338,  -877875009}, 
	{  759250125,  -759250125}, {  740388522,  -777654384}, {  721080937,  -795590213}, {  701339000,  -813046808}, 
	{  830013654,  -681174602}, {  813046808,  -701339000}, {  795590213,  -721080937}, {  777654384,  -740388522}, 
	{  892783698,  -596538995}, {  877875009,  -618269338}, {  862437520,  -639627258}, {  846480531,  -660599890}, 
	{  946955747,  -506158392}, {  934248793,  -529245404}, {  920979082,  -552013618}, {  907154608,  -574449320}, 
	{  992008094,  -410903207}, {  981625251,  -435124548}, {  970651112,  -459083786}, {  959092290,  -482766489}, 
	{ 1027506862,  -311690799}, { 1019548121,  -336813204}, { 1010975242,  -361732726}, { 1001793390,  -386434353}, 
	{ 1053110176,  -209476638}, { 1047652185,  -235258165}, { 1041563127,  -260897982}, { 1034846671,  -286380643}, 
	{ 1068571464,  -105245103}, { 1065666786,  -131437462}, { 1062120190,  -157550647}, { 1057933813,  -183568930}, 
	{ 1073741824,           0}, { 1073418433,   -26350943}, { 1072448455,   -52686014}, { 1070832474,   -78989349}, 
	{-1072448455,   -52686014}, {-1073014240,   -39521455}, {-1073418433,   -26350943}, {-1073660973,   -13176464}, 
	{-1068571464,  -105245103}, {-1069782521,   -92124163}, {-1070832474,   -78989349}, {-1071721163,   -65842639}, 
	{-1062120190,  -157550647}, {-1063973603,  -144504935}, {-1065666786,  -131437462}, {-1067199483,  -118350194}, 
	{-1053110176,  -209476638}, {-1055601479,  -196537583}, {-1057933813,  -183568930}, {-1060106826,  -170572633}, 
	{-1041563127,  -260897982}, {-1044686319,  -248096755}, {-1047652185,  -235258165}, {-1050460278,  -222384147}, 
	{-1027506862,  -311690799}, {-1031254418,  -299058239}, {-1034846671,  -286380643}, {-1038283080,  -273659918}, 
	{-1010975242,  -361732726}, {-1015338134,  -349299266}, {-1019548121,  -336813204}, {-1023604567,  -324276419}, 
	{ -992008094,  -410903207}, { -996975812,  -398698801}, {-1001793390,  -386434353}, {-1006460100,  -374111709}, 
	{ -970651112,  -459083786}, { -976211688,  -447137835}, { -981625251,  -435124548}, { -986890984,  -423045732}, 
	{ -946955747,  -506158392}, { -953095785,  -494499676}, { -959092290,  -482766489}, { -964944360,  -470960600}, 
	{ -920979082,  -552013618}, { -927683790,  -540670223}, { -934248793,  -529245404}, { -940673101,  -517740883}, 
	{ -892783698,  -596538995}, { -900036924,  -585538248}, { -907154608,  -574449320}, { -914135678,  -563273883}, 
	{ -862437520,  -639627258}, { -870221790,  -628995660}, { -877875009,  -618269338}, { -885396022,  -607449906}, 
	{ -830013654,  -681174602}, { -838310216,  -670937767}, { -846480531,  -660599890}, { -854523370,  -650162530}, 
	{ -795590213,  -721080937}, { -804379079,  -711263525}, { -813046808,  -701339000}, { -821592095,  -691308855}, 
	{ -759250125,  -759250125}, { -768510122,  -749875788}, { -777654384,  -740388522}, { -786681534,  -730789757}, 
	{ -721080937,  -795590213}, { -730789757,  -786681534}, { -740388522,  -777654384}, { -749875788,  -768510122}, 
	{ -681174602,  -830013654}, { -691308855,  -821592095}, { -701339000,  -813046808}, { -711263525,  -804379079}, 
	{ -639627258,  -862437520}, { -650162530,  -854523370}, { -660599890,  -846480531}, { -670937767,  -838310216}, 
	{ -596538995,  -892783698}, { -607449906,  -885396022}, { -618269338,  -877875009}, { -628995660,  -870221790}, 
	{ -552013618,  -920979082}, { -563273883,  -914135678}, { -574449320,  -907154608}, { -585538248,  -900036924}, 
	{ -506158392,  -946955747}, { -517740883,  -940673101}, { -529245404,  -934248793}, { -540670223,  -927683790}, 
	{ -459083786,  -970651112}, { -470960600,  -964944360}, { -482766489,  -959092290}, { -494499676,  -953095785}, 
	{ -410903207,  -992008094}, { -423045732,  -986890984}, { -435124548,  -981625251}, { -447137835,  -976211688}, 
	{ -361732726, -1010975242}, { -374111709, -1006460100}, { -386434353, -1001793390}, { -398698801,  -996975812}, 
	{ -311690799, -1027506862}, { -324276419, -1023604567}, { -336813204, -1019548121}, { -349299266, -1015338134}, 
	{ -260897982, -1041563127}, { -273659918, -1038283080}, { -286380643, -1034846671}, { -299058239, -1031254418}, 
	{ -209476638, -1053110176}, { -222384147, -1050460278}, { -235258165, -1047652185}, { -248096755, -1044686319}, 
	{ -157550647, -1062120190}, { -170572633, -1060106826}, { -183568930, -1057933813}, { -196537583, -1055601479}, 
	{ -105245103, -1068571464}, { -118350194, -1067199483}, { -131437462, -1065666786}, { -144504935, -1063973603}, 
	{  -52686014, -1072448455}, {  -65842639, -1071721163}, {  -78989349, -1070832474}, {  -92124163, -1069782521}, 
	{          0, -1073741824}, {  -13176464, -1073660973}, {  -26350943, -1073418433}, {  -39521455, -1073014240}, 
	{   52686014, -1072448455}, {   39521455, -1073014240}, {   26350943, -1073418433}, {   13176464, -1073660973}, 
	{  105245103, -1068571464}, {   92124163, -1069782521}, {   78989349, -1070832474}, {   65842639, -1071721163}, 
	{  157550647, -1062120190}, {  144504935, -1063973603}, {  131437462, -1065666786}, {  118350194, -1067199483}, 
	{  209476638, -1053110176}, {  196537583, -1055601479}, {  183568930, -1057933813}, {  170572633, -1060106826}, 
	{  260897982, -1041563127}, {  248096755, -1044686319}, {  235258165, -1047652185}, {  222384147, -1050460278}, 
	{  311690799, -1027506862}, {  299058239, -1031254418}, {  286380643, -1034846671}, {  273659918, -1038283080}, 
	{  361732726, -1010975242}, {  349299266, -1015338134}, {  336813204, -1019548121}, {  324276419, -1023604567}, 
	{  410903207,  -992008094}, {  398698801,  -996975812}, {  386434353, -1001793390}, {  374111709, -1006460100}, 
	{  459083786,  -970651112}, {  447137835,  -976211688}, {  435124548,  -981625251}, {  423045732,  -986890984}, 
	{  506158392,  -946955747}, {  494499676,  -953095785}, {  482766489,  -959092290}, {  470960600,  -964944360}, 
	{  552013618,  -920979082}, {  540670223,  -927683790}, {  529245404,  -934248793}, {  517740883,  -940673101}, 
	{  596538995,  -892783698}, {  585538248,  -900036924}, {  574449320,  -907154608}, {  563273883,  -914135678}, 
	{  639627258,  -862437520}, {  628995660,  -870221790}, {  618269338,  -877875009}, {  607449906,  -885396022}, 
	{  681174602,  -830013654}, {  670937767,  -838310216}, {  660599890,  -846480531}, {  650162530,  -854523370}, 
	{  721080937,  -795590213}, {  711263525,  -804379079}, {  701339000,  -813046808}, {  691308855,  -821592095}, 
	{  759250125,  -759250125}, {  749875788,  -768510122}, {  740388522,  -777654384}, {  730789757,  -786681534}, 
	{  795590213,  -721080937}, {  786681534,  -730789757}, {  777654384,  -740388522}, {  768510122,  -749875788}, 
	{  830013654,  -681174602}, {  821592095,  -691308855}, {  813046808,  -701339000}, {  804379079,  -711263525}, 
	{  862437520,  -639627258}, {  854523370,  -650162530}, {  846480531,  -660599890}, {  838310216,  -670937767}, 
	{  892783698,  -596538995}, {  885396022,  -607449906}, {  877875009,  -618269338}, {  870221790,  -628995660}, 
	{  920979082,  -552013618}, {  914135678,  -563273883}, {  907154608,  -574449320}, {  900036924,  -585538248}, 
	{  946955747,  -506158392}, {  940673101,  -517740883}, {  934248793,  -529245404}, {  927683790,  -540670223}, 
	{  970651112,  -459083786}, {  964944360,  -470960600}, {  959092290,  -482766489}, {  953095785,  -494499676}, 
	{  992008094,  -410903207}, {  986890984,  -423045732}, {  981625251,  -435124548}, {  976211688,  -447137835}, 
	{ 1010975242,  -361732726}, { 1006460100,  -374111709}, { 1001793390,  -386434353}, {  996975812,  -398698801}, 
	{ 1027506862,  -311690799}, { 1023604567,  -324276419}, { 1019548121,  -336813204}, { 1015338134,  -349299266}, 
	{ 1041563127,  -260897982}, { 1038283080,  -273659918}, { 1034846671,  -286380643}, { 1031254418,  -299058239}, 
	{ 1053110176,  -209476638}, { 1050460278,  -222384147}, { 1047652185,  -235258165}, { 1044686319,  -248096755}, 
	{ 1062120190,  -157550647}, { 1060106826,  -170572633}, { 1057933813,  -183568930}, { 1055601479,  -196537583}, 
	{ 1068571464,  -105245103}, { 1067199483,  -118350194}, { 1065666786,  -131437462}, { 1063973603,  -144504935}, 
	{ 1072448455,   -52686014}, { 1071721163,   -65842639}, { 1070832474,   -78989349}, { 1069782521,   -92124163}, 
	{ 1073741824,           0}, { 1073660973,   -13176464}, { 1073418433,   -26350943}, { 1073014240,   -39521455}, 
	{-1073418433,   -26350943}, {-1073559913,   -19764076}, {-1073660973,   -13176464}, {-1073721611,    -6588356}, 
	{-1072448455,   -52686014}, {-1072751542,   -46104602}, {-1073014240,   -39521455}, {-1073236540,   -32936819}, 
	{-1070832474,   -78989349}, {-1071296985,   -72417357}, {-1071721163,   -65842639}, {-1072104991,   -59265442}, 
	{-1068571464,  -105245103}, {-1069197120,   -98686491}, {-1069782521,   -92124163}, {-1070327646,   -85558366}, 
	{-1065666786,  -131437462}, {-1066453210,  -124896179}, {-1067199483,  -118350194}, {-1067905576,  -111799753}, 
	{-1062120190,  -157550647}, {-1063066909,  -151030634}, {-1063973603,  -144504935}, {-1064840240,  -137973796}, 
	{-1057933813,  -183568930}, {-1059040255,  -177074115}, {-1060106826,  -170572633}, {-1061133483,  -164064728}, 
	{-1053110176,  -209476638}, {-1054375676,  -203010932}, {-1055601479,  -196537583}, {-1056787540,  -190056834}, 
	{-1047652185,  -235258165}, {-1049075980,  -228825464}, {-1050460278,  -222384147}, {-1051805027,  -215934457}, 
	{-1041563127,  -260897982}, {-1043144360,  -254502159}, {-1044686319,  -248096755}, {-1046188946,  -241682010}, 
	{-1034846671,  -286380643}, {-1036584389,  -280025552}, {-1038283080,  -273659918}, {-1039942680,  -267283981}, 
	{-1027506862,  -311690799}, {-1029400018,  -305380268}, {-1031254418,  -299058239}, {-1033069992,  -292724951}, 
	{-1019548121,  -336813204}, {-1021595575,  -330551034}, {-1023604567,  -324276419}, {-1025575020,  -317989595}, 
	{-1010975242,  -361732726}, {-1013175761,  -355522689}, {-1015338134,  -349299266}, {-1017462281,  -343062693}, 
	{-1001793390,  -386434353}, {-1004145648,  -380280190}, {-1006460100,  -374111709}, {-1008736660,  -367929144}, 
	{ -992008094,  -410903207}, { -994510675,  -404808624}, { -996975812,  -398698801}, { -999403415,  -392573967}, 
	{ -981625251,  -435124548}, { -984276646,  -429093217}, { -986890984,  -423045732}, { -989468165,  -416982319}, 
	{ -970651112,  -459083786}, { -973449725,  -453119340}, { -976211688,  -447137835}, { -978936898,  -441139496}, 
	{ -959092290,  -482766489}, { -962036435,  -476872522}, { -964944360,  -470960600}, { -967815955,  -465030947}, 
	{ -946955747,  -506158392}, { -950043650,  -500338453}, { -953095785,  -494499676}, { -956112036,  -488642281}, 
	{ -934248793,  -529245404}, { -937478595,  -523502998}, { -940673101,  -517740883}, { -943832191,  -511959275}, 
	{ -920979082,  -552013618}, { -924348837,  -546352205}, { -927683790,  -540670223}, { -930983817,  -534967884}, 
	{ -907154608,  -574449320}, { -910662286,  -568872310}, { -914135678,  -563273883}, { -917574653,  -557654248}, 
	{ -892783698,  -596538995}, { -896427186,  -591049748}, { -900036924,  -585538248}, { -903612776,  -580004702}, 
	{ -877875009,  -618269338}, { -881652112,  -612871159}, { -885396022,  -607449906}, { -889106597,  -602005783}, 
	{ -862437520,  -639627258}, { -866345964,  -634323400}, { -870221790,  -628995660}, { -874064853,  -623644239}, 
	{ -846480531,  -660599890}, { -850517961,  -655393548}, { -854523370,  -650162530}, { -858496606,  -644907034}, 
	{ -830013654,  -681174602}, { -834177638,  -676068911}, { -838310216,  -670937767}, { -842411232,  -665781362}, 
	{ -813046808,  -701339000}, { -817334838,  -696337036}, { -821592095,  -691308855}, { -825818421,  -686254647}, 
	{ -795590213,  -721080937}, { -799999706,  -716185713}, { -804379079,  -711263525}, { -808728167,  -706314559}, 
	{ -777654384,  -740388522}, { -782182683,  -735602987}, { -786681534,  -730789757}, { -791150767,  -725949013}, 
	{ -759250125,  -759250125}, { -763894504,  -754577161}, { -768510122,  -749875788}, { -773096806,  -745146182}, 
	{ -740388522,  -777654384}, { -745146182,  -773096806}, { -749875788,  -768510122}, { -754577161,  -763894504}, 
	{ -721080937,  -795590213}, { -725949013,  -791150767}, { -730789757,  -786681534}, { -735602987,  -782182683}, 
	{ -701339000,  -813046808}, { -706314559,  -808728167}, { -711263525,  -804379079}, { -716185713,  -799999706}, 
	{ -681174602,  -830013654}, { -686254647,  -825818421}, { -691308855,  -821592095}, { -696337036,  -817334838}, 
	{ -660599890,  -846480531}, { -665781362,  -842411232}, { -670937767,  -838310216}, { -676068911,  -834177638}, 
	{ -639627258,  -862437520}, { -644907034,  -858496606}, { -650162530,  -854523370}, { -655393548,  -850517961}, 
	{ -618269338,  -877875009}, { -623644239,  -874064853}, { -628995660,  -870221790}, { -634323400,  -866345964}, 
	{ -596538995,  -892783698}, { -602005783,  -889106597}, { -607449906,  -885396022}, { -612871159,  -881652112}, 
	{ -574449320,  -907154608}, { -580004702,  -903612776}, { -585538248,  -900036924}, { -591049748,  -896427186}, 
	{ -552013618,  -920979082}, { -557654248,  -917574653}, { -563273883,  -914135678}, { -568872310,  -910662286}, 
	{ -529245404,  -934248793}, { -534967884,  -930983817}, { -540670223,  -927683790}, { -546352205,  -924348837}, 
	{ -506158392,  -946955747}, { -511959275,  -943832191}, { -517740883,  -940673101}, { -523502998,  -937478595}, 
	{ -482766489,  -959092290}, { -488642281,  -956112036}, { -494499676,  -953095785}, { -500338453,  -950043650}, 
	{ -459083786,  -970651112}, { -465030947,  -967815955}, { -470960600,  -964944360}, { -476872522,  -962036435}, 
	{ -435124548,  -981625251}, { -441139496,  -978936898}, { -447137835,  -976211688}, { -453119340,  -973449725}, 
	{ -410903207,  -992008094}, { -416982319,  -989468165}, { -423045732,  -986890984}, { -429093217,  -984276646}, 
	{ -386434353, -1001793390}, { -392573967,  -999403415}, { -398698801,  -996975812}, { -404808624,  -994510675}, 
	{ -361732726, -1010975242}, { -367929144, -1008736660}, { -374111709, -1006460100}, { -380280190, -1004145648}, 
	{ -336813204, -1019548121}, { -343062693, -1017462281}, { -349299266, -1015338134}, { -355522689, -1013175761}, 
	{ -311690799, -1027506862}, { -317989595, -1025575020}, { -324276419, -1023604567}, { -330551034, -1021595575}, 
	{ -286380643, -1034846671}, { -292724951, -1033069992}, { -299058239, -1031254418}, { -305380268, -1029400018}, 
	{ -260897982, -1041563127}, { -267283981, -1039942680}, { -273659918, -1038283080}, { -280025552, -1036584389}, 
	{ -235258165, -1047652185}, { -241682010, -1046188946}, { -248096755, -1044686319}, { -254502159, -1043144360}, 
	{ -209476638, -1053110176}, { -215934457, -1051805027}, { -222384147, -1050460278}, { -228825464, -1049075980}, 
	{ -183568930, -1057933813}, { -190056834, -1056787540}, { -196537583, -1055601479}, { -203010932, -1054375676}, 
	{ -157550647, -1062120190}, { -164064728, -1061133483}, { -170572633, -1060106826}, { -177074115, -1059040255}, 
	{ -131437462, -1065666786}, { -137973796, -1064840240}, { -144504935, -1063973603}, { -151030634, -1063066909}, 
	{ -105245103, -1068571464}, { -111799753, -1067905576}, { -118350194, -1067199483}, { -124896179, -1066453210}, 
	{  -78989349, -1070832474}, {  -85558366, -1070327646}, {  -92124163, -1069782521}, {  -98686491, -1069197120}, 
	{  -52686014, -1072448455}, {  -59265442, -1072104991}, {  -65842639, -1071721163}, {  -72417357, -1071296985}, 
	{  -26350943, -1073418433}, {  -32936819, -1073236540}, {  -39521455, -1073014240}, {  -46104602, -1072751542}, 
	{          0, -1073741824}, {   -6588356, -1073721611}, {  -13176464, -1073660973}, {  -19764076, -1073559913}, 
	{   26350943, -1073418433}, {   19764076, -1073559913}, {   13176464, -1073660973}, {    6588356, -1073721611}, 
	{   52686014, -1072448455}, {   46104602, -1072751542}, {   39521455, -1073014240}, {   32936819, -1073236540}, 
	{   78989349, -1070832474}, {   72417357, -1071296985}, {   65842639, -1071721163}, {   59265442, -1072104991}, 
	{  105245103, -1068571464}, {   98686491, -1069197120}, {   92124163, -1069782521}, {   85558366, -1070327646}, 
	{  131437462, -1065666786}, {  124896179, -1066453210}, {  118350194, -1067199483}, {  111799753, -1067905576}, 
	{  157550647, -1062120190}, {  151030634, -1063066909}, {  144504935, -1063973603}, {  137973796, -1064840240}, 
	{  183568930, -1057933813}, {  177074115, -1059040255}, {  170572633, -1060106826}, {  164064728, -1061133483}, 
	{  209476638, -1053110176}, {  203010932, -1054375676}, {  196537583, -1055601479}, {  190056834, -1056787540}, 
	{  235258165, -1047652185}, {  228825464, -1049075980}, {  222384147, -1050460278}, {  215934457, -1051805027}, 
	{  260897982, -1041563127}, {  254502159, -1043144360}, {  248096755, -1044686319}, {  241682010, -1046188946}, 
	{  286380643, -1034846671}, {  280025552, -1036584389}, {  273659918, -1038283080}, {  267283981, -1039942680}, 
	{  311690799, -1027506862}, {  305380268, -1029400018}, {  299058239, -1031254418}, {  292724951, -1033069992}, 
	{  336813204, -1019548121}, {  330551034, -1021595575}, {  324276419, -1023604567}, {  317989595, -1025575020}, 
	{  361732726, -1010975242}, {  355522689, -1013175761}, {  349299266, -1015338134}, {  343062693, -1017462281}, 
	{  386434353, -1001793390}, {  380280190, -1004145648}, {  374111709, -1006460100}, {  367929144, -1008736660}, 
	{  410903207,  -992008094}, {  404808624,  -994510675}, {  398698801,  -996975812}, {  392573967,  -999403415}, 
	{  435124548,  -981625251}, {  429093217,  -984276646}, {  423045732,  -986890984}, {  416982319,  -989468165}, 
	{  459083786,  -970651112}, {  453119340,  -973449725}, {  447137835,  -976211688}, {  441139496,  -978936898}, 
	{  482766489,  -959092290}, {  476872522,  -962036435}, {  470960600,  -964944360}, {  465030947,  -967815955}, 
	{  506158392,  -946955747}, {  500338453,  -950043650}, {  494499676,  -953095785}, {  488642281,  -956112036}, 
	{  529245404,  -934248793}, {  523502998,  -937478595}, {  517740883,  -940673101}, {  511959275,  -943832191}, 
	{  552013618,  -920979082}, {  546352205,  -924348837}, {  540670223,  -927683790}, {  534967884,  -930983817}, 
	{  574449320,  -907154608}, {  568872310,  -910662286}, {  563273883,  -914135678}, {  557654248,  -917574653}, 
	{  596538995,  -892783698}, {  591049748,  -896427186}, {  585538248,  -900036924}, {  580004702,  -903612776}, 
	{  618269338,  -877875009}, {  612871159,  -881652112}, {  607449906,  -885396022}, {  602005783,  -889106597}, 
	{  639627258,  -862437520}, {  634323400,  -866345964}, {  628995660,  -870221790}, {  623644239,  -874064853}, 
	{  660599890,  -846480531}, {  655393548,  -850517961}, {  650162530,  -854523370}, {  644907034,  -858496606}, 
	{  681174602,  -830013654}, {  676068911,  -834177638}, {  670937767,  -838310216}, {  665781362,  -842411232}, 
	{  701339000,  -813046808}, {  696337036,  -817334838}, {  691308855,  -821592095}, {  686254647,  -825818421}, 
	{  721080937,  -795590213}, {  716185713,  -799999706}, {  711263525,  -804379079}, {  706314559,  -808728167}, 
	{  740388522,  -777654384}, {  735602987,  -782182683}, {  730789757,  -786681534}, {  725949013,  -791150767}, 
	{  759250125,  -759250125}, {  754577161,  -763894504}, {  749875788,  -768510122}, {  745146182,  -773096806}, 
	{  777654384,  -740388522}, {  773096806,  -745146182}, {  768510122,  -749875788}, {  763894504,  -754577161}, 
	{  795590213,  -721080937}, {  791150767,  -725949013}, {  786681534,  -730789757}, {  782182683,  -735602987}, 
	{  813046808,  -701339000}, {  808728167,  -706314559}, {  804379079,  -711263525}, {  799999706,  -716185713}, 
	{  830013654,  -681174602}, {  825818421,  -686254647}, {  821592095,  -691308855}, {  817334838,  -696337036}, 
	{  846480531,  -660599890}, {  842411232,  -665781362}, {  838310216,  -670937767}, {  834177638,  -676068911}, 
	{  862437520,  -639627258}, {  858496606,  -644907034}, {  854523370,  -650162530}, {  850517961,  -655393548}, 
	{  877875009,  -618269338}, {  874064853,  -623644239}, {  870221790,  -628995660}, {  866345964,  -634323400}, 
	{  892783698,  -596538995}, {  889106597,  -602005783}, {  885396022,  -607449906}, {  881652112,  -612871159}, 
	{  907154608,  -574449320}, {  903612776,  -580004702}, {  900036924,  -585538248}, {  896427186,  -591049748}, 
	{  920979082,  -552013618}, {  917574653,  -557654248}, {  914135678,  -563273883}, {  910662286,  -568872310}, 
	{  934248793,  -529245404}, {  930983817,  -534967884}, {  927683790,  -540670223}, {  924348837,  -546352205}, 
	{  946955747,  -506158392}, {  943832191,  -511959275}, {  940673101,  -517740883}, {  937478595,  -523502998}, 
	{  959092290,  -482766489}, {  956112036,  -488642281}, {  953095785,  -494499676}, {  950043650,  -500338453}, 
	{  970651112,  -459083786}, {  967815955,  -465030947}, {  964944360,  -470960600}, {  962036435,  -476872522}, 
	{  981625251,  -435124548}, {  978936898,  -441139496}, {  976211688,  -447137835}, {  973449725,  -453119340}, 
	{  992008094,  -410903207}, {  989468165,  -416982319}, {  986890984,  -423045732}, {  984276646,  -429093217}, 
	{ 1001793390,  -386434353}, {  999403415,  -392573967}, {  996975812,  -398698801}, {  994510675,  -404808624}, 
	{ 1010975242,  -361732726}, { 1008736660,  -367929144}, { 1006460100,  -374111709}, { 1004145648,  -380280190}, 
	{ 1019548121,  -336813204}, { 1017462281,  -343062693}, { 1015338134,  -349299266}, { 1013175761,  -355522689}, 
	{ 1027506862,  -311690799}, { 1025575020,  -317989595}, { 1023604567,  -324276419}, { 1021595575,  -330551034}, 
	{ 1034846671,  -286380643}, { 1033069992,  -292724951}, { 1031254418,  -299058239}, { 1029400018,  -305380268}, 
	{ 1041563127,  -260897982}, { 1039942680,  -267283981}, { 1038283080,  -273659918}, { 1036584389,  -280025552}, 
	{ 1047652185,  -235258165}, { 1046188946,  -241682010}, { 1044686319,  -248096755}, { 1043144360,  -254502159}, 
	{ 1053110176,  -209476638}, { 1051805027,  -215934457}, { 1050460278,  -222384147}, { 1049075980,  -228825464}, 
	{ 1057933813,  -183568930}, { 1056787540,  -190056834}, { 1055601479,  -196537583}, { 1054375676,  -203010932}, 
	{ 1062120190,  -157550647}, { 1061133483,  -164064728}, { 1060106826,  -170572633}, { 1059040255,  -177074115}, 
	{ 1065666786,  -131437462}, { 1064840240,  -137973796}, { 1063973603,  -144504935}, { 1063066909,  -151030634}, 
	{ 1068571464,  -105245103}, { 1067905576,  -111799753}, { 1067199483,  -118350194}, { 1066453210,  -124896179}, 
	{ 1070832474,   -78989349}, { 1070327646,   -85558366}, { 1069782521,   -92124163}, { 1069197120,   -98686491}, 
	{ 1072448455,   -52686014}, { 1072104991,   -59265442}, { 1071721163,   -65842639}, { 1071296985,   -72417357}, 
	{ 1073418433,   -26350943}, { 1073236540,   -32936819}, { 1073014240,   -39521455}, { 1072751542,   -46104602}, 
	{ 1073741824,           0}, { 1073721611,    -6588356}, { 1073660973,   -13176464}, { 1073559913,   -19764076}, 
	};

    
const uint32_t xmath_dit_fft_lut_size = sizeof(xmath_dit_fft_lut);

const complex_s32_t xmath_dif_fft_lut[1020] = 
	{
	{ 1073418433,    26350943}, { 1073559913,    19764076}, { 1073660973,    13176464}, { 1073721611,     6588356}, 
	{ 1072448455,    52686014}, { 1072751542,    46104602}, { 1073014240,    39521455}, { 1073236540,    32936819}, 
	{ 1070832474,    78989349}, { 1071296985,    72417357}, { 1071721163,    65842639}, { 1072104991,    59265442}, 
	{ 1068571464,   105245103}, { 1069197120,    98686491}, { 1069782521,    92124163}, { 1070327646,    85558366}, 
	{ 1065666786,   131437462}, { 1066453210,   124896179}, { 1067199483,   118350194}, { 1067905576,   111799753}, 
	{ 1062120190,   157550647}, { 1063066909,   151030634}, { 1063973603,   144504935}, { 1064840240,   137973796}, 
	{ 1057933813,   183568930}, { 1059040255,   177074115}, { 1060106826,   170572633}, { 1061133483,   164064728}, 
	{ 1053110176,   209476638}, { 1054375676,   203010932}, { 1055601479,   196537583}, { 1056787540,   190056834}, 
	{ 1047652185,   235258165}, { 1049075980,   228825464}, { 1050460278,   222384147}, { 1051805027,   215934457}, 
	{ 1041563127,   260897982}, { 1043144360,   254502159}, { 1044686319,   248096755}, { 1046188946,   241682010}, 
	{ 1034846671,   286380643}, { 1036584389,   280025552}, { 1038283080,   273659918}, { 1039942680,   267283981}, 
	{ 1027506862,   311690799}, { 1029400018,   305380268}, { 1031254418,   299058239}, { 1033069992,   292724951}, 
	{ 1019548121,   336813204}, { 1021595575,   330551034}, { 1023604567,   324276419}, { 1025575020,   317989595}, 
	{ 1010975242,   361732726}, { 1013175761,   355522689}, { 1015338134,   349299266}, { 1017462281,   343062693}, 
	{ 1001793390,   386434353}, { 1004145648,   380280190}, { 1006460100,   374111709}, { 1008736660,   367929144}, 
	{  992008094,   410903207}, {  994510675,   404808624}, {  996975812,   398698801}, {  999403415,   392573967}, 
	{  981625251,   435124548}, {  984276646,   429093217}, {  986890984,   423045732}, {  989468165,   416982319}, 
	{  970651112,   459083786}, {  973449725,   453119340}, {  976211688,   447137835}, {  978936898,   441139496}, 
	{  959092290,   482766489}, {  962036435,   476872522}, {  964944360,   470960600}, {  967815955,   465030947}, 
	{  946955747,   506158392}, {  950043650,   500338453}, {  953095785,   494499676}, {  956112036,   488642281}, 
	{  934248793,   529245404}, {  937478595,   523502998}, {  940673101,   517740883}, {  943832191,   511959275}, 
	{  920979082,   552013618}, {  924348837,   546352205}, {  927683790,   540670223}, {  930983817,   534967884}, 
	{  907154608,   574449320}, {  910662286,   568872310}, {  914135678,   563273883}, {  917574653,   557654248}, 
	{  892783698,   596538995}, {  896427186,   591049748}, {  900036924,   585538248}, {  903612776,   580004702}, 
	{  877875009,   618269338}, {  881652112,   612871159}, {  885396022,   607449906}, {  889106597,   602005783}, 
	{  862437520,   639627258}, {  866345964,   634323400}, {  870221790,   628995660}, {  874064853,   623644239}, 
	{  846480531,   660599890}, {  850517961,   655393548}, {  854523370,   650162530}, {  858496606,   644907034}, 
	{  830013654,   681174602}, {  834177638,   676068911}, {  838310216,   670937767}, {  842411232,   665781362}, 
	{  813046808,   701339000}, {  817334838,   696337036}, {  821592095,   691308855}, {  825818421,   686254647}, 
	{  795590213,   721080937}, {  799999706,   716185713}, {  804379079,   711263525}, {  808728167,   706314559}, 
	{  777654384,   740388522}, {  782182683,   735602987}, {  786681534,   730789757}, {  791150767,   725949013}, 
	{  759250125,   759250125}, {  763894504,   754577161}, {  768510122,   749875788}, {  773096806,   745146182}, 
	{  740388522,   777654384}, {  745146182,   773096806}, {  749875788,   768510122}, {  754577161,   763894504}, 
	{  721080937,   795590213}, {  725949013,   791150767}, {  730789757,   786681534}, {  735602987,   782182683}, 
	{  701339000,   813046808}, {  706314559,   808728167}, {  711263525,   804379079}, {  716185713,   799999706}, 
	{  681174602,   830013654}, {  686254647,   825818421}, {  691308855,   821592095}, {  696337036,   817334838}, 
	{  660599890,   846480531}, {  665781362,   842411232}, {  670937767,   838310216}, {  676068911,   834177638}, 
	{  639627258,   862437520}, {  644907034,   858496606}, {  650162530,   854523370}, {  655393548,   850517961}, 
	{  618269338,   877875009}, {  623644239,   874064853}, {  628995660,   870221790}, {  634323400,   866345964}, 
	{  596538995,   892783698}, {  602005783,   889106597}, {  607449906,   885396022}, {  612871159,   881652112}, 
	{  574449320,   907154608}, {  580004702,   903612776}, {  585538248,   900036924}, {  591049748,   896427186}, 
	{  552013618,   920979082}, {  557654248,   917574653}, {  563273883,   914135678}, {  568872310,   910662286}, 
	{  529245404,   934248793}, {  534967884,   930983817}, {  540670223,   927683790}, {  546352205,   924348837}, 
	{  506158392,   946955747}, {  511959275,   943832191}, {  517740883,   940673101}, {  523502998,   937478595}, 
	{  482766489,   959092290}, {  488642281,   956112036}, {  494499676,   953095785}, {  500338453,   950043650}, 
	{  459083786,   970651112}, {  465030947,   967815955}, {  470960600,   964944360}, {  476872522,   962036435}, 
	{  435124548,   981625251}, {  441139496,   978936898}, {  447137835,   976211688}, {  453119340,   973449725}, 
	{  410903207,   992008094}, {  416982319,   989468165}, {  423045732,   986890984}, {  429093217,   984276646}, 
	{  386434353,  1001793390}, {  392573967,   999403415}, {  398698801,   996975812}, {  404808624,   994510675}, 
	{  361732726,  1010975242}, {  367929144,  1008736660}, {  374111709,  1006460100}, {  380280190,  1004145648}, 
	{  336813204,  1019548121}, {  343062693,  1017462281}, {  349299266,  1015338134}, {  355522689,  1013175761}, 
	{  311690799,  1027506862}, {  317989595,  1025575020}, {  324276419,  1023604567}, {  330551034,  1021595575}, 
	{  286380643,  1034846671}, {  292724951,  1033069992}, {  299058239,  1031254418}, {  305380268,  1029400018}, 
	{  260897982,  1041563127}, {  267283981,  1039942680}, {  273659918,  1038283080}, {  280025552,  1036584389}, 
	{  235258165,  1047652185}, {  241682010,  1046188946}, {  248096755,  1044686319}, {  254502159,  1043144360}, 
	{  209476638,  1053110176}, {  215934457,  1051805027}, {  222384147,  1050460278}, {  228825464,  1049075980}, 
	{  183568930,  1057933813}, {  190056834,  1056787540}, {  196537583,  1055601479}, {  203010932,  1054375676}, 
	{  157550647,  1062120190}, {  164064728,  1061133483}, {  170572633,  1060106826}, {  177074115,  1059040255}, 
	{  131437462,  1065666786}, {  137973796,  1064840240}, {  144504935,  1063973603}, {  151030634,  1063066909}, 
	{  105245103,  1068571464}, {  111799753,  1067905576}, {  118350194,  1067199483}, {  124896179,  1066453210}, 
	{   78989349,  1070832474}, {   85558366,  1070327646}, {   92124163,  1069782521}, {   98686491,  1069197120}, 
	{   52686014,  1072448455}, {   59265442,  1072104991}, {   65842639,  1071721163}, {   72417357,  1071296985}, 
	{   26350943,  1073418433}, {   32936819,  1073236540}, {   39521455,  1073014240}, {   46104602,  1072751542}, 
	{          0,  1073741824}, {    6588356,  1073721611}, {   13176464,  1073660973}, {   19764076,  1073559913}, 
	{  -26350943,  1073418433}, {  -19764076,  1073559913}, {  -13176464,  1073660973}, {   -6588356,  1073721611}, 
	{  -52686014,  1072448455}, {  -46104602,  1072751542}, {  -39521455,  1073014240}, {  -32936819,  1073236540}, 
	{  -78989349,  1070832474}, {  -72417357,  1071296985}, {  -65842639,  1071721163}, {  -59265442,  1072104991}, 
	{ -105245103,  1068571464}, {  -98686491,  1069197120}, {  -92124163,  1069782521}, {  -85558366,  1070327646}, 
	{ -131437462,  1065666786}, { -124896179,  1066453210}, { -118350194,  1067199483}, { -111799753,  1067905576}, 
	{ -157550647,  1062120190}, { -151030634,  1063066909}, { -144504935,  1063973603}, { -137973796,  1064840240}, 
	{ -183568930,  1057933813}, { -177074115,  1059040255}, { -170572633,  1060106826}, { -164064728,  1061133483}, 
	{ -209476638,  1053110176}, { -203010932,  1054375676}, { -196537583,  1055601479}, { -190056834,  1056787540}, 
	{ -235258165,  1047652185}, { -228825464,  1049075980}, { -222384147,  1050460278}, { -215934457,  1051805027}, 
	{ -260897982,  1041563127}, { -254502159,  1043144360}, { -248096755,  1044686319}, { -241682010,  1046188946}, 
	{ -286380643,  1034846671}, { -280025552,  1036584389}, { -273659918,  1038283080}, { -267283981,  1039942680}, 
	{ -311690799,  1027506862}, { -305380268,  1029400018}, { -299058239,  1031254418}, { -292724951,  1033069992}, 
	{ -336813204,  1019548121}, { -330551034,  1021595575}, { -324276419,  1023604567}, { -317989595,  1025575020}, 
	{ -361732726,  1010975242}, { -355522689,  1013175761}, { -349299266,  1015338134}, { -343062693,  1017462281}, 
	{ -386434353,  1001793390}, { -380280190,  1004145648}, { -374111709,  1006460100}, { -367929144,  1008736660}, 
	{ -410903207,   992008094}, { -404808624,   994510675}, { -398698801,   996975812}, { -392573967,   999403415}, 
	{ -435124548,   981625251}, { -429093217,   984276646}, { -423045732,   986890984}, { -416982319,   989468165}, 
	{ -459083786,   970651112}, { -453119340,   973449725}, { -447137835,   976211688}, { -441139496,   978936898}, 
	{ -482766489,   959092290}, { -476872522,   962036435}, { -470960600,   964944360}, { -465030947,   967815955}, 
	{ -506158392,   946955747}, { -500338453,   950043650}, { -494499676,   953095785}, { -488642281,   956112036}, 
	{ -529245404,   934248793}, { -523502998,   937478595}, { -517740883,   940673101}, { -511959275,   943832191}, 
	{ -552013618,   920979082}, { -546352205,   924348837}, { -540670223,   927683790}, { -534967884,   930983817}, 
	{ -574449320,   907154608}, { -568872310,   910662286}, { -563273883,   914135678}, { -557654248,   917574653}, 
	{ -596538995,   892783698}, { -591049748,   896427186}, { -585538248,   900036924}, { -580004702,   903612776}, 
	{ -618269338,   877875009}, { -612871159,   881652112}, { -607449906,   885396022}, { -602005783,   889106597}, 
	{ -639627258,   862437520}, { -634323400,   866345964}, { -628995660,   870221790}, { -623644239,   874064853}, 
	{ -660599890,   846480531}, { -655393548,   850517961}, { -650162530,   854523370}, { -644907034,   858496606}, 
	{ -681174602,   830013654}, { -676068911,   834177638}, { -670937767,   838310216}, { -665781362,   842411232}, 
	{ -701339000,   813046808}, { -696337036,   817334838}, { -691308855,   821592095}, { -686254647,   825818421}, 
	{ -721080937,   795590213}, { -716185713,   799999706}, { -711263525,   804379079}, { -706314559,   808728167}, 
	{ -740388522,   777654384}, { -735602987,   782182683}, { -730789757,   786681534}, { -725949013,   791150767}, 
	{ -759250125,   759250125}, { -754577161,   763894504}, { -749875788,   768510122}, { -745146182,   773096806}, 
	{ -777654384,   740388522}, { -773096806,   745146182}, { -768510122,   749875788}, { -763894504,   754577161}, 
	{ -795590213,   721080937}, { -791150767,   725949013}, { -786681534,   730789757}, { -782182683,   735602987}, 
	{ -813046808,   701339000}, { -808728167,   706314559}, { -804379079,   711263525}, { -799999706,   716185713}, 
	{ -830013654,   681174602}, { -825818421,   686254647}, { -821592095,   691308855}, { -817334838,   696337036}, 
	{ -846480531,   660599890}, { -842411232,   665781362}, { -838310216,   670937767}, { -834177638,   676068911}, 
	{ -862437520,   639627258}, { -858496606,   644907034}, { -854523370,   650162530}, { -850517961,   655393548}, 
	{ -877875009,   618269338}, { -874064853,   623644239}, { -870221790,   628995660}, { -866345964,   634323400}, 
	{ -892783698,   596538995}, { -889106597,   602005783}, { -885396022,   607449906}, { -881652112,   612871159}, 
	{ -907154608,   574449320}, { -903612776,   580004702}, { -900036924,   585538248}, { -896427186,   591049748}, 
	{ -920979082,   552013618}, { -917574653,   557654248}, { -914135678,   563273883}, { -910662286,   568872310}, 
	{ -934248793,   529245404}, { -930983817,   534967884}, { -927683790,   540670223}, { -924348837,   546352205}, 
	{ -946955747,   506158392}, { -943832191,   511959275}, { -940673101,   517740883}, { -937478595,   523502998}, 
	{ -959092290,   482766489}, { -956112036,   488642281}, { -953095785,   494499676}, { -950043650,   500338453}, 
	{ -970651112,   459083786}, { -967815955,   465030947}, { -964944360,   470960600}, { -962036435,   476872522}, 
	{ -981625251,   435124548}, { -978936898,   441139496}, { -976211688,   447137835}, { -973449725,   453119340}, 
	{ -992008094,   410903207}, { -989468165,   416982319}, { -986890984,   423045732}, { -984276646,   429093217}, 
	{-1001793390,   386434353}, { -999403415,   392573967}, { -996975812,   398698801}, { -994510675,   404808624}, 
	{-1010975242,   361732726}, {-1008736660,   367929144}, {-1006460100,   374111709}, {-1004145648,   380280190}, 
	{-1019548121,   336813204}, {-1017462281,   343062693}, {-1015338134,   349299266}, {-1013175761,   355522689}, 
	{-1027506862,   311690799}, {-1025575020,   317989595}, {-1023604567,   324276419}, {-1021595575,   330551034}, 
	{-1034846671,   286380643}, {-1033069992,   292724951}, {-1031254418,   299058239}, {-1029400018,   305380268}, 
	{-1041563127,   260897982}, {-1039942680,   267283981}, {-1038283080,   273659918}, {-1036584389,   280025552}, 
	{-1047652185,   235258165}, {-1046188946,   241682010}, {-1044686319,   248096755}, {-1043144360,   254502159}, 
	{-1053110176,   209476638}, {-1051805027,   215934457}, {-1050460278,   222384147}, {-1049075980,   228825464}, 
	{-1057933813,   183568930}, {-1056787540,   190056834}, {-1055601479,   196537583}, {-1054375676,   203010932}, 
	{-1062120190,   157550647}, {-1061133483,   164064728}, {-1060106826,   170572633}, {-1059040255,   177074115}, 
	{-1065666786,   131437462}, {-1064840240,   137973796}, {-1063973603,   144504935}, {-1063066909,   151030634}, 
	{-1068571464,   105245103}, {-1067905576,   111799753}, {-1067199483,   118350194}, {-1066453210,   124896179}, 
	{-1070832474,    78989349}, {-1070327646,    85558366}, {-1069782521,    92124163}, {-1069197120,    98686491}, 
	{-1072448455,    52686014}, {-1072104991,    59265442}, {-1071721163,    65842639}, {-1071296985,    72417357}, 
	{-1073418433,    26350943}, {-1073236540,    32936819}, {-1073014240,    39521455}, {-1072751542,    46104602}, 
	{-1073741824,           0}, {-1073721611,     6588356}, {-1073660973,    13176464}, {-1073559913,    19764076}, 
	{ 1072448455,    52686014}, { 1073014240,    39521455}, { 1073418433,    26350943}, { 1073660973,    13176464}, 
	{ 1068571464,   105245103}, { 1069782521,    92124163}, { 1070832474,    78989349}, { 1071721163,    65842639}, 
	{ 1062120190,   157550647}, { 1063973603,   144504935}, { 1065666786,   131437462}, { 1067199483,   118350194}, 
	{ 1053110176,   209476638}, { 1055601479,   196537583}, { 1057933813,   183568930}, { 1060106826,   170572633}, 
	{ 1041563127,   260897982}, { 1044686319,   248096755}, { 1047652185,   235258165}, { 1050460278,   222384147}, 
	{ 1027506862,   311690799}, { 1031254418,   299058239}, { 1034846671,   286380643}, { 1038283080,   273659918}, 
	{ 1010975242,   361732726}, { 1015338134,   349299266}, { 1019548121,   336813204}, { 1023604567,   324276419}, 
	{  992008094,   410903207}, {  996975812,   398698801}, { 1001793390,   386434353}, { 1006460100,   374111709}, 
	{  970651112,   459083786}, {  976211688,   447137835}, {  981625251,   435124548}, {  986890984,   423045732}, 
	{  946955747,   506158392}, {  953095785,   494499676}, {  959092290,   482766489}, {  964944360,   470960600}, 
	{  920979082,   552013618}, {  927683790,   540670223}, {  934248793,   529245404}, {  940673101,   517740883}, 
	{  892783698,   596538995}, {  900036924,   585538248}, {  907154608,   574449320}, {  914135678,   563273883}, 
	{  862437520,   639627258}, {  870221790,   628995660}, {  877875009,   618269338}, {  885396022,   607449906}, 
	{  830013654,   681174602}, {  838310216,   670937767}, {  846480531,   660599890}, {  854523370,   650162530}, 
	{  795590213,   721080937}, {  804379079,   711263525}, {  813046808,   701339000}, {  821592095,   691308855}, 
	{  759250125,   759250125}, {  768510122,   749875788}, {  777654384,   740388522}, {  786681534,   730789757}, 
	{  721080937,   795590213}, {  730789757,   786681534}, {  740388522,   777654384}, {  749875788,   768510122}, 
	{  681174602,   830013654}, {  691308855,   821592095}, {  701339000,   813046808}, {  711263525,   804379079}, 
	{  639627258,   862437520}, {  650162530,   854523370}, {  660599890,   846480531}, {  670937767,   838310216}, 
	{  596538995,   892783698}, {  607449906,   885396022}, {  618269338,   877875009}, {  628995660,   870221790}, 
	{  552013618,   920979082}, {  563273883,   914135678}, {  574449320,   907154608}, {  585538248,   900036924}, 
	{  506158392,   946955747}, {  517740883,   940673101}, {  529245404,   934248793}, {  540670223,   927683790}, 
	{  459083786,   970651112}, {  470960600,   964944360}, {  482766489,   959092290}, {  494499676,   953095785}, 
	{  410903207,   992008094}, {  423045732,   986890984}, {  435124548,   981625251}, {  447137835,   976211688}, 
	{  361732726,  1010975242}, {  374111709,  1006460100}, {  386434353,  1001793390}, {  398698801,   996975812}, 
	{  311690799,  1027506862}, {  324276419,  1023604567}, {  336813204,  1019548121}, {  349299266,  1015338134}, 
	{  260897982,  1041563127}, {  273659918,  1038283080}, {  286380643,  1034846671}, {  299058239,  1031254418}, 
	{  209476638,  1053110176}, {  222384147,  1050460278}, {  235258165,  1047652185}, {  248096755,  1044686319}, 
	{  157550647,  1062120190}, {  170572633,  1060106826}, {  183568930,  1057933813}, {  196537583,  1055601479}, 
	{  105245103,  1068571464}, {  118350194,  1067199483}, {  131437462,  1065666786}, {  144504935,  1063973603}, 
	{   52686014,  1072448455}, {   65842639,  1071721163}, {   78989349,  1070832474}, {   92124163,  1069782521}, 
	{          0,  1073741824}, {   13176464,  1073660973}, {   26350943,  1073418433}, {   39521455,  1073014240}, 
	{  -52686014,  1072448455}, {  -39521455,  1073014240}, {  -26350943,  1073418433}, {  -13176464,  1073660973}, 
	{ -105245103,  1068571464}, {  -92124163,  1069782521}, {  -78989349,  1070832474}, {  -65842639,  1071721163}, 
	{ -157550647,  1062120190}, { -144504935,  1063973603}, { -131437462,  1065666786}, { -118350194,  1067199483}, 
	{ -209476638,  1053110176}, { -196537583,  1055601479}, { -183568930,  1057933813}, { -170572633,  1060106826}, 
	{ -260897982,  1041563127}, { -248096755,  1044686319}, { -235258165,  1047652185}, { -222384147,  1050460278}, 
	{ -311690799,  1027506862}, { -299058239,  1031254418}, { -286380643,  1034846671}, { -273659918,  1038283080}, 
	{ -361732726,  1010975242}, { -349299266,  1015338134}, { -336813204,  1019548121}, { -324276419,  1023604567}, 
	{ -410903207,   992008094}, { -398698801,   996975812}, { -386434353,  1001793390}, { -374111709,  1006460100}, 
	{ -459083786,   970651112}, { -447137835,   976211688}, { -435124548,   981625251}, { -423045732,   986890984}, 
	{ -506158392,   946955747}, { -494499676,   953095785}, { -482766489,   959092290}, { -470960600,   964944360}, 
	{ -552013618,   920979082}, { -540670223,   927683790}, { -529245404,   934248793}, { -517740883,   940673101}, 
	{ -596538995,   892783698}, { -585538248,   900036924}, { -574449320,   907154608}, { -563273883,   914135678}, 
	{ -639627258,   862437520}, { -628995660,   870221790}, { -618269338,   877875009}, { -607449906,   885396022}, 
	{ -681174602,   830013654}, { -670937767,   838310216}, { -660599890,   846480531}, { -650162530,   854523370}, 
	{ -721080937,   795590213}, { -711263525,   804379079}, { -701339000,   813046808}, { -691308855,   821592095}, 
	{ -759250125,   759250125}, { -749875788,   768510122}, { -740388522,   777654384}, { -730789757,   786681534}, 
	{ -795590213,   721080937}, { -786681534,   730789757}, { -777654384,   740388522}, { -768510122,   749875788}, 
	{ -830013654,   681174602}, { -821592095,   691308855}, { -813046808,   701339000}, { -804379079,   711263525}, 
	{ -862437520,   639627258}, { -854523370,   650162530}, { -846480531,   660599890}, { -838310216,   670937767}, 
	{ -892783698,   596538995}, { -885396022,   607449906}, { -877875009,   618269338}, { -870221790,   628995660}, 
	{ -920979082,   552013618}, { -914135678,   563273883}, { -907154608,   574449320}, { -900036924,   585538248}, 
	{ -946955747,   506158392}, { -940673101,   517740883}, { -934248793,   529245404}, { -927683790,   540670223}, 
	{ -970651112,   459083786}, { -964944360,   470960600}, { -959092290,   482766489}, { -953095785,   494499676}, 
	{ -992008094,   410903207}, { -986890984,   423045732}, { -981625251,   435124548}, { -976211688,   447137835}, 
	{-1010975242,   361732726}, {-1006460100,   374111709}, {-1001793390,   386434353}, { -996975812,   398698801}, 
	{-1027506862,   311690799}, {-1023604567,   324276419}, {-1019548121,   336813204}, {-1015338134,   349299266}, 
	{-1041563127,   260897982}, {-1038283080,   273659918}, {-1034846671,   286380643}, {-1031254418,   299058239}, 
	{-1053110176,   209476638}, {-1050460278,   222384147}, {-1047652185,   235258165}, {-1044686319,   248096755}, 
	{-1062120190,   157550647}, {-1060106826,   170572633}, {-1057933813,   183568930}, {-1055601479,   196537583}, 
	{-1068571464,   105245103}, {-1067199483,   118350194}, {-1065666786,   131437462}, {-1063973603,   144504935}, 
	{-1072448455,    52686014}, {-1071721163,    65842639}, {-1070832474,    78989349}, {-1069782521,    92124163}, 
	{-1073741824,           0}, {-1073660973,    13176464}, {-1073418433,    26350943}, {-1073014240,    39521455}, 
	{ 1068571464,   105245103}, { 1070832474,    78989349}, { 1072448455,    52686014}, { 1073418433,    26350943}, 
	{ 1053110176,   209476638}, { 1057933813,   183568930}, { 1062120190,   157550647}, { 1065666786,   131437462}, 
	{ 1027506862,   311690799}, { 1034846671,   286380643}, { 1041563127,   260897982}, { 1047652185,   235258165}, 
	{  992008094,   410903207}, { 1001793390,   386434353}, { 1010975242,   361732726}, { 1019548121,   336813204}, 
	{  946955747,   506158392}, {  959092290,   482766489}, {  970651112,   459083786}, {  981625251,   435124548}, 
	{  892783698,   596538995}, {  907154608,   574449320}, {  920979082,   552013618}, {  934248793,   529245404}, 
	{  830013654,   681174602}, {  846480531,   660599890}, {  862437520,   639627258}, {  877875009,   618269338}, 
	{  759250125,   759250125}, {  777654384,   740388522}, {  795590213,   721080937}, {  813046808,   701339000}, 
	{  681174602,   830013654}, {  701339000,   813046808}, {  721080937,   795590213}, {  740388522,   777654384}, 
	{  596538995,   892783698}, {  618269338,   877875009}, {  639627258,   862437520}, {  660599890,   846480531}, 
	{  506158392,   946955747}, {  529245404,   934248793}, {  552013618,   920979082}, {  574449320,   907154608}, 
	{  410903207,   992008094}, {  435124548,   981625251}, {  459083786,   970651112}, {  482766489,   959092290}, 
	{  311690799,  1027506862}, {  336813204,  1019548121}, {  361732726,  1010975242}, {  386434353,  1001793390}, 
	{  209476638,  1053110176}, {  235258165,  1047652185}, {  260897982,  1041563127}, {  286380643,  1034846671}, 
	{  105245103,  1068571464}, {  131437462,  1065666786}, {  157550647,  1062120190}, {  183568930,  1057933813}, 
	{          0,  1073741824}, {   26350943,  1073418433}, {   52686014,  1072448455}, {   78989349,  1070832474}, 
	{ -105245103,  1068571464}, {  -78989349,  1070832474}, {  -52686014,  1072448455}, {  -26350943,  1073418433}, 
	{ -209476638,  1053110176}, { -183568930,  1057933813}, { -157550647,  1062120190}, { -131437462,  1065666786}, 
	{ -311690799,  1027506862}, { -286380643,  1034846671}, { -260897982,  1041563127}, { -235258165,  1047652185}, 
	{ -410903207,   992008094}, { -386434353,  1001793390}, { -361732726,  1010975242}, { -336813204,  1019548121}, 
	{ -506158392,   946955747}, { -482766489,   959092290}, { -459083786,   970651112}, { -435124548,   981625251}, 
	{ -596538995,   892783698}, { -574449320,   907154608}, { -552013618,   920979082}, { -529245404,   934248793}, 
	{ -681174602,   830013654}, { -660599890,   846480531}, { -639627258,   862437520}, { -618269338,   877875009}, 
	{ -759250125,   759250125}, { -740388522,   777654384}, { -721080937,   795590213}, { -701339000,   813046808}, 
	{ -830013654,   681174602}, { -813046808,   701339000}, { -795590213,   721080937}, { -777654384,   740388522}, 
	{ -892783698,   596538995}, { -877875009,   618269338}, { -862437520,   639627258}, { -846480531,   660599890}, 
	{ -946955747,   506158392}, { -934248793,   529245404}, { -920979082,   552013618}, { -907154608,   574449320}, 
	{ -992008094,   410903207}, { -981625251,   435124548}, { -970651112,   459083786}, { -959092290,   482766489}, 
	{-1027506862,   311690799}, {-1019548121,   336813204}, {-1010975242,   361732726}, {-1001793390,   386434353}, 
	{-1053110176,   209476638}, {-1047652185,   235258165}, {-1041563127,   260897982}, {-1034846671,   286380643}, 
	{-1068571464,   105245103}, {-1065666786,   131437462}, {-1062120190,   157550647}, {-1057933813,   183568930}, 
	{-1073741824,           0}, {-1073418433,    26350943}, {-1072448455,    52686014}, {-1070832474,    78989349}, 
	{ 1053110176,   209476638}, { 1062120190,   157550647}, { 1068571464,   105245103}, { 1072448455,    52686014}, 
	{  992008094,   410903207}, { 1010975242,   361732726}, { 1027506862,   311690799}, { 1041563127,   260897982}, 
	{  892783698,   596538995}, {  920979082,   552013618}, {  946955747,   506158392}, {  970651112,   459083786}, 
	{  759250125,   759250125}, {  795590213,   721080937}, {  830013654,   681174602}, {  862437520,   639627258}, 
	{  596538995,   892783698}, {  639627258,   862437520}, {  681174602,   830013654}, {  721080937,   795590213}, 
	{  410903207,   992008094}, {  459083786,   970651112}, {  506158392,   946955747}, {  552013618,   920979082}, 
	{  209476638,  1053110176}, {  260897982,  1041563127}, {  311690799,  1027506862}, {  361732726,  1010975242}, 
	{          0,  1073741824}, {   52686014,  1072448455}, {  105245103,  1068571464}, {  157550647,  1062120190}, 
	{ -209476638,  1053110176}, { -157550647,  1062120190}, { -105245103,  1068571464}, {  -52686014,  1072448455}, 
	{ -410903207,   992008094}, { -361732726,  1010975242}, { -311690799,  1027506862}, { -260897982,  1041563127}, 
	{ -596538995,   892783698}, { -552013618,   920979082}, { -506158392,   946955747}, { -459083786,   970651112}, 
	{ -759250125,   759250125}, { -721080937,   795590213}, { -681174602,   830013654}, { -639627258,   862437520}, 
	{ -892783698,   596538995}, { -862437520,   639627258}, { -830013654,   681174602}, { -795590213,   721080937}, 
	{ -992008094,   410903207}, { -970651112,   459083786}, { -946955747,   506158392}, { -920979082,   552013618}, 
	{-1053110176,   209476638}, {-1041563127,   260897982}, {-1027506862,   311690799}, {-1010975242,   361732726}, 
	{-1073741824,           0}, {-1072448455,    52686014}, {-1068571464,   105245103}, {-1062120190,   157550647}, 
	{  992008094,   410903207}, { 1027506862,   311690799}, { 1053110176,   209476638}, { 1068571464,   105245103}, 
	{  759250125,   759250125}, {  830013654,   681174602}, {  892783698,   596538995}, {  946955747,   506158392}, 
	{  410903207,   992008094}, {  506158392,   946955747}, {  596538995,   892783698}, {  681174602,   830013654}, 
	{          0,  1073741824}, {  105245103,  1068571464}, {  209476638,  1053110176}, {  311690799,  1027506862}, 
	{ -410903207,   992008094}, { -311690799,  1027506862}, { -209476638,  1053110176}, { -105245103,  1068571464}, 
	{ -759250125,   759250125}, { -681174602,   830013654}, { -596538995,   892783698}, { -506158392,   946955747}, 
	{ -992008094,   410903207}, { -946955747,   506158392}, { -892783698,   596538995}, { -830013654,   681174602}, 
	{-1073741824,           0}, {-1068571464,   105245103}, {-1053110176,   209476638}, {-1027506862,   311690799}, 
	{  759250125,   759250125}, {  892783698,   596538995}, {  992008094,   410903207}, { 1053110176,   209476638}, 
	{          0,  1073741824}, {  209476638,  1053110176}, {  410903207,   992008094}, {  596538995,   892783698}, 
	{ -759250125,   759250125}, { -596538995,   892783698}, { -410903207,   992008094}, { -209476638,  1053110176}, 
	{-1073741824,           0}, {-1053110176,   209476638}, { -992008094,   410903207}, { -892783698,   596538995}, 
	{          0,  1073741824}, {  410903207,   992008094}, {  759250125,   759250125}, {  992008094,   410903207}, 
	{-1073741824,           0}, { -992008094,   410903207}, { -759250125,   759250125}, { -410903207,   992008094}, 
	{-1073741824,           0}, { -759250125,   759250125}, {          0,  1073741824}, {  759250125,   759250125}, 
	};

const uint32_t xmath_dif_fft_lut_size = sizeof(xmath_dif_fft_lut);
