// Copyright 2023-2024 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.
// ===========================================================================
// ===========================================================================
//	
// File: IntArithmetic.c
//
// Integer arithmetic implementation file for the SSRC
//
// Target:	MS Windows
// Version: 1.0
//
// ===========================================================================
// ===========================================================================


// ===========================================================================
//
// Includes
//
// ===========================================================================
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>

// Integer arithmetic includes
#include "IntArithmetic.h"

// ===========================================================================
//
// Defines
//
// ===========================================================================




// ===========================================================================
//
// Variables
//
// ===========================================================================



// ===========================================================================
//
// Local Functions prototypes
//
// ===========================================================================




// ===========================================================================
//
// Functions implementations
//
// ===========================================================================

// ==================================================================== //
// Function:		MACC												//
// Description:		32i x 32i -> 64i Multiply-Accumulate				//
// ==================================================================== //
void	MACC(__int64* plAcc, int ix, int iy)
{
	*plAcc += (__int64)ix * (__int64)iy;
}


// ==================================================================== //
// Function:		LATS30												//
// Description:		Saturate 64i to 2^62-1, -2^62						//
// ==================================================================== //
#define		MAX_VAL64		(__int64)0x3FFFFFFFFFFFFFFF
#define		MIN_VAL64		(__int64)0xC000000000000000
void	LSAT30(__int64 *plx)
{
	if(*plx > MAX_VAL64)
		*plx = MAX_VAL64;
	if(*plx < MIN_VAL64)
		*plx = MIN_VAL64;
}


// ==================================================================== //
// Function:		EXT30												//
// Description:		Extracts bits [62-31] into 32i						//
// ==================================================================== //
void	EXT30(int *pr, __int64 lx)
{
	*pr		= (int)(lx>>31);
}



