// Copyright 2016-2021 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.
// ===========================================================================
// ===========================================================================
//
// File: IntArithmetic.c
//
// Integer arithmetic implementation file for the ASRC
//
// Target:    MS Windows
// Version: 1.0
//
// ===========================================================================
// ===========================================================================


// ===========================================================================
//
// Includes
//
// ===========================================================================
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>

// Integer arithmetic includes
#include "src_mrhf_int_arithmetic.h"

// ===========================================================================
//
// Defines
//
// ===========================================================================




// ===========================================================================
//
// Variables
//
// ===========================================================================



// ===========================================================================
//
// Local Functions prototypes
//
// ===========================================================================




// ===========================================================================
//
// Functions implementations
//
// ===========================================================================

// ==================================================================== //
// Function:        MACC                                                //
// Description:        32i x 32i -> 64i Multiply-Accumulate                //
// ==================================================================== //
void    MACC(__int64* plAcc, int ix, int iy)
{
    *plAcc += (__int64)ix * (__int64)iy;
}

// ==================================================================== //
// Function:        LMUL                                                //
// Description:        32i x 32i +32i + 32i -> 64i Multiply (and add)        //
// ==================================================================== //
void    LMUL(__int64* plAcc, int ix, int iy, int ic, int id)
{
    *plAcc = (__int64)ix * (__int64)iy;
    *plAcc += (__int64)ic;
    *plAcc += (__int64)id;
}


// ==================================================================== //
// Function:        LATS30                                                //
// Description:        Saturate 64i to 2^62-1, -2^62                        //
// ==================================================================== //
void    LSAT30(__int64 *plx)
{
    if(*plx > MAX_VAL64_30)
        *plx = MAX_VAL64_30;
    if(*plx < MIN_VAL64_30)
        *plx = MIN_VAL64_30;
}


// ==================================================================== //
// Function:        EXT30                                                //
// Description:        Extracts bits [62-31] into 32i                        //
// ==================================================================== //
void    EXT30(int *pr, __int64 lx)
{
    *pr        = (int)(lx>>31);
}


// ==================================================================== //
// Function:        LATS29                                                //
// Description:        Saturate 64i to 2^61-1, -2^61                        //
// ==================================================================== //
void    LSAT29(__int64 *plx)
{
    if(*plx > MAX_VAL64_29)
        *plx = MAX_VAL64_29;
    if(*plx < MIN_VAL64_29)
        *plx = MIN_VAL64_29;
}


// ==================================================================== //
// Function:        EXT29                                                //
// Description:        Extracts bits [61-30] into 32i                        //
// ==================================================================== //
void    EXT29(int *pr, __int64 lx)
{
    *pr        = (int)(lx>>30);
}



