// Copyright 2023 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.

/*********************************/
/* AUTOGENERATED. DO NOT MODIFY! */
/*********************************/

// Use src_rat_fir_gen.py script to regenare this file
// python src_rat_fir_gen.py -gc True -nt 96

#ifndef _SRC_RAT_COEFS_H_
#define _SRC_RAT_COEFS_H_

#include <stdint.h>

#ifndef ALIGNMENT
#  ifdef __xcore__
#    define ALIGNMENT(N)  __attribute__((aligned (N)))
#  else
#    define ALIGNMENT(N)
#  endif
#endif

#define SRC_RAT_FIR_NUM_TAPS (96)
#define SRC_RAT_FIR_NUM_PHASES_DS (2)
#define SRC_RAT_FIR_TAPS_PER_PHASE_DS (48)
#define SRC_RAT_FIR_NUM_PHASES_US (3)
#define SRC_RAT_FIR_TAPS_PER_PHASE_US (32)

/** q30 coefficients to use for the 48 -> 32 kHz polyphase rational factor downsampling */
extern const int32_t src_rat_fir_ds_coefs[SRC_RAT_FIR_NUM_PHASES_DS][SRC_RAT_FIR_TAPS_PER_PHASE_DS];

/** q30 coefficients to use for the 32 -> 48 kHz polyphase rational factor upsampling */
extern const int32_t src_rat_fir_us_coefs[SRC_RAT_FIR_NUM_PHASES_US][SRC_RAT_FIR_TAPS_PER_PHASE_US];

#endif // _SRC_RAT_COEFS_H_

