#!/usr/bin/env python
# Copyright 2015-2025 XMOS LIMITED.
# This Software is subject to the terms of the XMOS Public Licence: Version 1.
import pytest
import Pyxsim
from Pyxsim import testers
from gpio_events_checker import GPIOEventsChecker

@pytest.mark.parametrize("events", [False, True])
def test_input_events(events, capfd):
    events = int(events)
    path = f"gpio_input_events_test/bin/{events}/gpio_input_events_test_{events}.xe"
    build_ops = [f"EVENTS={events}"]

    if events:
        expected_result = "expected/input_events_test_events.expected"
    else:
        expected_result = "expected/input_events_test_basic.expected"

    checker = GPIOEventsChecker(test_port="tile[0]:XS1_PORT_4D",
                                expected_test_port_data=0b1010,
                                num_clients=4,
                                trigger_port="tile[0]:XS1_PORT_4B")

    tester = testers.ComparisonTester(open(expected_result), regexp=True)

    assert Pyxsim.run_on_simulator(
        path, simthreads=[checker], tester=tester, capfd=capfd, build_options=build_ops)
