// cc -g -m64 -I$XMOS_TOOL_PATH/include -O3 compressor.c $XMOS_TOOL_PATH/lib/libxsidevice.so -o compressor

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "xsidevice.h"

int main(int argc, char *argv[]) {
    int status, i, errors;
    int error = 0;
    double coreclock_period = 1/600e6;
    double tx_period  = 6000e-8;
    double tx_time = 0;
    int clk = 0;
    void *xsim;
    char *chars = "Hello\n";

    
    status = xsi_create(&xsim, argv[1]);
    assert(status == XSI_STATUS_OK);

    int port_val = 0;
    int clk_val = 0;
    double the_time = 0;
    fprintf(stderr, "Simulating\n");
    while(1) {
        status = xsi_clock(xsim);
        assert(status == XSI_STATUS_OK || status == XSI_STATUS_DONE);
        if (status == XSI_STATUS_DONE) {
            status = xsi_terminate(xsim);
            assert(status == XSI_STATUS_OK);
            return 0;
        }
        the_time += coreclock_period;
        unsigned val;
        tx_time += coreclock_period;
        if (tx_time >= tx_period) {
            tx_time -= tx_period;
            status = xsi_drive_port_pins(xsim, "tile[0]", "XS1_PORT_1A", 1, clk_val);
            assert(status == XSI_STATUS_OK || status == XSI_STATUS_DONE );
            status = xsi_drive_port_pins(xsim, "tile[0]", "XS1_PORT_8A", 0xf, port_val);
            assert(status == XSI_STATUS_OK || status == XSI_STATUS_DONE );
            clk_val = !clk_val;
            port_val++;
        }
    }
}
