#include <xcore/channel.h>
#include <xcore/parallel.h>
#include <xs1.h>
#include <stdlib.h>

void lcdInit(void);
void lcdDrive(chanend_t c);

DECLARE_JOB(lcd_thread,  (chanend_t));
DECLARE_JOB(data_thread, (chanend_t));

void data_thread(chanend_t c) {
    for(int i = 0; i < 960; i++) {
        chan_out_word(c, i+0x1000);
    }
    exit(1);
}

void lcd_thread(chanend_t c) {
    lcdInit();
    lcdDrive(c);
}

int main()
{
    channel_t c = chan_alloc();
    PAR_JOBS(
        PJOB(lcd_thread, (c.end_a)),
        PJOB(data_thread, (c.end_b)));
}
