//begin init
#include <xcore/port.h>
#include <xcore/clock.h>
#include <xcore/channel.h>
#include <xs1.h>

port_t   DCLK = XS1_PORT_1A;
port_t   DTMG = XS1_PORT_1B;
port_t   DATA = XS1_PORT_32A;
xclock_t clk  = XS1_CLKBLK_1;

void lcdInit(void) {
    port_enable(DCLK);
    port_enable(DTMG);
    port_enable(DATA);
    clock_enable(clk);
    
    clock_set_divide(clk, 8); // divide by 16 = 100/16 = 6.25 MHz
    port_set_clock(DATA, clk);
    port_set_clock(DTMG, clk);
    port_set_clock(DCLK, clk);
    port_set_out_clock(DCLK);
    clock_start(clk);
}
//end init

//begin drive
void lcdDrive(chanend_t c) {
    unsigned x, time;
    port_out(DTMG, 0);
    time = port_get_trigger_time(DTMG);
    while (1) {
        time += 4235;
        for (int cols=0; cols<320; cols++) {
            time +=20;
            x = chan_in_word(c);
            port_set_trigger_time(DTMG, time);
            port_out(DTMG, 1);
            port_set_trigger_time(DATA, time);
            port_out(DATA, x);   // pixel 1
            for (int rows=1; rows<240; rows++) {
                x = chan_in_word(c);
                port_out(DATA, x);  // pixels 1..239
            }
            port_set_trigger_time(DTMG, time+240);
            port_out(DTMG, 0);
            time += 35; 
        }
    }  
}
//end drive
