// cc -g -m64 -I$XMOS_TOOL_PATH/include -O3 compressor.c $XMOS_TOOL_PATH/lib/libxsidevice.so -o compressor

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "xsidevice.h"

int main(int argc, char *argv[]) {
    int status, i, errors;
    int error = 0;
    double coreclock_period = 1/600e6;
    double rx_period  = 1000e-8;
    double tx_period  = 6000e-8;
    double tx_time = 0;
    int clk = 0;
    void *xsim;
    char *chars = "Hello\n";
    char bits[400];

    int bitcounter = 0;
    int bitreader = 0;
    
    for(char *p = chars; *p != '\0'; p++) {
        for(int bs = 0; bs < 20; bs++) {
            bits[bitcounter++] = 1;
        }
        bits[bitcounter++] = 0;
        for(int bs = 0; bs < 8; bs++) {
            bits[bitcounter++] = ((*p) >> bs) & 1;
        }
        bits[bitcounter++] = 1;
        for(int bs = 0; bs < 20; bs++) {
            bits[bitcounter++] = 1;
        }
    }
    
    status = xsi_create(&xsim, argv[1]);
    assert(status == XSI_STATUS_OK);

    int byte = 0;
    int bits_received = 0;
    int rxing = 0;
    int txing = 0;
    double rx_time = 0;
    double the_time = 0;
    char rx_chars[10];
    int char_cnt = 0;
    fprintf(stderr, "Simulating\n");
    status = xsi_drive_port_pins(xsim, "tile[0]", "XS1_PORT_1B", 1, 1);
    assert(status == XSI_STATUS_OK || status == XSI_STATUS_DONE );
    do {
        status = xsi_clock(xsim);
        assert(status == XSI_STATUS_OK || status == XSI_STATUS_DONE);
        if (status == XSI_STATUS_DONE) {
            status = xsi_terminate(xsim);
            assert(status == XSI_STATUS_OK);
            return 0;
        }
        the_time += coreclock_period;
        unsigned val;
        if (!rxing) {
            status = xsi_sample_port_pins(xsim, "tile[0]", "XS1_PORT_1A", 1, &val);
            assert(status == XSI_STATUS_OK || status == XSI_STATUS_DONE );
            if (val == 0) {
                rxing = 1;
                txing = 1;
                rx_time = 3*rx_period/2;
                bits_received = 0;
                byte = 0;
            }
        } else {
            rx_time -= coreclock_period;
            if (rx_time <= 0) {
                rx_time += rx_period;
                status = xsi_sample_port_pins(xsim, "tile[0]", "XS1_PORT_1A", 1, &val);
                assert(status == XSI_STATUS_OK || status == XSI_STATUS_DONE );
                byte |= val << bits_received;
                bits_received ++;
                if (bits_received == 9) {
                    rxing = 0;
                    rx_chars[char_cnt] = byte;
                    char_cnt++;
                }
            }
        }
        if (txing) {
            tx_time += coreclock_period;
            if (tx_time >= tx_period) {
                tx_time -= tx_period;
                status = xsi_drive_port_pins(xsim, "tile[0]", "XS1_PORT_1B", 1, bits[bitreader++]);
                assert(status == XSI_STATUS_OK || status == XSI_STATUS_DONE );
            }
        }
    } while(bitreader < bitcounter);
    rx_chars[char_cnt] = '\0';
    printf("<%s>\n", rx_chars);
}
