#include <xcore/port.h>
#include <xcore/hwtimer.h>
#include <xs1.h>

#define BIT_RATE 115200
#define BIT_TIME (100000000 / BIT_RATE)

void put_byte(int x) {
}

int get_byte() {
    return 0;
}

void transmitter(port_t TXD) {
    unsigned byte, time;
    port_enable(TXD);
    hwtimer_t t = hwtimer_alloc();

    while (1) {
        // get next byte to transmit
        byte = get_byte();           // defined elsewhere
        time = hwtimer_get_time(t);

        // output start bit
        port_out(TXD, 0);
        time += BIT_TIME;
        hwtimer_set_trigger_time(t, time);
        (void) hwtimer_get_time(t);

        // output data bits
        for (int i=0; i<8; i++) {
            byte = port_out_shift_right(TXD, byte);
            time += BIT_TIME;
            hwtimer_set_trigger_time(t, time);
            (void) hwtimer_get_time(t);
        }

        // output stop bit
        port_out(TXD, 1);
        time += BIT_TIME;
        hwtimer_set_trigger_time(t, time);
        (void) hwtimer_get_time(t);
    }
    hwtimer_free(t);
} // transmitter

void receiver(port_t RXD) {
    unsigned byte, time;
    hwtimer_t t = hwtimer_alloc();
    port_enable(RXD);
    
    while (1) { 
        // wait for start bit
        port_set_trigger_in_equal(RXD, 0);
        (void) port_in(RXD);
        time = hwtimer_get_time(t);
        time += BIT_TIME/2;

        byte = 0;
        // input data bits
        for (int i=0; i<8; i++) {
            time += BIT_TIME;
            hwtimer_set_trigger_time(t, time);
            (void) hwtimer_get_time(t);
            byte = port_in_shift_right(RXD, byte);
        }

        // input stop bit
        time += BIT_TIME;
        hwtimer_set_trigger_time(t, time);
        (void) hwtimer_get_time(t);
        (void) port_in(RXD);

        put_byte(byte >> 24); // defined elsewhere
    }
    hwtimer_free(t);
} // receiver
