#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "xsidevice.h"

int main(int argc, char *argv[]) {
    int status, i, errors;
    int error = 0;
    double clock_step = 1/600e6;
    double ext_clock  = 1/1e5;
    double time = 0;
    int clk = 0;
    void *xsim;
    int counter = 0;

    status = xsi_create(&xsim, argv[1]);
    assert(status == XSI_STATUS_OK);

    fprintf(stderr, "Simulating\n");
    for(int i = 0; i < 10000; i++) {
        status = xsi_clock(xsim);
        assert(status == XSI_STATUS_OK || status == XSI_STATUS_DONE);
        if (status == XSI_STATUS_DONE) {
            status = xsi_terminate(xsim);
            assert(status == XSI_STATUS_OK);
            return 0;
        }
    }
    do {
        status = xsi_clock(xsim);
        assert(status == XSI_STATUS_OK || status == XSI_STATUS_DONE);
        if (status == XSI_STATUS_DONE) {
            status = xsi_terminate(xsim);
            assert(status == XSI_STATUS_OK);
            return 0;
        }
        time += clock_step;
        if (time >= ext_clock/2) {
            time -= ext_clock/2;
            status = xsi_drive_port_pins(xsim, "tile[0]", "XS1_PORT_4A", 0xF, counter);
            status = xsi_drive_port_pins(xsim, "tile[0]", "XS1_PORT_4B", 0xF, ~counter);
            status = xsi_drive_port_pins(xsim, "tile[0]", "XS1_PORT_1A", 1, clk);
            clk = !clk;
            counter++;
            assert(status == XSI_STATUS_OK || status == XSI_STATUS_DONE );
        }
    } while(counter < 16);
}
