#include <xcore/select.h>
#include <xcore/hwtimer.h>
#include <xcore/port.h>

extern void putByte(int b);
extern int  getByte();
extern int  hasData();

void UART(port_t RX, int rxPeriod, port_t TX, int txPeriod) {
    int txByte, rxByte;
    int txI, rxI;
    int rxTime, txTime;
    int isTX = 0;
    int isRX = 0;
    hwtimer_t tmrTX = hwtimer_alloc();
    hwtimer_t tmrRX = hwtimer_alloc();
    port_enable(RX);
    port_enable(TX);
    port_out(TX, 1);
  
    while (1) {
        if (!isTX && hasData()) {
            isTX = 1;
            txI = 0;
            txByte = getByte();
            port_out(TX, 0);            // transmit start bit
            txTime = hwtimer_get_time(tmrTX) + txPeriod;
        }
        if (isRX) {
            hwtimer_set_trigger_time(tmrRX, rxTime);
            port_clear_trigger_in(RX);
        } else {
            port_set_trigger_in_equal(RX, 0);
        }
        if (isTX)
            hwtimer_set_trigger_time(tmrTX, txTime);
    
        SELECT_RES(CASE_GUARD_THEN(RX,   !isRX, start_receiver),
                   CASE_GUARD_THEN(tmrRX, isRX, receive_bit),
                   CASE_GUARD_THEN(tmrTX, isTX, transmit_bit)) {
        start_receiver:
            (void) port_in(RX);
            rxTime = hwtimer_get_time(tmrRX) + rxPeriod * 3 / 2;
            isRX = 1;
            rxI = 0;
            rxByte = 0;
            break;
        
        receive_bit:
            (void) hwtimer_get_time(tmrRX);
            if (rxI < 8) {
                rxByte = port_in_shift_right(RX, rxByte);
                rxI++;
                rxTime += rxPeriod;
            } else { // receive stop bit
                (void) port_in(RX);    // Can be deleted
                putByte(rxByte >> 24);
                isRX = 0;
            }
            break;

        transmit_bit:
            (void) hwtimer_get_time(tmrTX);
            if (txI < 8)
                txByte = port_out_shift_right(TX, txByte);
            else if (txI == 8)
                port_out(TX, 1);      // send stop bit
            else
                isTX = 0;
            txI++;
            txTime += txPeriod;
            break;
        }
    }
    hwtimer_free(tmrTX);
    hwtimer_free(tmrRX);
}
