#include <xs1.h>
#include <print.h>
#include <xcore/select.h>
#include <xcore/hwtimer.h>
#include <xcore/port.h>

#define DELAY_Q 2000

port_t toggleP = XS1_PORT_1A;
port_t dataP   = XS1_PORT_4A;
port_t dataQ   = XS1_PORT_4B;

int main(void) {
    hwtimer_t t = hwtimer_alloc();
    unsigned time, x = 0;
    int data;
    port_enable(toggleP);
    port_enable(dataP);
    port_enable(dataQ);
  
    time = hwtimer_get_time(t);
    time += DELAY_Q;
    port_set_trigger_in_not_equal(toggleP, x);
    hwtimer_set_trigger_time(t, time);
    SELECT_RES(CASE_THEN(toggleP, p_toggled),
               CASE_THEN(t, timer_expired)) {
    p_toggled:
        x = port_in(toggleP);
        port_set_trigger_in_not_equal(toggleP, x);
        data = port_in(dataP);   // Input data from port P
        printchar(data + '0');   // Do something with it
        continue;

    timer_expired:
        time = hwtimer_get_time(t);
        data = port_in(dataQ);   // Input data form port Q
        printchar(data + 'a');   // Do something with it
        time += DELAY_Q;
        hwtimer_set_trigger_time(t, time);
        continue;
    }
    hwtimer_free(t);
}
