#include <xs1.h>
#include <xcore/port.h>
#include <xcore/hwtimer.h>

#define DELAY 50000000

port_t p = XS1_PORT_1A;

int main(void) {
    unsigned state = 1, time;
    port_enable(p);
    hwtimer_t t = hwtimer_alloc();
    time = hwtimer_get_time(t);
    while (1) {
        port_out(p, state);
        time += DELAY;
        hwtimer_set_trigger_time(t, time);
        (void) hwtimer_get_time(t);
        state = !state;
    } 
    hwtimer_free(t);
}

