// Copyright 2024-2025 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.
#pragma once

#include "adsp_module.h"
#include "bump_allocator.h"
#include "pipeline_config.h" // Autogenerated

typedef struct
{
    uint8_t checksum[16];
}pipeline_state_t;

#define PIPELINE_STAGE_REQUIRED_MEMORY 0

void pipeline_init(module_instance_t* instance, adsp_bump_allocator_t* allocator, uint8_t id, int n_inputs, int n_outputs, int frame_size);
void pipeline_control(void *state, module_control_t *control);
