// Copyright 2024-2025 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.
#pragma once

#include "bump_allocator.h"
#include "dsp/drc.h"
#include "limiter_rms_config.h" // Autogenerated

typedef struct
{
    limiter_t *lim;
    int n_inputs;
    int n_outputs;
    int frame_size;
}limiter_rms_state_t;

#define LIMITER_RMS_STAGE_REQUIRED_MEMORY(N_IN) (N_IN * sizeof(limiter_t))

void limiter_rms_init(module_instance_t* instance, adsp_bump_allocator_t* allocator, uint8_t id, int n_inputs, int n_outputs, int frame_size);

void limiter_rms_process(int32_t **input, int32_t **output, void *app_data_state);

void limiter_rms_control(void *state, module_control_t *control);
