// Copyright 2024-2025 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.
#pragma once

#include "bump_allocator.h"
#include "dsp/drc.h"
#include "clipper_config.h" // Autogenerated

typedef struct
{
    clipper_t * clip;
    int n_inputs;
    int n_outputs;
    int frame_size;
}clipper_state_t;

#define CLIPPER_STAGE_REQUIRED_MEMORY(N_IN) (N_IN * sizeof(clipper_t))

void clipper_init(module_instance_t* instance, adsp_bump_allocator_t* allocator, uint8_t id, int n_inputs, int n_outputs, int frame_size);

void clipper_process(int32_t **input, int32_t **output, void *app_data_state);

void clipper_control(void *state, module_control_t *control);
