// Copyright 2024-2025 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.

#include <stdint.h>

#include "mel_tables.h"

// 3x128
const int32_t mel_q30_20_4k[3][MELBANK_KWD_W] = {
  {0,0,0,1,1,2,3,4,5,5,6,7,7,8,8,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,17,17,18,18,18,19,19,
    20,20,20,21,21,21,22,22,22,23,23,23,24,24,24,24,25,25,25,26,26,26,26,27,27,27,27,28,28,28,28,29,29,29,29,
    30,30,30,30,30,31,31,31,31,32,32,32,32,32,33,33,33,33,33,34,34,34,34,34,34,35,35,35,35,35,36,36,36,36,36,36,
    37,37,37,37,37,37,38,38,38,38,38,38,38,39,39,39,39,39,39},
  {0,363815744,801690432,932904896,26775372,228082480,460667296,722360640,1011218304,251742320,589819904,
    950259200,258003120,659326656,5641266,443412448,897967872,294701856,780296832,206533392,720204672,173191792,
    712380544,189734128,752221376,251863040,835697920,355807744,959277120,498243680,46094700,676237312,240864192,
    887167232,467374368,54961300,723408064,324998208,1006981952,621652608,242557936,943223808,575988672,214413872,
    932063296,581303360,235700480,968856704,633148608,302173120,1049539904,727648384,410108256,96807640,861376512,
    556224576,254991856,1031315968,737626240,447561024,161038912,951715584,672026176,395628288,122448144,926153856,
    659193216,395231776,134208512,949796608,694456576,441858976,191955568,1018429696,773731648,531567680,291874240,
    54605528,893452608,660883456,430601856,202549296,1050442240,826746112,605159616,385644544,168165408,1026428416,
    812904064,601308928,391604800,183758640,1051476672,847247296,644779328,444047360,245013200,47654024,925680768,
    731587200,539084736,348152992,158759008,1044621760,858235008,673319936,489848512,307800416,127155344,1021629696,
    843724544,667156352,491904704,317956992,145285168,1047615872,877450176,708509504,540778752,374232384,208865392,
    44652296,955324480,793378240,632540096,472800000,314142656,156547744},
  {0,0,272051392,140836944,1046966464,845659328,613074560,351381184,62523508,821999488,483921920,123482608,815738688,
    414415136,1068100544,630329344,175773936,779040000,293444992,867208448,353537152,900550016,361361312,884007680,
    321520416,821878784,238043904,717934080,114464720,575498176,1027647104,397504512,832877632,186574592,606367424,
    1018780544,350333760,748743616,66759860,452089248,831183872,130517992,497753120,859327936,141678528,492438464,
    838041344,104885112,440593216,771568704,24201910,346093408,663633536,976934208,212365280,517517248,818749952,
    42425880,336115552,626180800,912702912,122026224,401715616,678113536,951293696,147587936,414548576,678510016,
    939533312,123945200,379285248,631882880,881786240,55312116,300010144,542174144,781867584,1019136320,180289232,
    412858368,643139968,871192512,23299612,246995728,468582240,688097280,905576448,47313440,260837728,472432896,
    682137024,889983168,22265148,226494496,428962464,629694464,828728640,1026087808,148061040,342154624,534657088,
    725588800,914982784,29120068,215506800,400421888,583893312,765941440,946586496,52112136,230017280,406585472,
    581837120,755784832,928456640,26125964,196291680,365232288,532963072,699509440,864876416,1029089536,0,0,0,0,0,0},
};

// 3x257
const int32_t mel_q30_00_8k[3][MELBANK_VID_W] = {
{0,0,0,1,1,2,2,3,3,4,5,5,6,6,6,7,7,8,8,9,9,9,10,10,10,11,11,11,12,12,12,13,13,13,14,14,14,14,15,15,15,15,16,16,16,16,
  17,17,17,17,18,18,18,18,19,19,19,19,19,20,20,20,20,20,21,21,21,21,21,21,22,22,22,22,22,22,23,23,23,23,23,23,
  24,24,24,24,24,24,25,25,25,25,25,25,25,26,26,26,26,26,26,26,26,27,27,27,27,27,27,27,27,28,28,28,28,28,28,28,28,
  29,29,29,29,29,29,29,29,29,30,30,30,30,30,30,30,30,30,30,31,31,31,31,31,31,31,31,31,31,32,32,32,32,32,32,32,32,32,32,32,
  33,33,33,33,33,33,33,33,33,33,33,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35,35,35,35,35,35,35,35,35,35,
  36,36,36,36,36,36,36,36,36,36,36,36,36,36,37,37,37,37,37,37,37,37,37,37,37,37,37,37,
  38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,0},
{0,765914304,647829056,1017410432,340536832,762654976,134466192,601826240,15788137,522515424,1047068288,514619456,
  1071661824,569807232,81967744,681123136,219089664,842703808,403883008,1049557504,631729792,223662192,898648768,508796160,
  127451888,827996608,462604928,104700768,827723136,483906496,146726784,889672448,565024128,246300384,1007028096,699524608,
  397338208,100291064,881954688,594677056,312046688,33917916,833891008,564343872,298893408,37414656,853535552,599659264,349419808,
  102711200,933182848,693250688,456573120,223057440,1066364096,838927680,614416640,392753376,173867872,1031432000,817896192,
  606939456,398499296,192519072,1062679936,861443136,662499648,465794656,271282752,78909056,962373760,774145856,587925632,403671424,
  221337808,40886932,936024896,759226368,584202624,410912192,239324752,69406240,974866112,808190592,643089344,479534016,317494368,
  156943920,1071597952,913948544,757706880,602852224,449356224,297197984,146352944,1070542080,922256960,775220672,629410496,484809504,
  341393024,199147824,58047412,991820480,852966400,715207872,578524096,442903776,308327968,174781488,42245468,984450368,853897344,
  724311296,595682688,467990688,341229696,215378848,90424904,1040105792,916914944,794590720,673114240,552474112,432666560,313672672,
  195481056,78087976,1035220224,919382976,804310144,689990400,576412416,463568608,351447616,240041904,129347656,19345950,983771072,
  875139328,767173632,659877760,553232832,447235072,341873056,237146832,133045032,29560096,1000429824,898155520,796471616,695385664,
  594874880,494939392,395575360,296771392,198523744,100824840,3670899,980792704,884710080,789149760,694111616,599580608,505564320,
  412047520,319034080,226508832,134471760,42915312,1025585088,934978560,844841216,755165632,665951744,577188224,488871232,401008384,
  313573152,226580736,140019712,53878772,1041911104,956614080,871733312,787261312,703198016,619532096,536274880,453403648,370926048,
  288838208,207132608,125805440,44856716,1038024384,957820864,877980736,798507648,719390272,640628672,562226624,484172704,406463168,
  329098016,252077248,175393296,99042376,23024486,1021077824,945714944,870677504,795965504,721563776,647483776,573710336,500250976,
  427101952,354251872,281712128,209463808,137514432,65867812,1068250624,997179264,926399232,855903104,785690752,715762304,646110080,
  576734080,507634368,438803360,370244832,301955008,233930064,166170048,98667368,31433384,1038190848,971467520,904990208,838770240,
  772800000,707079552,641605056,576372800,511382752,446634912,382125472,317858240,253821872,190020128,126453016,63112976,0},
{0,0,425912768,56331376,733204992,311086848,939275648,471915552,1057953664,551226432,26673554,559122368,2080013,503934624,991774080,
  392618656,854652160,231038032,669858816,24184350,442012000,850079616,175093072,564945664,946289920,245745248,611136896,969041024,
  246018672,589835328,927015040,184069408,508717664,827441408,66713748,374217248,676403648,973450752,191787120,479064768,761695104,
  1039823936,239850800,509397920,774848448,1036327168,220206256,474082560,724322048,971030592,140558992,380491168,617168704,850684416,
  7377737,234814144,459325184,680988480,899873984,42309804,255845648,466802400,675242496,881222784,11061876,212298704,411242176,
  607947136,802459072,994832768,111368072,299595936,485816160,670070400,852404032,1032854912,137716896,314515488,489539200,662829632,
  834417088,1004335552,98875688,265551248,430652480,594207808,756247424,916797888,2143873,159793312,316034944,470889568,624385600,
  776543808,927388864,3199731,151484880,298521152,444331296,588932288,732348800,874593984,1015694400,81921320,220775424,358533952,
  495217696,630838016,765413888,898960320,1031496384,89291472,219844464,349430528,478059136,605751104,732512128,858362944,983316928,
  33636032,156826880,279151072,400627552,521267712,641075264,760069184,878260736,995653824,38521600,154358880,269431712,383751424,
  497329408,610173184,722294208,833699904,944394176,1054395904,89970776,198602512,306568192,413864064,520508992,626506752,731868800,
  836595008,940696768,1044181696,73312024,175586304,277270208,378356192,478866912,578802432,678166464,776970432,875218048,972916992,
  1070070912,92949112,189031728,284592096,379630208,474161184,568177536,661694272,754707712,847233024,939270080,1030826496,48156732,
  138763296,228900576,318576160,407790048,496553600,584870592,672733440,760168640,847161088,933722112,1019863040,31830748,117127768,
  202008496,286480512,370543808,454209728,537466944,620338176,702815808,784903616,866609216,947936384,1028885120,35717472,115920944,
  195761104,275234176,354351520,433113120,511515200,589569152,667278656,744643840,821664576,898348544,974699456,1050717312,52663972,
  128026888,203064352,277776352,352178016,426258016,500031488,573490816,646639872,719489920,792029696,864278016,936227392,1007873984,
  5491192,76562576,147342560,217838720,288051040,357979552,427631776,497007744,566107456,634938432,703496960,771786816,839811776,907571776,
  975074432,1042308416,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
};

const int32_t hanning_window_q31[KWD_WINDOW_LEN] = {
0,81167,324657,730434,1298435,2028574,2920742,3974804,5190600,6567946,8106634,9806431,11667081,13688302,
15869789,18211212,20712216,23372424,26191433,29168818,32304128,35596889,39046603,42652749,46414781,50332132,
54404208,58630393,63010050,67542516,72227105,77063109,82049798,87186416,92472189,97906316,103487976,109216325,
115090497,121109604,127272736,133578961,140027326,146616856,153346555,160215404,167222367,174366382,181646371,
189061232,196609846,204291069,212103741,220046682,228118689,236318543,244645004,253096813,261672692,270371345,
279191457,288131694,297190704,306367118,315659549,325066592,334586823,344218805,353961081,363812178,373770607,
383834861,394003420,404274746,414647287,425119473,435689723,446356437,457118003,467972794,478919169,489955474,
501080038,512291182,523587209,534966412,546427070,557967451,569585810,581280391,593049425,604891133,616803725,
628785400,640834346,652948742,665126756,677366547,689666264,702024048,714438031,726906336,739427078,751998363,
764618292,777284956,789996440,802750823,815546175,828380564,841252047,854158680,867098511,880069583,893069936,
906097604,919150618,932227004,945324785,958441980,971576608,984726681,997890213,1011065212,1024249687,1037441644,
1050639090,1063840028,1077042463,1090244400,1103443841,1116638792,1129827257,1143007244,1156176758,1169333809,1182476408,
1195602567,1208710303,1221797634,1234862580,1247903168,1260917424,1273903383,1286859079,1299782555,1312671857,1325525036,
1338340148,1351115257,1363848431,1376537745,1389181280,1401777125,1414323376,1426818135,1439259515,1451645632,1463974616,
1476244602,1488453735,1500600170,1512682069,1524697607,1536644966,1548522340,1560327934,1572059963,1583716654,1595296243,
1606796980,1618217126,1629554955,1640808753,1651976818,1663057462,1674049010,1684949799,1695758182,1706472525,1717091207,
1727612624,1738035184,1748357313,1758577448,1768694046,1778705577,1788610527,1798407398,1808094710,1817670998,1827134814,
1836484727,1845719324,1854837209,1863837003,1872717345,1881476893,1890114322,1898628327,1907017621,1915280934,1923417019,
1931424644,1939302599,1947049693,1954664756,1962146634,1969494198,1976706337,1983781959,1990719996,1997519399,2004179139,
2010698209,2017075625,2023310422,2029401656,2035348408,2041149778,2046804890,2052312887,2057672938,2062884233,2067945982,
2072857421,2077617808,2082226422,2086682568,2090985570,2095134779,2099129568,2102969332,2106653491,2110181488,2113552789,
2116766885,2119823290,2122721542,2125461202,2128041857,2130463116,2132724614,2134826007,2136766980,2138547237,2140166510,
2141624555,2142921150,2144056100,2145029233,2145840403,2146489485,2146976383,2147301022,2147463354,2147463354,2147301022,
2146976383,2146489485,2145840403,2145029233,2144056100,2142921150,2141624555,2140166510,2138547237,2136766980,2134826007,
2132724614,2130463116,2128041857,2125461202,2122721542,2119823290,2116766885,2113552789,2110181488,2106653491,2102969332,
2099129568,2095134779,2090985570,2086682568,2082226422,2077617808,2072857421,2067945982,2062884233,2057672938,2052312887,
2046804890,2041149778,2035348408,2029401656,2023310422,2017075625,2010698209,2004179139,1997519399,1990719996,1983781959,
1976706337,1969494198,1962146634,1954664756,1947049693,1939302599,1931424644,1923417019,1915280934,1907017621,1898628327,
1890114322,1881476893,1872717345,1863837003,1854837209,1845719324,1836484727,1827134814,1817670998,1808094710,1798407398,
1788610527,1778705577,1768694046,1758577448,1748357313,1738035184,1727612624,1717091207,1706472525,1695758182,1684949799,
1674049010,1663057462,1651976818,1640808753,1629554955,1618217126,1606796980,1595296243,1583716654,1572059963,1560327934,
1548522340,1536644966,1524697607,1512682069,1500600170,1488453735,1476244602,1463974616,1451645632,1439259515,1426818135,
1414323376,1401777125,1389181280,1376537745,1363848431,1351115257,1338340148,1325525036,1312671857,1299782555,1286859079,
1273903383,1260917424,1247903168,1234862580,1221797634,1208710303,1195602567,1182476408,1169333809,1156176758,1143007244,
1129827257,1116638792,1103443841,1090244400,1077042463,1063840028,1050639090,1037441644,1024249687,1011065212,997890213,
984726681,971576608,958441980,945324785,932227004,919150618,906097604,893069936,880069583,867098511,854158680,841252047,
828380564,815546175,802750823,789996440,777284956,764618292,751998363,739427078,726906336,714438031,702024048,689666264,
677366547,665126756,652948742,640834346,628785400,616803725,604891133,593049425,581280391,569585810,557967451,546427070,
534966412,523587209,512291182,501080038,489955474,478919169,467972794,457118003,446356437,435689723,425119473,414647287,
404274746,394003420,383834861,373770607,363812178,353961081,344218805,334586823,325066592,315659549,306367118,297190704,
288131694,279191457,270371345,261672692,253096813,244645004,236318543,228118689,220046682,212103741,204291069,196609846,
189061232,181646371,174366382,167222367,160215404,153346555,146616856,140027326,133578961,127272736,121109604,115090497,
109216325,103487976,97906316,92472189,87186416,82049798,77063109,72227105,67542516,63010050,58630393,54404208,50332132,
46414781,42652749,39046603,35596889,32304128,29168818,26191433,23372424,20712216,18211212,15869789,13688302,11667081,
9806431,8106634,6567946,5190600,3974804,2920742,2028574,1298435,730434,324657,81167,0};


const int32_t hamming_window_q30[VID_WINDOW_LEN] = {
85899360,85960288,86143104,86447680,86874016,87421952,88091392,88882176,89794080,90826880,91980352,93254176,94648064,
96161632,97794592,99546464,101416800,103405216,105511136,107734112,110073568,112528960,115099616,117784928,120584256,
123496896,126522080,129659168,132907296,136265728,139733536,143309984,146994144,150785056,154681824,158683520,162789120,
166997600,171307936,175719104,180229920,184839360,189546272,194349472,199247744,204239936,209324832,214501120,219767552,
225122784,230565536,236094496,241708256,247405440,253184640,259044448,264983392,271000000,277092832,283260288,289500992,
295813312,302195680,308646592,315164416,321747520,328394240,335103072,341872256,348700160,355585088,362525344,369519232,
376564992,383660864,390805120,397996096,405231872,412510752,419830912,427190560,434587840,442020992,449488128,456987424,
464517024,472075072,479659680,487269024,494901216,502554336,510226560,517915904,525620544,533338560,541068032,548807104,
556553728,564306176,572062464,579820608,587578816,595335104,603087488,610834240,618573248,626302720,634020736,641725376,
649414784,657086976,664740096,672372288,679981632,687566272,695124288,702653888,710153216,717620224,725053440,732450688,
739810304,747130496,754409344,761645184,768836096,775980416,783076352,790122112,797115968,804056192,810941120,817769024,
824538240,831247040,837893824,844476928,850994688,857445632,863827968,870140288,876380992,882548480,888641280,894657920,
900596864,906456704,912235904,917933056,923546816,929075712,934518400,939873664,945140096,950316416,955401280,960393472,
965291776,970094976,974801920,979411328,983922176,988333312,992643648,996852096,1000957696,1004959424,1008856192,1012647104,
1016331264,1019907712,1023375552,1026733952,1029982080,1033119168,1036144384,1039057024,1041856320,1044541632,1047112320,
1049567680,1051907136,1054130112,1056236032,1058224448,1060094784,1061846656,1063479552,1064993152,1066387072,1067660864,
1068814336,1069847168,1070759040,1071549824,1072219264,1072767232,1073193536,1073498112,1073680896,1073741824,1073680896,
1073498112,1073193536,1072767232,1072219264,1071549824,1070759040,1069847168,1068814336,1067660800,1066387072,1064993152,
1063479552,1061846656,1060094720,1058224384,1056235968,1054130048,1051907072,1049567616,1047112192,1044541568,1041856256,
1039056896,1036144256,1033119104,1029982016,1026733824,1023375488,1019907584,1016331136,1012647040,1008856064,1004959296,
1000957696,996852096,992643584,988333248,983922048,979411264,974801792,970094912,965291712,960393472,955401216,950316352,
945140096,939873664,934518400,929075584,923546624,917932928,912235712,906456576,900596736,894657792,888641152,882548352,
876380800,870140160,863827840,857445440,850994560,844476736,837893632,831246848,824538048,817768832,810940928,804056064,
797115776,790121920,783076160,775980224,768835968,761644992,754409216,747130304,739810176,732450496,725053184,717620096,
710152960,702653632,695124032,687566016,679981376,672372032,664739840,657086720,649414528,641725120,634020480,626302464,
618572992,610833920,603087232,595334784,587578752,579820608,572062400,564306176,556553728,548807040,541067968,533338496,
525620480,517915840,510226464,502554272,494901120,487268960,479659616,472074976,464516928,456987328,449488064,442020928,
434587776,427190464,419830848,412510688,405231808,397995968,390805056,383660736,376564864,369519104,362525216,355584960,
348700032,341872128,335102944,328394144,321747360,315164288,308646464,302195584,295813184,289500864,283260192,277092672,
270999872,264983232,259044320,253184512,247405312,241708128,236094368,230565440,225122656,219767392,214500960,209324704,
204239840,199247616,194349344,189546144,184839264,180229792,175718976,171307840,166997504,162788992,158683392,154681696,
150784960,146994016,143309888,139733472,136265600,132907200,129659072,126521984,123496768,120584160,117784832,115099520,
112528864,110073504,107734048,105511072,103405120,101416736,99546432,97794560,96161632,94648032,93254176,91980352,90826880,
89794080,88882176,88091392,87421952,86874016,86447680,86143104,85960288,
};
