// Copyright 2025 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.

#include <stdio.h>

//start glow_fixed_simple
#include <xcore/port.h>
#include <xcore/clock.h>
#include <platform.h>

port_t led = PORT_LEDS;

void glow_fixed_simple(int percentage) {
    int accumulator = 0;
    for(int i = 0; i < 10000000; i++) {
        int on;
        accumulator += percentage;
        if (accumulator >= 100) {
            on = 1;
            accumulator -= 100;
        } else {
            on = 0;
        }
        port_out(led, on);
    }
}
//end glow_fixed_simple

//start glow_fixed_timer
#include <xcore/hwtimer.h>
#include <xcore/port.h>

void glow_fixed_timer(int percentage) {
    hwtimer_t tmr = hwtimer_alloc();
    int accumulator = 0;
    int next_time = hwtimer_get_time(tmr);
    for(int i = 0; i < 5000; i++) {               // five seconds
        int on;
        accumulator += percentage;
        if (accumulator >= 100) {
            on = 1;
            accumulator -= 100;
        } else {
            on = 0;
        }
        next_time += 100000;                      // 1 ms
        hwtimer_set_trigger_time(tmr, next_time);
        (void) hwtimer_get_time(tmr);
        port_out(led, on);
    }
    hwtimer_free(tmr);
}
//end glow_fixed_timer

//start clocked
#include <xcore/port.h>
#include <stdint.h>

void glow_clocked(int percentage) {
    static int accumulator = 0;
    static uint16_t clock_edge_number = 0;
    accumulator += percentage;
    clock_edge_number += 50000;
    port_set_trigger_time(led, clock_edge_number);
    if (accumulator >= 100) {
        accumulator -= 100;
        port_out(led, 1);
    } else {
        port_out(led, 0);
    }
}
//end clocked

//start pulse
#include <math.h>

void pulse() {
    for(int i = 0; i < 10000; i++) {               // five seconds
        glow_clocked(50 + 50 * sinf(i / 2000.0 * 2 * 3.14));
    }
}
//end pulse

int main()
{
    port_enable(led);
    printf("Simple glow\n");
    glow_fixed_simple(35);
    printf("Timer glow\n");
    glow_fixed_timer(35);
    printf("Pulse\n");
    pulse();
}
