// Copyright 2024-2025 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.
#include <string.h>
#include <stdlib.h>
#include <xcore/assert.h>
#include <debug_print.h>
#include "cmds.h" // Autogenerated
#include "cmd_offsets.h" // Autogenerated
#include "stages/dsp_thread.h"

void dsp_thread_init(module_instance_t* instance, adsp_bump_allocator_t* allocator, uint8_t id, int n_inputs, int n_outputs, int frame_size)
{
    dsp_thread_state_t *state = instance->state;
    dsp_thread_config_t *config = instance->control.config;

    memset(state, 0, sizeof(dsp_thread_state_t));

    config->max_cycles = 0;

    instance->state = state;
}

void dsp_thread_control(void *module_state, module_control_t *control)
{
    dsp_thread_state_t *state = module_state;
    dsp_thread_config_t *config = control->config;

    if(control->config_rw_state == config_write_pending)
    {
        // No write commands for the dsp_thread stage
        control->config_rw_state = config_none_pending;
    }
    else if(control->config_rw_state == config_read_pending)
    {
        config->max_cycles = state->max_cycles;
        control->config_rw_state = config_read_updated;
    }
    else
    {
        // nothing to do.
    }
}
