// Copyright 2024 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.

#pragma once

#include "command.hpp"

#define INVALID_INSTANCE_ID (0xff)


/**
 * @brief Look up the string in the option list.
 *
 * If the string is not found, will suggest a possible match and exit.
 *
 * @param str   String sequence to look up
 * @note Function is case insensitive
 */
opt_t * option_lookup(const std::string str);

/**
 * @brief Gets instance ID to use by looking for --instance-id
 *
 * @note Will decrement argc, if option is present
 */
uint8_t get_instance_id(int *argc, char **argv);

/** @brief Print application help menu */
control_ret_t print_help_menu();

/**
 * @brief Print command list loaded from the command_map
 *
 * @note Commands starting with SPECIAL_CMD_ and TEST_ will not be printed
 */
control_ret_t print_command_list();
