# Building host device_control drivers here

# Build device_control_host for USB

add_library(device_control_host_usb INTERFACE)

# Discern OS for libusb library location
if ((${CMAKE_SYSTEM_NAME} MATCHES "Darwin") AND (${CMAKE_SYSTEM_PROCESSOR} MATCHES "x86_64"))
    target_link_directories(device_control_host_usb INTERFACE "${DEVICE_CONTROL_PATH}/host/libusb/OSX64")
    set(libusb-1.0_INCLUDE_DIRS "${DEVICE_CONTROL_PATH}/host/libusb/OSX64")
    set(LINK_LIBS usb-1.0.0)
elseif ((${CMAKE_SYSTEM_NAME} MATCHES "Darwin") AND (${CMAKE_SYSTEM_PROCESSOR} MATCHES "arm64"))
    target_link_directories(device_control_host_usb INTERFACE "${DEVICE_CONTROL_PATH}/host/libusb/OSXARM")
    set(libusb-1.0_INCLUDE_DIRS "${DEVICE_CONTROL_PATH}/host/libusb/OSXARM")
    set(LINK_LIBS usb-1.0.0)
elseif (${CMAKE_SYSTEM_NAME} MATCHES "Linux")
    find_package(PkgConfig)
    pkg_check_modules(libusb-1.0 REQUIRED libusb-1.0)
    set(LINK_LIBS usb-1.0)
elseif (${CMAKE_SYSTEM_NAME} MATCHES "Windows")
    add_compile_definitions(nologo WAll WX- O2 EHa)
    target_link_directories(device_control_host_usb INTERFACE "${CMAKE_CURRENT_LIST_DIR}/device_control/libusb/Win")
    set(libusb-1.0_INCLUDE_DIRS "${CMAKE_CURRENT_LIST_DIR}/device_control/libusb/Win")
    set(LINK_LIBS libusb-1.0)
endif()

target_sources(device_control_host_usb
    INTERFACE
        ${CMAKE_CURRENT_LIST_DIR}/device_control/device_access_usb.c
)
target_include_directories(device_control_host_usb
    INTERFACE
        ${CMAKE_CURRENT_LIST_DIR}/device_control
        ${libusb-1.0_INCLUDE_DIRS}
)
target_link_libraries(device_control_host_usb
    INTERFACE
        ${LINK_LIBS}
)

# Build a wrapper driver for USB

add_library(device_usb STATIC)
target_sources(device_usb
    PRIVATE
        ${CMAKE_CURRENT_LIST_DIR}/device/device_usb.cpp
)
target_include_directories(device_usb
    PUBLIC
        ${CMAKE_CURRENT_LIST_DIR}/device
        ${CMAKE_CURRENT_LIST_DIR}/device_control
)
target_link_libraries(device_usb
    PUBLIC
        device_control_host_usb
)

target_link_libraries(device_usb PRIVATE -fPIC)

if (${CMAKE_SYSTEM_NAME} MATCHES "Darwin")
    add_custom_command(
        TARGET device_usb
        POST_BUILD
        COMMAND ${CMAKE_INSTALL_NAME_TOOL} -change "/usr/local/lib/libusb-1.0.0.dylib" "@executable_path/libusb-1.0.0.dylib" ${CMAKE_BINARY_DIR}/"libdevice_usb.dylib"
    )
    add_custom_command(
        TARGET device_usb
        POST_BUILD
        COMMAND ${CMAKE_COMMAND} -E copy ${DEVICE_CONTROL_PATH}/host/libusb/OSX64/libusb-1.0.0.dylib ${CMAKE_BINARY_DIR}
    )
endif()
