// Copyright 2024 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.

#include "device_usb.hpp"
#include "device_control_host.h"

using namespace std;

Device_USB::Device_USB(int * info)
{
    device_info = info;
}

control_ret_t Device_USB::device_init()
{
    control_ret_t ret = CONTROL_SUCCESS;
    if(!device_initialised)
    {
        ret = control_init_usb(static_cast<int>(device_info[0]), static_cast<int>(device_info[1]), static_cast<int>(device_info[2]));
        device_initialised = true;
    }
    return ret;
}

control_ret_t Device_USB::device_get(control_resid_t res_id, control_cmd_t cmd_id, uint8_t payload[], size_t payload_len)
{
    control_ret_t ret = control_read_command(res_id, cmd_id, payload, payload_len);
    return ret;
}

control_ret_t Device_USB::device_set(control_resid_t res_id, control_cmd_t cmd_id, const uint8_t payload[], size_t payload_len)
{
    control_ret_t ret = control_write_command(res_id, cmd_id, payload, payload_len);
    return ret;
}

Device_USB::~Device_USB()
{
    if(device_initialised)
    {
        control_cleanup_usb();
        device_initialised = false;
    }
}
