// Copyright 2024 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.

// This file contains defines relating to the USB build only

#ifndef _XUA_CONF_H_
#define _XUA_CONF_H_

#define NUM_USB_CHAN_OUT 2
#define NUM_USB_CHAN_IN 2
#define I2S_CHANS_DAC 2
#define I2S_CHANS_ADC 2
#define MCLK_441 (512 * 44100) // (256 * 44100)
#define MCLK_48 (512 * 48000) // (256 * 48000)
#define MIN_FREQ 48000
#define MAX_FREQ 48000
#define DEFAULT_FREQ MIN_FREQ

#define VENDOR_STR "XMOS"
#define VENDOR_ID 0x20B1
#define PRODUCT_STR_A2 "Live Streaming Sound Card"
#define PRODUCT_STR_A1 "Live Streaming Sound Card"
#define PID_AUDIO_1 0x4003
#define PID_AUDIO_2 0x4004
#define AUDIO_CLASS 2
#define AUDIO_IO_TILE 1
#define XUA_DFU_EN 0
#define USB_CONTROL_DESCS 1

#include "user_main.h"

#define VENDOR_REQUESTS_PARAMS c_control
#define VENDOR_REQUESTS_PARAMS_DEC chanend c_control

#endif
