// Copyright 2024 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.

#pragma once

#ifdef __XC__

#include "i2c.h"
#include <platform.h>
#include <xk_audio_316_mc_ab/board.h>
#include "app_dsp.h"

extern unsafe client interface i2c_master_if i_i2c_client;
extern void board_setup();


#define USER_MAIN_DECLARATIONS \
  interface i2c_master_if i2c[1]; \
  chan c_control;

#define USER_MAIN_CORES \
  on tile[0]: {\
    board_setup();\
    xk_audio_316_mc_ab_i2c_master(i2c);\
  }\
  on tile[1]: {\
    {\
      unsafe {\
        i_i2c_client = i2c[0]; \
      }\
      dsp_thread(c_control);\
    }\
  }
#endif
