
#include <stages/adsp_pipeline.h>
#include <stages/adsp_control.h>
#include <xcore/select.h>
#include <xcore/channel.h>
#include <xcore/assert.h>
#include <xcore/hwtimer.h>
#include <xcore/thread.h>
#include <print.h>
#include "cmds.h" // Autogenerated
#include "cmd_offsets.h" // Autogenerated
#include <stages/bump_allocator.h>
#include <dsp/signal_chain.h>

// used in print_max_ticks
static adsp_controller_t* m_control;
#include <stages/pipeline.h>
#include <stages/dsp_thread.h>
#include <stages/adder.h>
#include <stages/volume_control.h>
#include <stages/volume_control.h>
#include <stages/fork.h>
#include <stages/cascaded_biquads.h>
#include <stages/switch.h>
#include <stages/fork.h>
#include <stages/noise_suppressor_expander.h>
#include <stages/switch.h>
#include <stages/dsp_thread.h>
#include <stages/fork.h>
#include <stages/reverb_plate.h>
#include <stages/switch_stereo.h>
#include <stages/fork.h>
#include <stages/dsp_thread.h>
#include <stages/fork.h>
#include <stages/compressor_sidechain.h>
#include <stages/compressor_sidechain.h>
#include <stages/switch_stereo.h>
#include <stages/fork.h>
#include <stages/adder.h>
#include <stages/adder.h>
#include <stages/dsp_thread.h>
#include <stages/switch_stereo.h>
#include <stages/fork.h>
#include <stages/volume_control.h>
#include <stages/switch_stereo.h>
#include <stages/volume_control.h>
#include <pipeline_config.h>
#include <dsp_thread_config.h>
#include <volume_control_config.h>
#include <volume_control_config.h>
#include <cascaded_biquads_config.h>
#include <switch_config.h>
#include <noise_suppressor_expander_config.h>
#include <switch_config.h>
#include <dsp_thread_config.h>
#include <reverb_plate_config.h>
#include <switch_stereo_config.h>
#include <dsp_thread_config.h>
#include <compressor_sidechain_config.h>
#include <compressor_sidechain_config.h>
#include <switch_stereo_config.h>
#include <dsp_thread_config.h>
#include <switch_stereo_config.h>
#include <volume_control_config.h>
#include <switch_stereo_config.h>
#include <volume_control_config.h>
DECLARE_JOB(dsp_auto_thread0, (chanend_t*, chanend_t*, module_instance_t**));
void dsp_auto_thread0(chanend_t* c_source, chanend_t* c_dest, module_instance_t** modules) {
	local_thread_mode_set_bits(thread_mode_high_priority);	int32_t edge0[1] = {0};
	int32_t edge1[1] = {0};
	int32_t edge2[1] = {0};
	int32_t edge3[1] = {0};
	int32_t edge4[1] = {0};
	int32_t edge5[1] = {0};
	int32_t edge6[1] = {0};
	int32_t edge7[1] = {0};
	int32_t edge8[1] = {0};
	int32_t edge9[1] = {0};
	int32_t edge10[1] = {0};
	int32_t edge11[1] = {0};
	int32_t edge12[1] = {0};
	int32_t edge13[1] = {0};
	int32_t edge14[1] = {0};
	int32_t edge15[1] = {0};
	int32_t* stage_2_input[] = {edge2, edge3};
	int32_t* stage_2_output[] = {edge4};
	int32_t* stage_3_input[] = {edge0, edge1};
	int32_t* stage_3_output[] = {edge13, edge14};
	int32_t* stage_4_input[] = {edge4};
	int32_t* stage_4_output[] = {edge5};
	int32_t* stage_5_input[] = {edge5};
	int32_t* stage_5_output[] = {edge6, edge7};
	int32_t* stage_6_input[] = {edge6};
	int32_t* stage_6_output[] = {edge8};
	int32_t* stage_7_input[] = {edge7, edge8};
	int32_t* stage_7_output[] = {edge9};
	int32_t* stage_8_input[] = {edge9};
	int32_t* stage_8_output[] = {edge10, edge11};
	int32_t* stage_9_input[] = {edge10};
	int32_t* stage_9_output[] = {edge12};
	int32_t* stage_10_input[] = {edge11, edge12};
	int32_t* stage_10_output[] = {edge15};
	uint32_t start_ts, end_ts, start_control_ts, control_ticks;
	bool control_done;
	while(1) {
	control_done = false;
	int read_count = 1;
	SELECT_RES(
		CASE_THEN(c_source[0], case_0),
		DEFAULT_THEN(do_control)
	) {
		case_0: {
			chan_in_buf_word(c_source[0], (uint32_t*)edge0, 1); for(int idx = 0; idx < 1; ++idx) edge0[idx] = adsp_from_q31(edge0[idx]);
			chan_in_buf_word(c_source[0], (uint32_t*)edge1, 1); for(int idx = 0; idx < 1; ++idx) edge1[idx] = adsp_from_q31(edge1[idx]);
			chan_in_buf_word(c_source[0], (uint32_t*)edge2, 1); for(int idx = 0; idx < 1; ++idx) edge2[idx] = adsp_from_q31(edge2[idx]);
			chan_in_buf_word(c_source[0], (uint32_t*)edge3, 1); for(int idx = 0; idx < 1; ++idx) edge3[idx] = adsp_from_q31(edge3[idx]);
			if(!--read_count) break;
			else continue;
		}
		do_control: {
		start_control_ts = get_reference_time();
		pipeline_control(modules[0]->state, &modules[0]->control);
		dsp_thread_control(modules[1]->state, &modules[1]->control);
		volume_control_control(modules[3]->state, &modules[3]->control);
		volume_control_control(modules[4]->state, &modules[4]->control);
		cascaded_biquads_control(modules[6]->state, &modules[6]->control);
		switch_control(modules[7]->state, &modules[7]->control);
		noise_suppressor_expander_control(modules[9]->state, &modules[9]->control);
		switch_control(modules[10]->state, &modules[10]->control);
		control_done = true;
		control_ticks = get_reference_time() - start_control_ts;
		continue; }
	}
	if(!control_done){
		start_control_ts = get_reference_time();
		pipeline_control(modules[0]->state, &modules[0]->control);
		dsp_thread_control(modules[1]->state, &modules[1]->control);
		volume_control_control(modules[3]->state, &modules[3]->control);
		volume_control_control(modules[4]->state, &modules[4]->control);
		cascaded_biquads_control(modules[6]->state, &modules[6]->control);
		switch_control(modules[7]->state, &modules[7]->control);
		noise_suppressor_expander_control(modules[9]->state, &modules[9]->control);
		switch_control(modules[10]->state, &modules[10]->control);
		control_ticks = get_reference_time() - start_control_ts;
	}
	start_ts = get_reference_time();

	adder_process(
		stage_2_input,
		stage_2_output,
		modules[2]->state);
	volume_control_process(
		stage_3_input,
		stage_3_output,
		modules[3]->state);
	volume_control_process(
		stage_4_input,
		stage_4_output,
		modules[4]->state);
	fork_process(
		stage_5_input,
		stage_5_output,
		modules[5]->state);
	cascaded_biquads_process(
		stage_6_input,
		stage_6_output,
		modules[6]->state);
	switch_process(
		stage_7_input,
		stage_7_output,
		modules[7]->state);
	fork_process(
		stage_8_input,
		stage_8_output,
		modules[8]->state);
	noise_suppressor_expander_process(
		stage_9_input,
		stage_9_output,
		modules[9]->state);
	switch_process(
		stage_10_input,
		stage_10_output,
		modules[10]->state);

	end_ts = get_reference_time();
	uint32_t process_plus_control_ticks = (end_ts - start_ts) + control_ticks;
	if(process_plus_control_ticks > ((dsp_thread_state_t*)(modules[1]->state))->max_cycles)
	{
		((dsp_thread_state_t*)(modules[1]->state))->max_cycles = process_plus_control_ticks;
	}
	chan_out_buf_word(c_dest[0], (void*)edge13, 1);
	chan_out_buf_word(c_dest[0], (void*)edge14, 1);
	chan_out_buf_word(c_dest[0], (void*)edge15, 1);
	}
}
DECLARE_JOB(dsp_auto_thread1, (chanend_t*, chanend_t*, module_instance_t**));
void dsp_auto_thread1(chanend_t* c_source, chanend_t* c_dest, module_instance_t** modules) {
	local_thread_mode_set_bits(thread_mode_high_priority);	int32_t edge0[1] = {0};
	int32_t edge1[1] = {0};
	int32_t edge2[1] = {0};
	int32_t edge3[1] = {0};
	int32_t edge4[1] = {0};
	int32_t edge5[1] = {0};
	int32_t edge6[1] = {0};
	int32_t edge7[1] = {0};
	int32_t edge8[1] = {0};
	int32_t edge9[1] = {0};
	int32_t edge10[1] = {0};
	int32_t edge11[1] = {0};
	int32_t edge12[1] = {0};
	int32_t edge13[1] = {0};
	int32_t edge14[1] = {0};
	int32_t* stage_1_input[] = {edge0, edge1};
	int32_t* stage_1_output[] = {edge11, edge12, edge13, edge14};
	int32_t* stage_2_input[] = {edge2};
	int32_t* stage_2_output[] = {edge3, edge4, edge5, edge6};
	int32_t* stage_3_input[] = {edge5, edge6};
	int32_t* stage_3_output[] = {edge7, edge8};
	int32_t* stage_4_input[] = {edge3, edge4, edge7, edge8};
	int32_t* stage_4_output[] = {edge9, edge10};
	uint32_t start_ts, end_ts, start_control_ts, control_ticks;
	bool control_done;
	while(1) {
	control_done = false;
	chan_out_buf_word(c_dest[0], (void*)edge9, 1);
	chan_out_buf_word(c_dest[0], (void*)edge10, 1);
	chan_out_buf_word(c_dest[0], (void*)edge11, 1);
	chan_out_buf_word(c_dest[0], (void*)edge12, 1);
	chan_out_buf_word(c_dest[0], (void*)edge13, 1);
	chan_out_buf_word(c_dest[0], (void*)edge14, 1);
	int read_count = 1;
	SELECT_RES(
		CASE_THEN(c_source[0], case_0),
		DEFAULT_THEN(do_control)
	) {
		case_0: {
			chan_in_buf_word(c_source[0], (void*)edge0, 1);
			chan_in_buf_word(c_source[0], (void*)edge1, 1);
			chan_in_buf_word(c_source[0], (void*)edge2, 1);
			if(!--read_count) break;
			else continue;
		}
		do_control: {
		start_control_ts = get_reference_time();
		dsp_thread_control(modules[0]->state, &modules[0]->control);
		reverb_plate_control(modules[3]->state, &modules[3]->control);
		switch_stereo_control(modules[4]->state, &modules[4]->control);
		control_done = true;
		control_ticks = get_reference_time() - start_control_ts;
		continue; }
	}
	if(!control_done){
		start_control_ts = get_reference_time();
		dsp_thread_control(modules[0]->state, &modules[0]->control);
		reverb_plate_control(modules[3]->state, &modules[3]->control);
		switch_stereo_control(modules[4]->state, &modules[4]->control);
		control_ticks = get_reference_time() - start_control_ts;
	}
	start_ts = get_reference_time();

	fork_process(
		stage_1_input,
		stage_1_output,
		modules[1]->state);
	fork_process(
		stage_2_input,
		stage_2_output,
		modules[2]->state);
	reverb_plate_process(
		stage_3_input,
		stage_3_output,
		modules[3]->state);
	switch_stereo_process(
		stage_4_input,
		stage_4_output,
		modules[4]->state);

	end_ts = get_reference_time();
	uint32_t process_plus_control_ticks = (end_ts - start_ts) + control_ticks;
	if(process_plus_control_ticks > ((dsp_thread_state_t*)(modules[0]->state))->max_cycles)
	{
		((dsp_thread_state_t*)(modules[0]->state))->max_cycles = process_plus_control_ticks;
	}
	}
}
DECLARE_JOB(dsp_auto_thread2, (chanend_t*, chanend_t*, module_instance_t**));
void dsp_auto_thread2(chanend_t* c_source, chanend_t* c_dest, module_instance_t** modules) {
	local_thread_mode_set_bits(thread_mode_high_priority);	int32_t edge0[1] = {0};
	int32_t edge1[1] = {0};
	int32_t edge2[1] = {0};
	int32_t edge3[1] = {0};
	int32_t edge4[1] = {0};
	int32_t edge5[1] = {0};
	int32_t edge6[1] = {0};
	int32_t edge7[1] = {0};
	int32_t edge8[1] = {0};
	int32_t edge9[1] = {0};
	int32_t edge10[1] = {0};
	int32_t edge11[1] = {0};
	int32_t edge12[1] = {0};
	int32_t edge13[1] = {0};
	int32_t edge14[1] = {0};
	int32_t edge15[1] = {0};
	int32_t edge16[1] = {0};
	int32_t edge17[1] = {0};
	int32_t edge18[1] = {0};
	int32_t edge19[1] = {0};
	int32_t edge20[1] = {0};
	int32_t edge21[1] = {0};
	int32_t* stage_1_input[] = {edge0, edge1};
	int32_t* stage_1_output[] = {edge6, edge7, edge16, edge8, edge9, edge17};
	int32_t* stage_2_input[] = {edge3, edge6};
	int32_t* stage_2_output[] = {edge10};
	int32_t* stage_3_input[] = {edge5, edge8};
	int32_t* stage_3_output[] = {edge11};
	int32_t* stage_4_input[] = {edge2, edge4, edge10, edge11};
	int32_t* stage_4_output[] = {edge12, edge13};
	int32_t* stage_5_input[] = {edge12, edge13};
	int32_t* stage_5_output[] = {edge14, edge18, edge15, edge19};
	int32_t* stage_6_input[] = {edge14, edge7};
	int32_t* stage_6_output[] = {edge20};
	int32_t* stage_7_input[] = {edge15, edge9};
	int32_t* stage_7_output[] = {edge21};
	uint32_t start_ts, end_ts, start_control_ts, control_ticks;
	bool control_done;
	while(1) {
	control_done = false;
	chan_out_buf_word(c_dest[0], (void*)edge16, 1);
	chan_out_buf_word(c_dest[0], (void*)edge17, 1);
	chan_out_buf_word(c_dest[0], (void*)edge18, 1);
	chan_out_buf_word(c_dest[0], (void*)edge19, 1);
	chan_out_buf_word(c_dest[0], (void*)edge20, 1);
	chan_out_buf_word(c_dest[0], (void*)edge21, 1);
	int read_count = 1;
	SELECT_RES(
		CASE_THEN(c_source[0], case_0),
		DEFAULT_THEN(do_control)
	) {
		case_0: {
			chan_in_buf_word(c_source[0], (void*)edge0, 1);
			chan_in_buf_word(c_source[0], (void*)edge1, 1);
			chan_in_buf_word(c_source[0], (void*)edge2, 1);
			chan_in_buf_word(c_source[0], (void*)edge3, 1);
			chan_in_buf_word(c_source[0], (void*)edge4, 1);
			chan_in_buf_word(c_source[0], (void*)edge5, 1);
			if(!--read_count) break;
			else continue;
		}
		do_control: {
		start_control_ts = get_reference_time();
		dsp_thread_control(modules[0]->state, &modules[0]->control);
		compressor_sidechain_control(modules[2]->state, &modules[2]->control);
		compressor_sidechain_control(modules[3]->state, &modules[3]->control);
		switch_stereo_control(modules[4]->state, &modules[4]->control);
		control_done = true;
		control_ticks = get_reference_time() - start_control_ts;
		continue; }
	}
	if(!control_done){
		start_control_ts = get_reference_time();
		dsp_thread_control(modules[0]->state, &modules[0]->control);
		compressor_sidechain_control(modules[2]->state, &modules[2]->control);
		compressor_sidechain_control(modules[3]->state, &modules[3]->control);
		switch_stereo_control(modules[4]->state, &modules[4]->control);
		control_ticks = get_reference_time() - start_control_ts;
	}
	start_ts = get_reference_time();

	fork_process(
		stage_1_input,
		stage_1_output,
		modules[1]->state);
	compressor_sidechain_process(
		stage_2_input,
		stage_2_output,
		modules[2]->state);
	compressor_sidechain_process(
		stage_3_input,
		stage_3_output,
		modules[3]->state);
	switch_stereo_process(
		stage_4_input,
		stage_4_output,
		modules[4]->state);
	fork_process(
		stage_5_input,
		stage_5_output,
		modules[5]->state);
	adder_process(
		stage_6_input,
		stage_6_output,
		modules[6]->state);
	adder_process(
		stage_7_input,
		stage_7_output,
		modules[7]->state);

	end_ts = get_reference_time();
	uint32_t process_plus_control_ticks = (end_ts - start_ts) + control_ticks;
	if(process_plus_control_ticks > ((dsp_thread_state_t*)(modules[0]->state))->max_cycles)
	{
		((dsp_thread_state_t*)(modules[0]->state))->max_cycles = process_plus_control_ticks;
	}
	}
}
DECLARE_JOB(dsp_auto_thread3, (chanend_t*, chanend_t*, module_instance_t**));
void dsp_auto_thread3(chanend_t* c_source, chanend_t* c_dest, module_instance_t** modules) {
	local_thread_mode_set_bits(thread_mode_high_priority);	int32_t edge0[1] = {0};
	int32_t edge1[1] = {0};
	int32_t edge2[1] = {0};
	int32_t edge3[1] = {0};
	int32_t edge4[1] = {0};
	int32_t edge5[1] = {0};
	int32_t edge6[1] = {0};
	int32_t edge7[1] = {0};
	int32_t edge8[1] = {0};
	int32_t edge9[1] = {0};
	int32_t edge10[1] = {0};
	int32_t edge11[1] = {0};
	int32_t edge12[1] = {0};
	int32_t edge13[1] = {0};
	int32_t edge14[1] = {0};
	int32_t edge15[1] = {0};
	int32_t edge16[1] = {0};
	int32_t edge17[1] = {0};
	int32_t* stage_1_input[] = {edge0, edge1, edge4, edge5};
	int32_t* stage_1_output[] = {edge6, edge7};
	int32_t* stage_2_input[] = {edge6, edge7};
	int32_t* stage_2_output[] = {edge8, edge9, edge10, edge11};
	int32_t* stage_3_input[] = {edge8, edge10};
	int32_t* stage_3_output[] = {edge14, edge15};
	int32_t* stage_4_input[] = {edge2, edge3, edge9, edge11};
	int32_t* stage_4_output[] = {edge12, edge13};
	int32_t* stage_5_input[] = {edge12, edge13};
	int32_t* stage_5_output[] = {edge16, edge17};
	uint32_t start_ts, end_ts, start_control_ts, control_ticks;
	bool control_done;
	while(1) {
	control_done = false;
	for(int idx = 0; idx < 1; ++idx) edge14[idx] = adsp_to_q31(edge14[idx]); chan_out_buf_word(c_dest[0], (uint32_t*)edge14, 1);
	for(int idx = 0; idx < 1; ++idx) edge15[idx] = adsp_to_q31(edge15[idx]); chan_out_buf_word(c_dest[0], (uint32_t*)edge15, 1);
	for(int idx = 0; idx < 1; ++idx) edge16[idx] = adsp_to_q31(edge16[idx]); chan_out_buf_word(c_dest[0], (uint32_t*)edge16, 1);
	for(int idx = 0; idx < 1; ++idx) edge17[idx] = adsp_to_q31(edge17[idx]); chan_out_buf_word(c_dest[0], (uint32_t*)edge17, 1);
	int read_count = 1;
	SELECT_RES(
		CASE_THEN(c_source[0], case_0),
		DEFAULT_THEN(do_control)
	) {
		case_0: {
			chan_in_buf_word(c_source[0], (void*)edge0, 1);
			chan_in_buf_word(c_source[0], (void*)edge1, 1);
			chan_in_buf_word(c_source[0], (void*)edge2, 1);
			chan_in_buf_word(c_source[0], (void*)edge3, 1);
			chan_in_buf_word(c_source[0], (void*)edge4, 1);
			chan_in_buf_word(c_source[0], (void*)edge5, 1);
			if(!--read_count) break;
			else continue;
		}
		do_control: {
		start_control_ts = get_reference_time();
		dsp_thread_control(modules[0]->state, &modules[0]->control);
		switch_stereo_control(modules[1]->state, &modules[1]->control);
		volume_control_control(modules[3]->state, &modules[3]->control);
		switch_stereo_control(modules[4]->state, &modules[4]->control);
		volume_control_control(modules[5]->state, &modules[5]->control);
		control_done = true;
		control_ticks = get_reference_time() - start_control_ts;
		continue; }
	}
	if(!control_done){
		start_control_ts = get_reference_time();
		dsp_thread_control(modules[0]->state, &modules[0]->control);
		switch_stereo_control(modules[1]->state, &modules[1]->control);
		volume_control_control(modules[3]->state, &modules[3]->control);
		switch_stereo_control(modules[4]->state, &modules[4]->control);
		volume_control_control(modules[5]->state, &modules[5]->control);
		control_ticks = get_reference_time() - start_control_ts;
	}
	start_ts = get_reference_time();

	switch_stereo_process(
		stage_1_input,
		stage_1_output,
		modules[1]->state);
	fork_process(
		stage_2_input,
		stage_2_output,
		modules[2]->state);
	volume_control_process(
		stage_3_input,
		stage_3_output,
		modules[3]->state);
	switch_stereo_process(
		stage_4_input,
		stage_4_output,
		modules[4]->state);
	volume_control_process(
		stage_5_input,
		stage_5_output,
		modules[5]->state);

	end_ts = get_reference_time();
	uint32_t process_plus_control_ticks = (end_ts - start_ts) + control_ticks;
	if(process_plus_control_ticks > ((dsp_thread_state_t*)(modules[0]->state))->max_cycles)
	{
		((dsp_thread_state_t*)(modules[0]->state))->max_cycles = process_plus_control_ticks;
	}
	}
}
adsp_pipeline_t * adsp_auto_pipeline_init() {
	static adsp_pipeline_t adsp_auto;
	static adsp_controller_t adsp_auto_controller;
	m_control = &adsp_auto_controller;
	static channel_t adsp_auto_in_chans[1];
	static channel_t adsp_auto_out_chans[1];
	static channel_t adsp_auto_link_chans[3];
	static module_instance_t adsp_auto_modules[30];
	static adsp_mux_elem_t adsp_auto_in_mux_cfgs[] = {
		{ .channel_idx = 0, .data_idx = 0, .frame_size = 1},
		{ .channel_idx = 0, .data_idx = 1, .frame_size = 1},
		{ .channel_idx = 0, .data_idx = 2, .frame_size = 1},
		{ .channel_idx = 0, .data_idx = 3, .frame_size = 1},
	};
	static adsp_mux_elem_t adsp_auto_out_mux_cfgs[] = {
		{ .channel_idx = 0, .data_idx = 0, .frame_size = 1},
		{ .channel_idx = 0, .data_idx = 1, .frame_size = 1},
		{ .channel_idx = 0, .data_idx = 2, .frame_size = 1},
		{ .channel_idx = 0, .data_idx = 3, .frame_size = 1},
	};
	adsp_auto.input_mux.n_chan = 4;
	adsp_auto.input_mux.chan_cfg = (adsp_mux_elem_t *) adsp_auto_in_mux_cfgs;
	adsp_auto.output_mux.n_chan = 4;
	adsp_auto.output_mux.chan_cfg = (adsp_mux_elem_t *) adsp_auto_out_mux_cfgs;
	adsp_auto_in_chans[0] = chan_alloc();
	adsp_auto_out_chans[0] = chan_alloc();
	adsp_auto_link_chans[0] = chan_alloc();
	adsp_auto_link_chans[1] = chan_alloc();
	adsp_auto_link_chans[2] = chan_alloc();
	adsp_auto.p_in = (channel_t *) adsp_auto_in_chans;
	adsp_auto.n_in = 1;
	adsp_auto.p_out = (channel_t *) adsp_auto_out_chans;
	adsp_auto.n_out = 1;
	adsp_auto.p_link = (channel_t *) adsp_auto_link_chans;
	adsp_auto.n_link = 3;
	adsp_auto.modules = adsp_auto_modules;
	adsp_auto.n_modules = 30;
	static pipeline_config_t config0 = { .checksum = {212, 164, 106, 184, 2, 198, 65, 228, 1, 216, 80, 19, 98, 180, 250, 74} };

            static pipeline_state_t state0;
            static uint8_t memory0[PIPELINE_STAGE_REQUIRED_MEMORY];
            static adsp_bump_allocator_t allocator0 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory0);

            adsp_auto.modules[0].state = (void*)&state0;

            // Control stuff
            adsp_auto.modules[0].control.id = 0;
            adsp_auto.modules[0].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[0].control.config = (void*)&config0;
                adsp_auto.modules[0].control.module_type = e_dsp_stage_pipeline;
                adsp_auto.modules[0].control.num_control_commands = NUM_CMDS_PIPELINE;
                pipeline_init(&adsp_auto.modules[0], &allocator0, 0, 0, 0, 1);
	static dsp_thread_config_t config1 = {  };

            static dsp_thread_state_t state1;
            static uint8_t memory1[DSP_THREAD_STAGE_REQUIRED_MEMORY];
            static adsp_bump_allocator_t allocator1 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory1);

            adsp_auto.modules[1].state = (void*)&state1;

            // Control stuff
            adsp_auto.modules[1].control.id = 1;
            adsp_auto.modules[1].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[1].control.config = (void*)&config1;
                adsp_auto.modules[1].control.module_type = e_dsp_stage_dsp_thread;
                adsp_auto.modules[1].control.num_control_commands = NUM_CMDS_DSP_THREAD;
                dsp_thread_init(&adsp_auto.modules[1], &allocator1, 1, 0, 0, 1);

            static adder_state_t state2;
            static uint8_t memory2[ADDER_STAGE_REQUIRED_MEMORY];
            static adsp_bump_allocator_t allocator2 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory2);

            adsp_auto.modules[2].state = (void*)&state2;

            // Control stuff
            adsp_auto.modules[2].control.id = 2;
            adsp_auto.modules[2].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[2].control.config = NULL;
                adsp_auto.modules[2].control.num_control_commands = 0;
                adder_init(&adsp_auto.modules[2], &allocator2, 2, 2, 1, 1);
	static volume_control_config_t config4 = { .target_gain = 134217728, .slew_shift = 7, .mute_state = 0 };

            static volume_control_state_t state4;
            static uint8_t memory4[VOLUME_CONTROL_STAGE_REQUIRED_MEMORY(2)];
            static adsp_bump_allocator_t allocator4 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory4);

            adsp_auto.modules[4].state = (void*)&state4;

            // Control stuff
            adsp_auto.modules[4].control.id = 4;
            adsp_auto.modules[4].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[4].control.config = (void*)&config4;
                adsp_auto.modules[4].control.module_type = e_dsp_stage_volume_control;
                adsp_auto.modules[4].control.num_control_commands = NUM_CMDS_VOLUME_CONTROL;
                volume_control_init(&adsp_auto.modules[4], &allocator4, 4, 2, 2, 1);
	static volume_control_config_t config3 = { .target_gain = 134217728, .slew_shift = 7, .mute_state = 0 };

            static volume_control_state_t state3;
            static uint8_t memory3[VOLUME_CONTROL_STAGE_REQUIRED_MEMORY(1)];
            static adsp_bump_allocator_t allocator3 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory3);

            adsp_auto.modules[3].state = (void*)&state3;

            // Control stuff
            adsp_auto.modules[3].control.id = 3;
            adsp_auto.modules[3].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[3].control.config = (void*)&config3;
                adsp_auto.modules[3].control.module_type = e_dsp_stage_volume_control;
                adsp_auto.modules[3].control.num_control_commands = NUM_CMDS_VOLUME_CONTROL;
                volume_control_init(&adsp_auto.modules[3], &allocator3, 3, 1, 1, 1);

            static fork_state_t state5;
            static uint8_t memory5[FORK_STAGE_REQUIRED_MEMORY];
            static adsp_bump_allocator_t allocator5 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory5);

            adsp_auto.modules[5].state = (void*)&state5;

            // Control stuff
            adsp_auto.modules[5].control.id = 5;
            adsp_auto.modules[5].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[5].control.config = NULL;
                adsp_auto.modules[5].control.num_control_commands = 0;
                fork_init(&adsp_auto.modules[5], &allocator5, 5, 1, 2, 1);
	static cascaded_biquads_config_t config6 = { .left_shift = {2, 2, 2, 2, 2, 2, 2, 2}, .filter_coeffs = {268435456, -532998068, 264597976, 2131992270, -1058391903, 268435456, -534735555, 266371689, 2138942219, -1065486757, 268435456, -532474484, 264324274, 2129897937, -1057297098, 268435456, -527583317, 260279881, 2110333268, -1041119524, 268435456, -516381375, 252401754, 2065525501, -1009607015, 268435456, -488743488, 237549035, 1954973952, -950196142, 268435456, -415899139, 211803503, 1663596554, -847214013, 268435456, -277706204, 108832990, 1110824817, -435331961} };

            static cascaded_biquads_state_t state6;
            static uint8_t memory6[CASCADED_BIQUADS_STAGE_REQUIRED_MEMORY(1)];
            static adsp_bump_allocator_t allocator6 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory6);

            adsp_auto.modules[6].state = (void*)&state6;

            // Control stuff
            adsp_auto.modules[6].control.id = 6;
            adsp_auto.modules[6].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[6].control.config = (void*)&config6;
                adsp_auto.modules[6].control.module_type = e_dsp_stage_cascaded_biquads;
                adsp_auto.modules[6].control.num_control_commands = NUM_CMDS_CASCADED_BIQUADS;
                cascaded_biquads_init(&adsp_auto.modules[6], &allocator6, 6, 1, 1, 1);
	static switch_config_t config7 = { .position = 1 };

            static switch_state_t state7;
            static uint8_t memory7[SWITCH_STAGE_REQUIRED_MEMORY];
            static adsp_bump_allocator_t allocator7 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory7);

            adsp_auto.modules[7].state = (void*)&state7;

            // Control stuff
            adsp_auto.modules[7].control.id = 7;
            adsp_auto.modules[7].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[7].control.config = (void*)&config7;
                adsp_auto.modules[7].control.module_type = e_dsp_stage_switch;
                adsp_auto.modules[7].control.num_control_commands = NUM_CMDS_SWITCH;
                switch_init(&adsp_auto.modules[7], &allocator7, 7, 2, 1, 1);

            static fork_state_t state8;
            static uint8_t memory8[FORK_STAGE_REQUIRED_MEMORY];
            static adsp_bump_allocator_t allocator8 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory8);

            adsp_auto.modules[8].state = (void*)&state8;

            // Control stuff
            adsp_auto.modules[8].control.id = 8;
            adsp_auto.modules[8].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[8].control.config = NULL;
                adsp_auto.modules[8].control.num_control_commands = 0;
                fork_init(&adsp_auto.modules[8], &allocator8, 8, 1, 2, 1);
	static noise_suppressor_expander_config_t config9 = { .attack_alpha = 17895697, .release_alpha = 745654, .threshold = 754762, .slope = -2.0 };

            static noise_suppressor_expander_state_t state9;
            static uint8_t memory9[NOISE_SUPPRESSOR_EXPANDER_STAGE_REQUIRED_MEMORY(1)];
            static adsp_bump_allocator_t allocator9 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory9);

            adsp_auto.modules[9].state = (void*)&state9;

            // Control stuff
            adsp_auto.modules[9].control.id = 9;
            adsp_auto.modules[9].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[9].control.config = (void*)&config9;
                adsp_auto.modules[9].control.module_type = e_dsp_stage_noise_suppressor_expander;
                adsp_auto.modules[9].control.num_control_commands = NUM_CMDS_NOISE_SUPPRESSOR_EXPANDER;
                noise_suppressor_expander_init(&adsp_auto.modules[9], &allocator9, 9, 1, 1, 1);
	static switch_config_t config10 = { .position = 1 };

            static switch_state_t state10;
            static uint8_t memory10[SWITCH_STAGE_REQUIRED_MEMORY];
            static adsp_bump_allocator_t allocator10 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory10);

            adsp_auto.modules[10].state = (void*)&state10;

            // Control stuff
            adsp_auto.modules[10].control.id = 10;
            adsp_auto.modules[10].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[10].control.config = (void*)&config10;
                adsp_auto.modules[10].control.module_type = e_dsp_stage_switch;
                adsp_auto.modules[10].control.num_control_commands = NUM_CMDS_SWITCH;
                switch_init(&adsp_auto.modules[10], &allocator10, 10, 2, 1, 1);
	static dsp_thread_config_t config11 = {  };

            static dsp_thread_state_t state11;
            static uint8_t memory11[DSP_THREAD_STAGE_REQUIRED_MEMORY];
            static adsp_bump_allocator_t allocator11 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory11);

            adsp_auto.modules[11].state = (void*)&state11;

            // Control stuff
            adsp_auto.modules[11].control.id = 11;
            adsp_auto.modules[11].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[11].control.config = (void*)&config11;
                adsp_auto.modules[11].control.module_type = e_dsp_stage_dsp_thread;
                adsp_auto.modules[11].control.num_control_commands = NUM_CMDS_DSP_THREAD;
                dsp_thread_init(&adsp_auto.modules[11], &allocator11, 11, 0, 0, 1);

            static fork_state_t state15;
            static uint8_t memory15[FORK_STAGE_REQUIRED_MEMORY];
            static adsp_bump_allocator_t allocator15 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory15);

            adsp_auto.modules[15].state = (void*)&state15;

            // Control stuff
            adsp_auto.modules[15].control.id = 15;
            adsp_auto.modules[15].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[15].control.config = NULL;
                adsp_auto.modules[15].control.num_control_commands = 0;
                fork_init(&adsp_auto.modules[15], &allocator15, 15, 2, 4, 1);

            static fork_state_t state12;
            static uint8_t memory12[FORK_STAGE_REQUIRED_MEMORY];
            static adsp_bump_allocator_t allocator12 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory12);

            adsp_auto.modules[12].state = (void*)&state12;

            // Control stuff
            adsp_auto.modules[12].control.id = 12;
            adsp_auto.modules[12].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[12].control.config = NULL;
                adsp_auto.modules[12].control.num_control_commands = 0;
                fork_init(&adsp_auto.modules[12], &allocator12, 12, 1, 4, 1);
	static reverb_plate_constants_t reverb_plate_13_constants;
	reverb_plate_13_constants.sampling_freq = 48000;
	reverb_plate_13_constants.max_predelay = 960;
	adsp_auto.modules[13].constants = &reverb_plate_13_constants;
	static reverb_plate_config_t config13 = { .decay = 1073741824, .damping = 1073741823, .early_diffusion = 1073741824, .late_diffusion = -1073741824, .bandwidth = 1327217883, .wet_gain1 = 1276901416, .wet_gain2 = 0, .dry_gain = 1276901416, .pregain = 1073741824, .predelay = 960 };

            static reverb_plate_state_t state13;
            static uint8_t memory13[REVERB_PLATE_STAGE_REQUIRED_MEMORY(48000,960)];
            static adsp_bump_allocator_t allocator13 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory13);

            adsp_auto.modules[13].state = (void*)&state13;

            // Control stuff
            adsp_auto.modules[13].control.id = 13;
            adsp_auto.modules[13].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[13].control.config = (void*)&config13;
                adsp_auto.modules[13].control.module_type = e_dsp_stage_reverb_plate;
                adsp_auto.modules[13].control.num_control_commands = NUM_CMDS_REVERB_PLATE;
                reverb_plate_init(&adsp_auto.modules[13], &allocator13, 13, 2, 2, 1);
	static switch_stereo_config_t config14 = { .position = 1 };

            static switch_stereo_state_t state14;
            static uint8_t memory14[SWITCH_STEREO_STAGE_REQUIRED_MEMORY];
            static adsp_bump_allocator_t allocator14 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory14);

            adsp_auto.modules[14].state = (void*)&state14;

            // Control stuff
            adsp_auto.modules[14].control.id = 14;
            adsp_auto.modules[14].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[14].control.config = (void*)&config14;
                adsp_auto.modules[14].control.module_type = e_dsp_stage_switch_stereo;
                adsp_auto.modules[14].control.num_control_commands = NUM_CMDS_SWITCH_STEREO;
                switch_stereo_init(&adsp_auto.modules[14], &allocator14, 14, 4, 2, 1);
	static dsp_thread_config_t config16 = {  };

            static dsp_thread_state_t state16;
            static uint8_t memory16[DSP_THREAD_STAGE_REQUIRED_MEMORY];
            static adsp_bump_allocator_t allocator16 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory16);

            adsp_auto.modules[16].state = (void*)&state16;

            // Control stuff
            adsp_auto.modules[16].control.id = 16;
            adsp_auto.modules[16].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[16].control.config = (void*)&config16;
                adsp_auto.modules[16].control.module_type = e_dsp_stage_dsp_thread;
                adsp_auto.modules[16].control.num_control_commands = NUM_CMDS_DSP_THREAD;
                dsp_thread_init(&adsp_auto.modules[16], &allocator16, 16, 0, 0, 1);

            static fork_state_t state17;
            static uint8_t memory17[FORK_STAGE_REQUIRED_MEMORY];
            static adsp_bump_allocator_t allocator17 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory17);

            adsp_auto.modules[17].state = (void*)&state17;

            // Control stuff
            adsp_auto.modules[17].control.id = 17;
            adsp_auto.modules[17].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[17].control.config = NULL;
                adsp_auto.modules[17].control.num_control_commands = 0;
                fork_init(&adsp_auto.modules[17], &allocator17, 17, 2, 6, 1);
	static compressor_sidechain_config_t config18 = { .attack_alpha = 8947849, .release_alpha = 178957, .threshold = 13422, .slope = 0.4 };

            static compressor_sidechain_state_t state18;
            static uint8_t memory18[COMPRESSOR_SIDECHAIN_STAGE_REQUIRED_MEMORY(2)];
            static adsp_bump_allocator_t allocator18 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory18);

            adsp_auto.modules[18].state = (void*)&state18;

            // Control stuff
            adsp_auto.modules[18].control.id = 18;
            adsp_auto.modules[18].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[18].control.config = (void*)&config18;
                adsp_auto.modules[18].control.module_type = e_dsp_stage_compressor_sidechain;
                adsp_auto.modules[18].control.num_control_commands = NUM_CMDS_COMPRESSOR_SIDECHAIN;
                compressor_sidechain_init(&adsp_auto.modules[18], &allocator18, 18, 2, 1, 1);
	static compressor_sidechain_config_t config19 = { .attack_alpha = 8947849, .release_alpha = 178957, .threshold = 13422, .slope = 0.4 };

            static compressor_sidechain_state_t state19;
            static uint8_t memory19[COMPRESSOR_SIDECHAIN_STAGE_REQUIRED_MEMORY(2)];
            static adsp_bump_allocator_t allocator19 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory19);

            adsp_auto.modules[19].state = (void*)&state19;

            // Control stuff
            adsp_auto.modules[19].control.id = 19;
            adsp_auto.modules[19].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[19].control.config = (void*)&config19;
                adsp_auto.modules[19].control.module_type = e_dsp_stage_compressor_sidechain;
                adsp_auto.modules[19].control.num_control_commands = NUM_CMDS_COMPRESSOR_SIDECHAIN;
                compressor_sidechain_init(&adsp_auto.modules[19], &allocator19, 19, 2, 1, 1);
	static switch_stereo_config_t config20 = { .position = 1 };

            static switch_stereo_state_t state20;
            static uint8_t memory20[SWITCH_STEREO_STAGE_REQUIRED_MEMORY];
            static adsp_bump_allocator_t allocator20 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory20);

            adsp_auto.modules[20].state = (void*)&state20;

            // Control stuff
            adsp_auto.modules[20].control.id = 20;
            adsp_auto.modules[20].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[20].control.config = (void*)&config20;
                adsp_auto.modules[20].control.module_type = e_dsp_stage_switch_stereo;
                adsp_auto.modules[20].control.num_control_commands = NUM_CMDS_SWITCH_STEREO;
                switch_stereo_init(&adsp_auto.modules[20], &allocator20, 20, 4, 2, 1);

            static fork_state_t state21;
            static uint8_t memory21[FORK_STAGE_REQUIRED_MEMORY];
            static adsp_bump_allocator_t allocator21 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory21);

            adsp_auto.modules[21].state = (void*)&state21;

            // Control stuff
            adsp_auto.modules[21].control.id = 21;
            adsp_auto.modules[21].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[21].control.config = NULL;
                adsp_auto.modules[21].control.num_control_commands = 0;
                fork_init(&adsp_auto.modules[21], &allocator21, 21, 2, 4, 1);

            static adder_state_t state22;
            static uint8_t memory22[ADDER_STAGE_REQUIRED_MEMORY];
            static adsp_bump_allocator_t allocator22 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory22);

            adsp_auto.modules[22].state = (void*)&state22;

            // Control stuff
            adsp_auto.modules[22].control.id = 22;
            adsp_auto.modules[22].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[22].control.config = NULL;
                adsp_auto.modules[22].control.num_control_commands = 0;
                adder_init(&adsp_auto.modules[22], &allocator22, 22, 2, 1, 1);

            static adder_state_t state23;
            static uint8_t memory23[ADDER_STAGE_REQUIRED_MEMORY];
            static adsp_bump_allocator_t allocator23 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory23);

            adsp_auto.modules[23].state = (void*)&state23;

            // Control stuff
            adsp_auto.modules[23].control.id = 23;
            adsp_auto.modules[23].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[23].control.config = NULL;
                adsp_auto.modules[23].control.num_control_commands = 0;
                adder_init(&adsp_auto.modules[23], &allocator23, 23, 2, 1, 1);
	static dsp_thread_config_t config24 = {  };

            static dsp_thread_state_t state24;
            static uint8_t memory24[DSP_THREAD_STAGE_REQUIRED_MEMORY];
            static adsp_bump_allocator_t allocator24 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory24);

            adsp_auto.modules[24].state = (void*)&state24;

            // Control stuff
            adsp_auto.modules[24].control.id = 24;
            adsp_auto.modules[24].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[24].control.config = (void*)&config24;
                adsp_auto.modules[24].control.module_type = e_dsp_stage_dsp_thread;
                adsp_auto.modules[24].control.num_control_commands = NUM_CMDS_DSP_THREAD;
                dsp_thread_init(&adsp_auto.modules[24], &allocator24, 24, 0, 0, 1);
	static switch_stereo_config_t config25 = { .position = 1 };

            static switch_stereo_state_t state25;
            static uint8_t memory25[SWITCH_STEREO_STAGE_REQUIRED_MEMORY];
            static adsp_bump_allocator_t allocator25 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory25);

            adsp_auto.modules[25].state = (void*)&state25;

            // Control stuff
            adsp_auto.modules[25].control.id = 25;
            adsp_auto.modules[25].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[25].control.config = (void*)&config25;
                adsp_auto.modules[25].control.module_type = e_dsp_stage_switch_stereo;
                adsp_auto.modules[25].control.num_control_commands = NUM_CMDS_SWITCH_STEREO;
                switch_stereo_init(&adsp_auto.modules[25], &allocator25, 25, 4, 2, 1);

            static fork_state_t state26;
            static uint8_t memory26[FORK_STAGE_REQUIRED_MEMORY];
            static adsp_bump_allocator_t allocator26 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory26);

            adsp_auto.modules[26].state = (void*)&state26;

            // Control stuff
            adsp_auto.modules[26].control.id = 26;
            adsp_auto.modules[26].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[26].control.config = NULL;
                adsp_auto.modules[26].control.num_control_commands = 0;
                fork_init(&adsp_auto.modules[26], &allocator26, 26, 2, 4, 1);
	static volume_control_config_t config27 = { .target_gain = 134217728, .slew_shift = 7, .mute_state = 0 };

            static volume_control_state_t state27;
            static uint8_t memory27[VOLUME_CONTROL_STAGE_REQUIRED_MEMORY(2)];
            static adsp_bump_allocator_t allocator27 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory27);

            adsp_auto.modules[27].state = (void*)&state27;

            // Control stuff
            adsp_auto.modules[27].control.id = 27;
            adsp_auto.modules[27].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[27].control.config = (void*)&config27;
                adsp_auto.modules[27].control.module_type = e_dsp_stage_volume_control;
                adsp_auto.modules[27].control.num_control_commands = NUM_CMDS_VOLUME_CONTROL;
                volume_control_init(&adsp_auto.modules[27], &allocator27, 27, 2, 2, 1);
	static switch_stereo_config_t config28 = { .position = 1 };

            static switch_stereo_state_t state28;
            static uint8_t memory28[SWITCH_STEREO_STAGE_REQUIRED_MEMORY];
            static adsp_bump_allocator_t allocator28 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory28);

            adsp_auto.modules[28].state = (void*)&state28;

            // Control stuff
            adsp_auto.modules[28].control.id = 28;
            adsp_auto.modules[28].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[28].control.config = (void*)&config28;
                adsp_auto.modules[28].control.module_type = e_dsp_stage_switch_stereo;
                adsp_auto.modules[28].control.num_control_commands = NUM_CMDS_SWITCH_STEREO;
                switch_stereo_init(&adsp_auto.modules[28], &allocator28, 28, 4, 2, 1);
	static volume_control_config_t config29 = { .target_gain = 134217728, .slew_shift = 7, .mute_state = 0 };

            static volume_control_state_t state29;
            static uint8_t memory29[VOLUME_CONTROL_STAGE_REQUIRED_MEMORY(2)];
            static adsp_bump_allocator_t allocator29 = ADSP_BUMP_ALLOCATOR_INITIALISER(memory29);

            adsp_auto.modules[29].state = (void*)&state29;

            // Control stuff
            adsp_auto.modules[29].control.id = 29;
            adsp_auto.modules[29].control.config_rw_state = config_none_pending;
            
                adsp_auto.modules[29].control.config = (void*)&config29;
                adsp_auto.modules[29].control.module_type = e_dsp_stage_volume_control;
                adsp_auto.modules[29].control.num_control_commands = NUM_CMDS_VOLUME_CONTROL;
                volume_control_init(&adsp_auto.modules[29], &allocator29, 29, 2, 2, 1);
	adsp_controller_init(&adsp_auto_controller, &adsp_auto);
	return &adsp_auto;
}


#include "adsp_instance_id_auto.h"
#include <stdio.h>

static void do_read(int instance, int cmd_id, int size, void* data) {
    adsp_stage_control_cmd_t cmd = {
        .instance_id = instance,
        .cmd_id = cmd_id,
        .payload_len = size,
        .payload = data
    };
    xassert(m_control);
    for(;;) {
        adsp_control_status_t ret = adsp_read_module_config(
                m_control,
                &cmd);
        if(ADSP_CONTROL_SUCCESS == ret) {
            return;
        }
    }
}

void adsp_auto_print_thread_max_ticks(void) {
    int thread_ticks[4];
    do_read(thread0_stage_index, CMD_DSP_THREAD_MAX_CYCLES, sizeof(int), &thread_ticks[0]);
	do_read(thread1_stage_index, CMD_DSP_THREAD_MAX_CYCLES, sizeof(int), &thread_ticks[1]);
	do_read(thread2_stage_index, CMD_DSP_THREAD_MAX_CYCLES, sizeof(int), &thread_ticks[2]);
	do_read(thread3_stage_index, CMD_DSP_THREAD_MAX_CYCLES, sizeof(int), &thread_ticks[3]);
    printf("DSP Thread Ticks:\n0:\t%d\n1:\t%d\n2:\t%d\n3:\t%d\n", thread_ticks[0], thread_ticks[1], thread_ticks[2], thread_ticks[3]);
}
void adsp_auto_pipeline_main(adsp_pipeline_t* adsp) {
	module_instance_t* thread_0_modules[] = {
		&adsp->modules[0],
		&adsp->modules[1],
		&adsp->modules[2],
		&adsp->modules[4],
		&adsp->modules[3],
		&adsp->modules[5],
		&adsp->modules[6],
		&adsp->modules[7],
		&adsp->modules[8],
		&adsp->modules[9],
		&adsp->modules[10],
	};
	chanend_t thread_0_inputs[] = {
		adsp->p_in[0].end_b};
	chanend_t thread_0_outputs[] = {
		adsp->p_link[0].end_a};
	module_instance_t* thread_1_modules[] = {
		&adsp->modules[11],
		&adsp->modules[15],
		&adsp->modules[12],
		&adsp->modules[13],
		&adsp->modules[14],
	};
	chanend_t thread_1_inputs[] = {
		adsp->p_link[0].end_b};
	chanend_t thread_1_outputs[] = {
		adsp->p_link[1].end_a};
	module_instance_t* thread_2_modules[] = {
		&adsp->modules[16],
		&adsp->modules[17],
		&adsp->modules[18],
		&adsp->modules[19],
		&adsp->modules[20],
		&adsp->modules[21],
		&adsp->modules[22],
		&adsp->modules[23],
	};
	chanend_t thread_2_inputs[] = {
		adsp->p_link[1].end_b};
	chanend_t thread_2_outputs[] = {
		adsp->p_link[2].end_a};
	module_instance_t* thread_3_modules[] = {
		&adsp->modules[24],
		&adsp->modules[25],
		&adsp->modules[26],
		&adsp->modules[27],
		&adsp->modules[28],
		&adsp->modules[29],
	};
	chanend_t thread_3_inputs[] = {
		adsp->p_link[2].end_b};
	chanend_t thread_3_outputs[] = {
		adsp->p_out[0].end_a};
	PAR_JOBS(
		PJOB(dsp_auto_thread0, (thread_0_inputs, thread_0_outputs, thread_0_modules)),
		PJOB(dsp_auto_thread1, (thread_1_inputs, thread_1_outputs, thread_1_modules)),
		PJOB(dsp_auto_thread2, (thread_2_inputs, thread_2_outputs, thread_2_modules)),
		PJOB(dsp_auto_thread3, (thread_3_inputs, thread_3_outputs, thread_3_modules))
	);
}
