#!/usr/bin/env bash
set -e

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
SANDBOX_DIR="$(cd "$SCRIPT_DIR/.." && pwd)"
APP_DIR="$SCRIPT_DIR"
VENV_DIR="$SANDBOX_DIR/.tuning_venv"

echo "SANDBOX_DIR path: $SANDBOX_DIR"

if [ -d "$VENV_DIR" ]; then
    echo "Using existing venv at $VENV_DIR"
else
    bash "$SCRIPT_DIR/python/tuning_utility/create_venv.sh"
    if [ $? -ne 0 ]; then
        read -p "Press enter to exit..."
        exit $?
    fi
fi

source "$VENV_DIR/bin/activate"

python "$SCRIPT_DIR/tuning_gui.py"
STATUS=$?
if [ $STATUS -ne 0 ]; then
    read -p "Press enter to exit..."
fi
exit $STATUS
