#!/usr/bin/env bash
set -e

REQ_MAJOR=3
REQ_MINOR=12
CN_FLAG=n

if [[ "$1" == "cn" ]]; then
    echo "CN flag found, will use https://pypi.tuna.tsinghua.edu.cn/simple for python packages"
    CN_FLAG=y
fi

# Get Python version
PY_VERSION=$(python3 -V 2>&1 | awk '{print $2}')
MAJOR=$(echo "$PY_VERSION" | cut -d. -f1)
MINOR=$(echo "$PY_VERSION" | cut -d. -f2)

if [[ "$MAJOR" -eq "$REQ_MAJOR" && "$MINOR" -ge "$REQ_MINOR" ]]; then
    if [[ "$MINOR" -gt "$REQ_MINOR" ]]; then
        echo "WARNING: Python Recommended version is: $REQ_MAJOR.$REQ_MINOR"
        echo "WARNING: Python version is: $MAJOR.$MINOR"
        echo "WARNING: To use at your own risk."
    fi
    cd "$(dirname "$0")/../.."
    python3 -m venv ../.tuning_venv
    source ../.tuning_venv/bin/activate
    if [[ "$CN_FLAG" == "y" ]]; then
        pip install -Ur requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
    else
        pip install -Ur requirements.txt
    fi
    exit 0
else
    echo "Python version is too low."
    exit 1
fi
