@echo off
setlocal enabledelayedexpansion

:: Define required Python version
set REQ_MAJOR=3
set REQ_MINOR=12
set cn_flag=n
set arg1=%1

:: Check if CN flag
if !arg1! == cn (
	echo CN flag found, will use https://pypi.tuna.tsinghua.edu.cn/simple for python packages
	set cn_flag=y
)

:: Get Python version
for /f "tokens=2 delims= " %%v in ('python -V 2^>^&1') do set PY_VERSION=%%v
for /f "tokens=1,2 delims=." %%a in ("%PY_VERSION%") do (
    set MAJOR=%%a
    set MINOR=%%b
)

:: If required minor or above, proceed, otherwise exit
if %MAJOR% EQU %REQ_MAJOR% if %MINOR% GEQ %REQ_MINOR% (
    :: if minor is greater than required, warn user
	if %MINOR% GTR %REQ_MINOR% (
		echo WARNING: Python Recommended version is: %REQ_MAJOR%.%REQ_MINOR%
		echo WARNING: Python version is: %MAJOR%.%MINOR%
		echo WARNING: To use at your own risk.
	)
	cd /d "%~dp0..\.."
	python -m venv ../.tuning_venv
	call "../.tuning_venv/Scripts/activate.bat"
	if "%cn_flag%" == "y" ( 
		pip install -Ur requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
	) else (
		pip install -Ur requirements.txt
	)
	exit /b 0
)

:: If Python version is lower than required, exit with error
echo Python version is too low.
exit /b 1
