# Building host device_control drivers here

# Build device_control_host for USB

add_library(device_control_host_usb INTERFACE)

# Use FindLibUSB.cmake to locate and link libusb
find_libusb(LIBUSB_LIBRARIES LIBUSB_XMOS_LIBRARY_PATH LIBUSB_TARGET_NAME)

add_dependencies(device_control_host_usb
    ${LIBUSB_TARGET_NAME}
)

set(LIBUSB_INCLUDE_DIR "${CMAKE_CURRENT_LIST_DIR}/device_control/libusb/")

target_sources(device_control_host_usb
    INTERFACE
        ${CMAKE_CURRENT_LIST_DIR}/device_control/device_access_usb.c
)
target_include_directories(device_control_host_usb
    INTERFACE
        ${CMAKE_CURRENT_LIST_DIR}/device_control
        ${LIBUSB_INCLUDE_DIR}
)
target_link_libraries(device_control_host_usb
    INTERFACE
        ${LIBUSB_LIBRARIES}
)

# Build a wrapper driver for USB

add_library(device_usb STATIC)
target_sources(device_usb
    PRIVATE
        ${CMAKE_CURRENT_LIST_DIR}/device/device_usb.cpp
)
target_include_directories(device_usb
    PUBLIC
        ${CMAKE_CURRENT_LIST_DIR}/device
        ${CMAKE_CURRENT_LIST_DIR}/device_control
)
target_link_libraries(device_usb
    PUBLIC
        device_control_host_usb
)

target_link_libraries(device_usb PRIVATE -fPIC)

if(${CMAKE_SYSTEM_NAME} MATCHES "Windows")
    # For Windows, ensure the DLL is in the same directory as the executable
    add_custom_command(
        TARGET device_usb
        POST_BUILD
        COMMAND ${CMAKE_COMMAND} -E copy_if_different "${LIBUSB_XMOS_LIBRARY_PATH}" "${CMAKE_RUNTIME_OUTPUT_DIRECTORY}"
    )
endif()
