# Building main application here

## Define YAML autogen macro
#*********************************************************
# Autogenerate files from the cmds .yaml file
#*********************************************************
set(LIB_AUDIO_DSP_PATH ${CMAKE_CURRENT_LIST_DIR}/../../../lib_audio_dsp/lib_audio_dsp)
set(CONFIG_YAML_PATH ${LIB_AUDIO_DSP_PATH}/../stage_config)
set( AUTOGEN_DIR ${CMAKE_CURRENT_BINARY_DIR}/src.autogen )
file( GLOB CONFIGRE_DEPENDS MODULE_CONFIG_YAML_FILES  ${CONFIG_YAML_PATH}/*.yaml )
file(GLOB TEMPLATE_FILES ${LIB_AUDIO_DSP_PATH}/../python/audio_dsp/design/templates/*.mako)
unset(CMD_MAP_GEN_ARGS)
list(APPEND CMD_MAP_GEN_ARGS --config-dir ${CONFIG_YAML_PATH} --out-dir ${AUTOGEN_DIR})
set(CMD_MAP_GEN_SCRIPT ${LIB_AUDIO_DSP_PATH}/../python/audio_dsp/design/parse_config.py)

# Get output C file names
set(OUTPUT_C_FILES ${AUTOGEN_DIR}/generator/gen_cmd_map_offset.c)

add_custom_command(
    OUTPUT ${OUTPUT_C_FILES}
    COMMAND python -m audio_dsp.design.parse_config ${CMD_MAP_GEN_ARGS}
    DEPENDS ${MODULE_CONFIG_YAML_FILES} ${CMD_MAP_GEN_SCRIPT} ${TEMPLATE_FILES}
    COMMENT "Generating cmd_map files included in the device and host application"
    VERBATIM
)

add_custom_target(cmd_map_generation
    DEPENDS ${OUTPUT_C_FILES})


# Add target to generate the NUM_VALUES defines file
set(APP_HW_TARGET XK-EVK-XU316)
set(NUM_VALUES_GEN_APP gen_cmd_num_values)
add_executable(${NUM_VALUES_GEN_APP})
add_dependencies(${NUM_VALUES_GEN_APP} cmd_map_generation)
target_sources(${NUM_VALUES_GEN_APP} PRIVATE ${OUTPUT_C_FILES})
target_include_directories(${NUM_VALUES_GEN_APP} PRIVATE
                ${AUTOGEN_DIR} ${CMAKE_CURRENT_LIST_DIR}/../../../lib_xcore_math/lib_xcore_math/api
                ${LIB_AUDIO_DSP_PATH}/api ${AUTOGEN_DIR}/common ${AUTOGEN_DIR}/device ${AUTOGEN_DIR}/generator)
target_compile_options(${NUM_VALUES_GEN_APP} PRIVATE -DOFFSET_GEN=1 -g)


add_custom_target(run_${NUM_VALUES_GEN_APP}
COMMAND $<TARGET_FILE:${NUM_VALUES_GEN_APP}> ${AUTOGEN_DIR}/host/cmd_num_values.h
DEPENDS ${NUM_VALUES_GEN_APP}
COMMENT
  "Generate cmd num values defines included in the host code"
VERBATIM
)

set( APP_NAME  dsp_host )

set(COMMON_SOURCES
    ${CMAKE_CURRENT_LIST_DIR}/main.cpp
    ${CMAKE_CURRENT_LIST_DIR}/utils/utils.cpp
    ${CMAKE_CURRENT_LIST_DIR}/utils/type_utils.cpp
    ${CMAKE_CURRENT_LIST_DIR}/utils/platform_utils.cpp
    ${CMAKE_CURRENT_LIST_DIR}/command/command.cpp
    ${CMAKE_CURRENT_LIST_DIR}/options/options.cpp
)
set(COMMON_INCLUDES
    ${CMAKE_CURRENT_LIST_DIR}/utils
    ${CMAKE_CURRENT_LIST_DIR}/device
    ${CMAKE_CURRENT_LIST_DIR}/command
    ${CMAKE_CURRENT_LIST_DIR}/options
    ${CMAKE_CURRENT_LIST_DIR}/device_control
    ${AUTOGEN_DIR}/common
    ${AUTOGEN_DIR}/host
)

add_executable( ${APP_NAME})
add_dependencies( ${APP_NAME} run_${NUM_VALUES_GEN_APP})


# Set the executable name based on OS
if(${CMAKE_SYSTEM_NAME} MATCHES "Linux")
    set_target_properties(${APP_NAME} PROPERTIES OUTPUT_NAME "dsp_host_linux")
elseif(${CMAKE_SYSTEM_NAME} MATCHES "Darwin")
    set_target_properties(${APP_NAME} PROPERTIES OUTPUT_NAME "dsp_host_macos")
endif()

# Add options for different compilers
if (CMAKE_CXX_COMPILER_ID STREQUAL "MSVC")
    target_compile_options( ${APP_NAME}
        PRIVATE
            -WX
    )
else()
    target_compile_options( ${APP_NAME}
        PRIVATE
            -Werror
            -g
    )
endif()

target_sources( ${APP_NAME}
    PRIVATE
        ${COMMON_SOURCES}
)
target_include_directories( ${APP_NAME}
    PUBLIC
        ${COMMON_INCLUDES}
)

target_link_libraries( ${APP_NAME}
    PUBLIC
        device_usb
)
