param(
    [string]$DumpFile,
    [string]$DefFile
)

# Read dump file
$content = Get-Content -Path $DumpFile

# Find the header line index
$headerIndex = $content | Select-String -Pattern '^\s*ordinal\s+hint\s+RVA\s+name' | Select-Object -First 1 | ForEach-Object { $_.LineNumber - 1 }
if ($null -eq $headerIndex) {
    Write-Host "Could not find export table header in dump file."
    exit 1
}

# Find the end (Summary or end of file)
$summaryIndex = ($content | Select-String -Pattern '^\s*Summary' | Select-Object -First 1 | ForEach-Object { $_.LineNumber - 1 })
if ($null -eq $summaryIndex) {
    $summaryIndex = $content.Length
}

# Extract export table lines
$exportLines = $content[($headerIndex + 1)..($summaryIndex - 1)]

# Prepare output
$output = @("LIBRARY libusb-1.0.dll", "")
$output += @("EXPORTS", "")

foreach ($line in $exportLines) {
    $tokens = -split $line
    if ($tokens.Count -eq 4) {
        # Basic format: 1    0 00001360 FuncName
        $output += ("{0} @{1}" -f $tokens[3], $tokens[0])
    } elseif ($tokens.Count -gt 5) {
        # Debug format: 1    0 0000F911 ??0Client@... = ... = ...
        $output += ("{0} {1} {2} @{3}" -f $tokens[3], $tokens[4], $tokens[5], $tokens[0])
    }
    # Ignore other lines
}

# Write to def file
Set-Content -Path $DefFile -Value $output -Encoding ASCII
