#pragma once
#include <stages/adsp_pipeline.h>
#include <xcore/parallel.h>

#define ADSP_AUTO_FRAME_SIZE (1)
#define ADSP_AUTO_N_INPUTS (4)
#define ADSP_AUTO_N_OUTPUTS (4)

/// Autogenerated. Initialises the DSP pipeline.
/// @retval A pointer to the initialised DSP pipeline.
adsp_pipeline_t * adsp_auto_pipeline_init();

DECLARE_JOB(adsp_auto_pipeline_main, (adsp_pipeline_t*));

/// Autogenerated main function for the DSP pipeline
///
/// @param adsp The initialised pipeline.
void adsp_auto_pipeline_main(adsp_pipeline_t* adsp);

/// Autogenerated. Prints the maximum ticks for each thread in the DSP pipeline.
/// This function must be called from the control thread. It cannot be called 
/// from the DSP thread.
void adsp_auto_print_thread_max_ticks(void);

/// Autogenerated. Prints the maximum ticks for each thread in the DSP pipeline.
/// This function can be called from the same thread as the DSP pipeline.
///
/// @param adsp The initialised pipeline.
void adsp_auto_fast_print_thread_max_ticks(adsp_pipeline_t* adsp);
