// Copyright 2021-2024 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.

#include <stdint.h>

#include "mic_array/etc/filters_default.h"


// Each coefficient is 16 bits and the number of coefficients must be a multiple of 256.
// int32_t type so that it's word-aligned. So this is 512 16-bit coefficients.
const uint32_t stage1_coef[STAGE1_WORDS] = {

  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xEEEEEEEE, 0xEEEEEEEE, 0xEEEEEEEE, 0xEEEEEEEE,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFAFAFAFA, 0xFAFAFAFA, 0xEBEBEBEB, 0xEBEBEBEB,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xF5A0F5A0, 0xE4B1E4B1, 0xF1A4F1A4, 0xE0B5E0B5,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFB51AE04, 0xEF54BA01, 0xF00BA55E, 0xE40EB15B,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFD1353BD, 0xB31809B3, 0xF9B20319, 0xB7B95917,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFE4D120F, 0x584AEB52, 0xA95AEA43, 0x5E09164F,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF94E621, 0x17931C80, 0x0027193D, 0x108CE53F,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE6AE34, 0xE549505E, 0xEF415254, 0xE58EACFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF8CB6C, 0x066D9FCB, 0x1A7F36CC, 0x06DA63FF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFF0C49, 0x52DB4A93, 0xF92A5B69, 0x52461FFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFF071, 0x9B6D931C, 0x071936DB, 0x31C1FFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFF81, 0xE38E1C1F, 0xFF070E38, 0xF03FFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFE, 0x03F01FE0, 0x00FF01F8, 0x0FFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFC001FFF, 0xFFFF0007, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFE000, 0x0000FFFF, 0xFFFFFFFF,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,

};