// Copyright 2024-2025 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.
#include <string.h>
#include <stdlib.h>
#include <xcore/assert.h>
#include <debug_print.h>
#include "cmds.h" // Autogenerated
#include "cmd_offsets.h" // Autogenerated
#include "stages/fork.h"
#include <stdio.h>
#include "print.h"
void fork_process(int32_t **input, int32_t **output, void *app_data_state)
{
    fork_state_t *state = app_data_state;

    int output_idx = 0;
    for(int input_index = 0; input_index < state->n_inputs; ++input_index) {
        for(int fork_count = 0; fork_count < state->n_forks; fork_count++) {
            int32_t *in = input[input_index];
            int32_t *out = output[output_idx++];
            memcpy(out, in, sizeof(int32_t) * state->frame_size);
        }
    }

}

void fork_init(module_instance_t* instance, adsp_bump_allocator_t* allocator, uint8_t id, int n_inputs, int n_outputs, int frame_size)
{
    fork_state_t *state = instance->state;

    memset(state, 0, sizeof(fork_state_t));
    state->n_inputs = n_inputs;
    state->n_outputs = n_outputs;
    state->frame_size = frame_size;
    state->n_forks = n_outputs / n_inputs;
    xassert(n_outputs % n_inputs == 0 && "Fork must be able fork all the inputs");
}

