// Copyright 2024 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.

// This file contains defines relating to the USB build only

#ifndef _XUA_CONF_H_
#define _XUA_CONF_H_

/*** Set the number of USB and I2S channels, and the sample rate ***/
#define NUM_USB_CHAN_OUT 2
#define NUM_USB_CHAN_IN 0
#define I2S_CHANS_DAC 2
#define I2S_CHANS_ADC 0
#define MCLK_441 (512 * 44100) // (256 * 44100)
#define MCLK_48 (512 * 48000) // (256 * 48000)
#define MIN_FREQ 48000
#define MAX_FREQ 48000
#define DEFAULT_FREQ MIN_FREQ

/*** Defines relating to USB descriptor strings and ID's ***/
#define VENDOR_STR         "XMOS"
#define VENDOR_ID          (0x20B1) /* XMOS VID */
#define PID_AUDIO_2        (0x0016)
#define PID_AUDIO_1        (0x0017)
#define PRODUCT_STR_A2     "XMOS xCORE.ai MC (UAC2.0)"
#define PRODUCT_STR_A1     "XMOS xCORE.ai MC (UAC1.0)"
#define AUDIO_CLASS 2
#define AUDIO_IO_TILE 1
#define XUA_DFU_EN 0
#define USB_CONTROL_DESCS 1

#include "user_main.h"

#endif
