// Copyright 2020-2024 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.


#include "xmath/xmath.h"
#include "testing.h"
#include "floating_fft.h"
#include "tst_common.h"
#include "fft.h"
#include "unity_fixture.h"

#include <string.h>


TEST_GROUP_RUNNER(bfp_fft_issue96) {
  RUN_TEST_CASE(bfp_fft_issue96, bfp_fft_issue96);
}

TEST_GROUP(bfp_fft_issue96);
TEST_SETUP(bfp_fft_issue96) { fflush(stdout); }
TEST_TEAR_DOWN(bfp_fft_issue96) {}

int32_t DWORD_ALIGNED issue96_data[514] = {
  6711905, 79751042, 191523834, -68769221, -9449789, -5492547,
-66000433, 16733873, -91615307, -8799415, 80784328, -169151382, -35919998, 34058658, 7281155,
-11592943, -178650139, 145270879, 174556105, -80287655, 38797428, -58464948, -123491926,
-39027831, -180567064, 20540038, -99704822, -32060441, -144155254, 3011236, -31930857,
40105655, 104232210, 64446530, 18305219, -105192993, 242562167, -100930013, 249992849, -428606,
197503454, 116367798, -85860912, 23940815, -50567323, -91629985, 266672505, -102238261,
-91875668, -78659688, -35957336, 70782223, 123349363, -62841708, 18864004, 102101908,
-112866965, 146700436, -130500300, -89398121, 96420092, 53811810, 73903341, -23462892,
59166425, -88931475, 233833567, 122740028, -152035766, -20646566, -42450246, -194045264,
160489015, -90213670, 25989720, 54056967, 80518239, -125176031, -181104818, 169734078,
-17158813, 158217052, -5645132, 108041037, -37699470, 121399877, -131366662, -3875882,
-21829825, -79530791, -91034878, 194780346, -112821152, -96992810, -99489833, 226599298,
-74277805, -18586833, 91967154, -59409156, 21250178, 28160613, -87120291, 75060103, 109267984,
-174173015, 66834487, -139236446, -109462591, -146107343, 74835669, -84409141, -65118317,
35993994, -91637664, 60897116, 125793561, -186418354, -32434079, -104644499, -138859130,
164779766, -313908897, 92801746, 177166979, -12514525, -1879406, 45887291, -114513758,
-17219450, 14303698, -18705350, -148953183, -104339315, -182857197, 13318327, -192440423,
-87318807, 14030388, -76743275, -134831856, -161246698, 114350906, -149480678, 106039718,
-91641719, -52261233, 89738725, -173803752, -29333814, -170624901, -138657227, -70773307,
-104737423, 22267231, 80379663, 44432527, 6489783, -86686771, 43574031, 58665941, -171362509,
140718026, -93747121, -56062233, 203323342, -70821514, 19863746, 133770951, -153193931,
177467612, -3905555, 96132997, 81533880, -166369703, -126232856, 5318256, -115071034,
89629297, -275722146, 207877531, -100873146, 8620792, 242603246, 98652849, -67147421,
100309141, -35630245, -234254584, -77569779, -145294417, 121632986, -194645210, -33653401,
71657382, 28709309, 125965977, -98234045, -36159321, 15004181, -198300902, 146647920,
53104096, -119717967, 15024147, -117110974, -4933948, 41187323, -54782565, 67329318, 95223393,
-242560044, 135982608, 66056312, -96722831, 4474068, 9812295, -84938475, -270396787,
105634756, -220292994, 29775501, -49460999, 159331582, 18996676, 70048319, -240670998,
271130300, 46590393, -11252108, 63053224, 32348276, -119965509, -80598199, -4821629, 467465,
113318558, -19685325, -124953906, -51225811, -73069291, -169147877, 5659444, -119979991,
148320801, 125010217, -50991847, -22960771, -1791094, 33865649, -15657057, -8387064,
42722568, 225364701, -156606604, 27540149, -4529339, -36564780, -89396703, -93379648,
-21177530, -9697547, -10856541, 22358091, -66473526, -15764168, 35002201, -35394714,
164973540, -38245951, -190318689, 257781291, -39394621, 108644129, 54354992, -132200965,
38337603, 41659027, 52059087, -136581245, -79020627, 75272243, 194646225, 135047816,
-33127732, 77382106, 963035, 24734452, -54321805, 203943476, 14890554, 86137416, 102180818,
103952084, -3453671, -21176822, 189720483, 69357109, -121008396, 60894503, -98765965,
4113413, 45084356, -47732500, 17331202, -45428874, 66910536, 44118206, 16281908, -65684738,
21276172, 37477021, 137566233, -226082304, -18248331, -113921180, 80526883, -9432159,
52305607, -56864417, 80970279, -204905837, 117670202, -11341640, -151959405, 1924205,
-9797002, 119502970, -68674629, -96646759, -132722215, 84672979, -33135710, 140252800,
38876848, 193761796, 3316697, -151099513, 80694525, -92890903, -914358, 74187114, -77938084,
-73735047, 136457911, -230990975, 281459421, -110685925, 141808042, -25310689, 9529362,
-112435536, 15166111, 109446023, 15690293, 37135473, 7786834, 46008706, 73945870, -90561582,
10146057, 7254481, -105718923, -50086234, 33703391, -85898760, -119564515, -100359137,
22439383, -152296222, -34803021, 104451395, 60424920, -50201493, 202207876, -169631139,
147175628, 106048285, 25446841, -206302648, -158593106, 58900038, 128423970, 216193757,
-66724197, -31263642, -35384772, 140910924, -132054995, 79468559, -181473773, 165848085,
-101518499, 67623958, 57165506, -66751453, -36275223, 284721878, -12255141, 231739344,
127150877, 124089239, 249016862, -111518337, 3736013, -8977436, -37837776, 58443109,
-18018531, -331501900, -141071546, -100159360, 33010556, -85159402, 26425822, 68079147,
48390611, 39364822, -23665414, 92490855, -76618769, 100877992, -76433974, 179922752,
-203564343, -43782365, -61122476, -147846459, 145351971, 138790620, -113659313, -254082565,
-6918248, 310800327, 379232, 4301204, 21526919, 76261206, 242228488, 59668579, -74577805,
7542339, -20045061, 15060130, 142096913, -69272668, -97772013, -35540972, -52346462,
94310130, -34211249, 136300779, -245074123, -10579617, -14733398, -7292523, 90958919,
50276279, 44582775, 174283415, -246665083, 144572926, 195846338, -97258409, -158095011,
-145425851, -302124424, -33574471, -193388328, 47984242, -106419826, -13282590, 54279545,
30005294, -150099229, -27983100, 35067842, 15025578, -14311926, -177166845, 242273651,
-16327068, 101745979, -182490965, 150927413, -28513849, 35906233, 20137108, 250979764,
-177583112, 142627657, 10586680, 11450205, 241587434, -81824484, -91987138, 73785977,
-58697583, 92613688, 96820563, -79421268, 138977004, -19231710, 69935012, -127611095,
108494145, 2588400, 29186733, 33989564, 4865306, 97157545, -153344149, 0, 0,
};

/**
 * This test closes the loop on issue #96, identified by Shuchita K.
 *
 * https://github.com/xmos/lib_xcore_math/issues/96
 */
TEST(bfp_fft_issue96, bfp_fft_issue96)
{
  bfp_s32_t input;
  bfp_s32_init(&input, issue96_data, -31, 512, 1);

  // headroom_t input_hr = vect_s32_headroom(&input.data[0], input.length);

  // printf("input.length: %u\n", input.length);
  // printf("input.hr: %u\n", input.hr);
  // printf("input_hr: %u\n", input_hr);

  bfp_complex_s32_t *output = bfp_fft_forward_mono(&input);
  
  // printf("output->length: %u\n", output->length);
  // printf("output->hr: %u\n", output->hr);

  headroom_t output_hr = vect_complex_s32_headroom(&output->data[0], output->length);
  // printf("output_hr: %u\n", output_hr);

  TEST_ASSERT_EQUAL_INT32_MESSAGE(output_hr, output->hr,
    "bfp_fft_forward_mono() headroom mismatch");
}