// Copyright 2024-2025 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.
/// Blocks for a known amount of time.
///
#pragma once

// #include "wait_config.h" // Autogenerated
#include <xcore/hwtimer.h>
#include <stages/bump_allocator.h>
#include <stdint.h>

typedef struct
{
    int32_t ticks;
}wait_state_t;

typedef struct
{
    int32_t ticks;
} wait_constants_t;

#define WAIT_STAGE_REQUIRED_MEMORY 0

static inline void wait_init(module_instance_t* instance, adsp_bump_allocator_t* allocator, uint8_t id, int n_inputs, int n_outputs, int frame_size) {

    wait_constants_t *constants = instance->constants;
    wait_state_t *state = instance->state;
    state->ticks = constants->ticks;
}

static inline void wait_process(int32_t **input, int32_t **output, void *state) {
    int32_t start = get_reference_time();
    int32_t ticks = ((wait_state_t *)state)->ticks;
    while (get_reference_time() - start < ticks) {
        // Do nothing, just wait
    }
}

static inline void wait_control(void *state, module_control_t *control) {}
