// Copyright 2024-2025 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.
#include <string.h>
#include <stdlib.h>
#include <xcore/assert.h>
#include <debug_print.h>
#include "cmds.h" // Autogenerated
#include "cmd_offsets.h" // Autogenerated
#include "stages/switch_stereo.h"
#include <stdio.h>
#include "print.h"

void switch_stereo_process(int32_t **input, int32_t **output, void *app_data_state)
{
    switch_stereo_state_t *state = app_data_state;
    int32_t *in_1 = input[2 * state->config.position];
    int32_t *in_2 = input[2 * state->config.position + 1];

    int32_t *out_1 = output[0];
    int32_t *out_2 = output[1];

    memcpy(out_1, in_1, sizeof(int32_t) * state->frame_size);
    memcpy(out_2, in_2, sizeof(int32_t) * state->frame_size);

}

void switch_stereo_init(module_instance_t* instance, adsp_bump_allocator_t* allocator, uint8_t id, int n_inputs, int n_outputs, int frame_size)
{
    switch_stereo_state_t *state = instance->state;
    switch_stereo_config_t *config = instance->control.config;

    memset(state, 0, sizeof(switch_stereo_state_t));
    state->n_inputs = n_inputs;
    xassert(n_inputs % 2 == 0 && "Stereo switch must have multiple stereo inputs");

    state->frame_size = frame_size;
    xassert(n_outputs == 2 && "Stereo switch should only have two outputs");
    state->n_outputs = n_outputs;

    memcpy(&state->config, config, sizeof(switch_stereo_config_t));
}

void switch_stereo_control(void *module_state, module_control_t *control)
{
    switch_stereo_state_t *state = module_state;
    switch_stereo_config_t *config = control->config;

    if(control->config_rw_state == config_write_pending)
    {
        // Finish the write by updating the working copy with the new config
        memcpy(&state->config, config, sizeof(switch_stereo_config_t));
        control->config_rw_state = config_none_pending;
    }
    else if(control->config_rw_state == config_read_pending)
    {
        memcpy(config, &state->config, sizeof(switch_stereo_config_t));
        control->config_rw_state = config_read_updated;
    }
    else
    {
        // nothing to do.
    }
}

