// Copyright 2021 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.

/**
 * @brief Human Interface Device (HID) descriptors
 *
 * This file lists the contents of the HID descriptors returned during enumeration.
 * The full definition of the enumerated descriptors appears in xua_ep0_descriptors.h.
 * That file should #include the contents of this one at an appropriate point in the
 * definition of the cfgDesc_Audio1 and cfgDesc_Audio2 arrays.
 */

#ifndef _HID_DESCRIPTORS_
#define _HID_DESCRIPTORS_

#include "xua_hid_interface_descriptor_contents.h"
#include "xua_hid_descriptor_contents.h"
#include "xua_hid_endpoint_descriptor_contents.h"

#endif // _HID_DESCRIPTORS_
