// Copyright 2015-2021 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.
#include <stdint.h>

const int32_t dsp_sine_4[2] = {
           0, 2147483647,
};

const int32_t dsp_sine_8[3] = {
           0, 1518500249, 2147483647,
};

const int32_t dsp_sine_16[5] = {
           0,  821806413, 1518500249, 1984016188,
  2147483647,
};

const int32_t dsp_sine_32[9] = {
           0,  418953276,  821806413, 1193077990,
  1518500249, 1785567396, 1984016188, 2106220351,
  2147483647,
};

const int32_t dsp_sine_64[17] = {
           0,  210490206,  418953276,  623381597,
   821806413, 1012316784, 1193077990, 1362349204,
  1518500249, 1660027308, 1785567396, 1893911493,
  1984016188, 2055013723, 2106220351, 2137142927,
  2147483647,
};

const int32_t dsp_sine_128[33] = {
           0,  105372028,  210490206,  315101294,
   418953276,  521795963,  623381597,  723465451,
   821806413,  918167571, 1012316784, 1104027236,
  1193077990, 1279254515, 1362349204, 1442161874,
  1518500249, 1591180425, 1660027308, 1724875039,
  1785567396, 1841958164, 1893911493, 1941302224,
  1984016188, 2021950483, 2055013723, 2083126254,
  2106220351, 2124240380, 2137142927, 2144896909,
  2147483647,
};

const int32_t dsp_sine_256[65] = {
           0,   52701886,  105372028,  157978697,
   210490206,  262874923,  315101294,  367137860,
   418953276,  470516330,  521795963,  572761285,
   623381597,  673626408,  723465451,  772868705,
   821806413,  870249095,  918167571,  965532978,
  1012316784, 1058490807, 1104027236, 1148898640,
  1193077990, 1236538675, 1279254515, 1321199780,
  1362349204, 1402677999, 1442161874, 1480777044,
  1518500249, 1555308767, 1591180425, 1626093615,
  1660027308, 1692961062, 1724875039, 1755750017,
  1785567396, 1814309216, 1841958164, 1868497585,
  1893911493, 1918184580, 1941302224, 1963250501,
  1984016188, 2003586779, 2021950483, 2039096241,
  2055013723, 2069693341, 2083126254, 2095304369,
  2106220351, 2115867625, 2124240380, 2131333571,
  2137142927, 2141664948, 2144896909, 2146836866,
  2147483647,
};

const int32_t dsp_sine_512[129] = {
           0,   26352927,   52701886,   79042909,
   105372028,  131685278,  157978697,  184248325,
   210490206,  236700387,  262874923,  289009870,
   315101294,  341145265,  367137860,  393075166,
   418953276,  444768293,  470516330,  496193509,
   521795963,  547319836,  572761285,  598116478,
   623381597,  648552837,  673626408,  698598532,
   723465451,  748223418,  772868705,  797397602,
   821806413,  846091463,  870249095,  894275670,
   918167571,  941921199,  965532978,  988999351,
  1012316784, 1035481765, 1058490807, 1081340445,
  1104027236, 1126547765, 1148898640, 1171076495,
  1193077990, 1214899812, 1236538675, 1257991319,
  1279254515, 1300325060, 1321199780, 1341875533,
  1362349204, 1382617710, 1402677999, 1422527050,
  1442161874, 1461579513, 1480777044, 1499751575,
  1518500249, 1537020243, 1555308767, 1573363068,
  1591180425, 1608758157, 1626093615, 1643184190,
  1660027308, 1676620431, 1692961062, 1709046739,
  1724875039, 1740443580, 1755750017, 1770792044,
  1785567396, 1800073848, 1814309216, 1828271355,
  1841958164, 1855367580, 1868497585, 1881346201,
  1893911493, 1906191570, 1918184580, 1929888719,
  1941302224, 1952423376, 1963250501, 1973781967,
  1984016188, 1993951624, 2003586779, 2012920200,
  2021950483, 2030676268, 2039096241, 2047209133,
  2055013723, 2062508835, 2069693341, 2076566159,
  2083126254, 2089372637, 2095304369, 2100920556,
  2106220351, 2111202958, 2115867625, 2120213651,
  2124240380, 2127947206, 2131333571, 2134398965,
  2137142927, 2139565042, 2141664948, 2143442326,
  2144896909, 2146028479, 2146836866, 2147321946,
  2147483647,
};

const int32_t dsp_sine_1024[257] = {
           0,   13176711,   26352927,   39528151,
    52701886,   65873638,   79042909,   92209204,
   105372028,  118530884,  131685278,  144834714,
   157978697,  171116732,  184248325,  197372981,
   210490206,  223599506,  236700387,  249792357,
   262874923,  275947591,  289009870,  302061268,
   315101294,  328129456,  341145265,  354148229,
   367137860,  380113668,  393075166,  406021864,
   418953276,  431868914,  444768293,  457650927,
   470516330,  483364019,  496193509,  509004318,
   521795963,  534567962,  547319836,  560051103,
   572761285,  585449902,  598116478,  610760535,
   623381597,  635979189,  648552837,  661102068,
   673626408,  686125386,  698598532,  711045377,
   723465451,  735858287,  748223418,  760560379,
   772868705,  785147934,  797397602,  809617248,
   821806413,  833964637,  846091463,  858186434,
   870249095,  882278991,  894275670,  906238680,
   918167571,  930061894,  941921199,  953745043,
   965532978,  977284561,  988999351, 1000676904,
  1012316784, 1023918549, 1035481765, 1047005996,
  1058490807, 1069935767, 1081340445, 1092704410,
  1104027236, 1115308496, 1126547765, 1137744620,
  1148898640, 1160009404, 1171076495, 1182099495,
  1193077990, 1204011566, 1214899812, 1225742318,
  1236538675, 1247288477, 1257991319, 1268646799,
  1279254515, 1289814068, 1300325060, 1310787095,
  1321199780, 1331562723, 1341875533, 1352137822,
  1362349204, 1372509294, 1382617710, 1392674071,
  1402677999, 1412629117, 1422527050, 1432371426,
  1442161874, 1451898025, 1461579513, 1471205974,
  1480777044, 1490292364, 1499751575, 1509154322,
  1518500249, 1527789006, 1537020243, 1546193612,
  1555308767, 1564365366, 1573363068, 1582301533,
  1591180425, 1599999411, 1608758157, 1617456334,
  1626093615, 1634669675, 1643184190, 1651636841,
  1660027308, 1668355276, 1676620431, 1684822463,
  1692961062, 1701035922, 1709046739, 1716993211,
  1724875039, 1732691927, 1740443580, 1748129706,
  1755750017, 1763304224, 1770792044, 1778213194,
  1785567396, 1792854372, 1800073848, 1807225552,
  1814309216, 1821324571, 1828271355, 1835149306,
  1841958164, 1848697673, 1855367580, 1861967634,
  1868497585, 1874957189, 1881346201, 1887664382,
  1893911493, 1900087300, 1906191570, 1912224072,
  1918184580, 1924072870, 1929888719, 1935631910,
  1941302224, 1946899450, 1952423376, 1957873795,
  1963250501, 1968553291, 1973781967, 1978936330,
  1984016188, 1989021349, 1993951624, 1998806828,
  2003586779, 2008291295, 2012920200, 2017473320,
  2021950483, 2026351521, 2030676268, 2034924561,
  2039096241, 2043191149, 2047209133, 2051150040,
  2055013723, 2058800035, 2062508835, 2066139983,
  2069693341, 2073168777, 2076566159, 2079885360,
  2083126254, 2086288719, 2089372637, 2092377892,
  2095304369, 2098151959, 2100920556, 2103610053,
  2106220351, 2108751351, 2111202958, 2113575079,
  2115867625, 2118080510, 2120213651, 2122266966,
  2124240380, 2126133817, 2127947206, 2129680479,
  2131333571, 2132906419, 2134398965, 2135811152,
  2137142927, 2138394239, 2139565042, 2140655292,
  2141664948, 2142593970, 2143442326, 2144209982,
  2144896909, 2145503083, 2146028479, 2146473079,
  2146836866, 2147119825, 2147321946, 2147443222,
  2147483647,
};

const int32_t dsp_sine_2048[513] = {
           0,    6588386,   13176711,   19764912,
    26352927,   32940694,   39528151,   46115236,
    52701886,   59288041,   65873638,   72458614,
    79042909,   85626459,   92209204,   98791081,
   105372028,  111951983,  118530884,  125108670,
   131685278,  138260647,  144834714,  151407418,
   157978697,  164548489,  171116732,  177683365,
   184248325,  190811551,  197372981,  203932553,
   210490206,  217045877,  223599506,  230151030,
   236700387,  243247517,  249792357,  256334846,
   262874923,  269412525,  275947591,  282480060,
   289009870,  295536960,  302061268,  308582733,
   315101294,  321616889,  328129456,  334638935,
   341145265,  347648383,  354148229,  360644742,
   367137860,  373627523,  380113668,  386596237,
   393075166,  399550395,  406021864,  412489511,
   418953276,  425413097,  431868914,  438320667,
   444768293,  451211733,  457650927,  464085812,
   470516330,  476942419,  483364019,  489781069,
   496193509,  502601278,  509004318,  515402566,
   521795963,  528184448,  534567962,  540946445,
   547319836,  553688075,  560051103,  566408860,
   572761285,  579108319,  585449902,  591785975,
   598116478,  604441351,  610760535,  617073970,
   623381597,  629683357,  635979189,  642269036,
   648552837,  654830534,  661102068,  667367378,
   673626408,  679879097,  686125386,  692365218,
   698598532,  704825272,  711045377,  717258789,
   723465451,  729665303,  735858287,  742044345,
   748223418,  754395449,  760560379,  766718151,
   772868705,  779011986,  785147934,  791276492,
   797397602,  803511206,  809617248,  815715669,
   821806413,  827889421,  833964637,  840032003,
   846091463,  852142959,  858186434,  864221832,
   870249095,  876268167,  882278991,  888281511,
   894275670,  900261412,  906238680,  912207419,
   918167571,  924119081,  930061894,  935995951,
   941921199,  947837582,  953745043,  959643527,
   965532978,  971413341,  977284561,  983146583,
   988999351,  994842809, 1000676904, 1006501581,
  1012316784, 1018122458, 1023918549, 1029705003,
  1035481765, 1041248781, 1047005996, 1052753356,
  1058490807, 1064218296, 1069935767, 1075643168,
  1081340445, 1087027543, 1092704410, 1098370992,
  1104027236, 1109673088, 1115308496, 1120933406,
  1126547765, 1132151521, 1137744620, 1143327011,
  1148898640, 1154459455, 1160009404, 1165548435,
  1171076495, 1176593532, 1182099495, 1187594332,
  1193077990, 1198550419, 1204011566, 1209461381,
  1214899812, 1220326808, 1225742318, 1231146290,
  1236538675, 1241919421, 1247288477, 1252645793,
  1257991319, 1263325005, 1268646799, 1273956653,
  1279254515, 1284540337, 1289814068, 1295075658,
  1300325060, 1305562221, 1310787095, 1315999631,
  1321199780, 1326387493, 1331562723, 1336725418,
  1341875533, 1347013016, 1352137822, 1357249900,
  1362349204, 1367435684, 1372509294, 1377569985,
  1382617710, 1387652421, 1392674071, 1397682613,
  1402677999, 1407660183, 1412629117, 1417584755,
  1422527050, 1427455956, 1432371426, 1437273414,
  1442161874, 1447036759, 1451898025, 1456745625,
  1461579513, 1466399644, 1471205974, 1475998455,
  1480777044, 1485541695, 1490292364, 1495029005,
  1499751575, 1504460029, 1509154322, 1513834410,
  1518500249, 1523151796, 1527789006, 1532411837,
  1537020243, 1541614183, 1546193612, 1550758488,
  1555308767, 1559844408, 1564365366, 1568871600,
  1573363068, 1577839726, 1582301533, 1586748446,
  1591180425, 1595597427, 1599999411, 1604386334,
  1608758157, 1613114837, 1617456334, 1621782607,
  1626093615, 1630389318, 1634669675, 1638934646,
  1643184190, 1647418269, 1651636841, 1655839867,
  1660027308, 1664199124, 1668355276, 1672495725,
  1676620431, 1680729357, 1684822463, 1688899711,
  1692961062, 1697006478, 1701035922, 1705049354,
  1709046739, 1713028037, 1716993211, 1720942224,
  1724875039, 1728791619, 1732691927, 1736575926,
  1740443580, 1744294852, 1748129706, 1751948106,
  1755750017, 1759535401, 1763304224, 1767056450,
  1770792044, 1774510970, 1778213194, 1781898681,
  1785567396, 1789219304, 1792854372, 1796472564,
  1800073848, 1803658189, 1807225552, 1810775906,
  1814309216, 1817825449, 1821324571, 1824806551,
  1828271355, 1831718951, 1835149306, 1838562387,
  1841958164, 1845336603, 1848697673, 1852041343,
  1855367580, 1858676354, 1861967634, 1865241388,
  1868497585, 1871736196, 1874957189, 1878160534,
  1881346201, 1884514161, 1887664382, 1890796836,
  1893911493, 1897008324, 1900087300, 1903148391,
  1906191570, 1909216806, 1912224072, 1915213340,
  1918184580, 1921137766, 1924072870, 1926989863,
  1929888719, 1932769411, 1935631910, 1938476190,
  1941302224, 1944109987, 1946899450, 1949670589,
  1952423376, 1955157787, 1957873795, 1960571375,
  1963250501, 1965911148, 1968553291, 1971176906,
  1973781967, 1976368450, 1978936330, 1981485585,
  1984016188, 1986528118, 1989021349, 1991495859,
  1993951624, 1996388622, 1998806828, 2001206222,
  2003586779, 2005948477, 2008291295, 2010615210,
  2012920200, 2015206244, 2017473320, 2019721407,
  2021950483, 2024160528, 2026351521, 2028523441,
  2030676268, 2032809982, 2034924561, 2037019988,
  2039096241, 2041153301, 2043191149, 2045209766,
  2047209133, 2049189230, 2051150040, 2053091543,
  2055013723, 2056916559, 2058800035, 2060664133,
  2062508835, 2064334124, 2066139983, 2067926394,
  2069693341, 2071440808, 2073168777, 2074877233,
  2076566159, 2078235540, 2079885360, 2081515603,
  2083126254, 2084717298, 2086288719, 2087840504,
  2089372637, 2090885105, 2092377892, 2093850984,
  2095304369, 2096738032, 2098151959, 2099546138,
  2100920556, 2102275198, 2103610053, 2104925109,
  2106220351, 2107495770, 2108751351, 2109987085,
  2111202958, 2112398960, 2113575079, 2114731304,
  2115867625, 2116984031, 2118080510, 2119157054,
  2120213651, 2121250291, 2122266966, 2123263665,
  2124240380, 2125197100, 2126133817, 2127050522,
  2127947206, 2128823861, 2129680479, 2130517052,
  2131333571, 2132130029, 2132906419, 2133662734,
  2134398965, 2135115107, 2135811152, 2136487094,
  2137142927, 2137778644, 2138394239, 2138989707,
  2139565042, 2140120239, 2140655292, 2141170197,
  2141664948, 2142139540, 2142593970, 2143028234,
  2143442326, 2143836243, 2144209982, 2144563538,
  2144896909, 2145210092, 2145503083, 2145775880,
  2146028479, 2146260880, 2146473079, 2146665075,
  2146836866, 2146988449, 2147119825, 2147230991,
  2147321946, 2147392690, 2147443222, 2147473541,
  2147483647,
};

const int32_t dsp_sine_4096[1025] = {
           0,    3294197,    6588386,    9882561,
    13176711,   16470831,   19764912,   23058947,
    26352927,   29646846,   32940694,   36234465,
    39528151,   42821744,   46115236,   49408619,
    52701886,   55995030,   59288041,   62580913,
    65873638,   69166207,   72458614,   75750851,
    79042909,   82334781,   85626459,   88917936,
    92209204,   95500255,   98791081,  102081674,
   105372028,  108662133,  111951983,  115241569,
   118530884,  121819920,  125108670,  128397125,
   131685278,  134973121,  138260647,  141547847,
   144834714,  148121240,  151407418,  154693239,
   157978697,  161263783,  164548489,  167832808,
   171116732,  174400254,  177683365,  180966058,
   184248325,  187530158,  190811551,  194092494,
   197372981,  200653003,  203932553,  207211623,
   210490206,  213768293,  217045877,  220322951,
   223599506,  226875535,  230151030,  233425983,
   236700387,  239974235,  243247517,  246520227,
   249792357,  253063900,  256334846,  259605190,
   262874923,  266144037,  269412525,  272680379,
   275947591,  279214154,  282480060,  285745301,
   289009870,  292273759,  295536960,  298799466,
   302061268,  305322360,  308582733,  311842381,
   315101294,  318359466,  321616889,  324873555,
   328129456,  331384586,  334638935,  337892498,
   341145265,  344397229,  347648383,  350898719,
   354148229,  357396906,  360644742,  363891729,
   367137860,  370383127,  373627523,  376871039,
   380113668,  383355404,  386596237,  389836160,
   393075166,  396313247,  399550395,  402786604,
   406021864,  409256169,  412489511,  415721883,
   418953276,  422183683,  425413097,  428641510,
   431868914,  435095302,  438320667,  441544999,
   444768293,  447990540,  451211733,  454431865,
   457650927,  460868912,  464085812,  467301621,
   470516330,  473729932,  476942419,  480153784,
   483364019,  486573116,  489781069,  492987869,
   496193509,  499397981,  502601278,  505803393,
   509004318,  512204044,  515402566,  518599874,
   521795963,  524990823,  528184448,  531376830,
   534567962,  537757836,  540946445,  544133781,
   547319836,  550504603,  553688075,  556870244,
   560051103,  563230644,  566408860,  569585742,
   572761285,  575935480,  579108319,  582279796,
   585449902,  588618631,  591785975,  594951927,
   598116478,  601279622,  604441351,  607601658,
   610760535,  613917975,  617073970,  620228513,
   623381597,  626533214,  629683357,  632832018,
   635979189,  639124865,  642269036,  645411696,
   648552837,  651692452,  654830534,  657967075,
   661102068,  664235504,  667367378,  670497682,
   673626408,  676753548,  679879097,  683003045,
   686125386,  689246113,  692365218,  695482693,
   698598532,  701712728,  704825272,  707936157,
   711045377,  714152923,  717258789,  720362968,
   723465451,  726566232,  729665303,  732762657,
   735858287,  738952185,  742044345,  745134758,
   748223418,  751310317,  754395449,  757478805,
   760560379,  763640163,  766718151,  769794334,
   772868705,  775941259,  779011986,  782080880,
   785147934,  788213140,  791276492,  794337981,
   797397602,  800455346,  803511206,  806565176,
   809617248,  812667415,  815715669,  818762004,
   821806413,  824848887,  827889421,  830928007,
   833964637,  836999305,  840032003,  843062725,
   846091463,  849118210,  852142959,  855165703,
   858186434,  861205146,  864221832,  867236484,
   870249095,  873259658,  876268167,  879274614,
   882278991,  885281293,  888281511,  891279639,
   894275670,  897269597,  900261412,  903251109,
   906238680,  909224119,  912207419,  915188572,
   918167571,  921144410,  924119081,  927091578,
   930061894,  933030020,  935995951,  938959680,
   941921199,  944880502,  947837582,  950792431,
   953745043,  956695410,  959643527,  962589385,
   965532978,  968474299,  971413341,  974350098,
   977284561,  980216725,  983146583,  986074127,
   988999351,  991922247,  994842809,  997761031,
  1000676904, 1003590423, 1006501581, 1009410370,
  1012316784, 1015220815, 1018122458, 1021021705,
  1023918549, 1026812984, 1029705003, 1032594599,
  1035481765, 1038366495, 1041248781, 1044128617,
  1047005996, 1049880911, 1052753356, 1055623324,
  1058490807, 1061355800, 1064218296, 1067078287,
  1069935767, 1072790730, 1075643168, 1078493075,
  1081340445, 1084185270, 1087027543, 1089867259,
  1092704410, 1095538990, 1098370992, 1101200410,
  1104027236, 1106851464, 1109673088, 1112492101,
  1115308496, 1118122266, 1120933406, 1123741907,
  1126547765, 1129350972, 1132151521, 1134949406,
  1137744620, 1140537157, 1143327011, 1146114174,
  1148898640, 1151680403, 1154459455, 1157235791,
  1160009404, 1162780288, 1165548435, 1168313840,
  1171076495, 1173836395, 1176593532, 1179347901,
  1182099495, 1184848308, 1187594332, 1190337561,
  1193077990, 1195815611, 1198550419, 1201282406,
  1204011566, 1206737894, 1209461381, 1212182023,
  1214899812, 1217614743, 1220326808, 1223036002,
  1225742318, 1228445749, 1231146290, 1233843934,
  1236538675, 1239230506, 1241919421, 1244605413,
  1247288477, 1249968606, 1252645793, 1255320033,
  1257991319, 1260659645, 1263325005, 1265987391,
  1268646799, 1271303222, 1273956653, 1276607086,
  1279254515, 1281898934, 1284540337, 1287178717,
  1289814068, 1292446384, 1295075658, 1297701886,
  1300325060, 1302945174, 1305562221, 1308176197,
  1310787095, 1313394908, 1315999631, 1318601257,
  1321199780, 1323795194, 1326387493, 1328976672,
  1331562723, 1334145640, 1336725418, 1339302051,
  1341875533, 1344445856, 1347013016, 1349577007,
  1352137822, 1354695455, 1357249900, 1359801152,
  1362349204, 1364894050, 1367435684, 1369974101,
  1372509294, 1375041257, 1377569985, 1380095471,
  1382617710, 1385136695, 1387652421, 1390164882,
  1392674071, 1395179983, 1397682613, 1400181953,
  1402677999, 1405170744, 1407660183, 1410146309,
  1412629117, 1415108601, 1417584755, 1420057573,
  1422527050, 1424993179, 1427455956, 1429915373,
  1432371426, 1434824108, 1437273414, 1439719338,
  1442161874, 1444601016, 1447036759, 1449469097,
  1451898025, 1454323536, 1456745625, 1459164286,
  1461579513, 1463991301, 1466399644, 1468804537,
  1471205974, 1473603948, 1475998455, 1478389489,
  1480777044, 1483161115, 1485541695, 1487918780,
  1490292364, 1492662441, 1495029005, 1497392052,
  1499751575, 1502107569, 1504460029, 1506808948,
  1509154322, 1511496144, 1513834410, 1516169114,
  1518500249, 1520827812, 1523151796, 1525472196,
  1527789006, 1530102222, 1532411837, 1534717846,
  1537020243, 1539319024, 1541614183, 1543905714,
  1546193612, 1548477872, 1550758488, 1553035455,
  1555308767, 1557578420, 1559844408, 1562106725,
  1564365366, 1566620326, 1568871600, 1571119182,
  1573363068, 1575603250, 1577839726, 1580072488,
  1582301533, 1584526854, 1586748446, 1588966305,
  1591180425, 1593390801, 1595597427, 1597800299,
  1599999411, 1602194757, 1604386334, 1606574136,
  1608758157, 1610938392, 1613114837, 1615287486,
  1617456334, 1619621376, 1621782607, 1623940022,
  1626093615, 1628243383, 1630389318, 1632531417,
  1634669675, 1636804086, 1638934646, 1641061349,
  1643184190, 1645303165, 1647418269, 1649529495,
  1651636841, 1653740300, 1655839867, 1657935538,
  1660027308, 1662115171, 1664199124, 1666279160,
  1668355276, 1670427466, 1672495725, 1674560048,
  1676620431, 1678676869, 1680729357, 1682777890,
  1684822463, 1686863071, 1688899711, 1690932376,
  1692961062, 1694985764, 1697006478, 1699023199,
  1701035922, 1703044642, 1705049354, 1707050055,
  1709046739, 1711039401, 1713028037, 1715012641,
  1716993211, 1718969740, 1720942224, 1722910659,
  1724875039, 1726835361, 1728791619, 1730743809,
  1732691927, 1734635968, 1736575926, 1738511799,
  1740443580, 1742371266, 1744294852, 1746214334,
  1748129706, 1750040965, 1751948106, 1753851125,
  1755750017, 1757644777, 1759535401, 1761421885,
  1763304224, 1765182414, 1767056450, 1768926328,
  1770792044, 1772653592, 1774510970, 1776364172,
  1778213194, 1780058032, 1781898681, 1783735137,
  1785567396, 1787395453, 1789219304, 1791038945,
  1792854372, 1794665580, 1796472564, 1798275322,
  1800073848, 1801868138, 1803658189, 1805443995,
  1807225552, 1809002858, 1810775906, 1812544693,
  1814309216, 1816069469, 1817825449, 1819577151,
  1821324571, 1823067706, 1824806551, 1826541102,
  1828271355, 1829997306, 1831718951, 1833436285,
  1835149306, 1836858008, 1838562387, 1840262441,
  1841958164, 1843649553, 1845336603, 1847019311,
  1848697673, 1850371685, 1852041343, 1853706643,
  1855367580, 1857024152, 1858676354, 1860324183,
  1861967634, 1863606703, 1865241388, 1866871683,
  1868497585, 1870119091, 1871736196, 1873348896,
  1874957189, 1876561069, 1878160534, 1879755579,
  1881346201, 1882932396, 1884514161, 1886091490,
  1887664382, 1889232832, 1890796836, 1892356391,
  1893911493, 1895462139, 1897008324, 1898550046,
  1900087300, 1901620083, 1903148391, 1904672221,
  1906191570, 1907706432, 1909216806, 1910722687,
  1912224072, 1913720957, 1915213340, 1916701215,
  1918184580, 1919663432, 1921137766, 1922607580,
  1924072870, 1925533632, 1926989863, 1928441560,
  1929888719, 1931331337, 1932769411, 1934202936,
  1935631910, 1937056329, 1938476190, 1939891490,
  1941302224, 1942708391, 1944109987, 1945507007,
  1946899450, 1948287312, 1949670589, 1951049278,
  1952423376, 1953792880, 1955157787, 1956518093,
  1957873795, 1959224890, 1960571375, 1961913246,
  1963250501, 1964583136, 1965911148, 1967234534,
  1968553291, 1969867416, 1971176906, 1972481757,
  1973781967, 1975077532, 1976368450, 1977654717,
  1978936330, 1980213287, 1981485585, 1982753219,
  1984016188, 1985274489, 1986528118, 1987777072,
  1989021349, 1990260946, 1991495859, 1992726086,
  1993951624, 1995172470, 1996388622, 1997600075,
  1998806828, 2000008878, 2001206222, 2002398856,
  2003586779, 2004769987, 2005948477, 2007122248,
  2008291295, 2009455617, 2010615210, 2011770072,
  2012920200, 2014065592, 2015206244, 2016342154,
  2017473320, 2018599739, 2019721407, 2020838323,
  2021950483, 2023057886, 2024160528, 2025258408,
  2026351521, 2027439867, 2028523441, 2029602243,
  2030676268, 2031745515, 2032809982, 2033869664,
  2034924561, 2035974670, 2037019988, 2038060512,
  2039096241, 2040127171, 2041153301, 2042174628,
  2043191149, 2044202863, 2045209766, 2046211857,
  2047209133, 2048201591, 2049189230, 2050172047,
  2051150040, 2052123206, 2053091543, 2054055050,
  2055013723, 2055967560, 2056916559, 2057860718,
  2058800035, 2059734507, 2060664133, 2061588909,
  2062508835, 2063423907, 2064334124, 2065239483,
  2066139983, 2067035620, 2067926394, 2068812302,
  2069693341, 2070569510, 2071440808, 2072307230,
  2073168777, 2074025445, 2074877233, 2075724138,
  2076566159, 2077403294, 2078235540, 2079062896,
  2079885360, 2080702929, 2081515603, 2082323378,
  2083126254, 2083924228, 2084717298, 2085505462,
  2086288719, 2087067067, 2087840504, 2088609028,
  2089372637, 2090131330, 2090885105, 2091633959,
  2092377892, 2093116901, 2093850984, 2094580141,
  2095304369, 2096023667, 2096738032, 2097447463,
  2098151959, 2098851518, 2099546138, 2100235818,
  2100920556, 2101600350, 2102275198, 2102945100,
  2103610053, 2104270057, 2104925109, 2105575207,
  2106220351, 2106860539, 2107495770, 2108126041,
  2108751351, 2109371700, 2109987085, 2110597505,
  2111202958, 2111803444, 2112398960, 2112989506,
  2113575079, 2114155679, 2114731304, 2115301954,
  2115867625, 2116428318, 2116984031, 2117534762,
  2118080510, 2118621275, 2119157054, 2119687846,
  2120213651, 2120734466, 2121250291, 2121761125,
  2122266966, 2122767813, 2123263665, 2123754521,
  2124240380, 2124721239, 2125197100, 2125667959,
  2126133817, 2126594671, 2127050522, 2127501367,
  2127947206, 2128388038, 2128823861, 2129254675,
  2129680479, 2130101272, 2130517052, 2130927818,
  2131333571, 2131734308, 2132130029, 2132520733,
  2132906419, 2133287087, 2133662734, 2134033360,
  2134398965, 2134759548, 2135115107, 2135465642,
  2135811152, 2136151636, 2136487094, 2136817525,
  2137142927, 2137463300, 2137778644, 2138088957,
  2138394239, 2138694490, 2138989707, 2139279892,
  2139565042, 2139845158, 2140120239, 2140390284,
  2140655292, 2140915263, 2141170197, 2141420092,
  2141664948, 2141904764, 2142139540, 2142369276,
  2142593970, 2142813623, 2143028234, 2143237801,
  2143442326, 2143641806, 2143836243, 2144025635,
  2144209982, 2144389283, 2144563538, 2144732747,
  2144896909, 2145056024, 2145210092, 2145359112,
  2145503083, 2145642006, 2145775880, 2145904704,
  2146028479, 2146147205, 2146260880, 2146369505,
  2146473079, 2146571603, 2146665075, 2146753496,
  2146836866, 2146915183, 2146988449, 2147056663,
  2147119825, 2147177934, 2147230991, 2147278995,
  2147321946, 2147359844, 2147392690, 2147420482,
  2147443222, 2147460908, 2147473541, 2147481121,
  2147483647,
};

const int32_t dsp_sine_8192[2049] = {
           0,    1647099,    3294197,    4941293,
     6588386,    8235476,    9882561,   11529639,
    13176711,   14823776,   16470831,   18117877,
    19764912,   21411936,   23058947,   24705944,
    26352927,   27999895,   29646846,   31293779,
    32940694,   34587590,   36234465,   37881319,
    39528151,   41174959,   42821744,   44468503,
    46115236,   47761942,   49408619,   51055268,
    52701886,   54348474,   55995030,   57641552,
    59288041,   60934495,   62580913,   64227294,
    65873638,   67519942,   69166207,   70812432,
    72458614,   74104754,   75750851,   77396903,
    79042909,   80688869,   82334781,   83980645,
    85626459,   87272224,   88917936,   90563597,
    92209204,   93854757,   95500255,   97145696,
    98791081,  100436407,  102081674,  103726882,
   105372028,  107017112,  108662133,  110307090,
   111951983,  113596809,  115241569,  116886261,
   118530884,  120175438,  121819920,  123464331,
   125108670,  126752935,  128397125,  130041240,
   131685278,  133329239,  134973121,  136616924,
   138260647,  139904288,  141547847,  143191322,
   144834714,  146478020,  148121240,  149764373,
   151407418,  153050374,  154693239,  156336014,
   157978697,  159621287,  161263783,  162906184,
   164548489,  166190697,  167832808,  169474820,
   171116732,  172758544,  174400254,  176041861,
   177683365,  179324764,  180966058,  182607245,
   184248325,  185889296,  187530158,  189170910,
   190811551,  192452079,  194092494,  195732795,
   197372981,  199013050,  200653003,  202292837,
   203932553,  205572148,  207211623,  208850976,
   210490206,  212129312,  213768293,  215407148,
   217045877,  218684478,  220322951,  221961293,
   223599506,  225237586,  226875535,  228513349,
   230151030,  231788575,  233425983,  235063254,
   236700387,  238337381,  239974235,  241610947,
   243247517,  244883944,  246520227,  248156365,
   249792357,  251428202,  253063900,  254699448,
   256334846,  257970094,  259605190,  261240133,
   262874923,  264509558,  266144037,  267778360,
   269412525,  271046532,  272680379,  274314066,
   275947591,  277580954,  279214154,  280847190,
   282480060,  284112764,  285745301,  287377670,
   289009870,  290641900,  292273759,  293905446,
   295536960,  297168300,  298799466,  300430456,
   302061268,  303691904,  305322360,  306952637,
   308582733,  310212648,  311842381,  313471930,
   315101294,  316730473,  318359466,  319988271,
   321616889,  323245317,  324873555,  326501602,
   328129456,  329757118,  331384586,  333011858,
   334638935,  336265815,  337892498,  339518981,
   341145265,  342771348,  344397229,  346022908,
   347648383,  349273654,  350898719,  352523578,
   354148229,  355772672,  357396906,  359020929,
   360644742,  362268342,  363891729,  365514902,
   367137860,  368760602,  370383127,  372005434,
   373627523,  375249391,  376871039,  378492465,
   380113668,  381734648,  383355404,  384975933,
   386596237,  388216312,  389836160,  391455778,
   393075166,  394694322,  396313247,  397931938,
   399550395,  401168617,  402786604,  404404353,
   406021864,  407639137,  409256169,  410872961,
   412489511,  414105819,  415721883,  417337702,
   418953276,  420568603,  422183683,  423798515,
   425413097,  427027429,  428641510,  430255339,
   431868914,  433482236,  435095302,  436708113,
   438320667,  439932962,  441544999,  443156777,
   444768293,  446379548,  447990540,  449601269,
   451211733,  452821932,  454431865,  456041530,
   457650927,  459260054,  460868912,  462477498,
   464085812,  465693854,  467301621,  468909113,
   470516330,  472123270,  473729932,  475336315,
   476942419,  478548242,  480153784,  481759043,
   483364019,  484968710,  486573116,  488177236,
   489781069,  491384613,  492987869,  494590834,
   496193509,  497795891,  499397981,  500999777,
   502601278,  504202484,  505803393,  507404005,
   509004318,  510604331,  512204044,  513803456,
   515402566,  517001372,  518599874,  520198071,
   521795963,  523393547,  524990823,  526587791,
   528184448,  529780795,  531376830,  532972553,
   534567962,  536163057,  537757836,  539352299,
   540946445,  542540272,  544133781,  545726969,
   547319836,  548912381,  550504603,  552096502,
   553688075,  555279323,  556870244,  558460838,
   560051103,  561641039,  563230644,  564819918,
   566408860,  567997468,  569585742,  571173682,
   572761285,  574348551,  575935480,  577522069,
   579108319,  580694228,  582279796,  583865021,
   585449902,  587034440,  588618631,  590202477,
   591785975,  593369126,  594951927,  596534378,
   598116478,  599698226,  601279622,  602860664,
   604441351,  606021683,  607601658,  609181276,
   610760535,  612339435,  613917975,  615496154,
   617073970,  618651424,  620228513,  621805238,
   623381597,  624957589,  626533214,  628108470,
   629683357,  631257873,  632832018,  634405790,
   635979189,  637552214,  639124865,  640697139,
   642269036,  643840555,  645411696,  646982457,
   648552837,  650122836,  651692452,  653261685,
   654830534,  656398998,  657967075,  659534765,
   661102068,  662668981,  664235504,  665801637,
   667367378,  668932727,  670497682,  672062242,
   673626408,  675190177,  676753548,  678316522,
   679879097,  681441271,  683003045,  684564417,
   686125386,  687685952,  689246113,  690805868,
   692365218,  693924160,  695482693,  697040818,
   698598532,  700155836,  701712728,  703269207,
   704825272,  706380922,  707936157,  709490976,
   711045377,  712599360,  714152923,  715706067,
   717258789,  718811090,  720362968,  721914422,
   723465451,  725016054,  726566232,  728115981,
   729665303,  731214195,  732762657,  734310688,
   735858287,  737405453,  738952185,  740498483,
   742044345,  743589770,  745134758,  746679308,
   748223418,  749767088,  751310317,  752853105,
   754395449,  755937349,  757478805,  759019815,
   760560379,  762100495,  763640163,  765179382,
   766718151,  768256468,  769794334,  771331746,
   772868705,  774405210,  775941259,  777476851,
   779011986,  780546662,  782080880,  783614637,
   785147934,  786680768,  788213140,  789745048,
   791276492,  792807470,  794337981,  795868026,
   797397602,  798926709,  800455346,  801983512,
   803511206,  805038428,  806565176,  808091450,
   809617248,  811142570,  812667415,  814191782,
   815715669,  817239077,  818762004,  820284450,
   821806413,  823327892,  824848887,  826369397,
   827889421,  829408958,  830928007,  832446567,
   833964637,  835482217,  836999305,  838515901,
   840032003,  841547612,  843062725,  844577342,
   846091463,  847605086,  849118210,  850630835,
   852142959,  853654582,  855165703,  856676320,
   858186434,  859696043,  861205146,  862713743,
   864221832,  865729412,  867236484,  868743045,
   870249095,  871754633,  873259658,  874764170,
   876268167,  877771648,  879274614,  880777061,
   882278991,  883780402,  885281293,  886781663,
   888281511,  889780837,  891279639,  892777917,
   894275670,  895772897,  897269597,  898765769,
   900261412,  901756526,  903251109,  904745161,
   906238680,  907731667,  909224119,  910716037,
   912207419,  913698264,  915188572,  916678341,
   918167571,  919656261,  921144410,  922632017,
   924119081,  925605602,  927091578,  928577009,
   930061894,  931546231,  933030020,  934513261,
   935995951,  937478092,  938959680,  940440716,
   941921199,  943401128,  944880502,  946359320,
   947837582,  949315286,  950792431,  952269017,
   953745043,  955220507,  956695410,  958169750,
   959643527,  961116738,  962589385,  964061465,
   965532978,  967003923,  968474299,  969944105,
   971413341,  972882006,  974350098,  975817616,
   977284561,  978750931,  980216725,  981681943,
   983146583,  984610644,  986074127,  987537029,
   988999351,  990461090,  991922247,  993382820,
   994842809,  996302213,  997761031,  999219262,
  1000676904, 1002133959, 1003590423, 1005046298,
  1006501581, 1007956272, 1009410370, 1010863874,
  1012316784, 1013769098, 1015220815, 1016671936,
  1018122458, 1019572381, 1021021705, 1022470428,
  1023918549, 1025366069, 1026812984, 1028259296,
  1029705003, 1031150105, 1032594599, 1034038486,
  1035481765, 1036924435, 1038366495, 1039807944,
  1041248781, 1042689006, 1044128617, 1045567614,
  1047005996, 1048443762, 1049880911, 1051317443,
  1052753356, 1054188650, 1055623324, 1057057377,
  1058490807, 1059923616, 1061355800, 1062787361,
  1064218296, 1065648605, 1067078287, 1068507341,
  1069935767, 1071363564, 1072790730, 1074217265,
  1075643168, 1077068439, 1078493075, 1079917078,
  1081340445, 1082763176, 1084185270, 1085606726,
  1087027543, 1088447721, 1089867259, 1091286156,
  1092704410, 1094122022, 1095538990, 1096955314,
  1098370992, 1099786024, 1101200410, 1102614147,
  1104027236, 1105439675, 1106851464, 1108262602,
  1109673088, 1111082921, 1112492101, 1113900626,
  1115308496, 1116715710, 1118122266, 1119528165,
  1120933406, 1122337987, 1123741907, 1125145167,
  1126547765, 1127949700, 1129350972, 1130751579,
  1132151521, 1133550797, 1134949406, 1136347347,
  1137744620, 1139141224, 1140537157, 1141932420,
  1143327011, 1144720929, 1146114174, 1147506744,
  1148898640, 1150289860, 1151680403, 1153070268,
  1154459455, 1155847963, 1157235791, 1158622939,
  1160009404, 1161395188, 1162780288, 1164164704,
  1165548435, 1166931480, 1168313840, 1169695511,
  1171076495, 1172456790, 1173836395, 1175215309,
  1176593532, 1177971063, 1179347901, 1180724046,
  1182099495, 1183474250, 1184848308, 1186221669,
  1187594332, 1188966296, 1190337561, 1191708126,
  1193077990, 1194447152, 1195815611, 1197183367,
  1198550419, 1199916765, 1201282406, 1202647340,
  1204011566, 1205375085, 1206737894, 1208099993,
  1209461381, 1210822058, 1212182023, 1213541275,
  1214899812, 1216257635, 1217614743, 1218971134,
  1220326808, 1221681764, 1223036002, 1224389520,
  1225742318, 1227094395, 1228445749, 1229796382,
  1231146290, 1232495475, 1233843934, 1235191668,
  1236538675, 1237884954, 1239230506, 1240575328,
  1241919421, 1243262783, 1244605413, 1245947312,
  1247288477, 1248628909, 1249968606, 1251307568,
  1252645793, 1253983282, 1255320033, 1256656046,
  1257991319, 1259325853, 1260659645, 1261992696,
  1263325005, 1264656570, 1265987391, 1267317468,
  1268646799, 1269975384, 1271303222, 1272630311,
  1273956653, 1275282244, 1276607086, 1277931176,
  1279254515, 1280577101, 1281898934, 1283220013,
  1284540337, 1285859905, 1287178717, 1288496771,
  1289814068, 1291130605, 1292446384, 1293761402,
  1295075658, 1296389153, 1297701886, 1299013855,
  1300325060, 1301635499, 1302945174, 1304254081,
  1305562221, 1306869594, 1308176197, 1309482031,
  1310787095, 1312091387, 1313394908, 1314697656,
  1315999631, 1317300831, 1318601257, 1319900907,
  1321199780, 1322497876, 1323795194, 1325091734,
  1326387493, 1327682473, 1328976672, 1330270088,
  1331562723, 1332854573, 1334145640, 1335435922,
  1336725418, 1338014128, 1339302051, 1340589186,
  1341875533, 1343161089, 1344445856, 1345729832,
  1347013016, 1348295408, 1349577007, 1350857812,
  1352137822, 1353417036, 1354695455, 1355973076,
  1357249900, 1358525926, 1359801152, 1361075578,
  1362349204, 1363622028, 1364894050, 1366165269,
  1367435684, 1368705295, 1369974101, 1371242101,
  1372509294, 1373775680, 1375041257, 1376306026,
  1377569985, 1378833134, 1380095471, 1381356997,
  1382617710, 1383877610, 1385136695, 1386394966,
  1387652421, 1388909060, 1390164882, 1391419886,
  1392674071, 1393927437, 1395179983, 1396431709,
  1397682613, 1398932695, 1400181953, 1401430388,
  1402677999, 1403924785, 1405170744, 1406415877,
  1407660183, 1408903660, 1410146309, 1411388128,
  1412629117, 1413869275, 1415108601, 1416347094,
  1417584755, 1418821581, 1420057573, 1421292730,
  1422527050, 1423760534, 1424993179, 1426224987,
  1427455956, 1428686085, 1429915373, 1431143820,
  1432371426, 1433598189, 1434824108, 1436049183,
  1437273414, 1438496799, 1439719338, 1440941029,
  1442161874, 1443381869, 1444601016, 1445819313,
  1447036759, 1448253354, 1449469097, 1450683988,
  1451898025, 1453111208, 1454323536, 1455535008,
  1456745625, 1457955384, 1459164286, 1460372329,
  1461579513, 1462785837, 1463991301, 1465195904,
  1466399644, 1467602522, 1468804537, 1470005688,
  1471205974, 1472405394, 1473603948, 1474801635,
  1475998455, 1477194406, 1478389489, 1479583702,
  1480777044, 1481969515, 1483161115, 1484351841,
  1485541695, 1486730675, 1487918780, 1489106010,
  1490292364, 1491477841, 1492662441, 1493846163,
  1495029005, 1496210969, 1497392052, 1498572254,
  1499751575, 1500930014, 1502107569, 1503284241,
  1504460029, 1505634931, 1506808948, 1507982078,
  1509154322, 1510325677, 1511496144, 1512665722,
  1513834410, 1515002207, 1516169114, 1517335128,
  1518500249, 1519664478, 1520827812, 1521990252,
  1523151796, 1524312445, 1525472196, 1526631050,
  1527789006, 1528946064, 1530102222, 1531257480,
  1532411837, 1533565292, 1534717846, 1535869496,
  1537020243, 1538170086, 1539319024, 1540467056,
  1541614183, 1542760402, 1543905714, 1545050117,
  1546193612, 1547336197, 1548477872, 1549618635,
  1550758488, 1551897428, 1553035455, 1554172568,
  1555308767, 1556444051, 1557578420, 1558711872,
  1559844408, 1560976025, 1562106725, 1563236505,
  1564365366, 1565493307, 1566620326, 1567746424,
  1568871600, 1569995853, 1571119182, 1572241587,
  1573363068, 1574483622, 1575603250, 1576721952,
  1577839726, 1578956571, 1580072488, 1581187476,
  1582301533, 1583414659, 1584526854, 1585638117,
  1586748446, 1587857843, 1588966305, 1590073833,
  1591180425, 1592286081, 1593390801, 1594494583,
  1595597427, 1596699332, 1597800299, 1598900325,
  1599999411, 1601097555, 1602194757, 1603291017,
  1604386334, 1605480707, 1606574136, 1607666619,
  1608758157, 1609848748, 1610938392, 1612027089,
  1613114837, 1614201636, 1615287486, 1616372386,
  1617456334, 1618539331, 1619621376, 1620702469,
  1621782607, 1622861792, 1623940022, 1625017297,
  1626093615, 1627168978, 1628243383, 1629316830,
  1630389318, 1631460848, 1632531417, 1633601027,
  1634669675, 1635737362, 1636804086, 1637869848,
  1638934646, 1639998480, 1641061349, 1642123253,
  1643184190, 1644244161, 1645303165, 1646361201,
  1647418269, 1648474367, 1649529495, 1650583654,
  1651636841, 1652689056, 1653740300, 1654790570,
  1655839867, 1656888190, 1657935538, 1658981911,
  1660027308, 1661071728, 1662115171, 1663157637,
  1664199124, 1665239632, 1666279160, 1667317708,
  1668355276, 1669391862, 1670427466, 1671462087,
  1672495725, 1673528379, 1674560048, 1675590733,
  1676620431, 1677649144, 1678676869, 1679703607,
  1680729357, 1681754118, 1682777890, 1683800672,
  1684822463, 1685843263, 1686863071, 1687881887,
  1688899711, 1689916540, 1690932376, 1691947216,
  1692961062, 1693973911, 1694985764, 1695996620,
  1697006478, 1698015338, 1699023199, 1700030060,
  1701035922, 1702040782, 1703044642, 1704047499,
  1705049354, 1706050206, 1707050055, 1708048899,
  1709046739, 1710043573, 1711039401, 1712034222,
  1713028037, 1714020843, 1715012641, 1716003431,
  1716993211, 1717981981, 1718969740, 1719956488,
  1720942224, 1721926948, 1722910659, 1723893356,
  1724875039, 1725855708, 1726835361, 1727813998,
  1728791619, 1729768223, 1730743809, 1731718378,
  1732691927, 1733664457, 1734635968, 1735606457,
  1736575926, 1737544374, 1738511799, 1739478201,
  1740443580, 1741407935, 1742371266, 1743333572,
  1744294852, 1745255106, 1746214334, 1747172534,
  1748129706, 1749085850, 1750040965, 1750995051,
  1751948106, 1752900131, 1753851125, 1754801087,
  1755750017, 1756697913, 1757644777, 1758590606,
  1759535401, 1760479161, 1761421885, 1762363573,
  1763304224, 1764243838, 1765182414, 1766119951,
  1767056450, 1767991909, 1768926328, 1769859706,
  1770792044, 1771723339, 1772653592, 1773582803,
  1774510970, 1775438093, 1776364172, 1777289206,
  1778213194, 1779136136, 1780058032, 1780978880,
  1781898681, 1782817433, 1783735137, 1784651791,
  1785567396, 1786481950, 1787395453, 1788307905,
  1789219304, 1790129651, 1791038945, 1791947186,
  1792854372, 1793760503, 1794665580, 1795569600,
  1796472564, 1797374472, 1798275322, 1799175114,
  1800073848, 1800971523, 1801868138, 1802763694,
  1803658189, 1804551622, 1805443995, 1806335305,
  1807225552, 1808114737, 1809002858, 1809889914,
  1810775906, 1811660833, 1812544693, 1813427488,
  1814309216, 1815189876, 1816069469, 1816947993,
  1817825449, 1818701835, 1819577151, 1820451397,
  1821324571, 1822196675, 1823067706, 1823937665,
  1824806551, 1825674364, 1826541102, 1827406766,
  1828271355, 1829134869, 1829997306, 1830858667,
  1831718951, 1832578157, 1833436285, 1834293335,
  1835149306, 1836004197, 1836858008, 1837710738,
  1838562387, 1839412955, 1840262441, 1841110844,
  1841958164, 1842804400, 1843649553, 1844493620,
  1845336603, 1846178500, 1847019311, 1847859036,
  1848697673, 1849535223, 1850371685, 1851207059,
  1852041343, 1852874538, 1853706643, 1854537657,
  1855367580, 1856196412, 1857024152, 1857850800,
  1858676354, 1859500816, 1860324183, 1861146456,
  1861967634, 1862787716, 1863606703, 1864424594,
  1865241388, 1866057084, 1866871683, 1867685183,
  1868497585, 1869308888, 1870119091, 1870928194,
  1871736196, 1872543097, 1873348896, 1874153594,
  1874957189, 1875759681, 1876561069, 1877361354,
  1878160534, 1878958609, 1879755579, 1880551443,
  1881346201, 1882139852, 1882932396, 1883723832,
  1884514161, 1885303380, 1886091490, 1886878491,
  1887664382, 1888449162, 1889232832, 1890015390,
  1890796836, 1891577170, 1892356391, 1893134499,
  1893911493, 1894687374, 1895462139, 1896235790,
  1897008324, 1897779743, 1898550046, 1899319232,
  1900087300, 1900854251, 1901620083, 1902384797,
  1903148391, 1903910866, 1904672221, 1905432456,
  1906191570, 1906949562, 1907706432, 1908462180,
  1909216806, 1909970308, 1910722687, 1911473942,
  1912224072, 1912973077, 1913720957, 1914467712,
  1915213340, 1915957841, 1916701215, 1917443462,
  1918184580, 1918924571, 1919663432, 1920401164,
  1921137766, 1921873239, 1922607580, 1923340791,
  1924072870, 1924803817, 1925533632, 1926262314,
  1926989863, 1927716279, 1928441560, 1929165707,
  1929888719, 1930610596, 1931331337, 1932050942,
  1932769411, 1933486742, 1934202936, 1934917992,
  1935631910, 1936344689, 1937056329, 1937766829,
  1938476190, 1939184410, 1939891490, 1940597428,
  1941302224, 1942005879, 1942708391, 1943409761,
  1944109987, 1944809069, 1945507007, 1946203801,
  1946899450, 1947593954, 1948287312, 1948979524,
  1949670589, 1950360507, 1951049278, 1951736901,
  1952423376, 1953108703, 1953792880, 1954475909,
  1955157787, 1955838515, 1956518093, 1957196520,
  1957873795, 1958549919, 1959224890, 1959898709,
  1960571375, 1961242887, 1961913246, 1962582451,
  1963250501, 1963917396, 1964583136, 1965247720,
  1965911148, 1966573419, 1967234534, 1967894491,
  1968553291, 1969210933, 1969867416, 1970522740,
  1971176906, 1971829911, 1972481757, 1973132442,
  1973781967, 1974430330, 1975077532, 1975723572,
  1976368450, 1977012165, 1977654717, 1978296105,
  1978936330, 1979575391, 1980213287, 1980850019,
  1981485585, 1982119985, 1982753219, 1983385287,
  1984016188, 1984645922, 1985274489, 1985901887,
  1986528118, 1987153179, 1987777072, 1988399795,
  1989021349, 1989641733, 1990260946, 1990878988,
  1991495859, 1992111559, 1992726086, 1993339442,
  1993951624, 1994562634, 1995172470, 1995781133,
  1996388622, 1996994936, 1997600075, 1998204040,
  1998806828, 1999408441, 2000008878, 2000608138,
  2001206222, 2001803128, 2002398856, 2002993407,
  2003586779, 2004178972, 2004769987, 2005359822,
  2005948477, 2006535953, 2007122248, 2007707362,
  2008291295, 2008874047, 2009455617, 2010036005,
  2010615210, 2011193233, 2011770072, 2012345728,
  2012920200, 2013493488, 2014065592, 2014636511,
  2015206244, 2015774792, 2016342154, 2016908331,
  2017473320, 2018037123, 2018599739, 2019161167,
  2019721407, 2020280459, 2020838323, 2021394998,
  2021950483, 2022504780, 2023057886, 2023609802,
  2024160528, 2024710064, 2025258408, 2025805560,
  2026351521, 2026896290, 2027439867, 2027982250,
  2028523441, 2029063439, 2029602243, 2030139853,
  2030676268, 2031211489, 2031745515, 2032278346,
  2032809982, 2033340421, 2033869664, 2034397711,
  2034924561, 2035450214, 2035974670, 2036497928,
  2037019988, 2037540849, 2038060512, 2038578976,
  2039096241, 2039612306, 2040127171, 2040640836,
  2041153301, 2041664565, 2042174628, 2042683489,
  2043191149, 2043697607, 2044202863, 2044706916,
  2045209766, 2045711413, 2046211857, 2046711097,
  2047209133, 2047705964, 2048201591, 2048696013,
  2049189230, 2049681242, 2050172047, 2050661647,
  2051150040, 2051637227, 2052123206, 2052607979,
  2053091543, 2053573901, 2054055050, 2054534990,
  2055013723, 2055491246, 2055967560, 2056442664,
  2056916559, 2057389244, 2057860718, 2058330982,
  2058800035, 2059267877, 2059734507, 2060199926,
  2060664133, 2061127127, 2061588909, 2062049479,
  2062508835, 2062966978, 2063423907, 2063879623,
  2064334124, 2064787411, 2065239483, 2065690340,
  2066139983, 2066588409, 2067035620, 2067481615,
  2067926394, 2068369956, 2068812302, 2069253430,
  2069693341, 2070132035, 2070569510, 2071005768,
  2071440808, 2071874628, 2072307230, 2072738613,
  2073168777, 2073597721, 2074025445, 2074451949,
  2074877233, 2075301296, 2075724138, 2076145759,
  2076566159, 2076985337, 2077403294, 2077820028,
  2078235540, 2078649829, 2079062896, 2079474739,
  2079885360, 2080294756, 2080702929, 2081109878,
  2081515603, 2081920103, 2082323378, 2082725429,
  2083126254, 2083525853, 2083924228, 2084321376,
  2084717298, 2085111993, 2085505462, 2085897704,
  2086288719, 2086678507, 2087067067, 2087454400,
  2087840504, 2088225380, 2088609028, 2088991447,
  2089372637, 2089752598, 2090131330, 2090508832,
  2090885105, 2091260147, 2091633959, 2092006541,
  2092377892, 2092748012, 2093116901, 2093484558,
  2093850984, 2094216179, 2094580141, 2094942871,
  2095304369, 2095664634, 2096023667, 2096381466,
  2096738032, 2097093365, 2097447463, 2097800329,
  2098151959, 2098502356, 2098851518, 2099199446,
  2099546138, 2099891596, 2100235818, 2100578805,
  2100920556, 2101261071, 2101600350, 2101938392,
  2102275198, 2102610768, 2102945100, 2103278195,
  2103610053, 2103940674, 2104270057, 2104598202,
  2104925109, 2105250777, 2105575207, 2105898399,
  2106220351, 2106541065, 2106860539, 2107178774,
  2107495770, 2107811525, 2108126041, 2108439316,
  2108751351, 2109062146, 2109371700, 2109680013,
  2109987085, 2110292915, 2110597505, 2110900852,
  2111202958, 2111503822, 2111803444, 2112101823,
  2112398960, 2112694854, 2112989506, 2113282914,
  2113575079, 2113866001, 2114155679, 2114444114,
  2114731304, 2115017251, 2115301954, 2115585412,
  2115867625, 2116148594, 2116428318, 2116706797,
  2116984031, 2117260019, 2117534762, 2117808259,
  2118080510, 2118351515, 2118621275, 2118889787,
  2119157054, 2119423073, 2119687846, 2119951372,
  2120213651, 2120474682, 2120734466, 2120993003,
  2121250291, 2121506332, 2121761125, 2122014670,
  2122266966, 2122518014, 2122767813, 2123016364,
  2123263665, 2123509718, 2123754521, 2123998075,
  2124240380, 2124481434, 2124721239, 2124959795,
  2125197100, 2125433155, 2125667959, 2125901513,
  2126133817, 2126364869, 2126594671, 2126823222,
  2127050522, 2127276570, 2127501367, 2127724912,
  2127947206, 2128168248, 2128388038, 2128606575,
  2128823861, 2129039894, 2129254675, 2129468204,
  2129680479, 2129891502, 2130101272, 2130309788,
  2130517052, 2130723062, 2130927818, 2131131322,
  2131333571, 2131534567, 2131734308, 2131932796,
  2132130029, 2132326009, 2132520733, 2132714204,
  2132906419, 2133097380, 2133287087, 2133475538,
  2133662734, 2133848675, 2134033360, 2134216790,
  2134398965, 2134579884, 2134759548, 2134937955,
  2135115107, 2135291002, 2135465642, 2135639025,
  2135811152, 2135982022, 2136151636, 2136319994,
  2136487094, 2136652938, 2136817525, 2136980854,
  2137142927, 2137303742, 2137463300, 2137621601,
  2137778644, 2137934429, 2138088957, 2138242227,
  2138394239, 2138544993, 2138694490, 2138842728,
  2138989707, 2139135429, 2139279892, 2139423096,
  2139565042, 2139705730, 2139845158, 2139983328,
  2140120239, 2140255891, 2140390284, 2140523418,
  2140655292, 2140785907, 2140915263, 2141043360,
  2141170197, 2141295774, 2141420092, 2141543149,
  2141664948, 2141785486, 2141904764, 2142022782,
  2142139540, 2142255038, 2142369276, 2142482253,
  2142593970, 2142704427, 2142813623, 2142921559,
  2143028234, 2143133648, 2143237801, 2143340694,
  2143442326, 2143542697, 2143641806, 2143739655,
  2143836243, 2143931570, 2144025635, 2144118439,
  2144209982, 2144300263, 2144389283, 2144477041,
  2144563538, 2144648774, 2144732747, 2144815459,
  2144896909, 2144977098, 2145056024, 2145133689,
  2145210092, 2145285233, 2145359112, 2145431728,
  2145503083, 2145573175, 2145642006, 2145709574,
  2145775880, 2145840923, 2145904704, 2145967223,
  2146028479, 2146088473, 2146147205, 2146204674,
  2146260880, 2146315824, 2146369505, 2146421923,
  2146473079, 2146522972, 2146571603, 2146618970,
  2146665075, 2146709917, 2146753496, 2146795812,
  2146836866, 2146876656, 2146915183, 2146952448,
  2146988449, 2147023188, 2147056663, 2147088875,
  2147119825, 2147149511, 2147177934, 2147205094,
  2147230991, 2147255624, 2147278995, 2147301102,
  2147321946, 2147341527, 2147359844, 2147376899,
  2147392690, 2147407218, 2147420482, 2147432484,
  2147443222, 2147452696, 2147460908, 2147467856,
  2147473541, 2147477963, 2147481121, 2147483016,
  2147483647,
};

const int32_t dsp_sine_16384[4097] = {
           0,     823549,    1647099,    2470648,
     3294197,    4117745,    4941293,    5764840,
     6588386,    7411932,    8235476,    9059019,
     9882561,   10706101,   11529639,   12353176,
    13176711,   14000245,   14823776,   15647305,
    16470831,   17294356,   18117877,   18941396,
    19764912,   20588426,   21411936,   22235443,
    23058947,   23882447,   24705944,   25529438,
    26352927,   27176413,   27999895,   28823372,
    29646846,   30470315,   31293779,   32117239,
    32940694,   33764144,   34587590,   35411030,
    36234465,   37057895,   37881319,   38704738,
    39528151,   40351558,   41174959,   41998355,
    42821744,   43645126,   44468503,   45291873,
    46115236,   46938592,   47761942,   48585284,
    49408619,   50231947,   51055268,   51878581,
    52701886,   53525184,   54348474,   55171756,
    55995030,   56818295,   57641552,   58464801,
    59288041,   60111272,   60934495,   61757709,
    62580913,   63404108,   64227294,   65050471,
    65873638,   66696795,   67519942,   68343080,
    69166207,   69989325,   70812432,   71635528,
    72458614,   73281690,   74104754,   74927808,
    75750851,   76573882,   77396903,   78219911,
    79042909,   79865895,   80688869,   81511831,
    82334781,   83157719,   83980645,   84803558,
    85626459,   86449348,   87272224,   88095087,
    88917936,   89740773,   90563597,   91386407,
    92209204,   93031987,   93854757,   94677513,
    95500255,   96322983,   97145696,   97968396,
    98791081,   99613751,  100436407,  101259048,
   102081674,  102904286,  103726882,  104549462,
   105372028,  106194578,  107017112,  107839630,
   108662133,  109484620,  110307090,  111129545,
   111951983,  112774404,  113596809,  114419198,
   115241569,  116063924,  116886261,  117708581,
   118530884,  119353170,  120175438,  120997688,
   121819920,  122642135,  123464331,  124286510,
   125108670,  125930812,  126752935,  127575039,
   128397125,  129219192,  130041240,  130863268,
   131685278,  132507268,  133329239,  134151190,
   134973121,  135795033,  136616924,  137438795,
   138260647,  139082477,  139904288,  140726078,
   141547847,  142369595,  143191322,  144013029,
   144834714,  145656378,  146478020,  147299641,
   148121240,  148942818,  149764373,  150585907,
   151407418,  152228907,  153050374,  153871818,
   154693239,  155514638,  156336014,  157157367,
   157978697,  158800003,  159621287,  160442546,
   161263783,  162084995,  162906184,  163727348,
   164548489,  165369605,  166190697,  167011765,
   167832808,  168653826,  169474820,  170295788,
   171116732,  171937650,  172758544,  173579411,
   174400254,  175221070,  176041861,  176862626,
   177683365,  178504077,  179324764,  180145424,
   180966058,  181786665,  182607245,  183427798,
   184248325,  185068824,  185889296,  186709741,
   187530158,  188350548,  189170910,  189991244,
   190811551,  191631829,  192452079,  193272301,
   194092494,  194912659,  195732795,  196552902,
   197372981,  198193030,  199013050,  199833041,
   200653003,  201472935,  202292837,  203112710,
   203932553,  204752366,  205572148,  206391901,
   207211623,  208031315,  208850976,  209670606,
   210490206,  211309774,  212129312,  212948818,
   213768293,  214587736,  215407148,  216226529,
   217045877,  217865194,  218684478,  219503730,
   220322951,  221142138,  221961293,  222780416,
   223599506,  224418562,  225237586,  226056577,
   226875535,  227694459,  228513349,  229332206,
   230151030,  230969819,  231788575,  232607296,
   233425983,  234244636,  235063254,  235881838,
   236700387,  237518902,  238337381,  239155825,
   239974235,  240792608,  241610947,  242429250,
   243247517,  244065749,  244883944,  245702104,
   246520227,  247338314,  248156365,  248974380,
   249792357,  250610298,  251428202,  252246070,
   253063900,  253881692,  254699448,  255517166,
   256334846,  257152489,  257970094,  258787661,
   259605190,  260422681,  261240133,  262057547,
   262874923,  263692260,  264509558,  265326817,
   266144037,  266961218,  267778360,  268595462,
   269412525,  270229548,  271046532,  271863475,
   272680379,  273497242,  274314066,  275130849,
   275947591,  276764293,  277580954,  278397575,
   279214154,  280030693,  280847190,  281663646,
   282480060,  283296433,  284112764,  284929054,
   285745301,  286561507,  287377670,  288193792,
   289009870,  289825907,  290641900,  291457851,
   292273759,  293089624,  293905446,  294721225,
   295536960,  296352652,  297168300,  297983905,
   298799466,  299614983,  300430456,  301245884,
   302061268,  302876608,  303691904,  304507154,
   305322360,  306137521,  306952637,  307767708,
   308582733,  309397714,  310212648,  311027537,
   311842381,  312657178,  313471930,  314286635,
   315101294,  315915907,  316730473,  317544993,
   318359466,  319173892,  319988271,  320802604,
   321616889,  322431127,  323245317,  324059460,
   324873555,  325687602,  326501602,  327315553,
   328129456,  328943311,  329757118,  330570876,
   331384586,  332198247,  333011858,  333825421,
   334638935,  335452400,  336265815,  337079181,
   337892498,  338705764,  339518981,  340332148,
   341145265,  341958331,  342771348,  343584314,
   344397229,  345210094,  346022908,  346835671,
   347648383,  348461044,  349273654,  350086212,
   350898719,  351711174,  352523578,  353335929,
   354148229,  354960477,  355772672,  356584815,
   357396906,  358208944,  359020929,  359832862,
   360644742,  361456568,  362268342,  363080062,
   363891729,  364703342,  365514902,  366326408,
   367137860,  367949258,  368760602,  369571892,
   370383127,  371194308,  372005434,  372816506,
   373627523,  374438484,  375249391,  376060243,
   376871039,  377681780,  378492465,  379303095,
   380113668,  380924186,  381734648,  382545054,
   383355404,  384165697,  384975933,  385786113,
   386596237,  387406303,  388216312,  389026265,
   389836160,  390645998,  391455778,  392265501,
   393075166,  393884773,  394694322,  395503814,
   396313247,  397122622,  397931938,  398741196,
   399550395,  400359536,  401168617,  401977640,
   402786604,  403595508,  404404353,  405213138,
   406021864,  406830530,  407639137,  408447683,
   409256169,  410064595,  410872961,  411681266,
   412489511,  413297695,  414105819,  414913881,
   415721883,  416529823,  417337702,  418145520,
   418953276,  419760970,  420568603,  421376174,
   422183683,  422991130,  423798515,  424605837,
   425413097,  426220295,  427027429,  427834501,
   428641510,  429448456,  430255339,  431062158,
   431868914,  432675607,  433482236,  434288801,
   435095302,  435901740,  436708113,  437514422,
   438320667,  439126847,  439932962,  440739013,
   441544999,  442350921,  443156777,  443962568,
   444768293,  445573953,  446379548,  447185077,
   447990540,  448795938,  449601269,  450406534,
   451211733,  452016866,  452821932,  453626932,
   454431865,  455236731,  456041530,  456846262,
   457650927,  458455524,  459260054,  460064517,
   460868912,  461673239,  462477498,  463281689,
   464085812,  464889867,  465693854,  466497772,
   467301621,  468105402,  468909113,  469712756,
   470516330,  471319835,  472123270,  472926636,
   473729932,  474533158,  475336315,  476139402,
   476942419,  477745366,  478548242,  479351048,
   480153784,  480956449,  481759043,  482561566,
   483364019,  484166400,  484968710,  485770949,
   486573116,  487375212,  488177236,  488979188,
   489781069,  490582877,  491384613,  492186277,
   492987869,  493789388,  494590834,  495392208,
   496193509,  496994737,  497795891,  498596973,
   499397981,  500198916,  500999777,  501800565,
   502601278,  503401918,  504202484,  505002976,
   505803393,  506603736,  507404005,  508204198,
   509004318,  509804362,  510604331,  511404225,
   512204044,  513003788,  513803456,  514603049,
   515402566,  516202007,  517001372,  517800661,
   518599874,  519399011,  520198071,  520997055,
   521795963,  522594793,  523393547,  524192223,
   524990823,  525789345,  526587791,  527386158,
   528184448,  528982661,  529780795,  530578852,
   531376830,  532174731,  532972553,  533770297,
   534567962,  535365549,  536163057,  536960486,
   537757836,  538555107,  539352299,  540149412,
   540946445,  541743398,  542540272,  543337066,
   544133781,  544930415,  545726969,  546523443,
   547319836,  548116149,  548912381,  549708533,
   550504603,  551300593,  552096502,  552892329,
   553688075,  554483740,  555279323,  556074825,
   556870244,  557665582,  558460838,  559256012,
   560051103,  560846112,  561641039,  562435883,
   563230644,  564025323,  564819918,  565614430,
   566408860,  567203206,  567997468,  568791647,
   569585742,  570379754,  571173682,  571967525,
   572761285,  573554960,  574348551,  575142058,
   575935480,  576728817,  577522069,  578315237,
   579108319,  579901316,  580694228,  581487055,
   582279796,  583072451,  583865021,  584657505,
   585449902,  586242214,  587034440,  587826579,
   588618631,  589410598,  590202477,  590994270,
   591785975,  592577594,  593369126,  594160570,
   594951927,  595743196,  596534378,  597325472,
   598116478,  598907396,  599698226,  600488968,
   601279622,  602070187,  602860664,  603651052,
   604441351,  605231561,  606021683,  606811715,
   607601658,  608391512,  609181276,  609970950,
   610760535,  611550030,  612339435,  613128750,
   613917975,  614707109,  615496154,  616285107,
   617073970,  617862742,  618651424,  619440014,
   620228513,  621016921,  621805238,  622593463,
   623381597,  624169639,  624957589,  625745448,
   626533214,  627320888,  628108470,  628895960,
   629683357,  630470661,  631257873,  632044992,
   632832018,  633618950,  634405790,  635192536,
   635979189,  636765749,  637552214,  638338586,
   639124865,  639911049,  640697139,  641483134,
   642269036,  643054843,  643840555,  644626173,
   645411696,  646197124,  646982457,  647767695,
   648552837,  649337884,  650122836,  650907692,
   651692452,  652477117,  653261685,  654046158,
   654830534,  655614814,  656398998,  657183085,
   657967075,  658750969,  659534765,  660318465,
   661102068,  661885573,  662668981,  663452291,
   664235504,  665018620,  665801637,  666584557,
   667367378,  668150102,  668932727,  669715254,
   670497682,  671280012,  672062242,  672844375,
   673626408,  674408342,  675190177,  675971912,
   676753548,  677535085,  678316522,  679097859,
   679879097,  680660234,  681441271,  682222208,
   683003045,  683783781,  684564417,  685344952,
   686125386,  686905719,  687685952,  688466083,
   689246113,  690026041,  690805868,  691585594,
   692365218,  693144740,  693924160,  694703478,
   695482693,  696261807,  697040818,  697819726,
   698598532,  699377236,  700155836,  700934333,
   701712728,  702491019,  703269207,  704047291,
   704825272,  705603149,  706380922,  707158592,
   707936157,  708713619,  709490976,  710268229,
   711045377,  711822421,  712599360,  713376194,
   714152923,  714929548,  715706067,  716482481,
   717258789,  718034992,  718811090,  719587082,
   720362968,  721138748,  721914422,  722689989,
   723465451,  724240806,  725016054,  725791196,
   726566232,  727341160,  728115981,  728890696,
   729665303,  730439802,  731214195,  731988480,
   732762657,  733536726,  734310688,  735084541,
   735858287,  736631924,  737405453,  738178873,
   738952185,  739725388,  740498483,  741271468,
   742044345,  742817112,  743589770,  744362319,
   745134758,  745907088,  746679308,  747451418,
   748223418,  748995308,  749767088,  750538758,
   751310317,  752081766,  752853105,  753624332,
   754395449,  755166455,  755937349,  756708133,
   757478805,  758249366,  759019815,  759790153,
   760560379,  761330493,  762100495,  762870385,
   763640163,  764409829,  765179382,  765948823,
   766718151,  767487366,  768256468,  769025457,
   769794334,  770563097,  771331746,  772100283,
   772868705,  773637014,  774405210,  775173291,
   775941259,  776709112,  777476851,  778244476,
   779011986,  779779381,  780546662,  781313829,
   782080880,  782847816,  783614637,  784381343,
   785147934,  785914409,  786680768,  787447012,
   788213140,  788979152,  789745048,  790510828,
   791276492,  792042039,  792807470,  793572784,
   794337981,  795103062,  795868026,  796632872,
   797397602,  798162214,  798926709,  799691086,
   800455346,  801219488,  801983512,  802747418,
   803511206,  804274876,  805038428,  805801861,
   806565176,  807328372,  808091450,  808854408,
   809617248,  810379969,  811142570,  811905052,
   812667415,  813429658,  814191782,  814953785,
   815715669,  816477433,  817239077,  818000601,
   818762004,  819523287,  820284450,  821045492,
   821806413,  822567213,  823327892,  824088450,
   824848887,  825609203,  826369397,  827129470,
   827889421,  828649250,  829408958,  830168543,
   830928007,  831687348,  832446567,  833205663,
   833964637,  834723488,  835482217,  836240822,
   836999305,  837757664,  838515901,  839274014,
   840032003,  840789869,  841547612,  842305230,
   843062725,  843820096,  844577342,  845334465,
   846091463,  846848337,  847605086,  848361710,
   849118210,  849874585,  850630835,  851386959,
   852142959,  852898833,  853654582,  854410205,
   855165703,  855921074,  856676320,  857431440,
   858186434,  858941302,  859696043,  860450658,
   861205146,  861959508,  862713743,  863467851,
   864221832,  864975686,  865729412,  866483012,
   867236484,  867989828,  868743045,  869496134,
   870249095,  871001928,  871754633,  872507210,
   873259658,  874011978,  874764170,  875516233,
   876268167,  877019972,  877771648,  878523196,
   879274614,  880025902,  880777061,  881528091,
   882278991,  883029762,  883780402,  884530912,
   885281293,  886031543,  886781663,  887531652,
   888281511,  889031239,  889780837,  890530304,
   891279639,  892028844,  892777917,  893526860,
   894275670,  895024350,  895772897,  896521313,
   897269597,  898017749,  898765769,  899513657,
   900261412,  901009035,  901756526,  902503884,
   903251109,  903998201,  904745161,  905491987,
   906238680,  906985240,  907731667,  908477960,
   909224119,  909970145,  910716037,  911461795,
   912207419,  912952909,  913698264,  914443485,
   915188572,  915933524,  916678341,  917423024,
   918167571,  918911984,  919656261,  920400403,
   921144410,  921888281,  922632017,  923375617,
   924119081,  924862410,  925605602,  926348658,
   927091578,  927834362,  928577009,  929319520,
   930061894,  930804131,  931546231,  932288194,
   933030020,  933771709,  934513261,  935254675,
   935995951,  936737090,  937478092,  938218955,
   938959680,  939700267,  940440716,  941181027,
   941921199,  942661233,  943401128,  944140885,
   944880502,  945619981,  946359320,  947098521,
   947837582,  948576503,  949315286,  950053928,
   950792431,  951530794,  952269017,  953007100,
   953745043,  954482845,  955220507,  955958029,
   956695410,  957432651,  958169750,  958906709,
   959643527,  960380203,  961116738,  961853132,
   962589385,  963325496,  964061465,  964797292,
   965532978,  966268521,  967003923,  967739182,
   968474299,  969209273,  969944105,  970678795,
   971413341,  972147745,  972882006,  973616123,
   974350098,  975083929,  975817616,  976551161,
   977284561,  978017818,  978750931,  979483900,
   980216725,  980949406,  981681943,  982414335,
   983146583,  983878686,  984610644,  985342458,
   986074127,  986805651,  987537029,  988268263,
   988999351,  989730293,  990461090,  991191741,
   991922247,  992652607,  993382820,  994112888,
   994842809,  995572585,  996302213,  997031695,
   997761031,  998490220,  999219262,  999948157,
  1000676904, 1001405505, 1002133959, 1002862265,
  1003590423, 1004318434, 1005046298, 1005774013,
  1006501581, 1007229000, 1007956272, 1008683395,
  1009410370, 1010137196, 1010863874, 1011590403,
  1012316784, 1013043015, 1013769098, 1014495031,
  1015220815, 1015946450, 1016671936, 1017397272,
  1018122458, 1018847495, 1019572381, 1020297118,
  1021021705, 1021746142, 1022470428, 1023194564,
  1023918549, 1024642384, 1025366069, 1026089602,
  1026812984, 1027536216, 1028259296, 1028982226,
  1029705003, 1030427630, 1031150105, 1031872428,
  1032594599, 1033316619, 1034038486, 1034760202,
  1035481765, 1036203176, 1036924435, 1037645541,
  1038366495, 1039087296, 1039807944, 1040528439,
  1041248781, 1041968970, 1042689006, 1043408888,
  1044128617, 1044848192, 1045567614, 1046286882,
  1047005996, 1047724956, 1048443762, 1049162414,
  1049880911, 1050599254, 1051317443, 1052035477,
  1052753356, 1053471081, 1054188650, 1054906064,
  1055623324, 1056340428, 1057057377, 1057774170,
  1058490807, 1059207289, 1059923616, 1060639786,
  1061355800, 1062071659, 1062787361, 1063502906,
  1064218296, 1064933529, 1065648605, 1066363524,
  1067078287, 1067792893, 1068507341, 1069221633,
  1069935767, 1070649744, 1071363564, 1072077226,
  1072790730, 1073504076, 1074217265, 1074930296,
  1075643168, 1076355882, 1077068439, 1077780836,
  1078493075, 1079205156, 1079917078, 1080628841,
  1081340445, 1082051890, 1082763176, 1083474302,
  1084185270, 1084896077, 1085606726, 1086317214,
  1087027543, 1087737712, 1088447721, 1089157570,
  1089867259, 1090576787, 1091286156, 1091995363,
  1092704410, 1093413297, 1094122022, 1094830587,
  1095538990, 1096247233, 1096955314, 1097663234,
  1098370992, 1099078589, 1099786024, 1100493298,
  1101200410, 1101907360, 1102614147, 1103320773,
  1104027236, 1104733537, 1105439675, 1106145651,
  1106851464, 1107557115, 1108262602, 1108967927,
  1109673088, 1110378086, 1111082921, 1111787593,
  1112492101, 1113196445, 1113900626, 1114604643,
  1115308496, 1116012185, 1116715710, 1117419070,
  1118122266, 1118825298, 1119528165, 1120230868,
  1120933406, 1121635779, 1122337987, 1123040030,
  1123741907, 1124443620, 1125145167, 1125846549,
  1126547765, 1127248815, 1127949700, 1128650419,
  1129350972, 1130051358, 1130751579, 1131451633,
  1132151521, 1132851242, 1133550797, 1134250185,
  1134949406, 1135648460, 1136347347, 1137046067,
  1137744620, 1138443006, 1139141224, 1139839274,
  1140537157, 1141234873, 1141932420, 1142629799,
  1143327011, 1144024054, 1144720929, 1145417636,
  1146114174, 1146810543, 1147506744, 1148202777,
  1148898640, 1149594334, 1150289860, 1150985216,
  1151680403, 1152375420, 1153070268, 1153764946,
  1154459455, 1155153794, 1155847963, 1156541962,
  1157235791, 1157929450, 1158622939, 1159316257,
  1160009404, 1160702381, 1161395188, 1162087823,
  1162780288, 1163472581, 1164164704, 1164856655,
  1165548435, 1166240043, 1166931480, 1167622746,
  1168313840, 1169004761, 1169695511, 1170386089,
  1171076495, 1171766728, 1172456790, 1173146678,
  1173836395, 1174525938, 1175215309, 1175904507,
  1176593532, 1177282384, 1177971063, 1178659569,
  1179347901, 1180036060, 1180724046, 1181411857,
  1182099495, 1182786959, 1183474250, 1184161366,
  1184848308, 1185535075, 1186221669, 1186908087,
  1187594332, 1188280401, 1188966296, 1189652016,
  1190337561, 1191022931, 1191708126, 1192393146,
  1193077990, 1193762659, 1194447152, 1195131470,
  1195815611, 1196499577, 1197183367, 1197866981,
  1198550419, 1199233680, 1199916765, 1200599674,
  1201282406, 1201964961, 1202647340, 1203329542,
  1204011566, 1204693414, 1205375085, 1206056578,
  1206737894, 1207419032, 1208099993, 1208780776,
  1209461381, 1210141809, 1210822058, 1211502130,
  1212182023, 1212861738, 1213541275, 1214220633,
  1214899812, 1215578813, 1216257635, 1216936279,
  1217614743, 1218293028, 1218971134, 1219649061,
  1220326808, 1221004376, 1221681764, 1222358973,
  1223036002, 1223712851, 1224389520, 1225066009,
  1225742318, 1226418446, 1227094395, 1227770162,
  1228445749, 1229121156, 1229796382, 1230471427,
  1231146290, 1231820973, 1232495475, 1233169795,
  1233843934, 1234517892, 1235191668, 1235865262,
  1236538675, 1237211906, 1237884954, 1238557821,
  1239230506, 1239903008, 1240575328, 1241247466,
  1241919421, 1242591193, 1243262783, 1243934189,
  1244605413, 1245276454, 1245947312, 1246617986,
  1247288477, 1247958785, 1248628909, 1249298849,
  1249968606, 1250638179, 1251307568, 1251976773,
  1252645793, 1253314630, 1253983282, 1254651750,
  1255320033, 1255988132, 1256656046, 1257323775,
  1257991319, 1258658679, 1259325853, 1259992842,
  1260659645, 1261326263, 1261992696, 1262658943,
  1263325005, 1263990880, 1264656570, 1265322074,
  1265987391, 1266652523, 1267317468, 1267982227,
  1268646799, 1269311185, 1269975384, 1270639396,
  1271303222, 1271966860, 1272630311, 1273293576,
  1273956653, 1274619542, 1275282244, 1275944759,
  1276607086, 1277269225, 1277931176, 1278592940,
  1279254515, 1279915902, 1280577101, 1281238112,
  1281898934, 1282559568, 1283220013, 1283880269,
  1284540337, 1285200215, 1285859905, 1286519405,
  1287178717, 1287837839, 1288496771, 1289155514,
  1289814068, 1290472431, 1291130605, 1291788590,
  1292446384, 1293103988, 1293761402, 1294418625,
  1295075658, 1295732501, 1296389153, 1297045615,
  1297701886, 1298357966, 1299013855, 1299669553,
  1300325060, 1300980375, 1301635499, 1302290432,
  1302945174, 1303599723, 1304254081, 1304908247,
  1305562221, 1306216004, 1306869594, 1307522992,
  1308176197, 1308829211, 1309482031, 1310134659,
  1310787095, 1311439338, 1312091387, 1312743244,
  1313394908, 1314046379, 1314697656, 1315348740,
  1315999631, 1316650328, 1317300831, 1317951141,
  1318601257, 1319251179, 1319900907, 1320550440,
  1321199780, 1321848925, 1322497876, 1323146632,
  1323795194, 1324443561, 1325091734, 1325739711,
  1326387493, 1327035081, 1327682473, 1328329670,
  1328976672, 1329623478, 1330270088, 1330916503,
  1331562723, 1332208746, 1332854573, 1333500205,
  1334145640, 1334790879, 1335435922, 1336080769,
  1336725418, 1337369872, 1338014128, 1338658188,
  1339302051, 1339945717, 1340589186, 1341232458,
  1341875533, 1342518410, 1343161089, 1343803572,
  1344445856, 1345087943, 1345729832, 1346371523,
  1347013016, 1347654311, 1348295408, 1348936307,
  1349577007, 1350217509, 1350857812, 1351497916,
  1352137822, 1352777528, 1353417036, 1354056345,
  1354695455, 1355334365, 1355973076, 1356611588,
  1357249900, 1357888013, 1358525926, 1359163639,
  1359801152, 1360438465, 1361075578, 1361712491,
  1362349204, 1362985716, 1363622028, 1364258139,
  1364894050, 1365529760, 1366165269, 1366800577,
  1367435684, 1368070590, 1368705295, 1369339799,
  1369974101, 1370608202, 1371242101, 1371875798,
  1372509294, 1373142588, 1373775680, 1374408569,
  1375041257, 1375673743, 1376306026, 1376938107,
  1377569985, 1378201661, 1378833134, 1379464404,
  1380095471, 1380726336, 1381356997, 1381987455,
  1382617710, 1383247761, 1383877610, 1384507254,
  1385136695, 1385765932, 1386394966, 1387023795,
  1387652421, 1388280843, 1388909060, 1389537073,
  1390164882, 1390792486, 1391419886, 1392047081,
  1392674071, 1393300857, 1393927437, 1394553813,
  1395179983, 1395805949, 1396431709, 1397057264,
  1397682613, 1398307757, 1398932695, 1399557427,
  1400181953, 1400806274, 1401430388, 1402054297,
  1402677999, 1403301495, 1403924785, 1404547868,
  1405170744, 1405793414, 1406415877, 1407038133,
  1407660183, 1408282025, 1408903660, 1409525088,
  1410146309, 1410767322, 1411388128, 1412008726,
  1412629117, 1413249300, 1413869275, 1414489042,
  1415108601, 1415727952, 1416347094, 1416966029,
  1417584755, 1418203272, 1418821581, 1419439682,
  1420057573, 1420675256, 1421292730, 1421909994,
  1422527050, 1423143896, 1423760534, 1424376961,
  1424993179, 1425609188, 1426224987, 1426840576,
  1427455956, 1428071125, 1428686085, 1429300834,
  1429915373, 1430529702, 1431143820, 1431757728,
  1432371426, 1432984913, 1433598189, 1434211254,
  1434824108, 1435436751, 1436049183, 1436661404,
  1437273414, 1437885212, 1438496799, 1439108174,
  1439719338, 1440330289, 1440941029, 1441551558,
  1442161874, 1442771978, 1443381869, 1443991549,
  1444601016, 1445210271, 1445819313, 1446428143,
  1447036759, 1447645163, 1448253354, 1448861332,
  1449469097, 1450076649, 1450683988, 1451291113,
  1451898025, 1452504723, 1453111208, 1453717479,
  1454323536, 1454929379, 1455535008, 1456140424,
  1456745625, 1457350612, 1457955384, 1458559942,
  1459164286, 1459768415, 1460372329, 1460976028,
  1461579513, 1462182783, 1462785837, 1463388677,
  1463991301, 1464593710, 1465195904, 1465797882,
  1466399644, 1467001191, 1467602522, 1468203638,
  1468804537, 1469405220, 1470005688, 1470605939,
  1471205974, 1471805792, 1472405394, 1473004779,
  1473603948, 1474202900, 1474801635, 1475400154,
  1475998455, 1476596539, 1477194406, 1477792056,
  1478389489, 1478986704, 1479583702, 1480180482,
  1480777044, 1481373388, 1481969515, 1482565424,
  1483161115, 1483756587, 1484351841, 1484946878,
  1485541695, 1486136294, 1486730675, 1487324837,
  1487918780, 1488512505, 1489106010, 1489699297,
  1490292364, 1490885212, 1491477841, 1492070251,
  1492662441, 1493254412, 1493846163, 1494437694,
  1495029005, 1495620097, 1496210969, 1496801621,
  1497392052, 1497982263, 1498572254, 1499162025,
  1499751575, 1500340905, 1500930014, 1501518902,
  1502107569, 1502696016, 1503284241, 1503872246,
  1504460029, 1505047591, 1505634931, 1506222050,
  1506808948, 1507395624, 1507982078, 1508568311,
  1509154322, 1509740110, 1510325677, 1510911022,
  1511496144, 1512081044, 1512665722, 1513250177,
  1513834410, 1514418420, 1515002207, 1515585772,
  1516169114, 1516752232, 1517335128, 1517917800,
  1518500249, 1519082475, 1519664478, 1520246257,
  1520827812, 1521409144, 1521990252, 1522571136,
  1523151796, 1523732232, 1524312445, 1524892432,
  1525472196, 1526051735, 1526631050, 1527210141,
  1527789006, 1528367648, 1528946064, 1529524255,
  1530102222, 1530679963, 1531257480, 1531834771,
  1532411837, 1532988677, 1533565292, 1534141682,
  1534717846, 1535293784, 1535869496, 1536444983,
  1537020243, 1537595278, 1538170086, 1538744668,
  1539319024, 1539893153, 1540467056, 1541040733,
  1541614183, 1542187406, 1542760402, 1543333171,
  1543905714, 1544478029, 1545050117, 1545621978,
  1546193612, 1546765018, 1547336197, 1547907148,
  1548477872, 1549048367, 1549618635, 1550188676,
  1550758488, 1551328072, 1551897428, 1552466555,
  1553035455, 1553604126, 1554172568, 1554740782,
  1555308767, 1555876524, 1556444051, 1557011350,
  1557578420, 1558145261, 1558711872, 1559278255,
  1559844408, 1560410331, 1560976025, 1561541490,
  1562106725, 1562671730, 1563236505, 1563801051,
  1564365366, 1564929451, 1565493307, 1566056932,
  1566620326, 1567183491, 1567746424, 1568309128,
  1568871600, 1569433842, 1569995853, 1570557633,
  1571119182, 1571680500, 1572241587, 1572802443,
  1573363068, 1573923461, 1574483622, 1575043552,
  1575603250, 1576162717, 1576721952, 1577280955,
  1577839726, 1578398265, 1578956571, 1579514646,
  1580072488, 1580630098, 1581187476, 1581744620,
  1582301533, 1582858212, 1583414659, 1583970873,
  1584526854, 1585082602, 1585638117, 1586193398,
  1586748446, 1587303261, 1587857843, 1588412191,
  1588966305, 1589520186, 1590073833, 1590627246,
  1591180425, 1591733370, 1592286081, 1592838558,
  1593390801, 1593942809, 1594494583, 1595046122,
  1595597427, 1596148497, 1596699332, 1597249933,
  1597800299, 1598350429, 1598900325, 1599449985,
  1599999411, 1600548600, 1601097555, 1601646274,
  1602194757, 1602743005, 1603291017, 1603838794,
  1604386334, 1604933639, 1605480707, 1606027540,
  1606574136, 1607120496, 1607666619, 1608212506,
  1608758157, 1609303571, 1609848748, 1610393689,
  1610938392, 1611482859, 1612027089, 1612571082,
  1613114837, 1613658356, 1614201636, 1614744680,
  1615287486, 1615830055, 1616372386, 1616914479,
  1617456334, 1617997952, 1618539331, 1619080473,
  1619621376, 1620162042, 1620702469, 1621242657,
  1621782607, 1622322319, 1622861792, 1623401026,
  1623940022, 1624478779, 1625017297, 1625555576,
  1626093615, 1626631416, 1627168978, 1627706300,
  1628243383, 1628780226, 1629316830, 1629853194,
  1630389318, 1630925203, 1631460848, 1631996253,
  1632531417, 1633066342, 1633601027, 1634135471,
  1634669675, 1635203639, 1635737362, 1636270844,
  1636804086, 1637337087, 1637869848, 1638402367,
  1638934646, 1639466683, 1639998480, 1640530035,
  1641061349, 1641592421, 1642123253, 1642653842,
  1643184190, 1643714297, 1644244161, 1644773784,
  1645303165, 1645832304, 1646361201, 1646889856,
  1647418269, 1647946439, 1648474367, 1649002052,
  1649529495, 1650056696, 1650583654, 1651110369,
  1651636841, 1652163070, 1652689056, 1653214799,
  1653740300, 1654265556, 1654790570, 1655315340,
  1655839867, 1656364150, 1656888190, 1657411986,
  1657935538, 1658458846, 1658981911, 1659504731,
  1660027308, 1660549640, 1661071728, 1661593572,
  1662115171, 1662636526, 1663157637, 1663678503,
  1664199124, 1664719500, 1665239632, 1665759519,
  1666279160, 1666798557, 1667317708, 1667836615,
  1668355276, 1668873691, 1669391862, 1669909786,
  1670427466, 1670944899, 1671462087, 1671979029,
  1672495725, 1673012175, 1673528379, 1674044336,
  1674560048, 1675075513, 1675590733, 1676105705,
  1676620431, 1677134911, 1677649144, 1678163130,
  1678676869, 1679190362, 1679703607, 1680216605,
  1680729357, 1681241861, 1681754118, 1682266128,
  1682777890, 1683289404, 1683800672, 1684311691,
  1684822463, 1685332987, 1685843263, 1686353291,
  1686863071, 1687372603, 1687881887, 1688390923,
  1688899711, 1689408250, 1689916540, 1690424582,
  1690932376, 1691439920, 1691947216, 1692454264,
  1692961062, 1693467611, 1693973911, 1694479962,
  1694985764, 1695491317, 1695996620, 1696501674,
  1697006478, 1697511033, 1698015338, 1698519393,
  1699023199, 1699526755, 1700030060, 1700533116,
  1701035922, 1701538477, 1702040782, 1702542837,
  1703044642, 1703546196, 1704047499, 1704548552,
  1705049354, 1705549906, 1706050206, 1706550256,
  1707050055, 1707549603, 1708048899, 1708547945,
  1709046739, 1709545281, 1710043573, 1710541612,
  1711039401, 1711536937, 1712034222, 1712531255,
  1713028037, 1713524566, 1714020843, 1714516868,
  1715012641, 1715508162, 1716003431, 1716498447,
  1716993211, 1717487722, 1717981981, 1718475987,
  1718969740, 1719463240, 1719956488, 1720449483,
  1720942224, 1721434713, 1721926948, 1722418930,
  1722910659, 1723402134, 1723893356, 1724384324,
  1724875039, 1725365500, 1725855708, 1726345661,
  1726835361, 1727324807, 1727813998, 1728302936,
  1728791619, 1729280048, 1729768223, 1730256144,
  1730743809, 1731231221, 1731718378, 1732205280,
  1732691927, 1733178320, 1733664457, 1734150340,
  1734635968, 1735121340, 1735606457, 1736091320,
  1736575926, 1737060278, 1737544374, 1738028214,
  1738511799, 1738995128, 1739478201, 1739961019,
  1740443580, 1740925886, 1741407935, 1741889729,
  1742371266, 1742852547, 1743333572, 1743814340,
  1744294852, 1744775108, 1745255106, 1745734848,
  1746214334, 1746693562, 1747172534, 1747651249,
  1748129706, 1748607907, 1749085850, 1749563537,
  1750040965, 1750518137, 1750995051, 1751471708,
  1751948106, 1752424248, 1752900131, 1753375757,
  1753851125, 1754326235, 1754801087, 1755275681,
  1755750017, 1756224094, 1756697913, 1757171474,
  1757644777, 1758117821, 1758590606, 1759063133,
  1759535401, 1760007410, 1760479161, 1760950652,
  1761421885, 1761892858, 1762363573, 1762834028,
  1763304224, 1763774160, 1764243838, 1764713255,
  1765182414, 1765651312, 1766119951, 1766588330,
  1767056450, 1767524309, 1767991909, 1768459248,
  1768926328, 1769393147, 1769859706, 1770326005,
  1770792044, 1771257822, 1771723339, 1772188596,
  1772653592, 1773118328, 1773582803, 1774047017,
  1774510970, 1774974662, 1775438093, 1775901263,
  1776364172, 1776826819, 1777289206, 1777751331,
  1778213194, 1778674796, 1779136136, 1779597215,
  1780058032, 1780518587, 1780978880, 1781438911,
  1781898681, 1782358188, 1782817433, 1783276416,
  1783735137, 1784193595, 1784651791, 1785109725,
  1785567396, 1786024804, 1786481950, 1786938833,
  1787395453, 1787851810, 1788307905, 1788763736,
  1789219304, 1789674609, 1790129651, 1790584430,
  1791038945, 1791493197, 1791947186, 1792400911,
  1792854372, 1793307569, 1793760503, 1794213173,
  1794665580, 1795117722, 1795569600, 1796021214,
  1796472564, 1796923650, 1797374472, 1797825029,
  1798275322, 1798725350, 1799175114, 1799624613,
  1800073848, 1800522818, 1800971523, 1801419963,
  1801868138, 1802316048, 1802763694, 1803211074,
  1803658189, 1804105038, 1804551622, 1804997941,
  1805443995, 1805889783, 1806335305, 1806780561,
  1807225552, 1807670278, 1808114737, 1808558930,
  1809002858, 1809446519, 1809889914, 1810333043,
  1810775906, 1811218502, 1811660833, 1812102896,
  1812544693, 1812986224, 1813427488, 1813868485,
  1814309216, 1814749679, 1815189876, 1815629806,
  1816069469, 1816508865, 1816947993, 1817386855,
  1817825449, 1818263775, 1818701835, 1819139627,
  1819577151, 1820014408, 1820451397, 1820888118,
  1821324571, 1821760757, 1822196675, 1822632325,
  1823067706, 1823502820, 1823937665, 1824372242,
  1824806551, 1825240592, 1825674364, 1826107867,
  1826541102, 1826974069, 1827406766, 1827839195,
  1828271355, 1828703247, 1829134869, 1829566222,
  1829997306, 1830428121, 1830858667, 1831288944,
  1831718951, 1832148689, 1832578157, 1833007356,
  1833436285, 1833864945, 1834293335, 1834721455,
  1835149306, 1835576886, 1836004197, 1836431237,
  1836858008, 1837284508, 1837710738, 1838136698,
  1838562387, 1838987807, 1839412955, 1839837833,
  1840262441, 1840686778, 1841110844, 1841534639,
  1841958164, 1842381418, 1842804400, 1843227112,
  1843649553, 1844071722, 1844493620, 1844915247,
  1845336603, 1845757687, 1846178500, 1846599042,
  1847019311, 1847439309, 1847859036, 1848278490,
  1848697673, 1849116584, 1849535223, 1849953590,
  1850371685, 1850789508, 1851207059, 1851624337,
  1852041343, 1852458077, 1852874538, 1853290726,
  1853706643, 1854122286, 1854537657, 1854952755,
  1855367580, 1855782133, 1856196412, 1856610419,
  1857024152, 1857437613, 1857850800, 1858263714,
  1858676354, 1859088722, 1859500816, 1859912636,
  1860324183, 1860735456, 1861146456, 1861557182,
  1861967634, 1862377812, 1862787716, 1863197347,
  1863606703, 1864015786, 1864424594, 1864833128,
  1865241388, 1865649373, 1866057084, 1866464521,
  1866871683, 1867278570, 1867685183, 1868091522,
  1868497585, 1868903374, 1869308888, 1869714127,
  1870119091, 1870523780, 1870928194, 1871332332,
  1871736196, 1872139784, 1872543097, 1872946134,
  1873348896, 1873751383, 1874153594, 1874555529,
  1874957189, 1875358573, 1875759681, 1876160513,
  1876561069, 1876961350, 1877361354, 1877761082,
  1878160534, 1878559710, 1878958609, 1879357232,
  1879755579, 1880153650, 1880551443, 1880948961,
  1881346201, 1881743165, 1882139852, 1882536263,
  1882932396, 1883328253, 1883723832, 1884119135,
  1884514161, 1884908909, 1885303380, 1885697574,
  1886091490, 1886485130, 1886878491, 1887271575,
  1887664382, 1888056911, 1888449162, 1888841136,
  1889232832, 1889624250, 1890015390, 1890406252,
  1890796836, 1891187142, 1891577170, 1891966920,
  1892356391, 1892745584, 1893134499, 1893523136,
  1893911493, 1894299573, 1894687374, 1895074896,
  1895462139, 1895849104, 1896235790, 1896622196,
  1897008324, 1897394174, 1897779743, 1898165034,
  1898550046, 1898934779, 1899319232, 1899703406,
  1900087300, 1900470915, 1900854251, 1901237307,
  1901620083, 1902002580, 1902384797, 1902766734,
  1903148391, 1903529769, 1903910866, 1904291684,
  1904672221, 1905052479, 1905432456, 1905812153,
  1906191570, 1906570706, 1906949562, 1907328137,
  1907706432, 1908084447, 1908462180, 1908839634,
  1909216806, 1909593698, 1909970308, 1910346638,
  1910722687, 1911098455, 1911473942, 1911849147,
  1912224072, 1912598715, 1912973077, 1913347158,
  1913720957, 1914094475, 1914467712, 1914840666,
  1915213340, 1915585731, 1915957841, 1916329669,
  1916701215, 1917072479, 1917443462, 1917814162,
  1918184580, 1918554716, 1918924571, 1919294142,
  1919663432, 1920032439, 1920401164, 1920769606,
  1921137766, 1921505644, 1921873239, 1922240551,
  1922607580, 1922974327, 1923340791, 1923706972,
  1924072870, 1924438485, 1924803817, 1925168866,
  1925533632, 1925898115, 1926262314, 1926626231,
  1926989863, 1927353213, 1927716279, 1928079061,
  1928441560, 1928803776, 1929165707, 1929527355,
  1929888719, 1930249800, 1930610596, 1930971109,
  1931331337, 1931691282, 1932050942, 1932410318,
  1932769411, 1933128218, 1933486742, 1933844981,
  1934202936, 1934560606, 1934917992, 1935275093,
  1935631910, 1935988442, 1936344689, 1936700651,
  1937056329, 1937411722, 1937766829, 1938121652,
  1938476190, 1938830443, 1939184410, 1939538092,
  1939891490, 1940244601, 1940597428, 1940949969,
  1941302224, 1941654195, 1942005879, 1942357278,
  1942708391, 1943059219, 1943409761, 1943760017,
  1944109987, 1944459671, 1944809069, 1945158181,
  1945507007, 1945855547, 1946203801, 1946551769,
  1946899450, 1947246845, 1947593954, 1947940776,
  1948287312, 1948633561, 1948979524, 1949325200,
  1949670589, 1950015691, 1950360507, 1950705036,
  1951049278, 1951393233, 1951736901, 1952080282,
  1952423376, 1952766183, 1953108703, 1953450935,
  1953792880, 1954134538, 1954475909, 1954816992,
  1955157787, 1955498295, 1955838515, 1956178448,
  1956518093, 1956857450, 1957196520, 1957535301,
  1957873795, 1958212001, 1958549919, 1958887548,
  1959224890, 1959561943, 1959898709, 1960235186,
  1960571375, 1960907275, 1961242887, 1961578211,
  1961913246, 1962247993, 1962582451, 1962916620,
  1963250501, 1963584093, 1963917396, 1964250410,
  1964583136, 1964915572, 1965247720, 1965579578,
  1965911148, 1966242428, 1966573419, 1966904121,
  1967234534, 1967564657, 1967894491, 1968224036,
  1968553291, 1968882257, 1969210933, 1969539319,
  1969867416, 1970195223, 1970522740, 1970849968,
  1971176906, 1971503553, 1971829911, 1972155979,
  1972481757, 1972807245, 1973132442, 1973457349,
  1973781967, 1974106293, 1974430330, 1974754076,
  1975077532, 1975400697, 1975723572, 1976046156,
  1976368450, 1976690453, 1977012165, 1977333586,
  1977654717, 1977975557, 1978296105, 1978616363,
  1978936330, 1979256006, 1979575391, 1979894485,
  1980213287, 1980531799, 1980850019, 1981167947,
  1981485585, 1981802930, 1982119985, 1982436748,
  1982753219, 1983069399, 1983385287, 1983700884,
  1984016188, 1984331201, 1984645922, 1984960351,
  1985274489, 1985588334, 1985901887, 1986215149,
  1986528118, 1986840795, 1987153179, 1987465272,
  1987777072, 1988088580, 1988399795, 1988710718,
  1989021349, 1989331687, 1989641733, 1989951485,
  1990260946, 1990570113, 1990878988, 1991187570,
  1991495859, 1991803855, 1992111559, 1992418969,
  1992726086, 1993032910, 1993339442, 1993645680,
  1993951624, 1994257276, 1994562634, 1994867699,
  1995172470, 1995476949, 1995781133, 1996085024,
  1996388622, 1996691926, 1996994936, 1997297653,
  1997600075, 1997902204, 1998204040, 1998505581,
  1998806828, 1999107782, 1999408441, 1999708807,
  2000008878, 2000308655, 2000608138, 2000907327,
  2001206222, 2001504822, 2001803128, 2002101139,
  2002398856, 2002696279, 2002993407, 2003290240,
  2003586779, 2003883023, 2004178972, 2004474627,
  2004769987, 2005065052, 2005359822, 2005654297,
  2005948477, 2006242362, 2006535953, 2006829248,
  2007122248, 2007414952, 2007707362, 2007999476,
  2008291295, 2008582819, 2008874047, 2009164979,
  2009455617, 2009745958, 2010036005, 2010325755,
  2010615210, 2010904369, 2011193233, 2011481800,
  2011770072, 2012058048, 2012345728, 2012633112,
  2012920200, 2013206992, 2013493488, 2013779688,
  2014065592, 2014351199, 2014636511, 2014921525,
  2015206244, 2015490666, 2015774792, 2016058622,
  2016342154, 2016625391, 2016908331, 2017190974,
  2017473320, 2017755370, 2018037123, 2018318579,
  2018599739, 2018880601, 2019161167, 2019441435,
  2019721407, 2020001082, 2020280459, 2020559539,
  2020838323, 2021116809, 2021394998, 2021672889,
  2021950483, 2022227780, 2022504780, 2022781482,
  2023057886, 2023333993, 2023609802, 2023885314,
  2024160528, 2024435445, 2024710064, 2024984384,
  2025258408, 2025532133, 2025805560, 2026078690,
  2026351521, 2026624055, 2026896290, 2027168227,
  2027439867, 2027711208, 2027982250, 2028252995,
  2028523441, 2028793589, 2029063439, 2029332990,
  2029602243, 2029871197, 2030139853, 2030408210,
  2030676268, 2030944028, 2031211489, 2031478652,
  2031745515, 2032012080, 2032278346, 2032544313,
  2032809982, 2033075351, 2033340421, 2033605192,
  2033869664, 2034133837, 2034397711, 2034661286,
  2034924561, 2035187537, 2035450214, 2035712592,
  2035974670, 2036236448, 2036497928, 2036759107,
  2037019988, 2037280568, 2037540849, 2037800830,
  2038060512, 2038319894, 2038578976, 2038837758,
  2039096241, 2039354423, 2039612306, 2039869888,
  2040127171, 2040384154, 2040640836, 2040897219,
  2041153301, 2041409083, 2041664565, 2041919746,
  2042174628, 2042429209, 2042683489, 2042937469,
  2043191149, 2043444528, 2043697607, 2043950385,
  2044202863, 2044455040, 2044706916, 2044958491,
  2045209766, 2045460740, 2045711413, 2045961785,
  2046211857, 2046461627, 2046711097, 2046960265,
  2047209133, 2047457699, 2047705964, 2047953928,
  2048201591, 2048448953, 2048696013, 2048942772,
  2049189230, 2049435387, 2049681242, 2049926795,
  2050172047, 2050416998, 2050661647, 2050905994,
  2051150040, 2051393784, 2051637227, 2051880367,
  2052123206, 2052365743, 2052607979, 2052849912,
  2053091543, 2053332873, 2053573901, 2053814626,
  2054055050, 2054295171, 2054534990, 2054774508,
  2055013723, 2055252635, 2055491246, 2055729554,
  2055967560, 2056205263, 2056442664, 2056679763,
  2056916559, 2057153053, 2057389244, 2057625132,
  2057860718, 2058096002, 2058330982, 2058565660,
  2058800035, 2059034107, 2059267877, 2059501344,
  2059734507, 2059967368, 2060199926, 2060432181,
  2060664133, 2060895782, 2061127127, 2061358170,
  2061588909, 2061819346, 2062049479, 2062279309,
  2062508835, 2062738058, 2062966978, 2063195594,
  2063423907, 2063651917, 2063879623, 2064107025,
  2064334124, 2064560919, 2064787411, 2065013599,
  2065239483, 2065465064, 2065690340, 2065915313,
  2066139983, 2066364348, 2066588409, 2066812167,
  2067035620, 2067258770, 2067481615, 2067704157,
  2067926394, 2068148327, 2068369956, 2068591281,
  2068812302, 2069033018, 2069253430, 2069473538,
  2069693341, 2069912840, 2070132035, 2070350925,
  2070569510, 2070787792, 2071005768, 2071223440,
  2071440808, 2071657870, 2071874628, 2072091082,
  2072307230, 2072523074, 2072738613, 2072953848,
  2073168777, 2073383401, 2073597721, 2073811735,
  2074025445, 2074238850, 2074451949, 2074664743,
  2074877233, 2075089417, 2075301296, 2075512870,
  2075724138, 2075935101, 2076145759, 2076356112,
  2076566159, 2076775901, 2076985337, 2077194468,
  2077403294, 2077611814, 2077820028, 2078027937,
  2078235540, 2078442837, 2078649829, 2078856515,
  2079062896, 2079268971, 2079474739, 2079680202,
  2079885360, 2080090211, 2080294756, 2080498996,
  2080702929, 2080906557, 2081109878, 2081312893,
  2081515603, 2081718006, 2081920103, 2082121894,
  2082323378, 2082524557, 2082725429, 2082925994,
  2083126254, 2083326207, 2083525853, 2083725194,
  2083924228, 2084122955, 2084321376, 2084519490,
  2084717298, 2084914799, 2085111993, 2085308881,
  2085505462, 2085701737, 2085897704, 2086093365,
  2086288719, 2086483767, 2086678507, 2086872941,
  2087067067, 2087260887, 2087454400, 2087647605,
  2087840504, 2088033096, 2088225380, 2088417358,
  2088609028, 2088800391, 2088991447, 2089182196,
  2089372637, 2089562772, 2089752598, 2089942118,
  2090131330, 2090320235, 2090508832, 2090697122,
  2090885105, 2091072780, 2091260147, 2091447207,
  2091633959, 2091820404, 2092006541, 2092192370,
  2092377892, 2092563106, 2092748012, 2092932610,
  2093116901, 2093300883, 2093484558, 2093667925,
  2093850984, 2094033736, 2094216179, 2094398314,
  2094580141, 2094761660, 2094942871, 2095123774,
  2095304369, 2095484656, 2095664634, 2095844305,
  2096023667, 2096202720, 2096381466, 2096559903,
  2096738032, 2096915852, 2097093365, 2097270568,
  2097447463, 2097624050, 2097800329, 2097976298,
  2098151959, 2098327312, 2098502356, 2098677092,
  2098851518, 2099025636, 2099199446, 2099372947,
  2099546138, 2099719022, 2099891596, 2100063861,
  2100235818, 2100407466, 2100578805, 2100749835,
  2100920556, 2101090968, 2101261071, 2101430865,
  2101600350, 2101769525, 2101938392, 2102106950,
  2102275198, 2102443137, 2102610768, 2102778088,
  2102945100, 2103111802, 2103278195, 2103444279,
  2103610053, 2103775518, 2103940674, 2104105520,
  2104270057, 2104434284, 2104598202, 2104761810,
  2104925109, 2105088098, 2105250777, 2105413147,
  2105575207, 2105736958, 2105898399, 2106059530,
  2106220351, 2106380863, 2106541065, 2106700957,
  2106860539, 2107019812, 2107178774, 2107337427,
  2107495770, 2107653802, 2107811525, 2107968938,
  2108126041, 2108282834, 2108439316, 2108595489,
  2108751351, 2108906904, 2109062146, 2109217078,
  2109371700, 2109526011, 2109680013, 2109833704,
  2109987085, 2110140155, 2110292915, 2110445365,
  2110597505, 2110749334, 2110900852, 2111052060,
  2111202958, 2111353545, 2111503822, 2111653788,
  2111803444, 2111952789, 2112101823, 2112250547,
  2112398960, 2112547062, 2112694854, 2112842335,
  2112989506, 2113136365, 2113282914, 2113429152,
  2113575079, 2113720695, 2113866001, 2114010996,
  2114155679, 2114300052, 2114444114, 2114587865,
  2114731304, 2114874433, 2115017251, 2115159758,
  2115301954, 2115443838, 2115585412, 2115726674,
  2115867625, 2116008265, 2116148594, 2116288612,
  2116428318, 2116567713, 2116706797, 2116845569,
  2116984031, 2117122181, 2117260019, 2117397546,
  2117534762, 2117671666, 2117808259, 2117944540,
  2118080510, 2118216169, 2118351515, 2118486551,
  2118621275, 2118755687, 2118889787, 2119023576,
  2119157054, 2119290219, 2119423073, 2119555615,
  2119687846, 2119819765, 2119951372, 2120082667,
  2120213651, 2120344322, 2120474682, 2120604730,
  2120734466, 2120863890, 2120993003, 2121121803,
  2121250291, 2121378468, 2121506332, 2121633885,
  2121761125, 2121888054, 2122014670, 2122140974,
  2122266966, 2122392646, 2122518014, 2122643070,
  2122767813, 2122892245, 2123016364, 2123140171,
  2123263665, 2123386848, 2123509718, 2123632276,
  2123754521, 2123876454, 2123998075, 2124119384,
  2124240380, 2124361063, 2124481434, 2124601493,
  2124721239, 2124840673, 2124959795, 2125078603,
  2125197100, 2125315283, 2125433155, 2125550713,
  2125667959, 2125784892, 2125901513, 2126017821,
  2126133817, 2126249499, 2126364869, 2126479927,
  2126594671, 2126709103, 2126823222, 2126937028,
  2127050522, 2127163702, 2127276570, 2127389125,
  2127501367, 2127613296, 2127724912, 2127836215,
  2127947206, 2128057883, 2128168248, 2128278299,
  2128388038, 2128497463, 2128606575, 2128715375,
  2128823861, 2128932034, 2129039894, 2129147441,
  2129254675, 2129361596, 2129468204, 2129574498,
  2129680479, 2129786147, 2129891502, 2129996543,
  2130101272, 2130205686, 2130309788, 2130413577,
  2130517052, 2130620213, 2130723062, 2130825597,
  2130927818, 2131029727, 2131131322, 2131232603,
  2131333571, 2131434226, 2131534567, 2131634594,
  2131734308, 2131833709, 2131932796, 2132031569,
  2132130029, 2132228176, 2132326009, 2132423528,
  2132520733, 2132617625, 2132714204, 2132810468,
  2132906419, 2133002057, 2133097380, 2133192390,
  2133287087, 2133381469, 2133475538, 2133569293,
  2133662734, 2133755861, 2133848675, 2133941174,
  2134033360, 2134125232, 2134216790, 2134308035,
  2134398965, 2134489582, 2134579884, 2134669873,
  2134759548, 2134848908, 2134937955, 2135026688,
  2135115107, 2135203212, 2135291002, 2135378479,
  2135465642, 2135552491, 2135639025, 2135725246,
  2135811152, 2135896744, 2135982022, 2136066986,
  2136151636, 2136235972, 2136319994, 2136403701,
  2136487094, 2136570173, 2136652938, 2136735388,
  2136817525, 2136899346, 2136980854, 2137062048,
  2137142927, 2137223492, 2137303742, 2137383678,
  2137463300, 2137542608, 2137621601, 2137700279,
  2137778644, 2137856694, 2137934429, 2138011850,
  2138088957, 2138165749, 2138242227, 2138318390,
  2138394239, 2138469774, 2138544993, 2138619899,
  2138694490, 2138768766, 2138842728, 2138916375,
  2138989707, 2139062725, 2139135429, 2139207818,
  2139279892, 2139351651, 2139423096, 2139494227,
  2139565042, 2139635543, 2139705730, 2139775601,
  2139845158, 2139914401, 2139983328, 2140051941,
  2140120239, 2140188222, 2140255891, 2140323245,
  2140390284, 2140457008, 2140523418, 2140589512,
  2140655292, 2140720757, 2140785907, 2140850743,
  2140915263, 2140979469, 2141043360, 2141106936,
  2141170197, 2141233143, 2141295774, 2141358090,
  2141420092, 2141481778, 2141543149, 2141604206,
  2141664948, 2141725374, 2141785486, 2141845282,
  2141904764, 2141963931, 2142022782, 2142081319,
  2142139540, 2142197447, 2142255038, 2142312315,
  2142369276, 2142425922, 2142482253, 2142538269,
  2142593970, 2142649356, 2142704427, 2142759183,
  2142813623, 2142867748, 2142921559, 2142975054,
  2143028234, 2143081098, 2143133648, 2143185882,
  2143237801, 2143289405, 2143340694, 2143391667,
  2143442326, 2143492669, 2143542697, 2143592409,
  2143641806, 2143690889, 2143739655, 2143788107,
  2143836243, 2143884064, 2143931570, 2143978760,
  2144025635, 2144072195, 2144118439, 2144164368,
  2144209982, 2144255280, 2144300263, 2144344931,
  2144389283, 2144433320, 2144477041, 2144520448,
  2144563538, 2144606314, 2144648774, 2144690918,
  2144732747, 2144774261, 2144815459, 2144856342,
  2144896909, 2144937161, 2144977098, 2145016719,
  2145056024, 2145095015, 2145133689, 2145172048,
  2145210092, 2145247820, 2145285233, 2145322330,
  2145359112, 2145395578, 2145431728, 2145467563,
  2145503083, 2145538287, 2145573175, 2145607748,
  2145642006, 2145675948, 2145709574, 2145742885,
  2145775880, 2145808559, 2145840923, 2145872972,
  2145904704, 2145936122, 2145967223, 2145998009,
  2146028479, 2146058634, 2146088473, 2146117997,
  2146147205, 2146176097, 2146204674, 2146232935,
  2146260880, 2146288510, 2146315824, 2146342822,
  2146369505, 2146395872, 2146421923, 2146447659,
  2146473079, 2146498184, 2146522972, 2146547445,
  2146571603, 2146595444, 2146618970, 2146642181,
  2146665075, 2146687654, 2146709917, 2146731864,
  2146753496, 2146774812, 2146795812, 2146816497,
  2146836866, 2146856919, 2146876656, 2146896078,
  2146915183, 2146933973, 2146952448, 2146970606,
  2146988449, 2147005976, 2147023188, 2147040083,
  2147056663, 2147072927, 2147088875, 2147104508,
  2147119825, 2147134826, 2147149511, 2147163880,
  2147177934, 2147191672, 2147205094, 2147218200,
  2147230991, 2147243465, 2147255624, 2147267467,
  2147278995, 2147290206, 2147301102, 2147311682,
  2147321946, 2147331894, 2147341527, 2147350843,
  2147359844, 2147368529, 2147376899, 2147384952,
  2147392690, 2147400112, 2147407218, 2147414008,
  2147420482, 2147426641, 2147432484, 2147438011,
  2147443222, 2147448117, 2147452696, 2147456960,
  2147460908, 2147464540, 2147467856, 2147470857,
  2147473541, 2147475910, 2147477963, 2147479700,
  2147481121, 2147482226, 2147483016, 2147483490,
  2147483647,
};

