// Copyright 2024 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.

#include <stdio.h>

%for name in cmd_map:
#include "${name}_config.h"
%endfor

#if OFFSET_GEN
int main(int argc, char* argv[])
{
    FILE *fp;
    printf("argc = %d\n", argc);
    if(argc == 2)
    {
        printf("argv = %s\n", argv[1]);
        fp = fopen(argv[1], "w");
    }
    else
    {
        fp = fopen("cmd_offset_size.h", "w");
    }
    fprintf(fp, "#ifndef CMD_NUM_VALUES_H\n");
    fprintf(fp, "#define CMD_NUM_VALUES_H\n\n");

    // Number of values read or written as part of the command. Used in the host cmd_map.c file. Needs to be generated by running
    // an application since the config yaml files might specified size in terms of #defines (for eg. FILTERS * NUM_COEFFS_PER_BIQUAD)
%for name, data in cmd_map.items():
    %for field_name, field_data in data.items():
<%
    if "size" in field_data:
        size = field_data["size"]
    elif field_data["type"] == "float_s32_t":
        size = 2
    else:
        size = 1
%>\
    fprintf(fp, "#define NUM_VALUES_${name.upper()}_${field_name.upper()} %u\n", ${size});
    fprintf(fp, "\n");
    %endfor
%endfor
    fprintf(fp, "#endif\n");
    fclose(fp);
    return 0;
}
#endif
