// Copyright 2024 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.
#include <string.h>
#include <stdlib.h>
#include <xcore/assert.h>
#include <debug_print.h>
#include "cmds.h" // Autogenerated
#include "cmd_offsets.h" // Autogenerated
#include "stages/switch.h"
#include <stdio.h>
#include "print.h"

void switch_process(int32_t **input, int32_t **output, void *app_data_state)
{
    switch_state_t *state = app_data_state;
    int32_t *in = input[state->config.position];
    int32_t *out = output[0];

    memcpy(out, in, sizeof(int32_t) * state->frame_size);

}

void switch_init(module_instance_t* instance, adsp_bump_allocator_t* allocator, uint8_t id, int n_inputs, int n_outputs, int frame_size)
{
    switch_state_t *state = instance->state;
    switch_config_t *config = instance->control.config;

    memset(state, 0, sizeof(switch_state_t));
    state->n_inputs = n_inputs;
    state->frame_size = frame_size;
    xassert(n_outputs == 1 && "Switch should only have one output");
    state->n_outputs = n_outputs;

    memcpy(&state->config, config, sizeof(switch_config_t));
}

void switch_control(void *module_state, module_control_t *control)
{
    switch_state_t *state = module_state;
    switch_config_t *config = control->config;

    if(control->config_rw_state == config_write_pending)
    {
        // Finish the write by updating the working copy with the new config
        memcpy(&state->config, config, sizeof(switch_config_t));
        control->config_rw_state = config_none_pending;
    }
    else if(control->config_rw_state == config_read_pending)
    {
        memcpy(config, &state->config, sizeof(switch_config_t));
        control->config_rw_state = config_read_updated;
    }
    else
    {
        // nothing to do.
    }
}

