// Copyright 2024 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.
#pragma once

#include "bump_allocator.h"
#include "dsp/drc.h"
#include "compressor_rms_config.h" // Autogenerated

typedef struct
{
    compressor_t *comp;
    int n_inputs;
    int n_outputs;
    int frame_size;
}compressor_rms_state_t;

#define COMPRESSOR_RMS_STAGE_REQUIRED_MEMORY(N_IN) (N_IN * sizeof(compressor_t))

void compressor_rms_init(module_instance_t* instance, adsp_bump_allocator_t* allocator, uint8_t id, int n_inputs, int n_outputs, int frame_size);

void compressor_rms_process(int32_t **input, int32_t **output, void *app_data_state);

void compressor_rms_control(void *state, module_control_t *control);
