#ifndef _USER_MAIN_H_
#define _USER_MAIN_H_

#ifdef __XC__

#include "i2c.h"
#include <platform.h>
#include <xk_audio_316_mc_ab/board.h>
#include "app_dsp.h"

extern unsafe client interface i2c_master_if i_i2c_client;
extern void board_setup();

// start of user main macros
#define USER_MAIN_DECLARATIONS \
    interface i2c_master_if i2c[1];\
    chan c_gpio;

#define USER_MAIN_CORES on tile[0]: {\
                                        board_setup();\
                                        xk_audio_316_mc_ab_i2c_master(i2c);\
                                    }\
                        on tile[0]: gpio_task(c_gpio);\
                        on tile[1]: {\
                                        {\
                                            unsafe { i_i2c_client = i2c[0]; }\
                                            dsp_thread(c_gpio);\
                                        }\
                                    }
// end of user main macros
#endif

#endif
