// Copyright 2024-2025 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.
#pragma once

#include "bump_allocator.h"
#include "dsp/cascaded_biquads.h"
#include "cascaded_biquads_16_config.h" // Autogenerated

#define CASCADED_BIQUADS_16_STATE_LEN (128)
typedef struct
{
    cascaded_biquads_16_config_t config;
    int32_t **filter_states;
    int n_inputs;
    int n_outputs;
    int frame_size;
}cascaded_biquads_16_state_t;

#define _CBQ16_FILTER_MEMORY \
    (CASCADED_BIQUADS_16_STATE_LEN * sizeof(int32_t))
#define _CBQ16_ALL_FILTER_MEMORY(N_IN) \
    (ADSP_BUMP_ALLOCATOR_DWORD_N_BYTES(_CBQ16_FILTER_MEMORY) * (N_IN))
#define _CBQ16_ARR_MEMORY(N_IN) \
    ((N_IN) * sizeof(int32_t*))


#define CASCADED_BIQUADS_16_STAGE_REQUIRED_MEMORY(N_IN) \
    _CBQ16_ALL_FILTER_MEMORY(N_IN) + _CBQ16_ARR_MEMORY(N_IN)

void cascaded_biquads_16_init(module_instance_t* instance, adsp_bump_allocator_t* allocator, uint8_t id, int n_inputs, int n_outputs, int frame_size);

void cascaded_biquads_16_process(int32_t **input, int32_t **output, void *app_data_state);

void cascaded_biquads_16_control(void *state, module_control_t *control);
