// Copyright 2016-2021 XMOS LIMITED.
// This Software is subject to the terms of the XMOS Public Licence: Version 1.
#ifndef LOG2_LUT_H_
#define LOG2_LUT_H_

#define LOG2_BITS 12
#define LOG2_MASK ((1<<LOG2_BITS)-1)

const uint32_t log2_lut[] = {
    0xffffff, 0xffe8eb, 0xffd1d8, 0xffbac6, 0xffa3b6, 0xff8ca7, 0xff759a, 0xff5e8e,
    0xff4783, 0xff307a, 0xff1973, 0xff026d, 0xfeeb68, 0xfed465, 0xfebd63, 0xfea662,
    0xfe8f63, 0xfe7866, 0xfe616a, 0xfe4a6f, 0xfe3376, 0xfe1c7e, 0xfe0587, 0xfdee92,
    0xfdd79f, 0xfdc0ad, 0xfda9bc, 0xfd92cd, 0xfd7bdf, 0xfd64f2, 0xfd4e07, 0xfd371e,
    0xfd2035, 0xfd094f, 0xfcf269, 0xfcdb85, 0xfcc4a3, 0xfcadc2, 0xfc96e2, 0xfc8004,
    0xfc6927, 0xfc524c, 0xfc3b72, 0xfc2499, 0xfc0dc2, 0xfbf6ec, 0xfbe018, 0xfbc945,
    0xfbb273, 0xfb9ba3, 0xfb84d4, 0xfb6e07, 0xfb573b, 0xfb4071, 0xfb29a8, 0xfb12e0,
    0xfafc1a, 0xfae555, 0xface91, 0xfab7cf, 0xfaa10f, 0xfa8a4f, 0xfa7391, 0xfa5cd5,
    0xfa461a, 0xfa2f60, 0xfa18a8, 0xfa01f1, 0xf9eb3c, 0xf9d487, 0xf9bdd5, 0xf9a724,
    0xf99074, 0xf979c5, 0xf96318, 0xf94c6c, 0xf935c2, 0xf91f19, 0xf90871, 0xf8f1cb,
    0xf8db27, 0xf8c483, 0xf8ade1, 0xf89741, 0xf880a1, 0xf86a04, 0xf85367, 0xf83ccc,
    0xf82632, 0xf80f9a, 0xf7f903, 0xf7e26e, 0xf7cbd9, 0xf7b547, 0xf79eb5, 0xf78825,
    0xf77197, 0xf75b09, 0xf7447d, 0xf72df3, 0xf7176a, 0xf700e2, 0xf6ea5c, 0xf6d3d7,
    0xf6bd53, 0xf6a6d1, 0xf69050, 0xf679d0, 0xf66352, 0xf64cd5, 0xf6365a, 0xf61fe0,
    0xf60967, 0xf5f2f0, 0xf5dc7a, 0xf5c605, 0xf5af92, 0xf59920, 0xf582b0, 0xf56c41,
    0xf555d3, 0xf53f67, 0xf528fb, 0xf51292, 0xf4fc29, 0xf4e5c2, 0xf4cf5d, 0xf4b8f9,
    0xf4a296, 0xf48c34, 0xf475d4, 0xf45f75, 0xf44918, 0xf432bc, 0xf41c61, 0xf40607,
    0xf3efaf, 0xf3d959, 0xf3c303, 0xf3acaf, 0xf3965d, 0xf3800b, 0xf369bb, 0xf3536d,
    0xf33d20, 0xf326d4, 0xf31089, 0xf2fa40, 0xf2e3f8, 0xf2cdb1, 0xf2b76c, 0xf2a128,
    0xf28ae6, 0xf274a5, 0xf25e65, 0xf24826, 0xf231e9, 0xf21bae, 0xf20573, 0xf1ef3a,
    0xf1d902, 0xf1c2cc, 0xf1ac97, 0xf19663, 0xf18030, 0xf169ff, 0xf153cf, 0xf13da1,
    0xf12774, 0xf11148, 0xf0fb1e, 0xf0e4f4, 0xf0cecd, 0xf0b8a6, 0xf0a281, 0xf08c5d,
    0xf0763b, 0xf0601a, 0xf049fa, 0xf033db, 0xf01dbe, 0xf007a2, 0xeff188, 0xefdb6e,
    0xefc557, 0xefaf40, 0xef992b, 0xef8317, 0xef6d04, 0xef56f3, 0xef40e3, 0xef2ad4,
    0xef14c7, 0xeefebb, 0xeee8b0, 0xeed2a7, 0xeebc9f, 0xeea698, 0xee9092, 0xee7a8e,
    0xee648b, 0xee4e8a, 0xee388a, 0xee228b, 0xee0c8d, 0xedf691, 0xede096, 0xedca9c,
    0xedb4a4, 0xed9ead, 0xed88b7, 0xed72c3, 0xed5cd0, 0xed46de, 0xed30ed, 0xed1afe,
    0xed0510, 0xecef24, 0xecd938, 0xecc34e, 0xecad65, 0xec977e, 0xec8198, 0xec6bb3,
    0xec55d0, 0xec3fed, 0xec2a0c, 0xec142d, 0xebfe4f, 0xebe871, 0xebd296, 0xebbcbb,
    0xeba6e2, 0xeb910a, 0xeb7b34, 0xeb655e, 0xeb4f8a, 0xeb39b8, 0xeb23e6, 0xeb0e16,
    0xeaf847, 0xeae27a, 0xeaccad, 0xeab6e2, 0xeaa119, 0xea8b50, 0xea7589, 0xea5fc3,
    0xea49ff, 0xea343c, 0xea1e7a, 0xea08b9, 0xe9f2f9, 0xe9dd3b, 0xe9c77e, 0xe9b1c3,
    0xe99c09, 0xe9864f, 0xe97098, 0xe95ae1, 0xe9452c, 0xe92f78, 0xe919c5, 0xe90414,
    0xe8ee64, 0xe8d8b5, 0xe8c308, 0xe8ad5b, 0xe897b0, 0xe88207, 0xe86c5e, 0xe856b7,
    0xe84111, 0xe82b6c, 0xe815c9, 0xe80027, 0xe7ea86, 0xe7d4e6, 0xe7bf48, 0xe7a9ab,
    0xe7940f, 0xe77e74, 0xe768db, 0xe75343, 0xe73dac, 0xe72817, 0xe71283, 0xe6fcf0,
    0xe6e75e, 0xe6d1ce, 0xe6bc3e, 0xe6a6b0, 0xe69124, 0xe67b98, 0xe6660e, 0xe65085,
    0xe63afe, 0xe62577, 0xe60ff2, 0xe5fa6e, 0xe5e4ec, 0xe5cf6a, 0xe5b9ea, 0xe5a46b,
    0xe58eee, 0xe57971, 0xe563f6, 0xe54e7c, 0xe53904, 0xe5238c, 0xe50e16, 0xe4f8a1,
    0xe4e32e, 0xe4cdbb, 0xe4b84a, 0xe4a2da, 0xe48d6b, 0xe477fe, 0xe46292, 0xe44d27,
    0xe437bd, 0xe42255, 0xe40cee, 0xe3f788, 0xe3e223, 0xe3ccbf, 0xe3b75d, 0xe3a1fc,
    0xe38c9c, 0xe3773e, 0xe361e1, 0xe34c84, 0xe3372a, 0xe321d0, 0xe30c78, 0xe2f721,
    0xe2e1cb, 0xe2cc76, 0xe2b723, 0xe2a1d0, 0xe28c7f, 0xe27730, 0xe261e1, 0xe24c94,
    0xe23748, 0xe221fd, 0xe20cb3, 0xe1f76b, 0xe1e224, 0xe1ccde, 0xe1b799, 0xe1a256,
    0xe18d13, 0xe177d2, 0xe16293, 0xe14d54, 0xe13817, 0xe122db, 0xe10da0, 0xe0f866,
    0xe0e32d, 0xe0cdf6, 0xe0b8c0, 0xe0a38b, 0xe08e58, 0xe07925, 0xe063f4, 0xe04ec4,
    0xe03995, 0xe02468, 0xe00f3c, 0xdffa10, 0xdfe4e7, 0xdfcfbe, 0xdfba96, 0xdfa570,
    0xdf904b, 0xdf7b27, 0xdf6605, 0xdf50e3, 0xdf3bc3, 0xdf26a4, 0xdf1186, 0xdefc6a,
    0xdee74e, 0xded234, 0xdebd1b, 0xdea804, 0xde92ed, 0xde7dd8, 0xde68c3, 0xde53b1,
    0xde3e9f, 0xde298e, 0xde147f, 0xddff71, 0xddea64, 0xddd558, 0xddc04e, 0xddab44,
    0xdd963c, 0xdd8135, 0xdd6c2f, 0xdd572b, 0xdd4227, 0xdd2d25, 0xdd1824, 0xdd0325,
    0xdcee26, 0xdcd929, 0xdcc42c, 0xdcaf31, 0xdc9a38, 0xdc853f, 0xdc7048, 0xdc5b51,
    0xdc465c, 0xdc3168, 0xdc1c76, 0xdc0784, 0xdbf294, 0xdbdda5, 0xdbc8b7, 0xdbb3ca,
    0xdb9edf, 0xdb89f4, 0xdb750b, 0xdb6023, 0xdb4b3c, 0xdb3657, 0xdb2172, 0xdb0c8f,
    0xdaf7ad, 0xdae2cc, 0xdacdec, 0xdab90e, 0xdaa430, 0xda8f54, 0xda7a79, 0xda659f,
    0xda50c7, 0xda3bef, 0xda2719, 0xda1244, 0xd9fd70, 0xd9e89d, 0xd9d3cb, 0xd9befb,
    0xd9aa2c, 0xd9955e, 0xd98091, 0xd96bc5, 0xd956fa, 0xd94231, 0xd92d69, 0xd918a2,
    0xd903dc, 0xd8ef17, 0xd8da54, 0xd8c591, 0xd8b0d0, 0xd89c10, 0xd88751, 0xd87293,
    0xd85dd7, 0xd8491b, 0xd83461, 0xd81fa8, 0xd80af0, 0xd7f639, 0xd7e184, 0xd7cccf,
    0xd7b81c, 0xd7a36a, 0xd78eb9, 0xd77a09, 0xd7655a, 0xd750ad, 0xd73c01, 0xd72756,
    0xd712ac, 0xd6fe03, 0xd6e95b, 0xd6d4b4, 0xd6c00f, 0xd6ab6b, 0xd696c8, 0xd68226,
    0xd66d85, 0xd658e5, 0xd64447, 0xd62faa, 0xd61b0e, 0xd60673, 0xd5f1d9, 0xd5dd40,
    0xd5c8a8, 0xd5b412, 0xd59f7d, 0xd58ae9, 0xd57656, 0xd561c4, 0xd54d33, 0xd538a3,
    0xd52415, 0xd50f88, 0xd4fafc, 0xd4e671, 0xd4d1e7, 0xd4bd5e, 0xd4a8d7, 0xd49450,
    0xd47fcb, 0xd46b47, 0xd456c4, 0xd44242, 0xd42dc1, 0xd41942, 0xd404c3, 0xd3f046,
    0xd3dbca, 0xd3c74f, 0xd3b2d5, 0xd39e5c, 0xd389e5, 0xd3756e, 0xd360f9, 0xd34c85,
    0xd33812, 0xd323a0, 0xd30f2f, 0xd2fabf, 0xd2e651, 0xd2d1e3, 0xd2bd77, 0xd2a90c,
    0xd294a2, 0xd28039, 0xd26bd1, 0xd2576a, 0xd24305, 0xd22ea0, 0xd21a3d, 0xd205db,
    0xd1f17a, 0xd1dd1a, 0xd1c8bb, 0xd1b45d, 0xd1a001, 0xd18ba6, 0xd1774b, 0xd162f2,
    0xd14e9a, 0xd13a43, 0xd125ed, 0xd11199, 0xd0fd45, 0xd0e8f3, 0xd0d4a1, 0xd0c051,
    0xd0ac02, 0xd097b4, 0xd08367, 0xd06f1b, 0xd05ad1, 0xd04687, 0xd0323f, 0xd01df7,
    0xd009b1, 0xcff56c, 0xcfe128, 0xcfcce5, 0xcfb8a4, 0xcfa463, 0xcf9024, 0xcf7be5,
    0xcf67a8, 0xcf536c, 0xcf3f31, 0xcf2af7, 0xcf16be, 0xcf0286, 0xceee4f, 0xceda1a,
    0xcec5e5, 0xceb1b2, 0xce9d80, 0xce894f, 0xce751f, 0xce60f0, 0xce4cc2, 0xce3895,
    0xce246a, 0xce103f, 0xcdfc16, 0xcde7ed, 0xcdd3c6, 0xcdbfa0, 0xcdab7b, 0xcd9757,
    0xcd8334, 0xcd6f13, 0xcd5af2, 0xcd46d3, 0xcd32b4, 0xcd1e97, 0xcd0a7b, 0xccf65f,
    0xcce245, 0xccce2c, 0xccba15, 0xcca5fe, 0xcc91e8, 0xcc7dd4, 0xcc69c0, 0xcc55ae,
    0xcc419c, 0xcc2d8c, 0xcc197d, 0xcc056f, 0xcbf162, 0xcbdd56, 0xcbc94b, 0xcbb542,
    0xcba139, 0xcb8d32, 0xcb792b, 0xcb6526, 0xcb5122, 0xcb3d1f, 0xcb291c, 0xcb151b,
    0xcb011c, 0xcaed1d, 0xcad91f, 0xcac522, 0xcab127, 0xca9d2c, 0xca8933, 0xca753a,
    0xca6143, 0xca4d4d, 0xca3958, 0xca2564, 0xca1171, 0xc9fd7f, 0xc9e98e, 0xc9d59e,
    0xc9c1b0, 0xc9adc2, 0xc999d6, 0xc985ea, 0xc97200, 0xc95e17, 0xc94a2e, 0xc93647,
    0xc92261, 0xc90e7c, 0xc8fa98, 0xc8e6b6, 0xc8d2d4, 0xc8bef3, 0xc8ab13, 0xc89735,
    0xc88357, 0xc86f7b, 0xc85ba0, 0xc847c5, 0xc833ec, 0xc82014, 0xc80c3d, 0xc7f867,
    0xc7e492, 0xc7d0be, 0xc7bceb, 0xc7a919, 0xc79549, 0xc78179, 0xc76daa, 0xc759dd,
    0xc74610, 0xc73245, 0xc71e7b, 0xc70ab1, 0xc6f6e9, 0xc6e322, 0xc6cf5c, 0xc6bb97,
    0xc6a7d3, 0xc69410, 0xc6804e, 0xc66c8d, 0xc658ce, 0xc6450f, 0xc63151, 0xc61d95,
    0xc609d9, 0xc5f61f, 0xc5e265, 0xc5cead, 0xc5baf6, 0xc5a73f, 0xc5938a, 0xc57fd6,
    0xc56c23, 0xc55871, 0xc544c0, 0xc53110, 0xc51d61, 0xc509b3, 0xc4f606, 0xc4e25b,
    0xc4ceb0, 0xc4bb06, 0xc4a75e, 0xc493b6, 0xc4800f, 0xc46c6a, 0xc458c5, 0xc44522,
    0xc43180, 0xc41dde, 0xc40a3e, 0xc3f69f, 0xc3e301, 0xc3cf64, 0xc3bbc7, 0xc3a82c,
    0xc39492, 0xc380f9, 0xc36d62, 0xc359cb, 0xc34635, 0xc332a0, 0xc31f0c, 0xc30b79,
    0xc2f7e8, 0xc2e457, 0xc2d0c7, 0xc2bd39, 0xc2a9ab, 0xc2961f, 0xc28293, 0xc26f09,
    0xc25b7f, 0xc247f7, 0xc23470, 0xc220e9, 0xc20d64, 0xc1f9e0, 0xc1e65c, 0xc1d2da,
    0xc1bf59, 0xc1abd9, 0xc1985a, 0xc184dc, 0xc1715f, 0xc15de3, 0xc14a68, 0xc136ee,
    0xc12375, 0xc10ffd, 0xc0fc86, 0xc0e910, 0xc0d59b, 0xc0c227, 0xc0aeb5, 0xc09b43,
    0xc087d2, 0xc07462, 0xc060f4, 0xc04d86, 0xc03a19, 0xc026ae, 0xc01343, 0xbfffd9,
    0xbfec71, 0xbfd909, 0xbfc5a3, 0xbfb23d, 0xbf9ed9, 0xbf8b75, 0xbf7813, 0xbf64b1,
    0xbf5151, 0xbf3df2, 0xbf2a93, 0xbf1736, 0xbf03d9, 0xbef07e, 0xbedd24, 0xbec9ca,
    0xbeb672, 0xbea31b, 0xbe8fc5, 0xbe7c6f, 0xbe691b, 0xbe55c8, 0xbe4275, 0xbe2f24,
    0xbe1bd4, 0xbe0885, 0xbdf537, 0xbde1e9, 0xbdce9d, 0xbdbb52, 0xbda808, 0xbd94bf,
    0xbd8177, 0xbd6e30, 0xbd5ae9, 0xbd47a4, 0xbd3460, 0xbd211d, 0xbd0ddb, 0xbcfa9a,
    0xbce75a, 0xbcd41b, 0xbcc0dc, 0xbcad9f, 0xbc9a63, 0xbc8728, 0xbc73ee, 0xbc60b5,
    0xbc4d7d, 0xbc3a46, 0xbc2710, 0xbc13db, 0xbc00a6, 0xbbed73, 0xbbda41, 0xbbc710,
    0xbbb3e0, 0xbba0b1, 0xbb8d83, 0xbb7a56, 0xbb672a, 0xbb53fe, 0xbb40d4, 0xbb2dab,
    0xbb1a83, 0xbb075c, 0xbaf436, 0xbae111, 0xbacdec, 0xbabac9, 0xbaa7a7, 0xba9486,
    0xba8166, 0xba6e46, 0xba5b28, 0xba480b, 0xba34ef, 0xba21d3, 0xba0eb9, 0xb9fba0,
    0xb9e888, 0xb9d570, 0xb9c25a, 0xb9af45, 0xb99c30, 0xb9891d, 0xb9760b, 0xb962f9,
    0xb94fe9, 0xb93cd9, 0xb929cb, 0xb916bd, 0xb903b1, 0xb8f0a5, 0xb8dd9b, 0xb8ca91,
    0xb8b789, 0xb8a481, 0xb8917b, 0xb87e75, 0xb86b70, 0xb8586d, 0xb8456a, 0xb83268,
    0xb81f68, 0xb80c68, 0xb7f969, 0xb7e66b, 0xb7d36f, 0xb7c073, 0xb7ad78, 0xb79a7e,
    0xb78785, 0xb7748d, 0xb76196, 0xb74ea0, 0xb73bab, 0xb728b7, 0xb715c4, 0xb702d2,
    0xb6efe1, 0xb6dcf1, 0xb6ca01, 0xb6b713, 0xb6a426, 0xb6913a, 0xb67e4e, 0xb66b64,
    0xb6587b, 0xb64592, 0xb632ab, 0xb61fc4, 0xb60cdf, 0xb5f9fa, 0xb5e717, 0xb5d434,
    0xb5c153, 0xb5ae72, 0xb59b92, 0xb588b4, 0xb575d6, 0xb562f9, 0xb5501d, 0xb53d42,
    0xb52a68, 0xb5178f, 0xb504b7, 0xb4f1e0, 0xb4df0a, 0xb4cc35, 0xb4b961, 0xb4a68e,
    0xb493bc, 0xb480ea, 0xb46e1a, 0xb45b4b, 0xb4487c, 0xb435af, 0xb422e2, 0xb41017,
    0xb3fd4c, 0xb3ea83, 0xb3d7ba, 0xb3c4f2, 0xb3b22b, 0xb39f66, 0xb38ca1, 0xb379dd,
    0xb3671a, 0xb35458, 0xb34197, 0xb32ed7, 0xb31c18, 0xb3095a, 0xb2f69c, 0xb2e3e0,
    0xb2d125, 0xb2be6a, 0xb2abb1, 0xb298f8, 0xb28641, 0xb2738a, 0xb260d5, 0xb24e20,
    0xb23b6c, 0xb228b9, 0xb21608, 0xb20357, 0xb1f0a7, 0xb1ddf8, 0xb1cb4a, 0xb1b89d,
    0xb1a5f0, 0xb19345, 0xb1809b, 0xb16df2, 0xb15b49, 0xb148a2, 0xb135fb, 0xb12356,
    0xb110b1, 0xb0fe0d, 0xb0eb6b, 0xb0d8c9, 0xb0c628, 0xb0b388, 0xb0a0e9, 0xb08e4b,
    0xb07bae, 0xb06912, 0xb05676, 0xb043dc, 0xb03143, 0xb01eaa, 0xb00c13, 0xaff97c,
    0xafe6e7, 0xafd452, 0xafc1be, 0xafaf2b, 0xaf9c99, 0xaf8a08, 0xaf7778, 0xaf64e9,
    0xaf525b, 0xaf3fce, 0xaf2d42, 0xaf1ab6, 0xaf082c, 0xaef5a2, 0xaee31a, 0xaed092,
    0xaebe0c, 0xaeab86, 0xae9901, 0xae867d, 0xae73fa, 0xae6178, 0xae4ef7, 0xae3c77,
    0xae29f7, 0xae1779, 0xae04fb, 0xadf27f, 0xade003, 0xadcd89, 0xadbb0f, 0xada896,
    0xad961e, 0xad83a7, 0xad7131, 0xad5ebc, 0xad4c48, 0xad39d5, 0xad2762, 0xad14f1,
    0xad0280, 0xacf011, 0xacdda2, 0xaccb34, 0xacb8c8, 0xaca65c, 0xac93f1, 0xac8187,
    0xac6f1d, 0xac5cb5, 0xac4a4e, 0xac37e8, 0xac2582, 0xac131d, 0xac00ba, 0xabee57,
    0xabdbf5, 0xabc994, 0xabb734, 0xaba4d5, 0xab9277, 0xab801a, 0xab6dbd, 0xab5b62,
    0xab4908, 0xab36ae, 0xab2455, 0xab11fd, 0xaaffa7, 0xaaed51, 0xaadafc, 0xaac8a7,
    0xaab654, 0xaaa402, 0xaa91b0, 0xaa7f60, 0xaa6d10, 0xaa5ac2, 0xaa4874, 0xaa3627,
    0xaa23db, 0xaa1190, 0xa9ff46, 0xa9ecfd, 0xa9dab4, 0xa9c86d, 0xa9b626, 0xa9a3e1,
    0xa9919c, 0xa97f58, 0xa96d15, 0xa95ad3, 0xa94892, 0xa93652, 0xa92413, 0xa911d4,
    0xa8ff97, 0xa8ed5a, 0xa8db1e, 0xa8c8e3, 0xa8b6aa, 0xa8a471, 0xa89238, 0xa88001,
    0xa86dcb, 0xa85b95, 0xa84961, 0xa8372d, 0xa824fb, 0xa812c9, 0xa80098, 0xa7ee68,
    0xa7dc39, 0xa7ca0a, 0xa7b7dd, 0xa7a5b1, 0xa79385, 0xa7815a, 0xa76f31, 0xa75d08,
    0xa74ae0, 0xa738b9, 0xa72692, 0xa7146d, 0xa70249, 0xa6f025, 0xa6de03, 0xa6cbe1,
    0xa6b9c0, 0xa6a7a0, 0xa69581, 0xa68363, 0xa67145, 0xa65f29, 0xa64d0d, 0xa63af3,
    0xa628d9, 0xa616c0, 0xa604a8, 0xa5f291, 0xa5e07b, 0xa5ce66, 0xa5bc51, 0xa5aa3e,
    0xa5982b, 0xa58619, 0xa57408, 0xa561f8, 0xa54fe9, 0xa53ddb, 0xa52bcd, 0xa519c1,
    0xa507b5, 0xa4f5ab, 0xa4e3a1, 0xa4d198, 0xa4bf90, 0xa4ad89, 0xa49b82, 0xa4897d,
    0xa47778, 0xa46575, 0xa45372, 0xa44170, 0xa42f6f, 0xa41d6f, 0xa40b6f, 0xa3f971,
    0xa3e773, 0xa3d577, 0xa3c37b, 0xa3b180, 0xa39f86, 0xa38d8d, 0xa37b95, 0xa3699d,
    0xa357a7, 0xa345b1, 0xa333bc, 0xa321c8, 0xa30fd5, 0xa2fde3, 0xa2ebf2, 0xa2da01,
    0xa2c812, 0xa2b623, 0xa2a435, 0xa29248, 0xa2805c, 0xa26e71, 0xa25c87, 0xa24a9d,
    0xa238b5, 0xa226cd, 0xa214e6, 0xa20300, 0xa1f11b, 0xa1df37, 0xa1cd53, 0xa1bb71,
    0xa1a98f, 0xa197ae, 0xa185ce, 0xa173ef, 0xa16211, 0xa15034, 0xa13e57, 0xa12c7c,
    0xa11aa1, 0xa108c7, 0xa0f6ee, 0xa0e516, 0xa0d33e, 0xa0c168, 0xa0af92, 0xa09dbe,
    0xa08bea, 0xa07a17, 0xa06845, 0xa05673, 0xa044a3, 0xa032d3, 0xa02105, 0xa00f37,
    0x9ffd6a, 0x9feb9e, 0x9fd9d3, 0x9fc808, 0x9fb63f, 0x9fa476, 0x9f92ae, 0x9f80e7,
    0x9f6f21, 0x9f5d5c, 0x9f4b97, 0x9f39d4, 0x9f2811, 0x9f164f, 0x9f048e, 0x9ef2ce,
    0x9ee10f, 0x9ecf50, 0x9ebd93, 0x9eabd6, 0x9e9a1a, 0x9e885f, 0x9e76a5, 0x9e64eb,
    0x9e5333, 0x9e417b, 0x9e2fc5, 0x9e1e0f, 0x9e0c5a, 0x9dfaa5, 0x9de8f2, 0x9dd73f,
    0x9dc58e, 0x9db3dd, 0x9da22d, 0x9d907e, 0x9d7ecf, 0x9d6d22, 0x9d5b75, 0x9d49ca,
    0x9d381f, 0x9d2675, 0x9d14cb, 0x9d0323, 0x9cf17b, 0x9cdfd5, 0x9cce2f, 0x9cbc8a,
    0x9caae6, 0x9c9942, 0x9c87a0, 0x9c75fe, 0x9c645d, 0x9c52bd, 0x9c411e, 0x9c2f80,
    0x9c1de3, 0x9c0c46, 0x9bfaaa, 0x9be90f, 0x9bd775, 0x9bc5dc, 0x9bb444, 0x9ba2ac,
    0x9b9115, 0x9b7f7f, 0x9b6dea, 0x9b5c56, 0x9b4ac3, 0x9b3930, 0x9b279f, 0x9b160e,
    0x9b047e, 0x9af2ee, 0x9ae160, 0x9acfd3, 0x9abe46, 0x9aacba, 0x9a9b2f, 0x9a89a5,
    0x9a781b, 0x9a6693, 0x9a550b, 0x9a4384, 0x9a31fe, 0x9a2079, 0x9a0ef5, 0x99fd71,
    0x99ebee, 0x99da6d, 0x99c8ec, 0x99b76b, 0x99a5ec, 0x99946d, 0x9982f0, 0x997173,
    0x995ff7, 0x994e7b, 0x993d01, 0x992b87, 0x991a0f, 0x990897, 0x98f71f, 0x98e5a9,
    0x98d434, 0x98c2bf, 0x98b14b, 0x989fd8, 0x988e66, 0x987cf5, 0x986b84, 0x985a15,
    0x9848a6, 0x983738, 0x9825ca, 0x98145e, 0x9802f2, 0x97f188, 0x97e01e, 0x97ceb5,
    0x97bd4c, 0x97abe5, 0x979a7e, 0x978918, 0x9777b3, 0x97664f, 0x9754ec, 0x974389,
    0x973227, 0x9720c6, 0x970f66, 0x96fe07, 0x96eca9, 0x96db4b, 0x96c9ee, 0x96b892,
    0x96a737, 0x9695dc, 0x968483, 0x96732a, 0x9661d2, 0x96507b, 0x963f25, 0x962dcf,
    0x961c7a, 0x960b26, 0x95f9d3, 0x95e881, 0x95d730, 0x95c5df, 0x95b48f, 0x95a340,
    0x9591f2, 0x9580a5, 0x956f58, 0x955e0c, 0x954cc1, 0x953b77, 0x952a2e, 0x9518e5,
    0x95079e, 0x94f657, 0x94e511, 0x94d3cb, 0x94c287, 0x94b143, 0x94a000, 0x948ebe,
    0x947d7d, 0x946c3c, 0x945afd, 0x9449be, 0x943880, 0x942743, 0x941606, 0x9404cb,
    0x93f390, 0x93e256, 0x93d11d, 0x93bfe4, 0x93aeac, 0x939d76, 0x938c40, 0x937b0a,
    0x9369d6, 0x9358a2, 0x934770, 0x93363e, 0x93250c, 0x9313dc, 0x9302ac, 0x92f17e,
    0x92e050, 0x92cf22, 0x92bdf6, 0x92acca, 0x929ba0, 0x928a76, 0x92794c, 0x926824,
    0x9256fc, 0x9245d6, 0x9234b0, 0x92238a, 0x921266, 0x920142, 0x91f01f, 0x91defd,
    0x91cddc, 0x91bcbc, 0x91ab9c, 0x919a7d, 0x91895f, 0x917842, 0x916725, 0x91560a,
    0x9144ef, 0x9133d4, 0x9122bb, 0x9111a3, 0x91008b, 0x90ef74, 0x90de5e, 0x90cd48,
    0x90bc34, 0x90ab20, 0x909a0d, 0x9088fb, 0x9077e9, 0x9066d9, 0x9055c9, 0x9044ba,
    0x9033ac, 0x90229e, 0x901191, 0x900086, 0x8fef7a, 0x8fde70, 0x8fcd67, 0x8fbc5e,
    0x8fab56, 0x8f9a4f, 0x8f8948, 0x8f7843, 0x8f673e, 0x8f563a, 0x8f4536, 0x8f3434,
    0x8f2332, 0x8f1231, 0x8f0131, 0x8ef032, 0x8edf33, 0x8ece35, 0x8ebd38, 0x8eac3c,
    0x8e9b41, 0x8e8a46, 0x8e794c, 0x8e6853, 0x8e575b, 0x8e4663, 0x8e356c, 0x8e2477,
    0x8e1381, 0x8e028d, 0x8df199, 0x8de0a6, 0x8dcfb4, 0x8dbec3, 0x8dadd2, 0x8d9ce3,
    0x8d8bf4, 0x8d7b05, 0x8d6a18, 0x8d592b, 0x8d483f, 0x8d3754, 0x8d266a, 0x8d1580,
    0x8d0498, 0x8cf3b0, 0x8ce2c8, 0x8cd1e2, 0x8cc0fc, 0x8cb017, 0x8c9f33, 0x8c8e50,
    0x8c7d6d, 0x8c6c8b, 0x8c5baa, 0x8c4aca, 0x8c39eb, 0x8c290c, 0x8c182e, 0x8c0751,
    0x8bf674, 0x8be598, 0x8bd4be, 0x8bc3e3, 0x8bb30a, 0x8ba232, 0x8b915a, 0x8b8083,
    0x8b6fac, 0x8b5ed7, 0x8b4e02, 0x8b3d2e, 0x8b2c5b, 0x8b1b88, 0x8b0ab7, 0x8af9e6,
    0x8ae916, 0x8ad846, 0x8ac778, 0x8ab6aa, 0x8aa5dd, 0x8a9510, 0x8a8445, 0x8a737a,
    0x8a62b0, 0x8a51e7, 0x8a411e, 0x8a3056, 0x8a1f8f, 0x8a0ec9, 0x89fe04, 0x89ed3f,
    0x89dc7b, 0x89cbb8, 0x89baf6, 0x89aa34, 0x899973, 0x8988b3, 0x8977f3, 0x896735,
    0x895677, 0x8945ba, 0x8934fe, 0x892442, 0x891387, 0x8902cd, 0x88f214, 0x88e15b,
    0x88d0a3, 0x88bfec, 0x88af36, 0x889e80, 0x888dcc, 0x887d18, 0x886c64, 0x885bb2,
    0x884b00, 0x883a4f, 0x88299f, 0x8818ef, 0x880841, 0x87f793, 0x87e6e5, 0x87d639,
    0x87c58d, 0x87b4e2, 0x87a438, 0x87938f, 0x8782e6, 0x87723e, 0x876197, 0x8750f0,
    0x87404b, 0x872fa6, 0x871f01, 0x870e5e, 0x86fdbb, 0x86ed19, 0x86dc78, 0x86cbd8,
    0x86bb38, 0x86aa99, 0x8699fb, 0x86895d, 0x8678c0, 0x866824, 0x865789, 0x8646ef,
    0x863655, 0x8625bc, 0x861524, 0x86048c, 0x85f3f5, 0x85e35f, 0x85d2ca, 0x85c236,
    0x85b1a2, 0x85a10f, 0x85907d, 0x857feb, 0x856f5a, 0x855eca, 0x854e3b, 0x853dac,
    0x852d1e, 0x851c91, 0x850c05, 0x84fb79, 0x84eaee, 0x84da64, 0x84c9db, 0x84b952,
    0x84a8ca, 0x849843, 0x8487bd, 0x847737, 0x8466b2, 0x84562e, 0x8445aa, 0x843528,
    0x8424a6, 0x841424, 0x8403a4, 0x83f324, 0x83e2a5, 0x83d227, 0x83c1a9, 0x83b12c,
    0x83a0b0, 0x839035, 0x837fba, 0x836f40, 0x835ec7, 0x834e4f, 0x833dd7, 0x832d60,
    0x831cea, 0x830c74, 0x82fc00, 0x82eb8c, 0x82db18, 0x82caa6, 0x82ba34, 0x82a9c3,
    0x829952, 0x8288e3, 0x827874, 0x826806, 0x825798, 0x82472c, 0x8236c0, 0x822654,
    0x8215ea, 0x820580, 0x81f517, 0x81e4af, 0x81d447, 0x81c3e0, 0x81b37a, 0x81a315,
    0x8192b0, 0x81824c, 0x8171e9, 0x816186, 0x815124, 0x8140c3, 0x813063, 0x812003,
    0x810fa5, 0x80ff46, 0x80eee9, 0x80de8c, 0x80ce30, 0x80bdd5, 0x80ad7b, 0x809d21,
    0x808cc8, 0x807c6f, 0x806c18, 0x805bc1, 0x804b6b, 0x803b15, 0x802ac0, 0x801a6c,
    0x800a19, 0x7ff9c7, 0x7fe975, 0x7fd924, 0x7fc8d3, 0x7fb883, 0x7fa834, 0x7f97e6,
    0x7f8799, 0x7f774c, 0x7f6700, 0x7f56b4, 0x7f466a, 0x7f3620, 0x7f25d7, 0x7f158e,
    0x7f0546, 0x7ef4ff, 0x7ee4b9, 0x7ed473, 0x7ec42e, 0x7eb3ea, 0x7ea3a7, 0x7e9364,
    0x7e8322, 0x7e72e0, 0x7e62a0, 0x7e5260, 0x7e4221, 0x7e31e2, 0x7e21a5, 0x7e1167,
    0x7e012b, 0x7df0f0, 0x7de0b5, 0x7dd07a, 0x7dc041, 0x7db008, 0x7d9fd0, 0x7d8f99,
    0x7d7f62, 0x7d6f2c, 0x7d5ef7, 0x7d4ec3, 0x7d3e8f, 0x7d2e5c, 0x7d1e29, 0x7d0df8,
    0x7cfdc7, 0x7ced96, 0x7cdd67, 0x7ccd38, 0x7cbd0a, 0x7cacdd, 0x7c9cb0, 0x7c8c84,
    0x7c7c59, 0x7c6c2e, 0x7c5c04, 0x7c4bdb, 0x7c3bb3, 0x7c2b8b, 0x7c1b64, 0x7c0b3e,
    0x7bfb18, 0x7beaf3, 0x7bdacf, 0x7bcaab, 0x7bba88, 0x7baa66, 0x7b9a45, 0x7b8a24,
    0x7b7a04, 0x7b69e5, 0x7b59c7, 0x7b49a9, 0x7b398b, 0x7b296f, 0x7b1953, 0x7b0938,
    0x7af91e, 0x7ae904, 0x7ad8eb, 0x7ac8d3, 0x7ab8bb, 0x7aa8a5, 0x7a988e, 0x7a8879,
    0x7a7864, 0x7a6850, 0x7a583d, 0x7a482a, 0x7a3818, 0x7a2807, 0x7a17f6, 0x7a07e7,
    0x79f7d7, 0x79e7c9, 0x79d7bb, 0x79c7ae, 0x79b7a2, 0x79a796, 0x79978b, 0x798781,
    0x797777, 0x79676e, 0x795766, 0x79475f, 0x793758, 0x792752, 0x79174d, 0x790748,
    0x78f744, 0x78e741, 0x78d73e, 0x78c73c, 0x78b73b, 0x78a73a, 0x78973a, 0x78873b,
    0x78773d, 0x78673f, 0x785742, 0x784745, 0x78374a, 0x78274f, 0x781754, 0x78075b,
    0x77f762, 0x77e76a, 0x77d772, 0x77c77b, 0x77b785, 0x77a790, 0x77979b, 0x7787a7,
    0x7777b3, 0x7767c1, 0x7757cf, 0x7747dd, 0x7737ed, 0x7727fd, 0x77180d, 0x77081f,
    0x76f831, 0x76e844, 0x76d857, 0x76c86b, 0x76b880, 0x76a896, 0x7698ac, 0x7688c3,
    0x7678da, 0x7668f3, 0x76590c, 0x764925, 0x763940, 0x76295b, 0x761976, 0x760993,
    0x75f9b0, 0x75e9cd, 0x75d9ec, 0x75ca0b, 0x75ba2b, 0x75aa4b, 0x759a6c, 0x758a8e,
    0x757ab1, 0x756ad4, 0x755af8, 0x754b1c, 0x753b42, 0x752b68, 0x751b8e, 0x750bb5,
    0x74fbdd, 0x74ec06, 0x74dc2f, 0x74cc59, 0x74bc84, 0x74acaf, 0x749cdb, 0x748d08,
    0x747d35, 0x746d64, 0x745d92, 0x744dc2, 0x743df2, 0x742e23, 0x741e54, 0x740e86,
    0x73feb9, 0x73eeec, 0x73df21, 0x73cf55, 0x73bf8b, 0x73afc1, 0x739ff8, 0x739030,
    0x738068, 0x7370a1, 0x7360da, 0x735114, 0x73414f, 0x73318b, 0x7321c7, 0x731204,
    0x730242, 0x72f280, 0x72e2bf, 0x72d2ff, 0x72c33f, 0x72b380, 0x72a3c1, 0x729404,
    0x728447, 0x72748a, 0x7264cf, 0x725514, 0x724559, 0x7235a0, 0x7225e7, 0x72162e,
    0x720677, 0x71f6c0, 0x71e709, 0x71d754, 0x71c79f, 0x71b7ea, 0x71a837, 0x719884,
    0x7188d1, 0x717920, 0x71696f, 0x7159be, 0x714a0f, 0x713a60, 0x712ab1, 0x711b04,
    0x710b57, 0x70fbaa, 0x70ebff, 0x70dc54, 0x70cca9, 0x70bd00, 0x70ad57, 0x709dae,
    0x708e07, 0x707e5f, 0x706eb9, 0x705f13, 0x704f6e, 0x703fca, 0x703026, 0x702083,
    0x7010e1, 0x70013f, 0x6ff19e, 0x6fe1fe, 0x6fd25e, 0x6fc2bf, 0x6fb320, 0x6fa383,
    0x6f93e6, 0x6f8449, 0x6f74ad, 0x6f6512, 0x6f5578, 0x6f45de, 0x6f3645, 0x6f26ac,
    0x6f1715, 0x6f077d, 0x6ef7e7, 0x6ee851, 0x6ed8bc, 0x6ec927, 0x6eb994, 0x6eaa00,
    0x6e9a6e, 0x6e8adc, 0x6e7b4b, 0x6e6bba, 0x6e5c2a, 0x6e4c9b, 0x6e3d0c, 0x6e2d7e,
    0x6e1df1, 0x6e0e64, 0x6dfed8, 0x6def4d, 0x6ddfc2, 0x6dd038, 0x6dc0af, 0x6db126,
    0x6da19e, 0x6d9216, 0x6d8290, 0x6d730a, 0x6d6384, 0x6d53ff, 0x6d447b, 0x6d34f8,
    0x6d2575, 0x6d15f3, 0x6d0671, 0x6cf6f0, 0x6ce770, 0x6cd7f0, 0x6cc871, 0x6cb8f3,
    0x6ca975, 0x6c99f8, 0x6c8a7c, 0x6c7b00, 0x6c6b85, 0x6c5c0b, 0x6c4c91, 0x6c3d18,
    0x6c2d9f, 0x6c1e27, 0x6c0eb0, 0x6bff3a, 0x6befc4, 0x6be04f, 0x6bd0da, 0x6bc166,
    0x6bb1f3, 0x6ba280, 0x6b930e, 0x6b839d, 0x6b742c, 0x6b64bc, 0x6b554d, 0x6b45de,
    0x6b3670, 0x6b2702, 0x6b1795, 0x6b0829, 0x6af8be, 0x6ae953, 0x6ad9e9, 0x6aca7f,
    0x6abb16, 0x6aabae, 0x6a9c46, 0x6a8cdf, 0x6a7d78, 0x6a6e13, 0x6a5eae, 0x6a4f49,
    0x6a3fe5, 0x6a3082, 0x6a2120, 0x6a11be, 0x6a025c, 0x69f2fc, 0x69e39c, 0x69d43c,
    0x69c4de, 0x69b580, 0x69a622, 0x6996c5, 0x698769, 0x69780e, 0x6968b3, 0x695958,
    0x6949ff, 0x693aa6, 0x692b4e, 0x691bf6, 0x690c9f, 0x68fd48, 0x68edf3, 0x68de9d,
    0x68cf49, 0x68bff5, 0x68b0a2, 0x68a14f, 0x6891fd, 0x6882ac, 0x68735b, 0x68640b,
    0x6854bc, 0x68456d, 0x68361f, 0x6826d1, 0x681784, 0x680838, 0x67f8ed, 0x67e9a2,
    0x67da57, 0x67cb0e, 0x67bbc4, 0x67ac7c, 0x679d34, 0x678ded, 0x677ea6, 0x676f60,
    0x67601b, 0x6750d7, 0x674192, 0x67324f, 0x67230c, 0x6713ca, 0x670489, 0x66f548,
    0x66e608, 0x66d6c8, 0x66c789, 0x66b84b, 0x66a90d, 0x6699d0, 0x668a93, 0x667b57,
    0x666c1c, 0x665ce2, 0x664da8, 0x663e6e, 0x662f36, 0x661ffd, 0x6610c6, 0x66018f,
    0x65f259, 0x65e323, 0x65d3ee, 0x65c4ba, 0x65b586, 0x65a653, 0x659721, 0x6587ef,
    0x6578be, 0x65698d, 0x655a5d, 0x654b2e, 0x653bff, 0x652cd1, 0x651da4, 0x650e77,
    0x64ff4b, 0x64f01f, 0x64e0f4, 0x64d1ca, 0x64c2a0, 0x64b377, 0x64a44f, 0x649527,
    0x648600, 0x6476d9, 0x6467b3, 0x64588e, 0x644969, 0x643a45, 0x642b21, 0x641bfe,
    0x640cdc, 0x63fdbb, 0x63ee9a, 0x63df79, 0x63d059, 0x63c13a, 0x63b21c, 0x63a2fe,
    0x6393e0, 0x6384c4, 0x6375a8, 0x63668c, 0x635771, 0x634857, 0x63393e, 0x632a25,
    0x631b0c, 0x630bf5, 0x62fcdd, 0x62edc7, 0x62deb1, 0x62cf9c, 0x62c087, 0x62b173,
    0x62a260, 0x62934d, 0x62843b, 0x627529, 0x626618, 0x625708, 0x6247f8, 0x6238e9,
    0x6229da, 0x621acc, 0x620bbf, 0x61fcb3, 0x61eda6, 0x61de9b, 0x61cf90, 0x61c086,
    0x61b17c, 0x61a273, 0x61936b, 0x618463, 0x61755c, 0x616655, 0x615750, 0x61484a,
    0x613946, 0x612a41, 0x611b3e, 0x610c3b, 0x60fd39, 0x60ee37, 0x60df36, 0x60d036,
    0x60c136, 0x60b237, 0x60a338, 0x60943a, 0x60853c, 0x607640, 0x606744, 0x605848,
    0x60494d, 0x603a53, 0x602b59, 0x601c60, 0x600d67, 0x5ffe6f, 0x5fef78, 0x5fe081,
    0x5fd18b, 0x5fc296, 0x5fb3a1, 0x5fa4ac, 0x5f95b9, 0x5f86c6, 0x5f77d3, 0x5f68e1,
    0x5f59f0, 0x5f4aff, 0x5f3c0f, 0x5f2d20, 0x5f1e31, 0x5f0f43, 0x5f0055, 0x5ef168,
    0x5ee27c, 0x5ed390, 0x5ec4a4, 0x5eb5ba, 0x5ea6d0, 0x5e97e6, 0x5e88fe, 0x5e7a15,
    0x5e6b2e, 0x5e5c47, 0x5e4d60, 0x5e3e7a, 0x5e2f95, 0x5e20b1, 0x5e11cd, 0x5e02e9,
    0x5df406, 0x5de524, 0x5dd643, 0x5dc761, 0x5db881, 0x5da9a1, 0x5d9ac2, 0x5d8be3,
    0x5d7d05, 0x5d6e28, 0x5d5f4b, 0x5d506f, 0x5d4193, 0x5d32b8, 0x5d23de, 0x5d1504,
    0x5d062b, 0x5cf752, 0x5ce87a, 0x5cd9a3, 0x5ccacc, 0x5cbbf5, 0x5cad20, 0x5c9e4b,
    0x5c8f76, 0x5c80a2, 0x5c71cf, 0x5c62fc, 0x5c542a, 0x5c4559, 0x5c3688, 0x5c27b8,
    0x5c18e8, 0x5c0a19, 0x5bfb4a, 0x5bec7c, 0x5bddaf, 0x5bcee2, 0x5bc016, 0x5bb14b,
    0x5ba280, 0x5b93b5, 0x5b84eb, 0x5b7622, 0x5b675a, 0x5b5892, 0x5b49ca, 0x5b3b03,
    0x5b2c3d, 0x5b1d77, 0x5b0eb2, 0x5affee, 0x5af12a, 0x5ae267, 0x5ad3a4, 0x5ac4e2,
    0x5ab621, 0x5aa760, 0x5a989f, 0x5a89e0, 0x5a7b20, 0x5a6c62, 0x5a5da4, 0x5a4ee6,
    0x5a402a, 0x5a316d, 0x5a22b2, 0x5a13f7, 0x5a053c, 0x59f682, 0x59e7c9, 0x59d910,
    0x59ca58, 0x59bba1, 0x59acea, 0x599e34, 0x598f7e, 0x5980c9, 0x597214, 0x596360,
    0x5954ad, 0x5945fa, 0x593748, 0x592896, 0x5919e5, 0x590b34, 0x58fc84, 0x58edd5,
    0x58df26, 0x58d078, 0x58c1cb, 0x58b31e, 0x58a471, 0x5895c5, 0x58871a, 0x587870,
    0x5869c5, 0x585b1c, 0x584c73, 0x583dcb, 0x582f23, 0x58207c, 0x5811d5, 0x58032f,
    0x57f48a, 0x57e5e5, 0x57d741, 0x57c89d, 0x57b9fa, 0x57ab57, 0x579cb5, 0x578e14,
    0x577f73, 0x5770d3, 0x576233, 0x575394, 0x5744f6, 0x573658, 0x5727bb, 0x57191e,
    0x570a82, 0x56fbe6, 0x56ed4b, 0x56deb1, 0x56d017, 0x56c17e, 0x56b2e5, 0x56a44d,
    0x5695b5, 0x56871e, 0x567888, 0x5669f2, 0x565b5d, 0x564cc8, 0x563e34, 0x562fa1,
    0x56210e, 0x56127b, 0x5603ea, 0x55f559, 0x55e6c8, 0x55d838, 0x55c9a8, 0x55bb19,
    0x55ac8b, 0x559dfd, 0x558f70, 0x5580e4, 0x557257, 0x5563cc, 0x555541, 0x5546b7,
    0x55382d, 0x5529a4, 0x551b1b, 0x550c93, 0x54fe0c, 0x54ef85, 0x54e0ff, 0x54d279,
    0x54c3f4, 0x54b56f, 0x54a6eb, 0x549868, 0x5489e5, 0x547b62, 0x546ce1, 0x545e5f,
    0x544fdf, 0x54415f, 0x5432df, 0x542460, 0x5415e2, 0x540764, 0x53f8e7, 0x53ea6a,
    0x53dbee, 0x53cd73, 0x53bef8, 0x53b07d, 0x53a204, 0x53938a, 0x538512, 0x53769a,
    0x536822, 0x5359ab, 0x534b35, 0x533cbf, 0x532e4a, 0x531fd5, 0x531161, 0x5302ed,
    0x52f47a, 0x52e608, 0x52d796, 0x52c925, 0x52bab4, 0x52ac44, 0x529dd4, 0x528f65,
    0x5280f7, 0x527289, 0x52641b, 0x5255af, 0x524742, 0x5238d7, 0x522a6c, 0x521c01,
    0x520d97, 0x51ff2e, 0x51f0c5, 0x51e25d, 0x51d3f5, 0x51c58e, 0x51b727, 0x51a8c1,
    0x519a5c, 0x518bf7, 0x517d92, 0x516f2e, 0x5160cb, 0x515269, 0x514406, 0x5135a5,
    0x512744, 0x5118e3, 0x510a84, 0x50fc24, 0x50edc5, 0x50df67, 0x50d10a, 0x50c2ad,
    0x50b450, 0x50a5f4, 0x509799, 0x50893e, 0x507ae3, 0x506c8a, 0x505e31, 0x504fd8,
    0x504180, 0x503328, 0x5024d1, 0x50167b, 0x500825, 0x4ff9d0, 0x4feb7b, 0x4fdd27,
    0x4fced3, 0x4fc080, 0x4fb22e, 0x4fa3dc, 0x4f958b, 0x4f873a, 0x4f78e9, 0x4f6a9a,
    0x4f5c4a, 0x4f4dfc, 0x4f3fae, 0x4f3160, 0x4f2313, 0x4f14c7, 0x4f067b, 0x4ef830,
    0x4ee9e5, 0x4edb9b, 0x4ecd51, 0x4ebf08, 0x4eb0c0, 0x4ea278, 0x4e9430, 0x4e85e9,
    0x4e77a3, 0x4e695d, 0x4e5b18, 0x4e4cd3, 0x4e3e8f, 0x4e304c, 0x4e2209, 0x4e13c6,
    0x4e0584, 0x4df743, 0x4de902, 0x4ddac2, 0x4dcc82, 0x4dbe43, 0x4db004, 0x4da1c6,
    0x4d9389, 0x4d854c, 0x4d770f, 0x4d68d4, 0x4d5a98, 0x4d4c5d, 0x4d3e23, 0x4d2fea,
    0x4d21b0, 0x4d1378, 0x4d0540, 0x4cf708, 0x4ce8d1, 0x4cda9b, 0x4ccc65, 0x4cbe30,
    0x4caffb, 0x4ca1c7, 0x4c9393, 0x4c8560, 0x4c772d, 0x4c68fb, 0x4c5aca, 0x4c4c99,
    0x4c3e69, 0x4c3039, 0x4c220a, 0x4c13db, 0x4c05ad, 0x4bf77f, 0x4be952, 0x4bdb25,
    0x4bccf9, 0x4bbece, 0x4bb0a3, 0x4ba278, 0x4b944f, 0x4b8625, 0x4b77fc, 0x4b69d4,
    0x4b5bad, 0x4b4d85, 0x4b3f5f, 0x4b3139, 0x4b2313, 0x4b14ee, 0x4b06ca, 0x4af8a6,
    0x4aea83, 0x4adc60, 0x4ace3d, 0x4ac01c, 0x4ab1fb, 0x4aa3da, 0x4a95ba, 0x4a879a,
    0x4a797b, 0x4a6b5d, 0x4a5d3f, 0x4a4f21, 0x4a4105, 0x4a32e8, 0x4a24cc, 0x4a16b1,
    0x4a0896, 0x49fa7c, 0x49ec63, 0x49de4a, 0x49d031, 0x49c219, 0x49b401, 0x49a5eb,
    0x4997d4, 0x4989be, 0x497ba9, 0x496d94, 0x495f80, 0x49516c, 0x494359, 0x493546,
    0x492734, 0x491923, 0x490b12, 0x48fd01, 0x48eef1, 0x48e0e2, 0x48d2d3, 0x48c4c4,
    0x48b6b7, 0x48a8a9, 0x489a9c, 0x488c90, 0x487e85, 0x487079, 0x48626f, 0x485465,
    0x48465b, 0x483852, 0x482a4a, 0x481c42, 0x480e3a, 0x480033, 0x47f22d, 0x47e427,
    0x47d622, 0x47c81d, 0x47ba19, 0x47ac15, 0x479e12, 0x47900f, 0x47820d, 0x47740c,
    0x47660b, 0x47580a, 0x474a0a, 0x473c0b, 0x472e0c, 0x47200d, 0x471210, 0x470412,
    0x46f615, 0x46e819, 0x46da1d, 0x46cc22, 0x46be28, 0x46b02d, 0x46a234, 0x46943b,
    0x468642, 0x46784a, 0x466a53, 0x465c5c, 0x464e65, 0x46406f, 0x46327a, 0x462485,
    0x461691, 0x46089d, 0x45faa9, 0x45ecb7, 0x45dec4, 0x45d0d3, 0x45c2e2, 0x45b4f1,
    0x45a701, 0x459911, 0x458b22, 0x457d34, 0x456f46, 0x456158, 0x45536b, 0x45457f,
    0x453793, 0x4529a7, 0x451bbc, 0x450dd2, 0x44ffe8, 0x44f1ff, 0x44e416, 0x44d62e,
    0x44c846, 0x44ba5f, 0x44ac78, 0x449e92, 0x4490ac, 0x4482c7, 0x4474e3, 0x4466ff,
    0x44591b, 0x444b38, 0x443d56, 0x442f74, 0x442192, 0x4413b1, 0x4405d1, 0x43f7f1,
    0x43ea11, 0x43dc33, 0x43ce54, 0x43c076, 0x43b299, 0x43a4bc, 0x4396e0, 0x438904,
    0x437b29, 0x436d4f, 0x435f74, 0x43519b, 0x4343c2, 0x4335e9, 0x432811, 0x431a39,
    0x430c62, 0x42fe8c, 0x42f0b6, 0x42e2e0, 0x42d50b, 0x42c737, 0x42b963, 0x42ab8f,
    0x429dbc, 0x428fea, 0x428218, 0x427447, 0x426676, 0x4258a6, 0x424ad6, 0x423d06,
    0x422f38, 0x422169, 0x42139c, 0x4205ce, 0x41f802, 0x41ea36, 0x41dc6a, 0x41ce9f,
    0x41c0d4, 0x41b30a, 0x41a540, 0x419777, 0x4189af, 0x417be6, 0x416e1f, 0x416058,
    0x415291, 0x4144cb, 0x413706, 0x412941, 0x411b7c, 0x410db8, 0x40fff5, 0x40f232,
    0x40e46f, 0x40d6ae, 0x40c8ec, 0x40bb2b, 0x40ad6b, 0x409fab, 0x4091ec, 0x40842d,
    0x40766e, 0x4068b1, 0x405af3, 0x404d36, 0x403f7a, 0x4031be, 0x402403, 0x401648,
    0x40088e, 0x3ffad4, 0x3fed1b, 0x3fdf62, 0x3fd1aa, 0x3fc3f3, 0x3fb63b, 0x3fa885,
    0x3f9ace, 0x3f8d19, 0x3f7f64, 0x3f71af, 0x3f63fb, 0x3f5647, 0x3f4894, 0x3f3ae2,
    0x3f2d2f, 0x3f1f7e, 0x3f11cd, 0x3f041c, 0x3ef66c, 0x3ee8bc, 0x3edb0d, 0x3ecd5f,
    0x3ebfb1, 0x3eb203, 0x3ea456, 0x3e96aa, 0x3e88fe, 0x3e7b52, 0x3e6da7, 0x3e5ffd,
    0x3e5253, 0x3e44a9, 0x3e3700, 0x3e2958, 0x3e1bb0, 0x3e0e08, 0x3e0061, 0x3df2bb,
    0x3de515, 0x3dd76f, 0x3dc9ca, 0x3dbc26, 0x3dae82, 0x3da0df, 0x3d933c, 0x3d8599,
    0x3d77f7, 0x3d6a56, 0x3d5cb5, 0x3d4f15, 0x3d4175, 0x3d33d5, 0x3d2636, 0x3d1898,
    0x3d0afa, 0x3cfd5d, 0x3cefc0, 0x3ce223, 0x3cd487, 0x3cc6ec, 0x3cb951, 0x3cabb7,
    0x3c9e1d, 0x3c9083, 0x3c82ea, 0x3c7552, 0x3c67ba, 0x3c5a23, 0x3c4c8c, 0x3c3ef5,
    0x3c3160, 0x3c23ca, 0x3c1635, 0x3c08a1, 0x3bfb0d, 0x3bed7a, 0x3bdfe7, 0x3bd254,
    0x3bc4c2, 0x3bb731, 0x3ba9a0, 0x3b9c10, 0x3b8e80, 0x3b80f0, 0x3b7361, 0x3b65d3,
    0x3b5845, 0x3b4ab8, 0x3b3d2b, 0x3b2f9e, 0x3b2212, 0x3b1487, 0x3b06fc, 0x3af972,
    0x3aebe8, 0x3ade5e, 0x3ad0d5, 0x3ac34d, 0x3ab5c5, 0x3aa83d, 0x3a9ab6, 0x3a8d30,
    0x3a7faa, 0x3a7225, 0x3a64a0, 0x3a571b, 0x3a4997, 0x3a3c14, 0x3a2e91, 0x3a210e,
    0x3a138c, 0x3a060a, 0x39f889, 0x39eb09, 0x39dd89, 0x39d009, 0x39c28a, 0x39b50c,
    0x39a78e, 0x399a10, 0x398c93, 0x397f16, 0x39719a, 0x39641f, 0x3956a4, 0x394929,
    0x393baf, 0x392e35, 0x3920bc, 0x391343, 0x3905cb, 0x38f854, 0x38eadc, 0x38dd66,
    0x38cfef, 0x38c27a, 0x38b504, 0x38a790, 0x389a1c, 0x388ca8, 0x387f35, 0x3871c2,
    0x38644f, 0x3856de, 0x38496c, 0x383bfc, 0x382e8b, 0x38211b, 0x3813ac, 0x38063d,
    0x37f8cf, 0x37eb61, 0x37ddf4, 0x37d087, 0x37c31a, 0x37b5ae, 0x37a843, 0x379ad8,
    0x378d6d, 0x378003, 0x37729a, 0x376531, 0x3757c8, 0x374a60, 0x373cf9, 0x372f92,
    0x37222b, 0x3714c5, 0x370760, 0x36f9fa, 0x36ec96, 0x36df32, 0x36d1ce, 0x36c46b,
    0x36b708, 0x36a9a6, 0x369c44, 0x368ee3, 0x368182, 0x367422, 0x3666c2, 0x365963,
    0x364c04, 0x363ea6, 0x363148, 0x3623eb, 0x36168e, 0x360931, 0x35fbd5, 0x35ee7a,
    0x35e11f, 0x35d3c5, 0x35c66b, 0x35b911, 0x35abb8, 0x359e60, 0x359107, 0x3583b0,
    0x357659, 0x356902, 0x355bac, 0x354e56, 0x354101, 0x3533ad, 0x352658, 0x351905,
    0x350bb1, 0x34fe5f, 0x34f10c, 0x34e3bb, 0x34d669, 0x34c919, 0x34bbc8, 0x34ae78,
    0x34a129, 0x3493da, 0x34868c, 0x34793e, 0x346bf0, 0x345ea3, 0x345157, 0x34440b,
    0x3436bf, 0x342974, 0x341c29, 0x340edf, 0x340196, 0x33f44c, 0x33e704, 0x33d9bc,
    0x33cc74, 0x33bf2d, 0x33b1e6, 0x33a49f, 0x33975a, 0x338a14, 0x337ccf, 0x336f8b,
    0x336247, 0x335504, 0x3347c1, 0x333a7e, 0x332d3c, 0x331ffb, 0x3312ba, 0x330579,
    0x32f839, 0x32eaf9, 0x32ddba, 0x32d07b, 0x32c33d, 0x32b5ff, 0x32a8c2, 0x329b85,
    0x328e49, 0x32810d, 0x3273d2, 0x326697, 0x32595d, 0x324c23, 0x323ee9, 0x3231b0,
    0x322478, 0x321740, 0x320a08, 0x31fcd1, 0x31ef9a, 0x31e264, 0x31d52e, 0x31c7f9,
    0x31bac5, 0x31ad90, 0x31a05c, 0x319329, 0x3185f6, 0x3178c4, 0x316b92, 0x315e61,
    0x315130, 0x3143ff, 0x3136cf, 0x3129a0, 0x311c70, 0x310f42, 0x310214, 0x30f4e6,
    0x30e7b9, 0x30da8c, 0x30cd60, 0x30c034, 0x30b309, 0x30a5de, 0x3098b3, 0x308b8a,
    0x307e60, 0x307137, 0x30640f, 0x3056e7, 0x3049bf, 0x303c98, 0x302f71, 0x30224b,
    0x301525, 0x300800, 0x2ffadb, 0x2fedb7, 0x2fe093, 0x2fd370, 0x2fc64d, 0x2fb92b,
    0x2fac09, 0x2f9ee7, 0x2f91c6, 0x2f84a6, 0x2f7786, 0x2f6a66, 0x2f5d47, 0x2f5028,
    0x2f430a, 0x2f35ec, 0x2f28cf, 0x2f1bb2, 0x2f0e96, 0x2f017a, 0x2ef45e, 0x2ee743,
    0x2eda29, 0x2ecd0f, 0x2ebff5, 0x2eb2dc, 0x2ea5c3, 0x2e98ab, 0x2e8b94, 0x2e7e7c,
    0x2e7165, 0x2e644f, 0x2e5739, 0x2e4a24, 0x2e3d0f, 0x2e2ffb, 0x2e22e7, 0x2e15d3,
    0x2e08c0, 0x2dfbad, 0x2dee9b, 0x2de189, 0x2dd478, 0x2dc767, 0x2dba57, 0x2dad47,
    0x2da038, 0x2d9329, 0x2d861b, 0x2d790d, 0x2d6bff, 0x2d5ef2, 0x2d51e5, 0x2d44d9,
    0x2d37cd, 0x2d2ac2, 0x2d1db7, 0x2d10ad, 0x2d03a3, 0x2cf69a, 0x2ce991, 0x2cdc89,
    0x2ccf81, 0x2cc279, 0x2cb572, 0x2ca86b, 0x2c9b65, 0x2c8e5f, 0x2c815a, 0x2c7455,
    0x2c6751, 0x2c5a4d, 0x2c4d4a, 0x2c4047, 0x2c3344, 0x2c2642, 0x2c1941, 0x2c0c3f,
    0x2bff3f, 0x2bf23f, 0x2be53f, 0x2bd840, 0x2bcb41, 0x2bbe42, 0x2bb144, 0x2ba447,
    0x2b974a, 0x2b8a4d, 0x2b7d51, 0x2b7056, 0x2b635a, 0x2b5660, 0x2b4965, 0x2b3c6c,
    0x2b2f72, 0x2b2279, 0x2b1581, 0x2b0889, 0x2afb91, 0x2aee9a, 0x2ae1a4, 0x2ad4ae,
    0x2ac7b8, 0x2abac3, 0x2aadce, 0x2aa0d9, 0x2a93e5, 0x2a86f2, 0x2a79ff, 0x2a6d0d,
    0x2a601a, 0x2a5329, 0x2a4638, 0x2a3947, 0x2a2c57, 0x2a1f67, 0x2a1277, 0x2a0589,
    0x29f89a, 0x29ebac, 0x29debf, 0x29d1d1, 0x29c4e5, 0x29b7f9, 0x29ab0d, 0x299e22,
    0x299137, 0x29844c, 0x297762, 0x296a79, 0x295d90, 0x2950a7, 0x2943bf, 0x2936d8,
    0x2929f0, 0x291d09, 0x291023, 0x29033d, 0x28f658, 0x28e973, 0x28dc8e, 0x28cfaa,
    0x28c2c7, 0x28b5e3, 0x28a901, 0x289c1e, 0x288f3d, 0x28825b, 0x28757a, 0x28689a,
    0x285bba, 0x284eda, 0x2841fb, 0x28351c, 0x28283e, 0x281b60, 0x280e83, 0x2801a6,
    0x27f4ca, 0x27e7ee, 0x27db12, 0x27ce37, 0x27c15c, 0x27b482, 0x27a7a8, 0x279acf,
    0x278df6, 0x27811e, 0x277446, 0x27676e, 0x275a97, 0x274dc1, 0x2740ea, 0x273415,
    0x27273f, 0x271a6b, 0x270d96, 0x2700c2, 0x26f3ef, 0x26e71c, 0x26da49, 0x26cd77,
    0x26c0a5, 0x26b3d4, 0x26a703, 0x269a33, 0x268d63, 0x268093, 0x2673c4, 0x2666f5,
    0x265a27, 0x264d5a, 0x26408c, 0x2633bf, 0x2626f3, 0x261a27, 0x260d5c, 0x260090,
    0x25f3c6, 0x25e6fc, 0x25da32, 0x25cd69, 0x25c0a0, 0x25b3d7, 0x25a70f, 0x259a48,
    0x258d81, 0x2580ba, 0x2573f4, 0x25672e, 0x255a69, 0x254da4, 0x2540e0, 0x25341c,
    0x252758, 0x251a95, 0x250dd2, 0x250110, 0x24f44e, 0x24e78d, 0x24dacc, 0x24ce0b,
    0x24c14b, 0x24b48c, 0x24a7cd, 0x249b0e, 0x248e50, 0x248192, 0x2474d4, 0x246818,
    0x245b5b, 0x244e9f, 0x2441e3, 0x243528, 0x24286d, 0x241bb3, 0x240ef9, 0x240240,
    0x23f587, 0x23e8ce, 0x23dc16, 0x23cf5e, 0x23c2a7, 0x23b5f0, 0x23a93a, 0x239c84,
    0x238fce, 0x238319, 0x237665, 0x2369b1, 0x235cfd, 0x23504a, 0x234397, 0x2336e4,
    0x232a32, 0x231d81, 0x2310d0, 0x23041f, 0x22f76f, 0x22eabf, 0x22de0f, 0x22d160,
    0x22c4b2, 0x22b804, 0x22ab56, 0x229ea9, 0x2291fc, 0x228550, 0x2278a4, 0x226bf8,
    0x225f4d, 0x2252a3, 0x2245f9, 0x22394f, 0x222ca6, 0x221ffd, 0x221354, 0x2206ac,
    0x21fa05, 0x21ed5e, 0x21e0b7, 0x21d411, 0x21c76b, 0x21bac5, 0x21ae20, 0x21a17c,
    0x2194d8, 0x218834, 0x217b91, 0x216eee, 0x21624c, 0x2155aa, 0x214908, 0x213c67,
    0x212fc7, 0x212326, 0x211687, 0x2109e7, 0x20fd48, 0x20f0aa, 0x20e40c, 0x20d76e,
    0x20cad1, 0x20be34, 0x20b198, 0x20a4fc, 0x209861, 0x208bc5, 0x207f2b, 0x207291,
    0x2065f7, 0x20595e, 0x204cc5, 0x20402c, 0x203394, 0x2026fd, 0x201a65, 0x200dcf,
    0x200138, 0x1ff4a3, 0x1fe80d, 0x1fdb78, 0x1fcee3, 0x1fc24f, 0x1fb5bc, 0x1fa928,
    0x1f9c95, 0x1f9003, 0x1f8371, 0x1f76df, 0x1f6a4e, 0x1f5dbd, 0x1f512d, 0x1f449d,
    0x1f380e, 0x1f2b7f, 0x1f1ef0, 0x1f1262, 0x1f05d4, 0x1ef947, 0x1eecba, 0x1ee02d,
    0x1ed3a1, 0x1ec716, 0x1eba8b, 0x1eae00, 0x1ea175, 0x1e94eb, 0x1e8862, 0x1e7bd9,
    0x1e6f50, 0x1e62c8, 0x1e5640, 0x1e49b9, 0x1e3d32, 0x1e30ab, 0x1e2425, 0x1e17a0,
    0x1e0b1a, 0x1dfe96, 0x1df211, 0x1de58d, 0x1dd90a, 0x1dcc87, 0x1dc004, 0x1db382,
    0x1da700, 0x1d9a7e, 0x1d8dfd, 0x1d817d, 0x1d74fd, 0x1d687d, 0x1d5bfd, 0x1d4f7f,
    0x1d4300, 0x1d3682, 0x1d2a04, 0x1d1d87, 0x1d110a, 0x1d048e, 0x1cf812, 0x1ceb97,
    0x1cdf1c, 0x1cd2a1, 0x1cc627, 0x1cb9ad, 0x1cad33, 0x1ca0ba, 0x1c9442, 0x1c87ca,
    0x1c7b52, 0x1c6edb, 0x1c6264, 0x1c55ed, 0x1c4977, 0x1c3d02, 0x1c308d, 0x1c2418,
    0x1c17a3, 0x1c0b2f, 0x1bfebc, 0x1bf249, 0x1be5d6, 0x1bd964, 0x1bccf2, 0x1bc081,
    0x1bb410, 0x1ba79f, 0x1b9b2f, 0x1b8ebf, 0x1b8250, 0x1b75e1, 0x1b6972, 0x1b5d04,
    0x1b5097, 0x1b442a, 0x1b37bd, 0x1b2b50, 0x1b1ee4, 0x1b1279, 0x1b060e, 0x1af9a3,
    0x1aed39, 0x1ae0cf, 0x1ad465, 0x1ac7fc, 0x1abb94, 0x1aaf2b, 0x1aa2c4, 0x1a965c,
    0x1a89f5, 0x1a7d8f, 0x1a7128, 0x1a64c3, 0x1a585d, 0x1a4bf9, 0x1a3f94, 0x1a3330,
    0x1a26cc, 0x1a1a69, 0x1a0e06, 0x1a01a4, 0x19f542, 0x19e8e0, 0x19dc7f, 0x19d01e,
    0x19c3be, 0x19b75e, 0x19aaff, 0x199ea0, 0x199241, 0x1985e3, 0x197985, 0x196d27,
    0x1960ca, 0x19546e, 0x194812, 0x193bb6, 0x192f5b, 0x192300, 0x1916a5, 0x190a4b,
    0x18fdf1, 0x18f198, 0x18e53f, 0x18d8e7, 0x18cc8f, 0x18c037, 0x18b3e0, 0x18a789,
    0x189b33, 0x188edd, 0x188287, 0x187632, 0x1869dd, 0x185d89, 0x185135, 0x1844e1,
    0x18388e, 0x182c3b, 0x181fe9, 0x181397, 0x180746, 0x17faf5, 0x17eea4, 0x17e254,
    0x17d604, 0x17c9b5, 0x17bd66, 0x17b117, 0x17a4c9, 0x17987b, 0x178c2e, 0x177fe1,
    0x177394, 0x176748, 0x175afc, 0x174eb1, 0x174266, 0x17361c, 0x1729d2, 0x171d88,
    0x17113f, 0x1704f6, 0x16f8ad, 0x16ec65, 0x16e01e, 0x16d3d6, 0x16c790, 0x16bb49,
    0x16af03, 0x16a2be, 0x169678, 0x168a34, 0x167def, 0x1671ab, 0x166568, 0x165925,
    0x164ce2, 0x1640a0, 0x16345e, 0x16281c, 0x161bdb, 0x160f9a, 0x16035a, 0x15f71a,
    0x15eadb, 0x15de9c, 0x15d25d, 0x15c61f, 0x15b9e1, 0x15ada3, 0x15a166, 0x15952a,
    0x1588ed, 0x157cb1, 0x157076, 0x15643b, 0x155800, 0x154bc6, 0x153f8c, 0x153353,
    0x15271a, 0x151ae1, 0x150ea9, 0x150271, 0x14f63a, 0x14ea03, 0x14ddcc, 0x14d196,
    0x14c560, 0x14b92b, 0x14acf6, 0x14a0c2, 0x14948d, 0x14885a, 0x147c26, 0x146ff3,
    0x1463c1, 0x14578f, 0x144b5d, 0x143f2c, 0x1432fb, 0x1426ca, 0x141a9a, 0x140e6a,
    0x14023b, 0x13f60c, 0x13e9de, 0x13ddaf, 0x13d182, 0x13c554, 0x13b927, 0x13acfb,
    0x13a0cf, 0x1394a3, 0x138878, 0x137c4d, 0x137022, 0x1363f8, 0x1357cf, 0x134ba5,
    0x133f7c, 0x133354, 0x13272c, 0x131b04, 0x130edd, 0x1302b6, 0x12f68f, 0x12ea69,
    0x12de44, 0x12d21e, 0x12c5f9, 0x12b9d5, 0x12adb1, 0x12a18d, 0x12956a, 0x128947,
    0x127d24, 0x127102, 0x1264e0, 0x1258bf, 0x124c9e, 0x12407e, 0x12345e, 0x12283e,
    0x121c1e, 0x121000, 0x1203e1, 0x11f7c3, 0x11eba5, 0x11df88, 0x11d36b, 0x11c74e,
    0x11bb32, 0x11af16, 0x11a2fb, 0x1196e0, 0x118ac6, 0x117eab, 0x117292, 0x116678,
    0x115a5f, 0x114e47, 0x11422e, 0x113617, 0x1129ff, 0x111de8, 0x1111d2, 0x1105bc,
    0x10f9a6, 0x10ed90, 0x10e17b, 0x10d567, 0x10c952, 0x10bd3f, 0x10b12b, 0x10a518,
    0x109905, 0x108cf3, 0x1080e1, 0x1074d0, 0x1068bf, 0x105cae, 0x10509e, 0x10448e,
    0x10387e, 0x102c6f, 0x102061, 0x101452, 0x100844, 0x0ffc37, 0x0ff02a, 0x0fe41d,
    0x0fd811, 0x0fcc05, 0x0fbff9, 0x0fb3ee, 0x0fa7e3, 0x0f9bd9, 0x0f8fcf, 0x0f83c5,
    0x0f77bc, 0x0f6bb3, 0x0f5fab, 0x0f53a3, 0x0f479b, 0x0f3b94, 0x0f2f8d, 0x0f2387,
    0x0f1781, 0x0f0b7b, 0x0eff76, 0x0ef371, 0x0ee76c, 0x0edb68, 0x0ecf64, 0x0ec361,
    0x0eb75e, 0x0eab5c, 0x0e9f59, 0x0e9358, 0x0e8756, 0x0e7b55, 0x0e6f55, 0x0e6354,
    0x0e5755, 0x0e4b55, 0x0e3f56, 0x0e3357, 0x0e2759, 0x0e1b5b, 0x0e0f5e, 0x0e0361,
    0x0df764, 0x0deb68, 0x0ddf6c, 0x0dd370, 0x0dc775, 0x0dbb7a, 0x0daf80, 0x0da386,
    0x0d978c, 0x0d8b93, 0x0d7f9a, 0x0d73a2, 0x0d67aa, 0x0d5bb2, 0x0d4fbb, 0x0d43c4,
    0x0d37ce, 0x0d2bd7, 0x0d1fe2, 0x0d13ec, 0x0d07f8, 0x0cfc03, 0x0cf00f, 0x0ce41b,
    0x0cd828, 0x0ccc35, 0x0cc042, 0x0cb450, 0x0ca85e, 0x0c9c6c, 0x0c907b, 0x0c848b,
    0x0c789a, 0x0c6caa, 0x0c60bb, 0x0c54cc, 0x0c48dd, 0x0c3cef, 0x0c3101, 0x0c2513,
    0x0c1926, 0x0c0d39, 0x0c014d, 0x0bf560, 0x0be975, 0x0bdd89, 0x0bd19f, 0x0bc5b4,
    0x0bb9ca, 0x0bade0, 0x0ba1f7, 0x0b960e, 0x0b8a25, 0x0b7e3d, 0x0b7255, 0x0b666e,
    0x0b5a87, 0x0b4ea0, 0x0b42ba, 0x0b36d4, 0x0b2aee, 0x0b1f09, 0x0b1324, 0x0b0740,
    0x0afb5c, 0x0aef78, 0x0ae395, 0x0ad7b2, 0x0acbd0, 0x0abfee, 0x0ab40c, 0x0aa82a,
    0x0a9c4a, 0x0a9069, 0x0a8489, 0x0a78a9, 0x0a6cca, 0x0a60eb, 0x0a550c, 0x0a492e,
    0x0a3d50, 0x0a3172, 0x0a2595, 0x0a19b8, 0x0a0ddc, 0x0a0200, 0x09f624, 0x09ea49,
    0x09de6e, 0x09d294, 0x09c6ba, 0x09bae0, 0x09af07, 0x09a32e, 0x099755, 0x098b7d,
    0x097fa5, 0x0973ce, 0x0967f7, 0x095c20, 0x09504a, 0x094474, 0x09389e, 0x092cc9,
    0x0920f4, 0x091520, 0x09094c, 0x08fd78, 0x08f1a5, 0x08e5d2, 0x08da00, 0x08ce2e,
    0x08c25c, 0x08b68b, 0x08aaba, 0x089ee9, 0x089319, 0x088749, 0x087b79, 0x086faa,
    0x0863dc, 0x08580d, 0x084c3f, 0x084072, 0x0834a5, 0x0828d8, 0x081d0b, 0x08113f,
    0x080573, 0x07f9a8, 0x07eddd, 0x07e213, 0x07d648, 0x07ca7f, 0x07beb5, 0x07b2ec,
    0x07a723, 0x079b5b, 0x078f93, 0x0783cc, 0x077804, 0x076c3e, 0x076077, 0x0754b1,
    0x0748eb, 0x073d26, 0x073161, 0x07259d, 0x0719d8, 0x070e15, 0x070251, 0x06f68e,
    0x06eacb, 0x06df09, 0x06d347, 0x06c786, 0x06bbc4, 0x06b004, 0x06a443, 0x069883,
    0x068cc3, 0x068104, 0x067545, 0x066987, 0x065dc8, 0x06520b, 0x06464d, 0x063a90,
    0x062ed3, 0x062317, 0x06175b, 0x060b9f, 0x05ffe4, 0x05f429, 0x05e86f, 0x05dcb5,
    0x05d0fb, 0x05c542, 0x05b989, 0x05add0, 0x05a218, 0x059660, 0x058aa9, 0x057ef1,
    0x05733b, 0x056784, 0x055bce, 0x055019, 0x054463, 0x0538af, 0x052cfa, 0x052146,
    0x051592, 0x0509df, 0x04fe2c, 0x04f279, 0x04e6c7, 0x04db15, 0x04cf63, 0x04c3b2,
    0x04b801, 0x04ac51, 0x04a0a1, 0x0494f1, 0x048942, 0x047d93, 0x0471e4, 0x046636,
    0x045a88, 0x044eda, 0x04432d, 0x043781, 0x042bd4, 0x042028, 0x04147d, 0x0408d1,
    0x03fd26, 0x03f17c, 0x03e5d2, 0x03da28, 0x03ce7e, 0x03c2d5, 0x03b72d, 0x03ab84,
    0x039fdc, 0x039435, 0x03888e, 0x037ce7, 0x037140, 0x03659a, 0x0359f4, 0x034e4f,
    0x0342aa, 0x033705, 0x032b61, 0x031fbd, 0x031419, 0x030876, 0x02fcd3, 0x02f131,
    0x02e58f, 0x02d9ed, 0x02ce4c, 0x02c2ab, 0x02b70a, 0x02ab6a, 0x029fca, 0x02942b,
    0x02888b, 0x027ced, 0x02714e, 0x0265b0, 0x025a12, 0x024e75, 0x0242d8, 0x02373c,
    0x022b9f, 0x022003, 0x021468, 0x0208cd, 0x01fd32, 0x01f198, 0x01e5fe, 0x01da64,
    0x01cecb, 0x01c332, 0x01b799, 0x01ac01, 0x01a069, 0x0194d1, 0x01893a, 0x017da4,
    0x01720d, 0x016677, 0x015ae1, 0x014f4c, 0x0143b7, 0x013823, 0x012c8e, 0x0120fa,
    0x011567, 0x0109d4, 0x00fe41, 0x00f2af, 0x00e71d, 0x00db8b, 0x00cffa, 0x00c469,
    0x00b8d8, 0x00ad48, 0x00a1b8, 0x009628, 0x008a99, 0x007f0a, 0x00737c, 0x0067ee,
    0x005c60, 0x0050d3, 0x004546, 0x0039b9, 0x002e2d, 0x0022a1, 0x001715, 0x000b8a,
    };
#endif /* LOG2_LUT_H_ */
