#include <xcore/assert.h>
#include <xua.h>
#include <xua_audiohub.h>
#include <stdint.h>
#include <stages/adsp_pipeline.h>
#include <adsp_generated_auto.h>

// This assumes that the application has not enabled MIDI, SPDIF, ADAT, or PDM mics.
#define N_CHANS_FROM_AUDIO (I2S_CHANS_ADC)
#define N_CHANS_TO_AUDIO (I2S_CHANS_DAC)
#define N_CHANS_TO_DSP (NUM_USB_CHAN_OUT + I2S_CHANS_ADC)
#define N_CHANS_FROM_DSP (NUM_USB_CHAN_IN + I2S_CHANS_DAC)

static adsp_pipeline_t *m_dsp;

/// Fills an array of points to point to the corresponding element
/// of an input array.
static void arr_to_pointer(int32_t** pointer, unsigned* arr, int n) {
    for(int i = 0; i < n; ++i) {
        pointer[i] = &((int32_t*)arr)[i];
    }
}

/// Standard lib_xua callback function.
void UserBufferManagement(unsigned* sampsFromUsbToAudio, unsigned* sampsFromAudioToUsb) {
    xassert(NULL != m_dsp);

    // construct DSP input arrays and hand over to the DSP thread.
    int32_t* dsp_input[N_CHANS_TO_DSP];
    arr_to_pointer(&dsp_input[0], sampsFromUsbToAudio, NUM_USB_CHAN_OUT);
    arr_to_pointer(&dsp_input[NUM_USB_CHAN_OUT], sampsFromAudioToUsb, N_CHANS_FROM_AUDIO);
    adsp_pipeline_source(m_dsp, dsp_input);

    // construct the DSP output arrays and wait for output from the DSP
    // thread.
    int32_t* dsp_output[N_CHANS_FROM_DSP];
    arr_to_pointer(&dsp_output[0], sampsFromUsbToAudio, N_CHANS_TO_AUDIO);
    arr_to_pointer(&dsp_output[N_CHANS_TO_AUDIO], sampsFromAudioToUsb, NUM_USB_CHAN_IN);
    adsp_pipeline_sink(m_dsp, dsp_output);
}

// start dsp_thread
void dsp_thread(void) {
    // Initialise the DSP instance and enter the generated DSP main function.
    // This will never return.
    m_dsp = adsp_auto_pipeline_init();
    adsp_auto_pipeline_main(m_dsp);
}
// end dsp_thread
