macro(get_json_list json_dict json_key out_list)
    string(JSON json_array GET ${json_dict} ${json_key})

    set(${out_list} "")
    if(json_array MATCHES "^\\[.*\\]$")
        string(JSON array_len LENGTH ${json_array})
        math(EXPR last_idx "${array_len} - 1")
        foreach(idx RANGE ${last_idx})
            string(JSON elem GET ${json_array} ${idx})
            list(APPEND ${out_list} ${elem})
        endforeach()
    else()
        list(APPEND ${out_list} ${json_array}) # It's not an array but a single element
    endif()
endmacro()

macro(set_app_hw_target arch)
    if(arch STREQUAL "xs3")
        set(target "XK-EVK-XU316")
    elseif(arch STREQUAL "xs2")
        set(target "XCORE-200-EXPLORER")
    endif()
    set(APP_HW_TARGET ${target})
endmacro()

macro(set_app_tx_width tx_width)
    if(tx_width STREQUAL "4b_lower")
        list(APPEND APP_COMPILER_FLAGS_${config} -DTX_WIDTH=4)
        list(APPEND APP_COMPILER_FLAGS_${config} -DTX_USE_LOWER_2B=1)
    elseif(tx_width STREQUAL "4b_upper")
        list(APPEND APP_COMPILER_FLAGS_${config} -DTX_WIDTH=4) # TODO support upper and lower
        list(APPEND APP_COMPILER_FLAGS_${config} -DTX_USE_UPPER_2B=1)
    elseif(tx_width STREQUAL "1b")
        list(APPEND APP_COMPILER_FLAGS_${config} -DTX_WIDTH=1)
    endif()
endmacro()

macro(set_app_rx_width rx_width)
    if(rx_width STREQUAL "4b_lower")
        list(APPEND APP_COMPILER_FLAGS_${config} -DRX_WIDTH=4)
        list(APPEND APP_COMPILER_FLAGS_${config} -DRX_USE_LOWER_2B=1)
    elseif(rx_width STREQUAL "4b_upper")
        list(APPEND APP_COMPILER_FLAGS_${config} -DRX_WIDTH=4) # TODO support upper and lower
        list(APPEND APP_COMPILER_FLAGS_${config} -DRX_USE_UPPER_2B=1)
    elseif(rx_width STREQUAL "1b")
        list(APPEND APP_COMPILER_FLAGS_${config} -DRX_WIDTH=1)
    endif()
endmacro()
