r'''Utility functions to find and queary XMOS usb devices (XTAGS) using pyusb'''

# See https://github0.xmos.com/xmos-int/xtag/blob/master/app_xtag_bootloader/src/endpoint0.xc
# For detailed xtag usb descriptor info.

import usb.core

XMOS_VENDORID = 0x20b1
XTAG3_PRODUCTID = 0xf7d4
XTAG4_PRODUCTID = 0xf7d5

def find_adapterid(adapterID, xmosVID = XMOS_VENDORID):
    '''Returns the first XMOS VendorID usb object found with the given AdapterID.'''

    def search_adapterid(dev):
        if adapterID in dev.serial_number:
            return True
        return False

    try:
        return next(usb.core.find(find_all=True, idVendor = xmosVID, custom_match = search_adapterid))
    except StopIteration:
        return None

def check_loaded_firmware(adapterID):
    '''Checks an XTAGs serial decriptor for signs if a firmware is currently loaded or not.'''

    # We use pyusb to do an iSerialNumber descriptor check, 0x5 indicates that a firmware is loaded
    # 0x3 indicates that the device is empty waiting for a firmware.

    try:
        return bool(find_adapterid(adapterID).iSerialNumber == 0x5)
    # To do: Implement targeted exception handling, but what are the possible exceptions here?
    except:
        return None
